
/*
 * $Id: protos.h,v 1.340.2.23 2000/01/05 23:40:05 wessels Exp $
 *
 *
 * SQUID Internet Object Cache  http://squid.nlanr.net/Squid/
 * ----------------------------------------------------------
 *
 *  Squid is the result of efforts by numerous individuals from the
 *  Internet community.  Development is led by Duane Wessels of the
 *  National Laboratory for Applied Network Research and funded by the
 *  National Science Foundation.  Squid is Copyrighted (C) 1998 by
 *  Duane Wessels and the University of California San Diego.  Please
 *  see the COPYRIGHT file for full details.  Squid incorporates
 *  software developed and/or copyrighted by other sources.  Please see
 *  the CREDITS file for full details.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *   _PARAMS((at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

extern void accessLogLog _PARAMS((AccessLogEntry *));
extern void accessLogRotate _PARAMS((void));
extern void accessLogClose _PARAMS((void));
extern void accessLogInit _PARAMS((void));
extern const char *accessLogTime _PARAMS((time_t));
extern void hierarchyNote _PARAMS((HierarchyLogEntry *, hier_code, const char *));
#if FORW_VIA_DB
extern void fvdbCountVia _PARAMS((const char *key));
extern void fvdbCountForw _PARAMS((const char *key));
#endif

extern aclCheck_t *aclChecklistCreate _PARAMS((const struct _acl_access *,
    request_t *,
    const char *ident));
extern void aclNBCheck _PARAMS((aclCheck_t *, PF *, void *));
extern int aclCheckFast _PARAMS((const struct _acl_access *A, aclCheck_t *));
extern void aclChecklistFree _PARAMS((aclCheck_t *));
extern int aclMatchAclList _PARAMS((const acl_list * list, aclCheck_t * checklist));
extern void aclDestroyAccessList _PARAMS((struct _acl_access **list));
extern void aclDestroyAcls _PARAMS((acl **));
extern void aclParseAccessLine _PARAMS((struct _acl_access **));
extern void aclParseAclLine _PARAMS((acl **));
extern int aclIsProxyAuth _PARAMS((const char *name));
extern int aclGetDenyInfoPage _PARAMS((acl_deny_info_list ** head, const char *name));
extern void aclParseDenyInfoLine _PARAMS((struct _acl_deny_info_list **));
extern void aclDestroyDenyInfoList _PARAMS((struct _acl_deny_info_list **));
extern void aclDestroyRegexList _PARAMS((struct _relist *data));
extern int aclMatchRegex _PARAMS((relist * data, const char *word));
extern void aclParseRegexList _PARAMS((void *curlist));
extern const char *aclTypeToStr _PARAMS((squid_acl));
extern wordlist *aclDumpGeneric _PARAMS((const acl *));

#if USE_ASYNC_IO
extern int aio_cancel _PARAMS((aio_result_t *));
extern int aio_open _PARAMS((const char *, int, mode_t, aio_result_t *));
extern int aio_read _PARAMS((int, char *, int, off_t, int, aio_result_t *));
extern int aio_write _PARAMS((int, char *, int, off_t, int, aio_result_t *));
extern int aio_close _PARAMS((int, aio_result_t *));
extern int aio_stat _PARAMS((const char *, struct stat *, aio_result_t *));
extern int aio_unlink _PARAMS((const char *, aio_result_t *));
extern int aio_opendir _PARAMS((const char *, aio_result_t *));
extern aio_result_t *aio_poll_done _PARAMS((void));
extern int aio_operations_pending _PARAMS((void));
extern int aio_overloaded _PARAMS((void));
extern int aio_sync _PARAMS((void));
extern int aio_get_queue_len _PARAMS((void));

extern void aioInit _PARAMS((void));
extern void aioCancel _PARAMS((int));
extern void aioOpen _PARAMS((const char *, int, mode_t, AIOCB *, void *));
extern void aioClose _PARAMS((int));
extern void aioWrite _PARAMS((int, int offset, char *, int size, AIOCB *, void *, FREE *));
extern void aioRead _PARAMS((int, int offset, char *, int size, AIOCB *, void *));
extern void aioStat _PARAMS((char *, struct stat *, AIOCB *, void *));
extern void aioUnlink _PARAMS((const char *, AIOCB *, void *));
extern void aioCheckCallbacks _PARAMS((void));
extern void aioSync _PARAMS((void));
extern int aioQueueSize _PARAMS((void));
#endif

/*
 * cache_cf.c
 */
extern int parseConfigFile _PARAMS((const char *file_name));
extern void intlistDestroy _PARAMS((intlist **));
extern int intlistFind _PARAMS((intlist * list, int i));
extern wordlist *wordlistAdd _PARAMS((wordlist **, const char *));
extern wordlist *wordlistDup _PARAMS((const wordlist *));
extern void wordlistDestroy _PARAMS((wordlist **));
extern void configFreeMemory _PARAMS((void));
extern void wordlistCat _PARAMS((const wordlist *, MemBuf * mb));
extern void allocate_new_swapdir _PARAMS((cacheSwap *));
extern void self_destruct _PARAMS((void));
extern int GetInteger _PARAMS((void));


extern void cbdataInit _PARAMS((void));
#if CBDATA_DEBUG
extern void cbdataAddDbg _PARAMS((const void *p, CBDUNL *, int, const char *, int));
#else
extern void cbdataAdd _PARAMS((const void *p, CBDUNL *, int));
#endif
extern void cbdataFree _PARAMS((void *p));
extern void cbdataLock _PARAMS((const void *p));
extern void cbdataUnlock _PARAMS((const void *p));
extern int cbdataValid _PARAMS((const void *p));
extern CBDUNL cbdataXfree;

extern void clientdbInit _PARAMS((void));
extern void clientdbUpdate _PARAMS((struct in_addr, log_type, protocol_t, size_t));
extern int clientdbCutoffDenied _PARAMS((struct in_addr));
extern void clientdbDump _PARAMS((StoreEntry *));
extern void clientdbFreeMemory _PARAMS((void));
extern int clientdbEstablished _PARAMS((struct in_addr, int));

extern void clientAccessCheck _PARAMS((void *));
extern void clientAccessCheckDone _PARAMS((int, void *));
extern int modifiedSince _PARAMS((StoreEntry *, request_t *));
extern char *clientConstructTraceEcho _PARAMS((clientHttpRequest *));
extern void clientPurgeRequest _PARAMS((clientHttpRequest *));
extern int checkNegativeHit _PARAMS((StoreEntry *));
extern void clientHttpConnectionsOpen _PARAMS((void));
extern void clientHttpConnectionsClose _PARAMS((void));
extern StoreEntry *clientCreateStoreEntry _PARAMS((clientHttpRequest *, method_t, request_flags));
extern int isTcpHit _PARAMS((log_type));

extern int commSetNonBlocking _PARAMS((int fd));
extern int commUnsetNonBlocking _PARAMS((int fd));
extern void commSetCloseOnExec _PARAMS((int fd));
extern int comm_accept _PARAMS((int fd, struct sockaddr_in *, struct sockaddr_in *));
extern void comm_close _PARAMS((int fd));
#if LINGERING_CLOSE
extern void comm_lingering_close _PARAMS((int fd));
#endif
extern void commConnectStart _PARAMS((int fd, const char *, u_short, CNCB *, void *));
extern int comm_connect_addr _PARAMS((int sock, const struct sockaddr_in *));
extern void comm_init _PARAMS((void));
extern int comm_listen _PARAMS((int sock));
extern int comm_open _PARAMS((int, int, struct in_addr, u_short port, int, const char *note));
extern u_short comm_local_port _PARAMS((int fd));

extern void commSetSelect _PARAMS((int, unsigned int, PF *, void *, time_t));
extern void comm_add_close_handler _PARAMS((int fd, PF *, void *));
extern void comm_remove_close_handler _PARAMS((int fd, PF *, void *));
extern int comm_udp_sendto _PARAMS((int, const struct sockaddr_in *, int, const void *, int));
extern void comm_write _PARAMS((int fd,
    char *buf,
    int size,
    CWCB * handler,
    void *handler_data,
    FREE *));
extern void comm_write_mbuf _PARAMS((int fd, MemBuf mb, CWCB * handler, void *handler_data));
extern void commCallCloseHandlers _PARAMS((int fd));
extern int commSetTimeout _PARAMS((int fd, int, PF *, void *));
extern void commSetDefer _PARAMS((int fd, DEFER * func, void *));
extern int ignoreErrno _PARAMS((int));
extern void commCloseAllSockets _PARAMS((void));


/*
 * comm_select.c
 */
extern void comm_select_init _PARAMS((void));
#if HAVE_POLL
extern int comm_poll _PARAMS((int));
#else
extern int comm_select _PARAMS((int));
#endif
extern void commUpdateReadBits _PARAMS((int, PF *));
extern void commUpdateWriteBits _PARAMS((int, PF *));

extern void packerToStoreInit _PARAMS((Packer * p, StoreEntry * e));
extern void packerToMemInit _PARAMS((Packer * p, MemBuf * mb));
extern void packerClean _PARAMS((Packer * p));
extern void packerAppend _PARAMS((Packer * p, const char *buf, int size));
#if STDC_HEADERS
extern void packerPrintf _PARAMS((Packer * p, const char *fmt,...));
#else
extern void packerPrintf _PARAMS(());
#endif


/* see debug.c for info on context-based debugging */
extern Ctx ctx_enter _PARAMS((const char *descr));
extern void ctx_exit _PARAMS((Ctx ctx));

extern void _db_init _PARAMS((const char *logfile, const char *options));
extern void _db_rotate_log _PARAMS((void));

#if STDC_HEADERS
extern void _db_print _PARAMS((const char *,...));
#else
extern void _db_print _PARAMS(());
#endif
extern void xassert _PARAMS((const char *, const char *, int));

/* packs, then prints an object using debug _PARAMS(()) */
extern void debugObj _PARAMS((int section, int level, const char *label, void *obj, ObjPackMethod pm));


extern int file_open _PARAMS((const char *path, int mode));
extern void file_close _PARAMS((int fd));
extern void file_write _PARAMS((int, off_t, void *, int len, DWCB *, void *, FREE *));
extern void file_write_mbuf _PARAMS((int fd, off_t, MemBuf mb, DWCB * handler, void *handler_data));
extern void file_read _PARAMS((int, char *, int, off_t, DRCB *, void *));
extern void disk_init _PARAMS((void));

extern void dnsShutdown _PARAMS((void));
extern void dnsInit _PARAMS((void));
extern void dnsSubmit _PARAMS((const char *lookup, HLPCB * callback, void *data));

/* dns_internal.c */
extern void idnsInit _PARAMS((void));
extern void idnsShutdown _PARAMS((void));
extern void idnsALookup _PARAMS((const char *, IDNSCB *, void *));
extern void idnsPTRLookup _PARAMS((const struct in_addr, IDNSCB *, void *));

extern void eventAdd _PARAMS((const char *name, EVH * func, void *arg, double when, int));
extern void eventAddIsh _PARAMS((const char *name, EVH * func, void *arg, double delta_ish, int));
extern void eventRun _PARAMS((void));
extern time_t eventNextTime _PARAMS((void));
extern void eventDelete _PARAMS((EVH * func, void *arg));
extern void eventInit _PARAMS((void));
extern void eventFreeMemory _PARAMS((void));
extern int eventFind _PARAMS((EVH *, void *));

extern void fd_close _PARAMS((int fd));
extern void fd_open _PARAMS((int fd, unsigned int type, const char *));
extern void fd_note _PARAMS((int fd, const char *));
extern void fd_bytes _PARAMS((int fd, int len, unsigned int type));
extern void fdFreeMemory _PARAMS((void));
extern void fdDumpOpen _PARAMS((void));
extern int fdNFree _PARAMS((void));
extern void fdAdjustReserved _PARAMS((void));

extern fileMap *file_map_create _PARAMS((void));
extern int file_map_allocate _PARAMS((fileMap *, int));
extern int file_map_bit_set _PARAMS((fileMap *, int));
extern int file_map_bit_test _PARAMS((fileMap *, int));
extern void file_map_bit_reset _PARAMS((fileMap *, int));
extern void filemapFreeMemory _PARAMS((fileMap *));


extern void fqdncache_nbgethostbyaddr _PARAMS((struct in_addr, FQDNH *, void *));
extern int fqdncacheUnregister _PARAMS((struct in_addr, void *));
extern const char *fqdncache_gethostbyaddr _PARAMS((struct in_addr, int flags));
extern void fqdncache_init _PARAMS((void));
extern void fqdnStats _PARAMS((StoreEntry *));
extern void fqdncacheReleaseInvalid _PARAMS((const char *));
extern const char *fqdnFromAddr _PARAMS((struct in_addr));
extern int fqdncacheQueueDrain _PARAMS((void));
extern void fqdncacheFreeMemory _PARAMS((void));
extern void fqdncache_restart _PARAMS((void));
extern EVH fqdncache_purgelru;

extern void ftpStart _PARAMS((FwdState *));
extern char *ftpUrlWith2f _PARAMS((const request_t *));

extern void gopherStart _PARAMS((FwdState *));
extern int gopherCachable _PARAMS((const char *));


extern void whoisStart _PARAMS((FwdState *));

extern int httpCachable _PARAMS((method_t));
extern void httpStart _PARAMS((FwdState *));
extern void httpParseReplyHeaders _PARAMS((const char *, http_reply *));
extern void httpProcessReplyHeader _PARAMS((HttpStateData *, const char *, int));
extern mb_size_t httpBuildRequestPrefix _PARAMS((request_t * request,
    request_t * orig_request,
    StoreEntry * entry,
    MemBuf * mb,
    int cfd,
    http_state_flags));
extern void httpAnonInitModule _PARAMS((void));
extern int httpAnonHdrAllowed _PARAMS((http_hdr_type hdr_id));
extern int httpAnonHdrDenied _PARAMS((http_hdr_type hdr_id));
extern void httpBuildRequestHeader _PARAMS((request_t *, request_t *, StoreEntry *, HttpHeader *, int, http_state_flags));

/* ETag */
extern int etagParseInit _PARAMS((ETag * etag, const char *str));
extern int etagIsEqual _PARAMS((const ETag * tag1, const ETag * tag2));

/* Http Status Line */
/* init/clean */
extern void httpStatusLineInit _PARAMS((HttpStatusLine * sline));
extern void httpStatusLineClean _PARAMS((HttpStatusLine * sline));
/* set/get values */
extern void httpStatusLineSet _PARAMS((HttpStatusLine * sline, double version,
    http_status status, const char *reason));
extern const char *httpStatusLineReason _PARAMS((const HttpStatusLine * sline));
/* parse/pack */
/* parse a 0-terminating buffer and fill internal structires; returns true on success */
extern int httpStatusLineParse _PARAMS((HttpStatusLine * sline, const char *start,
    const char *end));
/* pack fields using Packer */
extern void httpStatusLinePackInto _PARAMS((const HttpStatusLine * sline, Packer * p));
extern const char *httpStatusString _PARAMS((http_status status));

/* Http Body */
/* init/clean */
extern void httpBodyInit _PARAMS((HttpBody * body));
extern void httpBodyClean _PARAMS((HttpBody * body));
/* get body ptr  _PARAMS((always use this)) */
extern const char *httpBodyPtr _PARAMS((const HttpBody * body));
/* set body, does not clone mb so you should not reuse it */
extern void httpBodySet _PARAMS((HttpBody * body, MemBuf * mb));

/* pack */
extern void httpBodyPackInto _PARAMS((const HttpBody * body, Packer * p));

/* Http Cache Control Header Field */
extern void httpHdrCcInitModule _PARAMS((void));
extern void httpHdrCcCleanModule _PARAMS((void));
extern HttpHdrCc *httpHdrCcCreate _PARAMS((void));
extern HttpHdrCc *httpHdrCcParseCreate _PARAMS((const String * str));
extern void httpHdrCcDestroy _PARAMS((HttpHdrCc * cc));
extern HttpHdrCc *httpHdrCcDup _PARAMS((const HttpHdrCc * cc));
extern void httpHdrCcPackInto _PARAMS((const HttpHdrCc * cc, Packer * p));
extern void httpHdrCcJoinWith _PARAMS((HttpHdrCc * cc, const HttpHdrCc * new_cc));
extern void httpHdrCcSetMaxAge _PARAMS((HttpHdrCc * cc, int max_age));
extern void httpHdrCcSetSMaxAge _PARAMS((HttpHdrCc * cc, int s_maxage));
extern void httpHdrCcUpdateStats _PARAMS((const HttpHdrCc * cc, StatHist * hist));
extern void httpHdrCcStatDumper _PARAMS((StoreEntry * sentry, int idx, double val, double size, int count));

/* Http Range Header Field */
extern HttpHdrRange *httpHdrRangeParseCreate _PARAMS((const String * range_spec));
/* returns true if ranges are valid; inits HttpHdrRange */
extern int httpHdrRangeParseInit _PARAMS((HttpHdrRange * range, const String * range_spec));
extern void httpHdrRangeDestroy _PARAMS((HttpHdrRange * range));
extern HttpHdrRange *httpHdrRangeDup _PARAMS((const HttpHdrRange * range));
extern void httpHdrRangePackInto _PARAMS((const HttpHdrRange * range, Packer * p));
/* iterate through specs */
extern HttpHdrRangeSpec *httpHdrRangeGetSpec _PARAMS((const HttpHdrRange * range, HttpHdrRangePos * pos));
/* adjust specs after the length is known */
extern int httpHdrRangeCanonize _PARAMS((HttpHdrRange *, ssize_t));
/* other */
extern String httpHdrRangeBoundaryStr _PARAMS((clientHttpRequest * http));
extern int httpHdrRangeIsComplex _PARAMS((const HttpHdrRange * range));
extern int httpHdrRangeWillBeComplex _PARAMS((const HttpHdrRange * range));
extern ssize_t httpHdrRangeFirstOffset _PARAMS((const HttpHdrRange * range));
extern ssize_t httpHdrRangeLowestOffset _PARAMS((const HttpHdrRange * range, ssize_t));


/* Http Content Range Header Field */
extern HttpHdrContRange *httpHdrContRangeCreate _PARAMS((void));
extern HttpHdrContRange *httpHdrContRangeParseCreate _PARAMS((const char *crange_spec));
/* returns true if range is valid; inits HttpHdrContRange */
extern int httpHdrContRangeParseInit _PARAMS((HttpHdrContRange * crange, const char *crange_spec));
extern void httpHdrContRangeDestroy _PARAMS((HttpHdrContRange * crange));
extern HttpHdrContRange *httpHdrContRangeDup _PARAMS((const HttpHdrContRange * crange));
extern void httpHdrContRangePackInto _PARAMS((const HttpHdrContRange * crange, Packer * p));
/* inits with given spec */
extern void httpHdrContRangeSet _PARAMS((HttpHdrContRange *, HttpHdrRangeSpec, ssize_t));

/* Http Header Tools */
extern HttpHeaderFieldInfo *httpHeaderBuildFieldsInfo _PARAMS((const HttpHeaderFieldAttrs * attrs, int count));
extern void httpHeaderDestroyFieldsInfo _PARAMS((HttpHeaderFieldInfo * info, int count));
extern int httpHeaderIdByName _PARAMS((const char *name, int name_len, const HttpHeaderFieldInfo * attrs, int end));
extern int httpHeaderIdByNameDef _PARAMS((const char *name, int name_len));
extern void httpHeaderMaskInit _PARAMS((HttpHeaderMask * mask, int value));
extern void httpHeaderCalcMask _PARAMS((HttpHeaderMask * mask, const int *enums, int count));
extern int httpHeaderHasConnDir _PARAMS((const HttpHeader * hdr, const char *directive));
extern void httpHeaderAddContRange _PARAMS((HttpHeader *, HttpHdrRangeSpec, ssize_t));
extern void strListAdd _PARAMS((String * str, const char *item, char del));
extern int strListIsMember _PARAMS((const String * str, const char *item, char del));
extern int strListIsSubstr _PARAMS((const String * list, const char *s, char del));
extern int strListGetItem _PARAMS((const String * str, char del, const char **item, int *ilen, const char **pos));
extern const char *getStringPrefix _PARAMS((const char *str, const char *end));
extern int httpHeaderParseInt _PARAMS((const char *start, int *val));
extern int httpHeaderParseSize _PARAMS((const char *start, ssize_t * sz));
extern int httpHeaderReset _PARAMS((HttpHeader * hdr));
#if STDC_HEADERS
extern void httpHeaderPutStrf _PARAMS((HttpHeader * hdr, http_hdr_type id, const char *fmt,...));
#else
extern void httpHeaderPutStrf _PARAMS(());
#endif


/* Http Header */
extern void httpHeaderInitModule _PARAMS((void));
extern void httpHeaderCleanModule _PARAMS((void));
/* init/clean */
extern void httpHeaderInit _PARAMS((HttpHeader * hdr, http_hdr_owner_type owner));
extern void httpHeaderClean _PARAMS((HttpHeader * hdr));
/* append/update */
extern void httpHeaderAppend _PARAMS((HttpHeader * dest, const HttpHeader * src));
extern void httpHeaderUpdate _PARAMS((HttpHeader * old, const HttpHeader * fresh, const HttpHeaderMask * denied_mask));
/* parse/pack */
extern int httpHeaderParse _PARAMS((HttpHeader * hdr, const char *header_start, const char *header_end));
extern void httpHeaderPackInto _PARAMS((const HttpHeader * hdr, Packer * p));
/* field manipulation */
extern int httpHeaderHas _PARAMS((const HttpHeader * hdr, http_hdr_type type));
extern void httpHeaderPutInt _PARAMS((HttpHeader * hdr, http_hdr_type type, int number));
extern void httpHeaderPutTime _PARAMS((HttpHeader * hdr, http_hdr_type type, time_t time));
extern void httpHeaderPutStr _PARAMS((HttpHeader * hdr, http_hdr_type type, const char *str));
extern void httpHeaderPutAuth _PARAMS((HttpHeader * hdr, const char *authScheme, const char *realm));
extern void httpHeaderPutCc _PARAMS((HttpHeader * hdr, const HttpHdrCc * cc));
extern void httpHeaderPutContRange _PARAMS((HttpHeader * hdr, const HttpHdrContRange * cr));
extern void httpHeaderPutRange _PARAMS((HttpHeader * hdr, const HttpHdrRange * range));
extern void httpHeaderPutExt _PARAMS((HttpHeader * hdr, const char *name, const char *value));
extern int httpHeaderGetInt _PARAMS((const HttpHeader * hdr, http_hdr_type id));
extern time_t httpHeaderGetTime _PARAMS((const HttpHeader * hdr, http_hdr_type id));
extern TimeOrTag httpHeaderGetTimeOrTag _PARAMS((const HttpHeader * hdr, http_hdr_type id));
extern HttpHdrCc *httpHeaderGetCc _PARAMS((const HttpHeader * hdr));
extern ETag httpHeaderGetETag _PARAMS((const HttpHeader * hdr, http_hdr_type id));
extern HttpHdrRange *httpHeaderGetRange _PARAMS((const HttpHeader * hdr));
extern HttpHdrContRange *httpHeaderGetContRange _PARAMS((const HttpHeader * hdr));
extern const char *httpHeaderGetStr _PARAMS((const HttpHeader * hdr, http_hdr_type id));
extern const char *httpHeaderGetLastStr _PARAMS((const HttpHeader * hdr, http_hdr_type id));
extern const char *httpHeaderGetAuth _PARAMS((const HttpHeader * hdr, http_hdr_type id, const char *authScheme));
extern String httpHeaderGetList _PARAMS((const HttpHeader * hdr, http_hdr_type id));
extern int httpHeaderDelByName _PARAMS((HttpHeader * hdr, const char *name));
extern int httpHeaderDelById _PARAMS((HttpHeader * hdr, http_hdr_type id));
extern void httpHeaderDelAt _PARAMS((HttpHeader * hdr, HttpHeaderPos pos));
/* avoid using these low level routines */
extern HttpHeaderEntry *httpHeaderGetEntry _PARAMS((const HttpHeader * hdr, HttpHeaderPos * pos));
extern HttpHeaderEntry *httpHeaderFindEntry _PARAMS((const HttpHeader * hdr, http_hdr_type id));
extern void httpHeaderAddEntry _PARAMS((HttpHeader * hdr, HttpHeaderEntry * e));
extern HttpHeaderEntry *httpHeaderEntryClone _PARAMS((const HttpHeaderEntry * e));
extern void httpHeaderEntryPackInto _PARAMS((const HttpHeaderEntry * e, Packer * p));
/* store report about current header usage and other stats */
extern void httpHeaderStoreReport _PARAMS((StoreEntry * e));

/* Http Msg  _PARAMS((currently in HttpReply.c @?@ )) */
extern int httpMsgIsPersistent _PARAMS((float http_ver, const HttpHeader * hdr));
extern int httpMsgIsolateHeaders _PARAMS((const char **parse_start, const char **blk_start, const char **blk_end));

/* Http Reply */
extern void httpReplyInitModule _PARAMS((void));
/* create/destroy */
extern HttpReply *httpReplyCreate _PARAMS((void));
extern void httpReplyDestroy _PARAMS((HttpReply * rep));
/* reset: clean, then init */
extern void httpReplyReset _PARAMS((HttpReply * rep));
/* absorb: copy the contents of a new reply to the old one, destroy new one */
extern void httpReplyAbsorb _PARAMS((HttpReply * rep, HttpReply * new_rep));
/* parse returns -1,0,+1 on error,need-more-data,success */
extern int httpReplyParse _PARAMS((HttpReply * rep, const char *buf, ssize_t));
extern void httpReplyPackInto _PARAMS((const HttpReply * rep, Packer * p));
/* ez-routines */
/* mem-pack: returns a ready to use mem buffer with a packed reply */
extern MemBuf httpReplyPack _PARAMS((const HttpReply * rep));
/* swap: create swap-based packer, pack, destroy packer */
extern void httpReplySwapOut _PARAMS((const HttpReply * rep, StoreEntry * e));
/* set commonly used info with one call */
extern void httpReplySetHeaders _PARAMS((HttpReply * rep, double ver, http_status status,
    const char *reason, const char *ctype, int clen, time_t lmt, time_t expires));
/* do everything in one call: init, set, pack, clean, return MemBuf */
extern MemBuf httpPackedReply _PARAMS((double ver, http_status status, const char *ctype,
    int clen, time_t lmt, time_t expires));
/* construct 304 reply and pack it into MemBuf, return MemBuf */
extern MemBuf httpPacked304Reply _PARAMS((const HttpReply * rep));
/* update when 304 reply is received for a cached object */
extern void httpReplyUpdateOnNotModified _PARAMS((HttpReply * rep, HttpReply * freshRep));
/* header manipulation */
extern int httpReplyContentLen _PARAMS((const HttpReply * rep));
extern const char *httpReplyContentType _PARAMS((const HttpReply * rep));
extern time_t httpReplyExpires _PARAMS((const HttpReply * rep));
extern int httpReplyHasCc _PARAMS((const HttpReply * rep, http_hdr_cc_type type));
extern void httpRedirectReply _PARAMS((HttpReply *, http_status, const char *));
extern int httpReplyBodySize _PARAMS((method_t, HttpReply *));

/* Http Request */
extern request_t *requestCreate _PARAMS((method_t, protocol_t, const char *urlpath));
extern void requestDestroy _PARAMS((request_t *));
extern request_t *requestLink _PARAMS((request_t *));
extern void requestUnlink _PARAMS((request_t *));
extern int httpRequestParseHeader _PARAMS((request_t * req, const char *parse_start));
extern void httpRequestSwapOut _PARAMS((const request_t * req, StoreEntry * e));
extern void httpRequestPack _PARAMS((const request_t * req, Packer * p));
extern int httpRequestPrefixLen _PARAMS((const request_t * req));
extern int httpRequestHdrAllowed _PARAMS((const HttpHeaderEntry * e, String * strConnection));
extern int httpRequestHdrAllowedByName _PARAMS((http_hdr_type id));

extern void icmpOpen _PARAMS((void));
extern void icmpClose _PARAMS((void));
extern void icmpPing _PARAMS((struct in_addr to));
extern void icmpSourcePing _PARAMS((struct in_addr to, const icp_common_t *, const char *url));
extern void icmpDomainPing _PARAMS((struct in_addr to, const char *domain));

extern void *icpCreateMessage _PARAMS((icp_opcode opcode,
    int flags,
    const char *url,
    int reqnum,
    int pad));
extern int icpUdpSend _PARAMS((int, const struct sockaddr_in *, icp_common_t *, log_type, int));
extern PF icpHandleUdp;
extern PF icpUdpSendQueue;
extern PF httpAccept;

#ifdef SQUID_SNMP
extern PF snmpHandleUdp;
extern void snmpInit _PARAMS((void));
extern void snmpConnectionOpen _PARAMS((void));
extern void snmpConnectionShutdown _PARAMS((void));
extern void snmpConnectionClose _PARAMS((void));
extern void snmpDebugOid _PARAMS((int lvl, oid * Name, snint Len));
extern void addr2oid _PARAMS((struct in_addr addr, oid * Dest));
extern struct in_addr *oid2addr _PARAMS((oid * id));
extern struct in_addr *client_entry _PARAMS((struct in_addr *current));
extern variable_list *snmp_basicFn _PARAMS((variable_list *, snint *));
extern variable_list *snmp_confFn _PARAMS((variable_list *, snint *));
extern variable_list *snmp_sysFn _PARAMS((variable_list *, snint *));
extern variable_list *snmp_prfSysFn _PARAMS((variable_list *, snint *));
extern variable_list *snmp_prfProtoFn _PARAMS((variable_list *, snint *));
extern variable_list *snmp_prfPeerFn _PARAMS((variable_list *, snint *));
extern variable_list *snmp_netIpFn _PARAMS((variable_list *, snint *));
extern variable_list *snmp_netFqdnFn _PARAMS((variable_list *, snint *));
extern variable_list *snmp_netDnsFn _PARAMS((variable_list *, snint *));
extern variable_list *snmp_meshPtblFn _PARAMS((variable_list *, snint *));
extern variable_list *snmp_meshCtblFn _PARAMS((variable_list *, snint *));
#endif /* SQUID_SNMP */

#if USE_WCCP
extern void wccpInit _PARAMS((void));
extern void wccpConnectionOpen _PARAMS((void));
extern void wccpConnectionShutdown _PARAMS((void));
extern void wccpConnectionClose _PARAMS((void));
#endif /* USE_WCCP */

extern void icpHandleIcpV3 _PARAMS((int, struct sockaddr_in, char *, int));
extern int icpCheckUdpHit _PARAMS((StoreEntry *, request_t * request));
extern void icpConnectionsOpen _PARAMS((void));
extern void icpConnectionShutdown _PARAMS((void));
extern void icpConnectionClose _PARAMS((void));
extern int icpSetCacheKey _PARAMS((const cache_key * key));
extern const cache_key *icpGetCacheKey _PARAMS((const char *url, int reqnum));

extern void ipcache_nbgethostbyname _PARAMS((const char *name,
    IPH * handler,
    void *handlerData));
extern EVH ipcache_purgelru;
extern const ipcache_addrs *ipcache_gethostbyname _PARAMS((const char *, int flags));
extern void ipcacheInvalidate _PARAMS((const char *));
extern void ipcacheReleaseInvalid _PARAMS((const char *));
extern void ipcache_init _PARAMS((void));
extern void stat_ipcache_get _PARAMS((StoreEntry *));
extern int ipcacheQueueDrain _PARAMS((void));
extern void ipcacheCycleAddr _PARAMS((const char *name, ipcache_addrs *));
extern void ipcacheMarkBadAddr _PARAMS((const char *name, struct in_addr));
extern void ipcacheMarkGoodAddr _PARAMS((const char *name, struct in_addr));
extern void ipcacheFreeMemory _PARAMS((void));
extern ipcache_addrs *ipcacheCheckNumeric _PARAMS((const char *name));
extern void ipcache_restart _PARAMS((void));
extern int ipcacheUnregister _PARAMS((const char *name, void *data));

/* MemBuf */
/* init with specific sizes */
extern void memBufInit _PARAMS((MemBuf * mb, mb_size_t szInit, mb_size_t szMax));
/* init with defaults */
extern void memBufDefInit _PARAMS((MemBuf * mb));
/* cleans mb; last function to call if you do not give .buf away */
extern void memBufClean _PARAMS((MemBuf * mb));
/* resets mb preserving  _PARAMS((or initializing if needed)) memory buffer */
extern void memBufReset _PARAMS((MemBuf * mb));
/* unfirtunate hack to test if the buffer has been Init _PARAMS(())ialized */
extern int memBufIsNull _PARAMS((MemBuf * mb));
/* calls memcpy, appends exactly size bytes, extends buffer if needed */
extern void memBufAppend _PARAMS((MemBuf * mb, const char *buf, mb_size_t size));
/* calls snprintf, extends buffer if needed */
#if STDC_HEADERS
extern void memBufPrintf _PARAMS((MemBuf * mb, const char *fmt,...));
#else
extern void memBufPrintf _PARAMS(());
#endif
/* vprintf for other printf _PARAMS(())'s to use */
extern void memBufVPrintf _PARAMS((MemBuf * mb, const char *fmt, va_list ap));
/* returns free _PARAMS(()) function to be used, _freezes_ the object! */
extern FREE *memBufFreeFunc _PARAMS((MemBuf * mb));
/* puts report on MemBuf _module_ usage into mb */
extern void memBufReport _PARAMS((MemBuf * mb));

extern char *mime_get_header _PARAMS((const char *mime, const char *header));
extern char *mime_get_header_field _PARAMS((const char *mime, const char *name, const char *prefix));
extern size_t headersEnd _PARAMS((const char *, size_t));
extern const char *mime_get_auth _PARAMS((const char *hdr, const char *auth_scheme, const char **auth_field));

extern void mimeInit _PARAMS((char *filename));
extern void mimeFreeMemory _PARAMS((void));
extern char *mimeGetContentEncoding _PARAMS((const char *fn));
extern char *mimeGetContentType _PARAMS((const char *fn));
extern char *mimeGetIcon _PARAMS((const char *fn));
extern char *mimeGetIconURL _PARAMS((const char *fn));
extern char mimeGetTransferMode _PARAMS((const char *fn));
extern int mimeGetDownloadOption _PARAMS((const char *fn));
extern int mimeGetViewOption _PARAMS((const char *fn));

extern int mcastSetTtl _PARAMS((int, int));
extern IPH mcastJoinGroups;

/* Labels for hierachical log file */
/* put them all here for easier reference when writing a logfile analyzer */


extern peer *getFirstPeer _PARAMS((void));
extern peer *getFirstUpParent _PARAMS((request_t *));
extern peer *getNextPeer _PARAMS((peer *));
extern peer *getSingleParent _PARAMS((request_t *));
extern int neighborsCount _PARAMS((request_t *));
extern int neighborsUdpPing _PARAMS((request_t *,
    StoreEntry *,
    IRCB * callback,
    void *data,
    int *exprep,
    int *timeout));
extern void neighborAddAcl _PARAMS((const char *, const char *));
extern void neighborsUdpAck _PARAMS((const cache_key *, icp_common_t *, const struct sockaddr_in *));
extern void neighborAdd _PARAMS((const char *, const char *, int, int, int, int, int));
extern void neighbors_open _PARAMS((int));
extern peer *peerFindByName _PARAMS((const char *));
extern peer *peerFindByNameAndPort _PARAMS((const char *, unsigned short));
extern peer *getDefaultParent _PARAMS((request_t * request));
extern peer *getRoundRobinParent _PARAMS((request_t * request));
extern peer *getAnyParent _PARAMS((request_t * request));
extern lookup_t peerDigestLookup _PARAMS((peer * p, request_t * request, StoreEntry * entry));
extern peer *neighborsDigestSelect _PARAMS((request_t * request, StoreEntry * entry));
extern void peerNoteDigestLookup _PARAMS((request_t * request, peer * p, lookup_t lookup));
extern void peerNoteDigestGone _PARAMS((peer * p));
extern int neighborUp _PARAMS((const peer * e));
extern CBDUNL peerDestroy;
extern char *neighborTypeStr _PARAMS((const peer * e));
extern peer_t neighborType _PARAMS((const peer *, const request_t *));
extern void peerCheckConnectStart _PARAMS((peer *));
extern void dump_peer_options _PARAMS((StoreEntry *, peer *));
extern int peerHTTPOkay _PARAMS((const peer *, request_t *));
extern peer *whichPeer _PARAMS((const struct sockaddr_in *from));
#if USE_HTCP
extern void neighborsHtcpReply _PARAMS((const cache_key *, htcpReplyData *, const struct sockaddr_in *));
#endif

extern void netdbInit _PARAMS((void));
extern void netdbHandlePingReply _PARAMS((const struct sockaddr_in *from, int hops, int rtt));
extern void netdbPingSite _PARAMS((const char *hostname));
extern void netdbInit _PARAMS((void));
extern void netdbDump _PARAMS((StoreEntry *));
extern int netdbHops _PARAMS((struct in_addr));
extern void netdbFreeMemory _PARAMS((void));
extern int netdbHostHops _PARAMS((const char *host));
extern int netdbHostRtt _PARAMS((const char *host));
extern int netdbHostPeerRtt _PARAMS((const char *host, peer * peer));
extern void netdbUpdatePeer _PARAMS((request_t *, peer * e, int rtt, int hops));
extern void netdbDeleteAddrNetwork _PARAMS((struct in_addr addr));
extern int netdbHostPeerRtt _PARAMS((const char *host, peer * peer));
extern void netdbBinaryExchange _PARAMS((StoreEntry *));
extern EVH netdbExchangeStart;
extern void netdbExchangeUpdatePeer _PARAMS((struct in_addr, peer *, double, double));
extern peer *netdbClosestParent _PARAMS((request_t *));
extern void netdbHostData _PARAMS((const char *host, int *samp, int *rtt, int *hops));

extern void cachemgrStart _PARAMS((int fd, request_t * request, StoreEntry * entry));
extern void cachemgrRegister _PARAMS((const char *, const char *, OBJH *, int, int));
extern void cachemgrInit _PARAMS((void));

extern void peerSelect _PARAMS((request_t *, StoreEntry *, PSC *, void *data));
extern void peerSelectInit _PARAMS((void));

/* peer_digest.c */
extern PeerDigest *peerDigestCreate _PARAMS((peer * p));
extern void peerDigestNeeded _PARAMS((PeerDigest * pd));
extern void peerDigestNotePeerGone _PARAMS((PeerDigest * pd));
extern void peerDigestStatsReport _PARAMS((const PeerDigest * pd, StoreEntry * e));

/* forward.c */
extern void fwdStart _PARAMS((int, StoreEntry *, request_t *));
extern DEFER fwdCheckDeferRead;
extern void fwdFail _PARAMS((FwdState *, ErrorState *));
extern void fwdUnregister _PARAMS((int fd, FwdState *));
extern void fwdComplete _PARAMS((FwdState * fwdState));
extern void fwdInit _PARAMS((void));
extern int fwdReforwardableStatus _PARAMS((http_status s));
extern void fwdServersFree _PARAMS((FwdServer ** FS));

extern void urnStart _PARAMS((request_t *, StoreEntry *));

extern void redirectStart _PARAMS((clientHttpRequest *, RH *, void *));
extern void redirectInit _PARAMS((void));
extern void redirectShutdown _PARAMS((void));

extern void authenticateStart _PARAMS((acl_proxy_auth_user *, RH *, void *));
extern void authenticateInit _PARAMS((void));
extern void authenticateShutdown _PARAMS((void));

extern void refreshAddToList _PARAMS((const char *, int, time_t, int, time_t));
extern int refreshIsCachable _PARAMS((const StoreEntry *));
extern int refreshCheckHTTP _PARAMS((const StoreEntry *, request_t *));
extern int refreshCheckICP _PARAMS((const StoreEntry *, request_t *));
extern int refreshCheckHTCP _PARAMS((const StoreEntry *, request_t *));
extern int refreshCheckDigest _PARAMS((const StoreEntry *, time_t delta));
extern time_t getMaxAge _PARAMS((const char *url));
extern void refreshInit _PARAMS((void));

extern void serverConnectionsClose _PARAMS((void));
extern void shut_down _PARAMS((int));


extern void start_announce _PARAMS((void *unused));
extern void sslStart _PARAMS((int fd, const char *, request_t *, size_t * sz));
extern void waisStart _PARAMS((FwdState *));

/* ident.c */
#if USE_IDENT
extern void identStart _PARAMS((struct sockaddr_in *me, struct sockaddr_in *peer, IDCB * callback, void *cbdata));
extern void identInit _PARAMS((void));
#endif

extern void statInit _PARAMS((void));
extern void statFreeMemory _PARAMS((void));
extern double median_svc_get _PARAMS((int, int));
extern void pconnHistCount _PARAMS((int, int));
extern int stat5minClientRequests _PARAMS((void));
extern double stat5minCPUUsage _PARAMS((void));
extern const char *storeEntryFlags _PARAMS((const StoreEntry *));
extern double statRequestHitRatio _PARAMS((int minutes));
extern double statByteHitRatio _PARAMS((int minutes));



/* StatHist */
extern void statHistClean _PARAMS((StatHist * H));
extern void statHistCount _PARAMS((StatHist * H, double val));
extern void statHistCopy _PARAMS((StatHist * Dest, const StatHist * Orig));
extern void statHistSafeCopy _PARAMS((StatHist * Dest, const StatHist * Orig));
extern double statHistDeltaMedian _PARAMS((const StatHist * A, const StatHist * B));
extern void statHistDump _PARAMS((const StatHist * H, StoreEntry * sentry, StatHistBinDumper bd));
extern void statHistLogInit _PARAMS((StatHist * H, int capacity, double min, double max));
extern void statHistEnumInit _PARAMS((StatHist * H, int last_enum));
extern void statHistIntInit _PARAMS((StatHist * H, int n));
extern StatHistBinDumper statHistEnumDumper;
extern StatHistBinDumper statHistIntDumper;

extern void memMeterSyncHWater _PARAMS((MemMeter * m));
#define memMeterCheckHWater(m) { if ((m).hwater_level < (m).level) memMeterSyncHWater(&(m)); }
#define memMeterInc(m) { (m).level++; memMeterCheckHWater(m); }
#define memMeterDec(m) { (m).level--; }
#define memMeterAdd(m, sz) { (m).level += (sz); memMeterCheckHWater(m); }
#define memMeterDel(m, sz) { (m).level -= (sz); }

/* mem */
extern void memInit _PARAMS((void));
extern void memClean _PARAMS((void));
extern void memInitModule _PARAMS((void));
extern void memCleanModule _PARAMS((void));
extern void memConfigure _PARAMS((void));
extern void *memAllocate _PARAMS((mem_type));
extern void *memAllocBuf _PARAMS((size_t net_size, size_t * gross_size));
extern CBDUNL memFree;
extern void memFreeBuf _PARAMS((size_t size, void *));
extern void memFree2K _PARAMS((void *));
extern void memFree4K _PARAMS((void *));
extern void memFree8K _PARAMS((void *));
extern void memFreeDISK _PARAMS((void *));
extern int memInUse _PARAMS((mem_type));
extern size_t memTotalAllocated _PARAMS((void));
extern void memDataInit _PARAMS((mem_type, const char *, size_t, int));
extern void memCheckInit _PARAMS((void));

/* MemPool */
extern MemPool *memPoolCreate _PARAMS((const char *label, size_t obj_size));
extern void memPoolDestroy _PARAMS((MemPool * pool));
extern void *memPoolAlloc _PARAMS((MemPool * pool));
extern void memPoolFree _PARAMS((MemPool * pool, void *obj));
extern int memPoolWasUsed _PARAMS((const MemPool * pool));
extern int memPoolInUseCount _PARAMS((const MemPool * pool));
extern size_t memPoolInUseSize _PARAMS((const MemPool * pool));
extern int memPoolUsedCount _PARAMS((const MemPool * pool));
extern void memPoolReport _PARAMS((const MemPool * pool, StoreEntry * e));

/* Mem */
extern void memReport _PARAMS((StoreEntry * e));

extern int stmemFreeDataUpto _PARAMS((mem_hdr *, int));
extern void stmemAppend _PARAMS((mem_hdr *, const char *, int));
extern ssize_t stmemCopy _PARAMS((const mem_hdr *, off_t, char *, size_t));
extern void stmemFree _PARAMS((mem_hdr *));
extern void stmemFreeData _PARAMS((mem_hdr *));

/* ----------------------------------------------------------------- */

/*
 * store.c
 */
extern StoreEntry *new_StoreEntry _PARAMS((int, const char *, const char *));
extern StoreEntry *storeGet _PARAMS((const cache_key *));
extern StoreEntry *storeGetPublic _PARAMS((const char *uri, const method_t method));
extern StoreEntry *storeCreateEntry _PARAMS((const char *, const char *, request_flags, method_t));
extern void storeSetPublicKey _PARAMS((StoreEntry *));
extern void storeComplete _PARAMS((StoreEntry *));
extern void storeInit _PARAMS((void));
extern int storeClientWaiting _PARAMS((const StoreEntry *));
extern void storeAbort _PARAMS((StoreEntry *));
extern void storeAppend _PARAMS((StoreEntry *, const char *, int));
extern void storeLockObject _PARAMS((StoreEntry *));
extern void storeRelease _PARAMS((StoreEntry *));
extern int storeUnlockObject _PARAMS((StoreEntry *));
extern int storeUnregister _PARAMS((StoreEntry *, void *));
extern void storeClientCopy _PARAMS((StoreEntry * e,
    off_t seen_offset,
    off_t copy_offset,
    size_t size,
    char *buf,
    STCB * callback,
    void *data));
extern int storePendingNClients _PARAMS((const StoreEntry *));
extern EVH storeMaintainSwapSpace;
extern void storeExpireNow _PARAMS((StoreEntry *));
extern void storeReleaseRequest _PARAMS((StoreEntry *));
extern off_t storeLowestMemReaderOffset _PARAMS((const StoreEntry *));
extern void storeConfigure _PARAMS((void));
extern void storeNegativeCache _PARAMS((StoreEntry *));
extern void storeFreeMemory _PARAMS((void));
extern int expiresMoreThan _PARAMS((time_t, time_t));
extern int storeClientCopyPending _PARAMS((StoreEntry *, void *));
extern void InvokeHandlers _PARAMS((StoreEntry *));
extern int storeEntryValidToSend _PARAMS((StoreEntry *));
extern void storeTimestampsSet _PARAMS((StoreEntry *));
#if !HEAP_REPLACEMENT
extern time_t storeExpiredReferenceAge _PARAMS((void));
#endif
extern void storeRegisterAbort _PARAMS((StoreEntry * e, STABH * cb, void *));
extern void storeUnregisterAbort _PARAMS((StoreEntry * e));
extern void storeMemObjectDump _PARAMS((MemObject * mem));
extern void storeEntryDump _PARAMS((const StoreEntry * e, int debug_lvl));
extern const char *storeUrl _PARAMS((const StoreEntry *));
extern void storeCreateMemObject _PARAMS((StoreEntry *, const char *, const char *));
extern void storeCopyNotModifiedReplyHeaders _PARAMS((MemObject * O, MemObject * N));
extern void storeBuffer _PARAMS((StoreEntry *));
extern void storeBufferFlush _PARAMS((StoreEntry *));
extern void storeHashInsert _PARAMS((StoreEntry * e, const cache_key *));
extern void storeSetMemStatus _PARAMS((StoreEntry * e, int));
#if STDC_HEADERS
extern void storeAppendPrintf _PARAMS((StoreEntry *, const char *,...));
#else
extern void storeAppendPrintf _PARAMS(());
#endif
extern void storeAppendVPrintf _PARAMS((StoreEntry *, const char *, va_list ap));
extern int storeCheckCachable _PARAMS((StoreEntry * e));
extern void storeSetPrivateKey _PARAMS((StoreEntry *));
extern int objectLen _PARAMS((const StoreEntry * e));
extern int contentLen _PARAMS((const StoreEntry * e));
extern HttpReply *storeEntryReply _PARAMS((StoreEntry *));
extern int storeTooManyDiskFilesOpen _PARAMS((void));
extern void storeEntryReset _PARAMS((StoreEntry *));
extern void storeHeapPositionUpdate _PARAMS((StoreEntry *));

/* store_io.c */
extern STOBJOPEN storeOpen;
extern STOBJCLOSE storeClose;
extern STOBJREAD storeRead;
extern STOBJWRITE storeWrite;
extern STOBJUNLINK storeUnlink;
extern off_t storeOffset _PARAMS((storeIOState *));

/*
 * store_io_ufs.c
 */
extern storeIOState *storeUfsOpen _PARAMS((sfileno, mode_t, STIOCB *, void *));
extern void storeUfsClose _PARAMS((storeIOState * sio));
extern void storeUfsRead _PARAMS((storeIOState *, char *, size_t, off_t, STRCB *, void *));
extern void storeUfsWrite _PARAMS((storeIOState *, char *, size_t, off_t, FREE *));
extern void storeUfsUnlink _PARAMS((int fileno));

#if USE_ASYNC_IO
/*
 * store_io_ufs.c
 */
extern storeIOState *storeAufsOpen _PARAMS((sfileno, mode_t, STIOCB *, void *));
extern void storeAufsClose _PARAMS((storeIOState * sio));
extern void storeAufsRead _PARAMS((storeIOState *, char *, size_t, off_t, STRCB *, void *));
extern void storeAufsWrite _PARAMS((storeIOState *, char *, size_t, off_t, FREE *));
extern void storeAufsUnlink _PARAMS((int fileno));
#endif

/*
 * store_log.c
 */
extern void storeLog _PARAMS((int tag, const StoreEntry * e));
extern void storeLogRotate _PARAMS((void));
extern void storeLogClose _PARAMS((void));
extern void storeLogOpen _PARAMS((void));


/*
 * store_key_*.c
 */
extern const cache_key *storeKeyDup _PARAMS((const cache_key *));
extern cache_key *storeKeyCopy _PARAMS((cache_key *, const cache_key *));
extern void storeKeyFree _PARAMS((const cache_key *));
extern const cache_key *storeKeyScan _PARAMS((const char *));
extern const char *storeKeyText _PARAMS((const cache_key *));
extern const cache_key *storeKeyPublic _PARAMS((const char *, const method_t));
extern const cache_key *storeKeyPrivate _PARAMS((const char *, method_t, int));
extern int storeKeyHashBuckets _PARAMS((int));
extern int storeKeyNull _PARAMS((const cache_key *));
extern void storeKeyInit _PARAMS((void));
extern HASHHASH storeKeyHashHash;
extern HASHCMP storeKeyHashCmp;

/*
 * store_digest.c
 */
extern void storeDigestInit _PARAMS((void));
extern void storeDigestNoteStoreReady _PARAMS((void));
extern void storeDigestScheduleRebuild _PARAMS((void));
extern void storeDigestDel _PARAMS((const StoreEntry * entry));
extern void storeDigestReport _PARAMS((StoreEntry *));

/*
 * store_dir.c
 */
extern OBJH storeDirStats;
extern char *storeDirSwapLogFile _PARAMS((int, const char *));
extern char *storeSwapDir _PARAMS((int));
extern char *storeSwapFullPath _PARAMS((int, char *));
extern char *storeSwapSubSubDir _PARAMS((int, char *));
extern const char *storeSwapPath _PARAMS((int));
extern int storeDirMapAllocate _PARAMS((void));
extern int storeDirMapBitTest _PARAMS((int fn));
extern int storeDirMapBitsInUse _PARAMS((void));
extern int storeDirNumber _PARAMS((int fileno));
extern int storeDirProperFileno _PARAMS((int dirn, int fn));
extern int storeDirValidFileno _PARAMS((int fn, int));
extern int storeDirWriteCleanLogs _PARAMS((int reopen));
extern int storeVerifySwapDirs _PARAMS((void));
extern void storeCreateSwapDirectories _PARAMS((void));
extern void storeDirCloseSwapLogs _PARAMS((void));
extern void storeDirCloseTmpSwapLog _PARAMS((int dirn));
extern void storeDirConfigure _PARAMS((void));
extern void storeDirDiskFull _PARAMS((int fn));
extern void storeDirInit _PARAMS((void));
extern void storeDirMapBitReset _PARAMS((int fn));
extern void storeDirMapBitSet _PARAMS((int fn));
extern void storeDirOpenSwapLogs _PARAMS((void));
extern void storeDirSwapLog _PARAMS((const StoreEntry *, int op));
extern void storeDirUpdateSwapSize _PARAMS((int fn, size_t size, int sign));

/*
 * store_dir_ufs.c
 */
extern OBJH storeUfsDirStats;
extern void storeUfsDirParse _PARAMS((cacheSwap * swap));
extern void storeUfsDirDump _PARAMS((StoreEntry * entry, const char *name, SwapDir * s));
extern void storeUfsDirFree _PARAMS((SwapDir *));
extern char *storeUfsFullPath _PARAMS((sfileno fn, char *fullpath));
#if USE_ASYNC_IO
extern void storeAufsDirParse _PARAMS((cacheSwap * swap));
#endif


/*
 * store_swapmeta.c
 */
extern char *storeSwapMetaPack _PARAMS((tlv * tlv_list, int *length));
extern tlv *storeSwapMetaBuild _PARAMS((StoreEntry * e));
extern tlv *storeSwapMetaUnpack _PARAMS((const char *buf, int *hdrlen));
extern void storeSwapTLVFree _PARAMS((tlv * n));

/*
 * store_rebuild.c
 */
extern void storeRebuildStart _PARAMS((void));
extern void storeRebuildComplete _PARAMS((struct _store_rebuild_data *));

/*
 * store_swapin.c
 */
extern void storeSwapInStart _PARAMS((store_client *));

/*
 * store_swapout.c
 */
extern void storeSwapOut _PARAMS((StoreEntry * e));
extern void storeSwapOutFileClose _PARAMS((StoreEntry * e));
extern int storeSwapOutAble _PARAMS((const StoreEntry * e));

/*
 * store_client.c
 */
extern store_client *storeClientListSearch _PARAMS((const MemObject * mem, void *data));
extern void storeClientListAdd _PARAMS((StoreEntry * e, void *data));
extern void storeClientCopy _PARAMS((StoreEntry *, off_t, off_t, size_t, char *, STCB *, void *));
extern int storeClientCopyPending _PARAMS((StoreEntry * e, void *data));
extern int storeUnregister _PARAMS((StoreEntry * e, void *data));
extern off_t storeLowestMemReaderOffset _PARAMS((const StoreEntry * entry));
extern void InvokeHandlers _PARAMS((StoreEntry * e));
extern int storePendingNClients _PARAMS((const StoreEntry * e));


extern const char *getMyHostname _PARAMS((void));
extern const char *uniqueHostname _PARAMS((void));
extern void safeunlink _PARAMS((const char *path, int quiet));
extern void death _PARAMS((int sig));
extern void fatal _PARAMS((const char *message));
#if STDC_HEADERS
extern void fatalf _PARAMS((const char *fmt,...));
#else
extern void fatalf _PARAMS(());
#endif
extern void fatal_dump _PARAMS((const char *message));
extern void sigusr2_handle _PARAMS((int sig));
extern void sig_child _PARAMS((int sig));
extern void leave_suid _PARAMS((void));
extern void enter_suid _PARAMS((void));
extern void no_suid _PARAMS((void));
extern void writePidFile _PARAMS((void));
extern void setSocketShutdownLifetimes _PARAMS((int));
extern void setMaxFD _PARAMS((void));
extern time_t getCurrentTime _PARAMS((void));
extern int percent _PARAMS((int, int));
extern double dpercent _PARAMS((double, double));
extern void squid_signal _PARAMS((int sig, SIGHDLR *, int flags));
extern pid_t readPidFile _PARAMS((void));
extern struct in_addr inaddrFromHostent _PARAMS((const struct hostent *hp));
extern int intAverage _PARAMS((int, int, int, int));
extern double doubleAverage _PARAMS((double, double, int, int));
extern void debug_trap _PARAMS((const char *));
extern void logsFlush _PARAMS((void));
extern char *checkNullString _PARAMS((char *p));
extern void squid_getrusage _PARAMS((struct rusage *r));
extern double rusage_cputime _PARAMS((struct rusage *r));
extern int rusage_maxrss _PARAMS((struct rusage *r));
extern int rusage_pagefaults _PARAMS((struct rusage *r));
extern void releaseServerSockets _PARAMS((void));
extern void PrintRusage _PARAMS((void));
extern void dumpMallocStats _PARAMS((void));

extern void pumpInit _PARAMS((int fd, request_t * r, char *uri));
extern void pumpStart _PARAMS((int, FwdState *, CWCB * callback, void *));
extern int pumpMethod _PARAMS((method_t method));
extern int pumpRestart _PARAMS((request_t *));

extern void unlinkdInit _PARAMS((void));
extern void unlinkdClose _PARAMS((void));
extern void unlinkdUnlink _PARAMS((const char *));

extern char *url_convert_hex _PARAMS((char *org_url, int allocate));
extern char *url_escape _PARAMS((const char *url));
extern protocol_t urlParseProtocol _PARAMS((const char *));
extern method_t urlParseMethod _PARAMS((const char *));
extern void urlInitialize _PARAMS((void));
extern request_t *urlParse _PARAMS((method_t, char *));
extern const char *urlCanonical _PARAMS((request_t *));
extern char *urlRInternal _PARAMS((const char *host, u_short port, const char *dir, const char *name));
extern char *urlInternal _PARAMS((const char *dir, const char *name));
extern int matchDomainName _PARAMS((const char *host, const char *domain));
extern int urlCheckRequest _PARAMS((const request_t *));
extern int urlDefaultPort _PARAMS((protocol_t p));
extern char *urlCanonicalClean _PARAMS((const request_t *));
extern char *urlHostname _PARAMS((const char *url));

extern void useragentOpenLog _PARAMS((void));
extern void useragentRotateLog _PARAMS((void));
extern void logUserAgent _PARAMS((const char *, const char *));
extern peer_t parseNeighborType _PARAMS((const char *s));

extern void errorInitialize _PARAMS((void));
extern void errorClean _PARAMS((void));
extern HttpReply *errorBuildReply _PARAMS((ErrorState * err));
extern void errorSend _PARAMS((int fd, ErrorState *));
extern void errorAppendEntry _PARAMS((StoreEntry *, ErrorState *));
extern void errorStateFree _PARAMS((ErrorState * err));
extern int errorReservePageId _PARAMS((const char *page_name));
extern ErrorState *errorCon _PARAMS((err_type type, http_status));

extern void pconnPush _PARAMS((int, const char *host, u_short port));
extern int pconnPop _PARAMS((const char *host, u_short port));
extern void pconnInit _PARAMS((void));

extern int asnMatchIp _PARAMS((void *, struct in_addr));
extern void asnInit _PARAMS((void));
extern void asnFreeMemory _PARAMS((void));

/* tools.c */
extern void dlinkAdd _PARAMS((void *data, dlink_node *, dlink_list *));
extern void dlinkAddTail _PARAMS((void *data, dlink_node *, dlink_list *));
extern void dlinkDelete _PARAMS((dlink_node * m, dlink_list * list));
extern void kb_incr _PARAMS((kb_t *, size_t));
extern double gb_to_double _PARAMS((const gb_t *));
extern const char *gb_to_str _PARAMS((const gb_t *));
extern void gb_flush _PARAMS((gb_t *));	/* internal, do not use this */
extern int stringHasWhitespace _PARAMS((const char *));
extern int stringHasCntl _PARAMS((const char *));
extern void linklistPush _PARAMS((link_list **, void *));
extern void *linklistShift _PARAMS((link_list **));
extern int xrename _PARAMS((const char *from, const char *to));

#if USE_HTCP
extern void htcpInit _PARAMS((void));
extern void htcpQuery _PARAMS((StoreEntry * e, request_t * req, peer * p));
extern void htcpSocketShutdown _PARAMS((void));
extern void htcpSocketClose _PARAMS((void));
#endif

/* String */
#define strLen(s)      ( (const int) (s).len)
#define strBuf(s)      ( (const char*) (s).buf)
#define strChr(s,ch)   ( (const char*)strchr (strBuf (s),(ch)))
#define strRChr(s,ch)  ( (const char*)strrchr (strBuf (s),(ch)))
#define strStr(s,str)  ( (const char*)strstr (strBuf (s),(str)))
#define strCmp(s,str)   strcmp (strBuf (s),  (str))
#define strNCmp(s,str,n)     strncmp (strBuf (s),  (str),  (n))
#define strCaseCmp(s,str) strcasecmp (strBuf (s),  (str))
#define strNCaseCmp(s,str,n) strncasecmp (strBuf (s),  (str),  (n))
#define strSet(s,ptr,ch)  (s).buf[ptr- (s).buf] =  (ch)
#define strCut(s,pos)  ( ( (s).len = pos) ,  ( (s).buf[pos] = '\0'))
#define strCutPtr(s,ptr)  ( ( (s).len =  (ptr)- (s).buf) ,  ( (s).buf[ (s).len] = '\0'))
/* #define strCat _PARAMS((s,str))  stringAppend _PARAMS((& _PARAMS((s)),  _PARAMS((str)), strlen _PARAMS((str))+1)) */
extern void stringInit _PARAMS((String * s, const char *str));
extern void stringLimitInit _PARAMS((String * s, const char *str, int len));
extern String stringDup _PARAMS((const String * s));
extern void stringClean _PARAMS((String * s));
extern void stringReset _PARAMS((String * s, const char *str));
extern void stringAppend _PARAMS((String * s, const char *buf, int len));
/* extern void stringAppendf _PARAMS((String *s, const char *fmt, ...)); */

/*
 * ipc.c
 */
extern int ipcCreate _PARAMS((int type,
    const char *prog,
    char * args[],
    const char *name,
    int *rfd,
    int *wfd));

/* CacheDigest */
extern CacheDigest *cacheDigestCreate _PARAMS((int capacity, int bpe));
extern void cacheDigestDestroy _PARAMS((CacheDigest * cd));
extern CacheDigest *cacheDigestClone _PARAMS((const CacheDigest * cd));
extern void cacheDigestClear _PARAMS((CacheDigest * cd));
extern void cacheDigestChangeCap _PARAMS((CacheDigest * cd, int new_cap));
extern int cacheDigestTest _PARAMS((const CacheDigest * cd, const cache_key * key));
extern void cacheDigestAdd _PARAMS((CacheDigest * cd, const cache_key * key));
extern void cacheDigestDel _PARAMS((CacheDigest * cd, const cache_key * key));
extern size_t cacheDigestCalcMaskSize _PARAMS((int cap, int bpe));
extern int cacheDigestBitUtil _PARAMS((const CacheDigest * cd));
extern void cacheDigestGuessStatsUpdate _PARAMS((cd_guess_stats * stats, int real_hit, int guess_hit));
extern void cacheDigestGuessStatsReport _PARAMS((const cd_guess_stats * stats, StoreEntry * sentry, const char *label));
extern void cacheDigestReport _PARAMS((CacheDigest * cd, const char *label, StoreEntry * e));

extern void internalStart _PARAMS((request_t *, StoreEntry *));
extern int internalCheck _PARAMS((const char *urlpath));
extern int internalStaticCheck _PARAMS((const char *urlpath));
extern char *internalLocalUri _PARAMS((const char *dir, const char *name));
extern char *internalRemoteUri _PARAMS((const char *, u_short, const char *, const char *));
extern const char *internalHostname _PARAMS((void));
extern int internalHostnameIs _PARAMS((const char *));

#if USE_CARP
extern void carpInit _PARAMS((void));
extern peer *carpSelectParent _PARAMS((request_t *));
#endif

#if DELAY_POOLS
extern void delayPoolsInit _PARAMS((void));
extern void delayInitDelayData _PARAMS((unsigned short pools));
extern void delayFreeDelayData _PARAMS((void));
extern void delayCreateDelayPool _PARAMS((unsigned short pool, u_char class));
extern void delayInitDelayPool _PARAMS((unsigned short pool, u_char class, delaySpecSet * rates));
extern void delayFreeDelayPool _PARAMS((unsigned short pool));
extern void delayPoolsReconfigure _PARAMS((void));
extern void delaySetNoDelay _PARAMS((int fd));
extern void delayClearNoDelay _PARAMS((int fd));
extern int delayIsNoDelay _PARAMS((int fd));
extern delay_id delayClient _PARAMS((request_t *));
extern EVH delayPoolsUpdate;
extern int delayBytesWanted _PARAMS((delay_id d, int min, int max));
extern void delayBytesIn _PARAMS((delay_id, int qty));
extern int delayMostBytesWanted _PARAMS((const MemObject * mem, int max));
extern delay_id delayMostBytesAllowed _PARAMS((const MemObject * mem));
extern void delaySetStoreClient _PARAMS((StoreEntry * e, void *data, delay_id delay_id));
void delayRegisterDelayIdPtr _PARAMS((delay_id * loc));
void delayUnregisterDelayIdPtr _PARAMS((delay_id * loc));
#endif

/* helper.c */
extern void helperOpenServers _PARAMS((helper * hlp));
extern void helperSubmit _PARAMS((helper * hlp, const char *buf, HLPCB * callback, void *data));
extern void helperStats _PARAMS((StoreEntry * sentry, helper * hlp));
extern void helperShutdown _PARAMS((helper * hlp));
extern helper *helperCreate _PARAMS((const char *));
extern void helperFree _PARAMS((helper *));

#if USE_LEAKFINDER
extern void leakInit _PARAMS((void));
extern void *leakAddFL _PARAMS((void *, const char *, int));
extern void *leakTouchFL _PARAMS((void *, const char *, int));
extern void *leakFree _PARAMS((void *));
#endif

int rename_unixstyle _PARAMS((const char *old_name, const char *new_name));
/*
 * prototypes for system functions missing from system includes
 */

#ifdef _SQUID_SOLARIS_
extern int getrusage _PARAMS((int, struct rusage *));
extern int getpagesize _PARAMS((void));
extern int gethostname _PARAMS((char *, int));
#endif
