/*
 * Generated automatically from cf.data by cf_gen.exe
 *
 * Abstract: This file contains routines used to configure the
 *           variables in the squid server.
 */

static void
default_line(const char *s)
{
	LOCAL_ARRAY(char, tmp_line, BUFSIZ);
	xstrncpy(tmp_line, s, BUFSIZ);
	xstrncpy(config_input_line, s, BUFSIZ);
	config_lineno++;
	parse_line(tmp_line);
}
static void
default_all(void)
{
	cfg_filename = "Default Configuration";
	config_lineno = 0;
	/* No default for http_port */
	default_line("icp_port 3130");
#if USE_HTCP
	default_line("htcp_port 4827");
#endif
	/* No default for mcast_groups */
	default_line("tcp_outgoing_address 255.255.255.255");
	default_line("udp_incoming_address 0.0.0.0");
	default_line("udp_outgoing_address 255.255.255.255");
	/* No default for cache_peer */
	/* No default for cache_peer_domain */
	/* No default for neighbor_type_domain */
	default_line("icp_query_timeout 0");
	default_line("maximum_icp_query_timeout 2000");
	default_line("mcast_icp_query_timeout 2000");
	default_line("dead_peer_timeout 10 seconds");
	/* No default for hierarchy_stoplist */
	/* No default for no_cache */
	default_line("cache_mem 8 MB");
	default_line("cache_swap_low 90");
	default_line("cache_swap_high 95");
	default_line("maximum_object_size 4096 KB");
	default_line("ipcache_size 1024");
	default_line("ipcache_low 90");
	default_line("ipcache_high 95");
	default_line("fqdncache_size 1024");
	/* No default for cache_dir */
	default_line("cache_access_log logs/access_log");
	default_line("cache_log logs/cache_log");
	default_line("cache_store_log logs/store_log");
	/* No default for cache_swap_log */
	default_line("emulate_httpd_log off");
	default_line("mime_table errors/mime.conf");
	default_line("log_mime_hdrs off");
	/* No default for useragent_log */
	default_line("pid_filename squid.pid");
	default_line("debug_options ALL,1");
	default_line("log_fqdn off");
	default_line("client_netmask 255.255.255.255");
	default_line("ftp_user Squid@");
	default_line("ftp_list_width 32");
	default_line("cache_dns_program dnsserver.exe");
	default_line("dns_children 5");
	default_line("dns_defnames off");
	/* No default for dns_nameservers */
	default_line("unlinkd_program unlinkd.exe");
	default_line("pinger_program pinger.exe");
	/* No default for redirect_program */
	default_line("redirect_children 5");
	default_line("redirect_rewrites_host_header on");
	/* No default for redirector_access */
	/* No default for authenticate_program */
	default_line("authenticate_children 5");
	default_line("authenticate_ttl 3600");
	default_line("authenticate_ip_ttl 0");
	/* No default for wais_relay_host */
	default_line("wais_relay_port 0");
	default_line("request_header_max_size 10 KB");
	default_line("request_body_max_size 1 MB");
	default_line("reply_body_max_size 0");
	/* No default for refresh_pattern */
#if HEAP_REPLACEMENT
	default_line("replacement_policy LFUDA");
#endif
	default_line("reference_age 1 year");
	default_line("quick_abort_min 16 KB");
	default_line("quick_abort_max 16 kb");
	default_line("quick_abort_pct 95");
	default_line("negative_ttl 5 minutes");
	default_line("positive_dns_ttl 6 hours");
	default_line("negative_dns_ttl 5 minutes");
	default_line("range_offset_limit 0 KB");
	default_line("connect_timeout 2 minutes");
	default_line("peer_connect_timeout 30 seconds");
	default_line("siteselect_timeout 4 seconds");
	default_line("read_timeout 15 minutes");
	default_line("request_timeout 30 seconds");
	default_line("client_lifetime 1 day");
	default_line("half_closed_clients on");
	default_line("pconn_timeout 120 seconds");
#if USE_IDENT
	default_line("ident_timeout 10 seconds");
#endif
	default_line("shutdown_lifetime 30 seconds");
	/* No default for acl */
	/* No default for http_access */
	/* No default for icp_access */
	/* No default for miss_access */
	/* No default for cache_peer_access */
	default_line("proxy_auth_realm Squid proxy-caching web server");
#if USE_IDENT
	/* No default for ident_lookup_access */
#endif
	default_line("cache_mgr webmaster");
	default_line("cache_effective_user nobody");
	default_line("cache_effective_group nogroup");
	/* No default for visible_hostname */
	/* No default for unique_hostname */
	/* No default for hostname_aliases */
	default_line("announce_period 0");
	default_line("announce_host tracker.ircache.net");
	/* No default for announce_file */
	default_line("announce_port 3131");
	/* No default for httpd_accel_host */
	default_line("httpd_accel_port 80");
	default_line("httpd_accel_with_proxy off");
	default_line("httpd_accel_uses_host_header off");
	/* No default for dns_testnames */
	default_line("logfile_rotate 10");
	/* No default for append_domain */
	default_line("tcp_recv_bufsize 0 bytes");
	/* No default for err_html_text */
	/* No default for deny_info */
	default_line("memory_pools on");
	/* No default for memory_pools_limit */
	default_line("forwarded_for on");
	default_line("log_icp_queries on");
	default_line("icp_hit_stale off");
	default_line("minimum_direct_hops 4");
	/* No default for cachemgr_passwd */
	default_line("store_avg_object_size 13 KB");
	default_line("store_objects_per_bucket 50");
	default_line("client_db on");
	default_line("netdb_low 900");
	default_line("netdb_high 1000");
	default_line("netdb_ping_period 5 minutes");
	default_line("query_icmp off");
	default_line("test_reachability off");
	default_line("buffered_logs off");
#if HTTP_VIOLATIONS
	default_line("reload_into_ims off");
#endif
	/* No default for always_direct */
	/* No default for never_direct */
	/* No default for anonymize_headers */
	/* No default for fake_user_agent */
	default_line("icon_directory icons");
	default_line("error_directory errors");
	default_line("minimum_retry_timeout 5 seconds");
	default_line("maximum_single_addr_tries 3");
#if SQUID_SNMP
	default_line("snmp_port 3401");
#endif
#if SQUID_SNMP
	/* No default for snmp_access */
#endif
#if SQUID_SNMP
	default_line("snmp_incoming_address 0.0.0.0");
#endif
#if SQUID_SNMP
	default_line("snmp_outgoing_address 255.255.255.255");
#endif
	default_line("as_whois_server whois.ra.net");
#if USE_WCCP
	default_line("wccp_router 0.0.0.0");
#endif
#if USE_WCCP
	default_line("wccp_incoming_address 0.0.0.0");
#endif
#if USE_WCCP
	default_line("wccp_outgoing_address 255.255.255.255");
#endif
#if DELAY_POOLS
	default_line("delay_pools 0");
#endif
#if DELAY_POOLS
	/* No default for delay_class */
#endif
#if DELAY_POOLS
	/* No default for delay_access */
#endif
#if DELAY_POOLS
	/* No default for delay_parameters */
#endif
#if DELAY_POOLS
	default_line("delay_initial_bucket_level 50");
#endif
	default_line("incoming_icp_average 6");
	default_line("incoming_http_average 4");
	default_line("min_icp_poll_cnt 8");
	default_line("min_http_poll_cnt 8");
	default_line("max_open_disk_fds 0");
	default_line("offline_mode off");
	default_line("uri_whitespace strip");
	/* No default for broken_posts */
#if MULTICAST_MISS_STREAM
	default_line("mcast_miss_addr 255.255.255.255");
#endif
#if MULTICAST_MISS_TTL
	default_line("mcast_miss_ttl 16");
#endif
#if MULTICAST_MISS_STREAM
	default_line("mcast_miss_port 3135");
#endif
#if MULTICAST_MISS_STREAM
	default_line("mcast_miss_encode_key XXXXXXXXXXXXXXXX");
#endif
	default_line("prefer_direct on");
	default_line("strip_query_terms on");
	/* No default for coredump_dir */
	default_line("redirector_bypass off");
	default_line("ignore_unknown_nameservers on");
#if USE_CACHE_DIGESTS
	default_line("digest_generation on");
#endif
#if USE_CACHE_DIGESTS
	default_line("digest_bits_per_entry 5");
#endif
#if USE_CACHE_DIGESTS
	default_line("digest_rebuild_period 1 hour");
#endif
#if USE_CACHE_DIGESTS
	default_line("digest_rewrite_period 1 hour");
#endif
#if USE_CACHE_DIGESTS
	default_line("digest_swapout_chunk_size 4096 bytes");
#endif
#if USE_CACHE_DIGESTS
	default_line("digest_rebuild_chunk_percentage 10");
#endif
	/* No default for chroot */
	default_line("restart_times 3");
	cfg_filename = NULL;
}

static void
defaults_if_none(void)
{
	if (check_null_sockaddr_in_list(Config.Sockaddr.http))
		default_line("http_port 3128");
	if (check_null_wordlist(Config.hierarchy_stoplist))
		default_line("hierarchy_stoplist cgi-bin ?");
	if (check_null_cachedir(Config.cacheSwap))
		default_line("cache_dir ufs cache 100 16 256");
	if (check_null_acl_access(Config.accessList.http))
		default_line("http_access deny all");
	if (check_null_acl_access(Config.accessList.icp))
		default_line("icp_access deny all");
#if USE_IDENT
	if (check_null_acl_access(Config.accessList.identLookup))
		default_line("ident_lookup_access deny all");
#endif
#if SQUID_SNMP
	if (check_null_acl_access(Config.accessList.snmp))
		default_line("snmp_access deny all");
#endif
	if (check_null_string(Config.as_whois_server))
		default_line("as_whois_server whois.ra.net");
}

static int
parse_line(char *buff)
{
	int	result = 1;
	char	*token;
	debug(0,10)("parse_line: %s\n", buff);
	if ((token = strtok(buff, w_space)) == NULL)
		(void) 0;	/* ignore empty lines */
	else if (!strcmp(token, "http_port"))
		parse_sockaddr_in_list(&Config.Sockaddr.http);
	else if (!strcmp(token, "icp_port"))
		parse_ushort(&Config.Port.icp);
#if USE_HTCP
	else if (!strcmp(token, "htcp_port"))
		parse_ushort(&Config.Port.htcp);
#endif
	else if (!strcmp(token, "mcast_groups"))
		parse_wordlist(&Config.mcast_group_list);
	else if (!strcmp(token, "tcp_outgoing_address"))
		parse_address(&Config.Addrs.tcp_outgoing);
	else if (!strcmp(token, "udp_incoming_address"))
		parse_address(&Config.Addrs.udp_incoming);
	else if (!strcmp(token, "udp_outgoing_address"))
		parse_address(&Config.Addrs.udp_outgoing);
	else if (!strcmp(token, "cache_peer"))
		parse_peer(&Config.peers);
	else if (!strcmp(token, "cache_peer_domain"))
		parse_hostdomain();
	else if (!strcmp(token, "neighbor_type_domain"))
		parse_hostdomaintype();
	else if (!strcmp(token, "icp_query_timeout"))
		parse_int(&Config.Timeout.icp_query);
	else if (!strcmp(token, "maximum_icp_query_timeout"))
		parse_int(&Config.Timeout.icp_query_max);
	else if (!strcmp(token, "mcast_icp_query_timeout"))
		parse_int(&Config.Timeout.mcast_icp_query);
	else if (!strcmp(token, "dead_peer_timeout"))
		parse_time_t(&Config.Timeout.deadPeer);
	else if (!strcmp(token, "hierarchy_stoplist"))
		parse_wordlist(&Config.hierarchy_stoplist);
	else if (!strcmp(token, "no_cache"))
		parse_acl_access(&Config.accessList.noCache);
	else if (!strcmp(token, "cache_mem"))
		parse_b_size_t(&Config.memMaxSize);
	else if (!strcmp(token, "cache_swap_low"))
		parse_int(&Config.Swap.lowWaterMark);
	else if (!strcmp(token, "cache_swap_high"))
		parse_int(&Config.Swap.highWaterMark);
	else if (!strcmp(token, "maximum_object_size"))
		parse_b_size_t(&Config.Store.maxObjectSize);
	else if (!strcmp(token, "ipcache_size"))
		parse_int(&Config.ipcache.size);
	else if (!strcmp(token, "ipcache_low"))
		parse_int(&Config.ipcache.low);
	else if (!strcmp(token, "ipcache_high"))
		parse_int(&Config.ipcache.high);
	else if (!strcmp(token, "fqdncache_size"))
		parse_int(&Config.fqdncache.size);
	else if (!strcmp(token, "cache_dir"))
		parse_cachedir(&Config.cacheSwap);
	else if (!strcmp(token, "cache_access_log"))
		parse_string(&Config.Log.access);
	else if (!strcmp(token, "cache_log"))
		parse_string(&Config.Log.log);
	else if (!strcmp(token, "cache_store_log"))
		parse_string(&Config.Log.store);
	else if (!strcmp(token, "cache_swap_log"))
		parse_string(&Config.Log.swap);
	else if (!strcmp(token, "emulate_httpd_log"))
		parse_onoff(&Config.onoff.common_log);
	else if (!strcmp(token, "mime_table"))
		parse_string(&Config.mimeTablePathname);
	else if (!strcmp(token, "log_mime_hdrs"))
		parse_onoff(&Config.onoff.log_mime_hdrs);
	else if (!strcmp(token, "useragent_log"))
		parse_string(&Config.Log.useragent);
	else if (!strcmp(token, "pid_filename"))
		parse_string(&Config.pidFilename);
	else if (!strcmp(token, "debug_options"))
		parse_eol(&Config.debugOptions);
	else if (!strcmp(token, "log_fqdn"))
		parse_onoff(&Config.onoff.log_fqdn);
	else if (!strcmp(token, "client_netmask"))
		parse_address(&Config.Addrs.client_netmask);
	else if (!strcmp(token, "ftp_user"))
		parse_string(&Config.Ftp.anon_user);
	else if (!strcmp(token, "ftp_list_width"))
		parse_size_t(&Config.Ftp.list_width);
	else if (!strcmp(token, "cache_dns_program"))
		parse_string(&Config.Program.dnsserver);
	else if (!strcmp(token, "dns_children"))
		parse_int(&Config.dnsChildren);
	else if (!strcmp(token, "dns_defnames"))
		parse_onoff(&Config.onoff.res_defnames);
	else if (!strcmp(token, "dns_nameservers"))
		parse_wordlist(&Config.dns_nameservers);
	else if (!strcmp(token, "unlinkd_program"))
		parse_string(&Config.Program.unlinkd);
	else if (!strcmp(token, "pinger_program"))
		parse_string(&Config.Program.pinger);
	else if (!strcmp(token, "redirect_program"))
		parse_wordlist(&Config.Program.redirect);
	else if (!strcmp(token, "redirect_children"))
		parse_int(&Config.redirectChildren);
	else if (!strcmp(token, "redirect_rewrites_host_header"))
		parse_onoff(&Config.onoff.redir_rewrites_host);
	else if (!strcmp(token, "redirector_access"))
		parse_acl_access(&Config.accessList.redirector);
	else if (!strcmp(token, "authenticate_program"))
		parse_wordlist(&Config.Program.authenticate);
	else if (!strcmp(token, "authenticate_children"))
		parse_int(&Config.authenticateChildren);
	else if (!strcmp(token, "authenticate_ttl"))
		parse_int(&Config.authenticateTTL);
	else if (!strcmp(token, "authenticate_ip_ttl"))
		parse_int(&Config.authenticateIpTTL);
	else if (!strcmp(token, "wais_relay_host"))
		parse_string(&Config.Wais.relayHost);
	else if (!strcmp(token, "wais_relay_port"))
		parse_ushort(&Config.Wais.relayPort);
	else if (!strcmp(token, "request_header_max_size"))
		parse_b_size_t(&Config.maxRequestHeaderSize);
	else if (!strcmp(token, "request_body_max_size"))
		parse_b_size_t(&Config.maxRequestBodySize);
	else if (!strcmp(token, "reply_body_max_size"))
		parse_b_size_t(&Config.maxReplyBodySize);
	else if (!strcmp(token, "refresh_pattern"))
		parse_refreshpattern(&Config.Refresh);
#if HEAP_REPLACEMENT
	else if (!strcmp(token, "replacement_policy"))
		parse_string(&Config.replPolicy);
#endif
	else if (!strcmp(token, "reference_age"))
		parse_time_t(&Config.referenceAge);
	else if (!strcmp(token, "quick_abort_min"))
		parse_kb_size_t(&Config.quickAbort.min);
	else if (!strcmp(token, "quick_abort_max"))
		parse_kb_size_t(&Config.quickAbort.max);
	else if (!strcmp(token, "quick_abort_pct"))
		parse_int(&Config.quickAbort.pct);
	else if (!strcmp(token, "negative_ttl"))
		parse_time_t(&Config.negativeTtl);
	else if (!strcmp(token, "positive_dns_ttl"))
		parse_time_t(&Config.positiveDnsTtl);
	else if (!strcmp(token, "negative_dns_ttl"))
		parse_time_t(&Config.negativeDnsTtl);
	else if (!strcmp(token, "range_offset_limit"))
		parse_b_size_t(&Config.rangeOffsetLimit);
	else if (!strcmp(token, "connect_timeout"))
		parse_time_t(&Config.Timeout.connect);
	else if (!strcmp(token, "peer_connect_timeout"))
		parse_time_t(&Config.Timeout.peer_connect);
	else if (!strcmp(token, "siteselect_timeout"))
		parse_time_t(&Config.Timeout.siteSelect);
	else if (!strcmp(token, "read_timeout"))
		parse_time_t(&Config.Timeout.read);
	else if (!strcmp(token, "request_timeout"))
		parse_time_t(&Config.Timeout.request);
	else if (!strcmp(token, "client_lifetime"))
		parse_time_t(&Config.Timeout.lifetime);
	else if (!strcmp(token, "half_closed_clients"))
		parse_onoff(&Config.onoff.half_closed_clients);
	else if (!strcmp(token, "pconn_timeout"))
		parse_time_t(&Config.Timeout.pconn);
#if USE_IDENT
	else if (!strcmp(token, "ident_timeout"))
		parse_time_t(&Config.Timeout.ident);
#endif
	else if (!strcmp(token, "shutdown_lifetime"))
		parse_time_t(&Config.shutdownLifetime);
	else if (!strcmp(token, "acl"))
		parse_acl(&Config.aclList);
	else if (!strcmp(token, "http_access"))
		parse_acl_access(&Config.accessList.http);
	else if (!strcmp(token, "icp_access"))
		parse_acl_access(&Config.accessList.icp);
	else if (!strcmp(token, "miss_access"))
		parse_acl_access(&Config.accessList.miss);
	else if (!strcmp(token, "cache_peer_access"))
		parse_peer_access();
	else if (!strcmp(token, "proxy_auth_realm"))
		parse_eol(&Config.proxyAuthRealm);
#if USE_IDENT
	else if (!strcmp(token, "ident_lookup_access"))
		parse_acl_access(&Config.accessList.identLookup);
#endif
	else if (!strcmp(token, "cache_mgr"))
		parse_string(&Config.adminEmail);
	else if (!strcmp(token, "cache_effective_user"))
		parse_string(&Config.effectiveUser);
	else if (!strcmp(token, "cache_effective_group"))
		parse_string(&Config.effectiveGroup);
	else if (!strcmp(token, "visible_hostname"))
		parse_string(&Config.visibleHostname);
	else if (!strcmp(token, "unique_hostname"))
		parse_string(&Config.uniqueHostname);
	else if (!strcmp(token, "hostname_aliases"))
		parse_wordlist(&Config.hostnameAliases);
	else if (!strcmp(token, "announce_period"))
		parse_time_t(&Config.Announce.period);
	else if (!strcmp(token, "announce_host"))
		parse_string(&Config.Announce.host);
	else if (!strcmp(token, "announce_file"))
		parse_string(&Config.Announce.file);
	else if (!strcmp(token, "announce_port"))
		parse_ushort(&Config.Announce.port);
	else if (!strcmp(token, "httpd_accel_host"))
		parse_string(&Config.Accel.host);
	else if (!strcmp(token, "httpd_accel_port"))
		parse_ushort(&Config.Accel.port);
	else if (!strcmp(token, "httpd_accel_with_proxy"))
		parse_onoff(&Config.onoff.accel_with_proxy);
	else if (!strcmp(token, "httpd_accel_uses_host_header"))
		parse_onoff(&opt_accel_uses_host);
	else if (!strcmp(token, "dns_testnames"))
		parse_wordlist(&Config.dns_testname_list);
	else if (!strcmp(token, "logfile_rotate"))
		parse_int(&Config.Log.rotateNumber);
	else if (!strcmp(token, "append_domain"))
		parse_string(&Config.appendDomain);
	else if (!strcmp(token, "tcp_recv_bufsize"))
		parse_b_size_t(&Config.tcpRcvBufsz);
	else if (!strcmp(token, "err_html_text"))
		parse_eol(&Config.errHtmlText);
	else if (!strcmp(token, "deny_info"))
		parse_denyinfo(&Config.denyInfoList);
	else if (!strcmp(token, "memory_pools"))
		parse_onoff(&Config.onoff.mem_pools);
	else if (!strcmp(token, "memory_pools_limit"))
		parse_b_size_t(&Config.MemPools.limit);
	else if (!strcmp(token, "forwarded_for"))
		parse_onoff(&opt_forwarded_for);
	else if (!strcmp(token, "log_icp_queries"))
		parse_onoff(&Config.onoff.log_udp);
	else if (!strcmp(token, "icp_hit_stale"))
		parse_onoff(&Config.onoff.icp_hit_stale);
	else if (!strcmp(token, "minimum_direct_hops"))
		parse_int(&Config.minDirectHops);
	else if (!strcmp(token, "cachemgr_passwd"))
		parse_cachemgrpasswd(&Config.passwd_list);
	else if (!strcmp(token, "store_avg_object_size"))
		parse_kb_size_t(&Config.Store.avgObjectSize);
	else if (!strcmp(token, "store_objects_per_bucket"))
		parse_int(&Config.Store.objectsPerBucket);
	else if (!strcmp(token, "client_db"))
		parse_onoff(&Config.onoff.client_db);
	else if (!strcmp(token, "netdb_low"))
		parse_int(&Config.Netdb.low);
	else if (!strcmp(token, "netdb_high"))
		parse_int(&Config.Netdb.high);
	else if (!strcmp(token, "netdb_ping_period"))
		parse_time_t(&Config.Netdb.period);
	else if (!strcmp(token, "query_icmp"))
		parse_onoff(&Config.onoff.query_icmp);
	else if (!strcmp(token, "test_reachability"))
		parse_onoff(&Config.onoff.test_reachability);
	else if (!strcmp(token, "buffered_logs"))
		parse_onoff(&Config.onoff.buffered_logs);
#if HTTP_VIOLATIONS
	else if (!strcmp(token, "reload_into_ims"))
		parse_onoff(&Config.onoff.reload_into_ims);
#endif
	else if (!strcmp(token, "always_direct"))
		parse_acl_access(&Config.accessList.AlwaysDirect);
	else if (!strcmp(token, "never_direct"))
		parse_acl_access(&Config.accessList.NeverDirect);
	else if (!strcmp(token, "anonymize_headers"))
		parse_http_header(&Config.anonymize_headers);
	else if (!strcmp(token, "fake_user_agent"))
		parse_eol(&Config.fake_ua);
	else if (!strcmp(token, "icon_directory"))
		parse_string(&Config.icons.directory);
	else if (!strcmp(token, "error_directory"))
		parse_string(&Config.errorDirectory);
	else if (!strcmp(token, "minimum_retry_timeout"))
		parse_time_t(&Config.retry.timeout);
	else if (!strcmp(token, "maximum_single_addr_tries"))
		parse_int(&Config.retry.maxtries);
#if SQUID_SNMP
	else if (!strcmp(token, "snmp_port"))
		parse_ushort(&Config.Port.snmp);
#endif
#if SQUID_SNMP
	else if (!strcmp(token, "snmp_access"))
		parse_acl_access(&Config.accessList.snmp);
#endif
#if SQUID_SNMP
	else if (!strcmp(token, "snmp_incoming_address"))
		parse_address(&Config.Addrs.snmp_incoming);
#endif
#if SQUID_SNMP
	else if (!strcmp(token, "snmp_outgoing_address"))
		parse_address(&Config.Addrs.snmp_outgoing);
#endif
	else if (!strcmp(token, "as_whois_server"))
		parse_string(&Config.as_whois_server);
#if USE_WCCP
	else if (!strcmp(token, "wccp_router"))
		parse_address(&Config.Wccp.router);
#endif
#if USE_WCCP
	else if (!strcmp(token, "wccp_incoming_address"))
		parse_address(&Config.Wccp.incoming);
#endif
#if USE_WCCP
	else if (!strcmp(token, "wccp_outgoing_address"))
		parse_address(&Config.Wccp.outgoing);
#endif
#if DELAY_POOLS
	else if (!strcmp(token, "delay_pools"))
		parse_delay_pool_count(&Config.Delay);
#endif
#if DELAY_POOLS
	else if (!strcmp(token, "delay_class"))
		parse_delay_pool_class(&Config.Delay);
#endif
#if DELAY_POOLS
	else if (!strcmp(token, "delay_access"))
		parse_delay_pool_access(&Config.Delay);
#endif
#if DELAY_POOLS
	else if (!strcmp(token, "delay_parameters"))
		parse_delay_pool_rates(&Config.Delay);
#endif
#if DELAY_POOLS
	else if (!strcmp(token, "delay_initial_bucket_level"))
		parse_ushort(&Config.Delay.initial);
#endif
	else if (!strcmp(token, "incoming_icp_average"))
		parse_int(&Config.comm_incoming.icp_average);
	else if (!strcmp(token, "incoming_http_average"))
		parse_int(&Config.comm_incoming.http_average);
	else if (!strcmp(token, "min_icp_poll_cnt"))
		parse_int(&Config.comm_incoming.icp_min_poll);
	else if (!strcmp(token, "min_http_poll_cnt"))
		parse_int(&Config.comm_incoming.http_min_poll);
	else if (!strcmp(token, "max_open_disk_fds"))
		parse_int(&Config.max_open_disk_fds);
	else if (!strcmp(token, "offline_mode"))
		parse_onoff(&Config.onoff.offline);
	else if (!strcmp(token, "uri_whitespace"))
		parse_uri_whitespace(&Config.uri_whitespace);
	else if (!strcmp(token, "broken_posts"))
		parse_acl_access(&Config.accessList.brokenPosts);
#if MULTICAST_MISS_STREAM
	else if (!strcmp(token, "mcast_miss_addr"))
		parse_address(&Config.mcast_miss.addr);
#endif
#if MULTICAST_MISS_TTL
	else if (!strcmp(token, "mcast_miss_ttl"))
		parse_ushort(&Config.mcast_miss.ttl);
#endif
#if MULTICAST_MISS_STREAM
	else if (!strcmp(token, "mcast_miss_port"))
		parse_ushort(&Config.mcast_miss.port);
#endif
#if MULTICAST_MISS_STREAM
	else if (!strcmp(token, "mcast_miss_encode_key"))
		parse_string(&Config.mcast_miss.encode_key);
#endif
	else if (!strcmp(token, "prefer_direct"))
		parse_onoff(&Config.onoff.prefer_direct);
	else if (!strcmp(token, "strip_query_terms"))
		parse_onoff(&Config.onoff.strip_query_terms);
	else if (!strcmp(token, "coredump_dir"))
		parse_string(&Config.coredump_dir);
	else if (!strcmp(token, "redirector_bypass"))
		parse_onoff(&Config.onoff.redirector_bypass);
	else if (!strcmp(token, "ignore_unknown_nameservers"))
		parse_onoff(&Config.onoff.ignore_unknown_nameservers);
#if USE_CACHE_DIGESTS
	else if (!strcmp(token, "digest_generation"))
		parse_onoff(&Config.onoff.digest_generation);
#endif
#if USE_CACHE_DIGESTS
	else if (!strcmp(token, "digest_bits_per_entry"))
		parse_int(&Config.digest.bits_per_entry);
#endif
#if USE_CACHE_DIGESTS
	else if (!strcmp(token, "digest_rebuild_period"))
		parse_time_t(&Config.digest.rebuild_period);
#endif
#if USE_CACHE_DIGESTS
	else if (!strcmp(token, "digest_rewrite_period"))
		parse_time_t(&Config.digest.rewrite_period);
#endif
#if USE_CACHE_DIGESTS
	else if (!strcmp(token, "digest_swapout_chunk_size"))
		parse_b_size_t(&Config.digest.swapout_chunk_size);
#endif
#if USE_CACHE_DIGESTS
	else if (!strcmp(token, "digest_rebuild_chunk_percentage"))
		parse_int(&Config.digest.rebuild_chunk_percentage);
#endif
	else if (!strcmp(token, "chroot"))
		parse_string(&Config.chroot_dir);
	else if (!strcmp(token, "restart_times"))
		parse_int(&Config.restart_times);
	else
		result = 0; /* failure */
	return(result);
}

static void
dump_config(StoreEntry *entry)
{
	dump_sockaddr_in_list(entry, "http_port", Config.Sockaddr.http);
	dump_ushort(entry, "icp_port", Config.Port.icp);
#if USE_HTCP
	dump_ushort(entry, "htcp_port", Config.Port.htcp);
#endif
	dump_wordlist(entry, "mcast_groups", Config.mcast_group_list);
	dump_address(entry, "tcp_outgoing_address", Config.Addrs.tcp_outgoing);
	dump_address(entry, "udp_incoming_address", Config.Addrs.udp_incoming);
	dump_address(entry, "udp_outgoing_address", Config.Addrs.udp_outgoing);
	dump_peer(entry, "cache_peer", Config.peers);
	dump_int(entry, "icp_query_timeout", Config.Timeout.icp_query);
	dump_int(entry, "maximum_icp_query_timeout", Config.Timeout.icp_query_max);
	dump_int(entry, "mcast_icp_query_timeout", Config.Timeout.mcast_icp_query);
	dump_time_t(entry, "dead_peer_timeout", Config.Timeout.deadPeer);
	dump_wordlist(entry, "hierarchy_stoplist", Config.hierarchy_stoplist);
	dump_acl_access(entry, "no_cache", Config.accessList.noCache);
	dump_b_size_t(entry, "cache_mem", Config.memMaxSize);
	dump_int(entry, "cache_swap_low", Config.Swap.lowWaterMark);
	dump_int(entry, "cache_swap_high", Config.Swap.highWaterMark);
	dump_b_size_t(entry, "maximum_object_size", Config.Store.maxObjectSize);
	dump_int(entry, "ipcache_size", Config.ipcache.size);
	dump_int(entry, "ipcache_low", Config.ipcache.low);
	dump_int(entry, "ipcache_high", Config.ipcache.high);
	dump_int(entry, "fqdncache_size", Config.fqdncache.size);
	dump_cachedir(entry, "cache_dir", Config.cacheSwap);
	dump_string(entry, "cache_access_log", Config.Log.access);
	dump_string(entry, "cache_log", Config.Log.log);
	dump_string(entry, "cache_store_log", Config.Log.store);
	dump_string(entry, "cache_swap_log", Config.Log.swap);
	dump_onoff(entry, "emulate_httpd_log", Config.onoff.common_log);
	dump_string(entry, "mime_table", Config.mimeTablePathname);
	dump_onoff(entry, "log_mime_hdrs", Config.onoff.log_mime_hdrs);
	dump_string(entry, "useragent_log", Config.Log.useragent);
	dump_string(entry, "pid_filename", Config.pidFilename);
	dump_eol(entry, "debug_options", Config.debugOptions);
	dump_onoff(entry, "log_fqdn", Config.onoff.log_fqdn);
	dump_address(entry, "client_netmask", Config.Addrs.client_netmask);
	dump_string(entry, "ftp_user", Config.Ftp.anon_user);
	dump_size_t(entry, "ftp_list_width", Config.Ftp.list_width);
	dump_string(entry, "cache_dns_program", Config.Program.dnsserver);
	dump_int(entry, "dns_children", Config.dnsChildren);
	dump_onoff(entry, "dns_defnames", Config.onoff.res_defnames);
	dump_wordlist(entry, "dns_nameservers", Config.dns_nameservers);
	dump_string(entry, "unlinkd_program", Config.Program.unlinkd);
	dump_string(entry, "pinger_program", Config.Program.pinger);
	dump_wordlist(entry, "redirect_program", Config.Program.redirect);
	dump_int(entry, "redirect_children", Config.redirectChildren);
	dump_onoff(entry, "redirect_rewrites_host_header", Config.onoff.redir_rewrites_host);
	dump_acl_access(entry, "redirector_access", Config.accessList.redirector);
	dump_wordlist(entry, "authenticate_program", Config.Program.authenticate);
	dump_int(entry, "authenticate_children", Config.authenticateChildren);
	dump_int(entry, "authenticate_ttl", Config.authenticateTTL);
	dump_int(entry, "authenticate_ip_ttl", Config.authenticateIpTTL);
	dump_string(entry, "wais_relay_host", Config.Wais.relayHost);
	dump_ushort(entry, "wais_relay_port", Config.Wais.relayPort);
	dump_b_size_t(entry, "request_header_max_size", Config.maxRequestHeaderSize);
	dump_b_size_t(entry, "request_body_max_size", Config.maxRequestBodySize);
	dump_b_size_t(entry, "reply_body_max_size", Config.maxReplyBodySize);
	dump_refreshpattern(entry, "refresh_pattern", Config.Refresh);
#if HEAP_REPLACEMENT
	dump_string(entry, "replacement_policy", Config.replPolicy);
#endif
	dump_time_t(entry, "reference_age", Config.referenceAge);
	dump_kb_size_t(entry, "quick_abort_min", Config.quickAbort.min);
	dump_kb_size_t(entry, "quick_abort_max", Config.quickAbort.max);
	dump_int(entry, "quick_abort_pct", Config.quickAbort.pct);
	dump_time_t(entry, "negative_ttl", Config.negativeTtl);
	dump_time_t(entry, "positive_dns_ttl", Config.positiveDnsTtl);
	dump_time_t(entry, "negative_dns_ttl", Config.negativeDnsTtl);
	dump_b_size_t(entry, "range_offset_limit", Config.rangeOffsetLimit);
	dump_time_t(entry, "connect_timeout", Config.Timeout.connect);
	dump_time_t(entry, "peer_connect_timeout", Config.Timeout.peer_connect);
	dump_time_t(entry, "siteselect_timeout", Config.Timeout.siteSelect);
	dump_time_t(entry, "read_timeout", Config.Timeout.read);
	dump_time_t(entry, "request_timeout", Config.Timeout.request);
	dump_time_t(entry, "client_lifetime", Config.Timeout.lifetime);
	dump_onoff(entry, "half_closed_clients", Config.onoff.half_closed_clients);
	dump_time_t(entry, "pconn_timeout", Config.Timeout.pconn);
#if USE_IDENT
	dump_time_t(entry, "ident_timeout", Config.Timeout.ident);
#endif
	dump_time_t(entry, "shutdown_lifetime", Config.shutdownLifetime);
	dump_acl(entry, "acl", Config.aclList);
	dump_acl_access(entry, "http_access", Config.accessList.http);
	dump_acl_access(entry, "icp_access", Config.accessList.icp);
	dump_acl_access(entry, "miss_access", Config.accessList.miss);
	dump_eol(entry, "proxy_auth_realm", Config.proxyAuthRealm);
#if USE_IDENT
	dump_acl_access(entry, "ident_lookup_access", Config.accessList.identLookup);
#endif
	dump_string(entry, "cache_mgr", Config.adminEmail);
	dump_string(entry, "cache_effective_user", Config.effectiveUser);
	dump_string(entry, "cache_effective_group", Config.effectiveGroup);
	dump_string(entry, "visible_hostname", Config.visibleHostname);
	dump_string(entry, "unique_hostname", Config.uniqueHostname);
	dump_wordlist(entry, "hostname_aliases", Config.hostnameAliases);
	dump_time_t(entry, "announce_period", Config.Announce.period);
	dump_string(entry, "announce_host", Config.Announce.host);
	dump_string(entry, "announce_file", Config.Announce.file);
	dump_ushort(entry, "announce_port", Config.Announce.port);
	dump_string(entry, "httpd_accel_host", Config.Accel.host);
	dump_ushort(entry, "httpd_accel_port", Config.Accel.port);
	dump_onoff(entry, "httpd_accel_with_proxy", Config.onoff.accel_with_proxy);
	dump_onoff(entry, "httpd_accel_uses_host_header", opt_accel_uses_host);
	dump_wordlist(entry, "dns_testnames", Config.dns_testname_list);
	dump_int(entry, "logfile_rotate", Config.Log.rotateNumber);
	dump_string(entry, "append_domain", Config.appendDomain);
	dump_b_size_t(entry, "tcp_recv_bufsize", Config.tcpRcvBufsz);
	dump_eol(entry, "err_html_text", Config.errHtmlText);
	dump_denyinfo(entry, "deny_info", Config.denyInfoList);
	dump_onoff(entry, "memory_pools", Config.onoff.mem_pools);
	dump_b_size_t(entry, "memory_pools_limit", Config.MemPools.limit);
	dump_onoff(entry, "forwarded_for", opt_forwarded_for);
	dump_onoff(entry, "log_icp_queries", Config.onoff.log_udp);
	dump_onoff(entry, "icp_hit_stale", Config.onoff.icp_hit_stale);
	dump_int(entry, "minimum_direct_hops", Config.minDirectHops);
	dump_cachemgrpasswd(entry, "cachemgr_passwd", Config.passwd_list);
	dump_kb_size_t(entry, "store_avg_object_size", Config.Store.avgObjectSize);
	dump_int(entry, "store_objects_per_bucket", Config.Store.objectsPerBucket);
	dump_onoff(entry, "client_db", Config.onoff.client_db);
	dump_int(entry, "netdb_low", Config.Netdb.low);
	dump_int(entry, "netdb_high", Config.Netdb.high);
	dump_time_t(entry, "netdb_ping_period", Config.Netdb.period);
	dump_onoff(entry, "query_icmp", Config.onoff.query_icmp);
	dump_onoff(entry, "test_reachability", Config.onoff.test_reachability);
	dump_onoff(entry, "buffered_logs", Config.onoff.buffered_logs);
#if HTTP_VIOLATIONS
	dump_onoff(entry, "reload_into_ims", Config.onoff.reload_into_ims);
#endif
	dump_acl_access(entry, "always_direct", Config.accessList.AlwaysDirect);
	dump_acl_access(entry, "never_direct", Config.accessList.NeverDirect);
	dump_http_header(entry, "anonymize_headers", Config.anonymize_headers);
	dump_eol(entry, "fake_user_agent", Config.fake_ua);
	dump_string(entry, "icon_directory", Config.icons.directory);
	dump_string(entry, "error_directory", Config.errorDirectory);
	dump_time_t(entry, "minimum_retry_timeout", Config.retry.timeout);
	dump_int(entry, "maximum_single_addr_tries", Config.retry.maxtries);
#if SQUID_SNMP
	dump_ushort(entry, "snmp_port", Config.Port.snmp);
#endif
#if SQUID_SNMP
	dump_acl_access(entry, "snmp_access", Config.accessList.snmp);
#endif
#if SQUID_SNMP
	dump_address(entry, "snmp_incoming_address", Config.Addrs.snmp_incoming);
#endif
#if SQUID_SNMP
	dump_address(entry, "snmp_outgoing_address", Config.Addrs.snmp_outgoing);
#endif
	dump_string(entry, "as_whois_server", Config.as_whois_server);
#if USE_WCCP
	dump_address(entry, "wccp_router", Config.Wccp.router);
#endif
#if USE_WCCP
	dump_address(entry, "wccp_incoming_address", Config.Wccp.incoming);
#endif
#if USE_WCCP
	dump_address(entry, "wccp_outgoing_address", Config.Wccp.outgoing);
#endif
#if DELAY_POOLS
	dump_delay_pool_count(entry, "delay_pools", Config.Delay);
#endif
#if DELAY_POOLS
	dump_delay_pool_class(entry, "delay_class", Config.Delay);
#endif
#if DELAY_POOLS
	dump_delay_pool_access(entry, "delay_access", Config.Delay);
#endif
#if DELAY_POOLS
	dump_delay_pool_rates(entry, "delay_parameters", Config.Delay);
#endif
#if DELAY_POOLS
	dump_ushort(entry, "delay_initial_bucket_level", Config.Delay.initial);
#endif
	dump_int(entry, "incoming_icp_average", Config.comm_incoming.icp_average);
	dump_int(entry, "incoming_http_average", Config.comm_incoming.http_average);
	dump_int(entry, "min_icp_poll_cnt", Config.comm_incoming.icp_min_poll);
	dump_int(entry, "min_http_poll_cnt", Config.comm_incoming.http_min_poll);
	dump_int(entry, "max_open_disk_fds", Config.max_open_disk_fds);
	dump_onoff(entry, "offline_mode", Config.onoff.offline);
	dump_uri_whitespace(entry, "uri_whitespace", Config.uri_whitespace);
	dump_acl_access(entry, "broken_posts", Config.accessList.brokenPosts);
#if MULTICAST_MISS_STREAM
	dump_address(entry, "mcast_miss_addr", Config.mcast_miss.addr);
#endif
#if MULTICAST_MISS_TTL
	dump_ushort(entry, "mcast_miss_ttl", Config.mcast_miss.ttl);
#endif
#if MULTICAST_MISS_STREAM
	dump_ushort(entry, "mcast_miss_port", Config.mcast_miss.port);
#endif
#if MULTICAST_MISS_STREAM
	dump_string(entry, "mcast_miss_encode_key", Config.mcast_miss.encode_key);
#endif
	dump_onoff(entry, "prefer_direct", Config.onoff.prefer_direct);
	dump_onoff(entry, "strip_query_terms", Config.onoff.strip_query_terms);
	dump_string(entry, "coredump_dir", Config.coredump_dir);
	dump_onoff(entry, "redirector_bypass", Config.onoff.redirector_bypass);
	dump_onoff(entry, "ignore_unknown_nameservers", Config.onoff.ignore_unknown_nameservers);
#if USE_CACHE_DIGESTS
	dump_onoff(entry, "digest_generation", Config.onoff.digest_generation);
#endif
#if USE_CACHE_DIGESTS
	dump_int(entry, "digest_bits_per_entry", Config.digest.bits_per_entry);
#endif
#if USE_CACHE_DIGESTS
	dump_time_t(entry, "digest_rebuild_period", Config.digest.rebuild_period);
#endif
#if USE_CACHE_DIGESTS
	dump_time_t(entry, "digest_rewrite_period", Config.digest.rewrite_period);
#endif
#if USE_CACHE_DIGESTS
	dump_b_size_t(entry, "digest_swapout_chunk_size", Config.digest.swapout_chunk_size);
#endif
#if USE_CACHE_DIGESTS
	dump_int(entry, "digest_rebuild_chunk_percentage", Config.digest.rebuild_chunk_percentage);
#endif
	dump_string(entry, "chroot", Config.chroot_dir);
	dump_int(entry, "restart_times", Config.restart_times);
}

static void
free_all(void)
{
	free_sockaddr_in_list(&Config.Sockaddr.http);
	free_ushort(&Config.Port.icp);
#if USE_HTCP
	free_ushort(&Config.Port.htcp);
#endif
	free_wordlist(&Config.mcast_group_list);
	free_address(&Config.Addrs.tcp_outgoing);
	free_address(&Config.Addrs.udp_incoming);
	free_address(&Config.Addrs.udp_outgoing);
	free_peer(&Config.peers);
	free_int(&Config.Timeout.icp_query);
	free_int(&Config.Timeout.icp_query_max);
	free_int(&Config.Timeout.mcast_icp_query);
	free_time_t(&Config.Timeout.deadPeer);
	free_wordlist(&Config.hierarchy_stoplist);
	free_acl_access(&Config.accessList.noCache);
	free_b_size_t(&Config.memMaxSize);
	free_int(&Config.Swap.lowWaterMark);
	free_int(&Config.Swap.highWaterMark);
	free_b_size_t(&Config.Store.maxObjectSize);
	free_int(&Config.ipcache.size);
	free_int(&Config.ipcache.low);
	free_int(&Config.ipcache.high);
	free_int(&Config.fqdncache.size);
	free_cachedir(&Config.cacheSwap);
	free_string(&Config.Log.access);
	free_string(&Config.Log.log);
	free_string(&Config.Log.store);
	free_string(&Config.Log.swap);
	free_onoff(&Config.onoff.common_log);
	free_string(&Config.mimeTablePathname);
	free_onoff(&Config.onoff.log_mime_hdrs);
	free_string(&Config.Log.useragent);
	free_string(&Config.pidFilename);
	free_eol(&Config.debugOptions);
	free_onoff(&Config.onoff.log_fqdn);
	free_address(&Config.Addrs.client_netmask);
	free_string(&Config.Ftp.anon_user);
	free_size_t(&Config.Ftp.list_width);
	free_string(&Config.Program.dnsserver);
	free_int(&Config.dnsChildren);
	free_onoff(&Config.onoff.res_defnames);
	free_wordlist(&Config.dns_nameservers);
	free_string(&Config.Program.unlinkd);
	free_string(&Config.Program.pinger);
	free_wordlist(&Config.Program.redirect);
	free_int(&Config.redirectChildren);
	free_onoff(&Config.onoff.redir_rewrites_host);
	free_acl_access(&Config.accessList.redirector);
	free_wordlist(&Config.Program.authenticate);
	free_int(&Config.authenticateChildren);
	free_int(&Config.authenticateTTL);
	free_int(&Config.authenticateIpTTL);
	free_string(&Config.Wais.relayHost);
	free_ushort(&Config.Wais.relayPort);
	free_b_size_t(&Config.maxRequestHeaderSize);
	free_b_size_t(&Config.maxRequestBodySize);
	free_b_size_t(&Config.maxReplyBodySize);
	free_refreshpattern(&Config.Refresh);
#if HEAP_REPLACEMENT
	free_string(&Config.replPolicy);
#endif
	free_time_t(&Config.referenceAge);
	free_kb_size_t(&Config.quickAbort.min);
	free_kb_size_t(&Config.quickAbort.max);
	free_int(&Config.quickAbort.pct);
	free_time_t(&Config.negativeTtl);
	free_time_t(&Config.positiveDnsTtl);
	free_time_t(&Config.negativeDnsTtl);
	free_b_size_t(&Config.rangeOffsetLimit);
	free_time_t(&Config.Timeout.connect);
	free_time_t(&Config.Timeout.peer_connect);
	free_time_t(&Config.Timeout.siteSelect);
	free_time_t(&Config.Timeout.read);
	free_time_t(&Config.Timeout.request);
	free_time_t(&Config.Timeout.lifetime);
	free_onoff(&Config.onoff.half_closed_clients);
	free_time_t(&Config.Timeout.pconn);
#if USE_IDENT
	free_time_t(&Config.Timeout.ident);
#endif
	free_time_t(&Config.shutdownLifetime);
	free_acl(&Config.aclList);
	free_acl_access(&Config.accessList.http);
	free_acl_access(&Config.accessList.icp);
	free_acl_access(&Config.accessList.miss);
	free_eol(&Config.proxyAuthRealm);
#if USE_IDENT
	free_acl_access(&Config.accessList.identLookup);
#endif
	free_string(&Config.adminEmail);
	free_string(&Config.effectiveUser);
	free_string(&Config.effectiveGroup);
	free_string(&Config.visibleHostname);
	free_string(&Config.uniqueHostname);
	free_wordlist(&Config.hostnameAliases);
	free_time_t(&Config.Announce.period);
	free_string(&Config.Announce.host);
	free_string(&Config.Announce.file);
	free_ushort(&Config.Announce.port);
	free_string(&Config.Accel.host);
	free_ushort(&Config.Accel.port);
	free_onoff(&Config.onoff.accel_with_proxy);
	free_onoff(&opt_accel_uses_host);
	free_wordlist(&Config.dns_testname_list);
	free_int(&Config.Log.rotateNumber);
	free_string(&Config.appendDomain);
	free_b_size_t(&Config.tcpRcvBufsz);
	free_eol(&Config.errHtmlText);
	free_denyinfo(&Config.denyInfoList);
	free_onoff(&Config.onoff.mem_pools);
	free_b_size_t(&Config.MemPools.limit);
	free_onoff(&opt_forwarded_for);
	free_onoff(&Config.onoff.log_udp);
	free_onoff(&Config.onoff.icp_hit_stale);
	free_int(&Config.minDirectHops);
	free_cachemgrpasswd(&Config.passwd_list);
	free_kb_size_t(&Config.Store.avgObjectSize);
	free_int(&Config.Store.objectsPerBucket);
	free_onoff(&Config.onoff.client_db);
	free_int(&Config.Netdb.low);
	free_int(&Config.Netdb.high);
	free_time_t(&Config.Netdb.period);
	free_onoff(&Config.onoff.query_icmp);
	free_onoff(&Config.onoff.test_reachability);
	free_onoff(&Config.onoff.buffered_logs);
#if HTTP_VIOLATIONS
	free_onoff(&Config.onoff.reload_into_ims);
#endif
	free_acl_access(&Config.accessList.AlwaysDirect);
	free_acl_access(&Config.accessList.NeverDirect);
	free_http_header(&Config.anonymize_headers);
	free_eol(&Config.fake_ua);
	free_string(&Config.icons.directory);
	free_string(&Config.errorDirectory);
	free_time_t(&Config.retry.timeout);
	free_int(&Config.retry.maxtries);
#if SQUID_SNMP
	free_ushort(&Config.Port.snmp);
#endif
#if SQUID_SNMP
	free_acl_access(&Config.accessList.snmp);
#endif
#if SQUID_SNMP
	free_address(&Config.Addrs.snmp_incoming);
#endif
#if SQUID_SNMP
	free_address(&Config.Addrs.snmp_outgoing);
#endif
	free_string(&Config.as_whois_server);
#if USE_WCCP
	free_address(&Config.Wccp.router);
#endif
#if USE_WCCP
	free_address(&Config.Wccp.incoming);
#endif
#if USE_WCCP
	free_address(&Config.Wccp.outgoing);
#endif
#if DELAY_POOLS
	free_delay_pool_count(&Config.Delay);
#endif
#if DELAY_POOLS
	free_delay_pool_class(&Config.Delay);
#endif
#if DELAY_POOLS
	free_delay_pool_access(&Config.Delay);
#endif
#if DELAY_POOLS
	free_delay_pool_rates(&Config.Delay);
#endif
#if DELAY_POOLS
	free_ushort(&Config.Delay.initial);
#endif
	free_int(&Config.comm_incoming.icp_average);
	free_int(&Config.comm_incoming.http_average);
	free_int(&Config.comm_incoming.icp_min_poll);
	free_int(&Config.comm_incoming.http_min_poll);
	free_int(&Config.max_open_disk_fds);
	free_onoff(&Config.onoff.offline);
	free_uri_whitespace(&Config.uri_whitespace);
	free_acl_access(&Config.accessList.brokenPosts);
#if MULTICAST_MISS_STREAM
	free_address(&Config.mcast_miss.addr);
#endif
#if MULTICAST_MISS_TTL
	free_ushort(&Config.mcast_miss.ttl);
#endif
#if MULTICAST_MISS_STREAM
	free_ushort(&Config.mcast_miss.port);
#endif
#if MULTICAST_MISS_STREAM
	free_string(&Config.mcast_miss.encode_key);
#endif
	free_onoff(&Config.onoff.prefer_direct);
	free_onoff(&Config.onoff.strip_query_terms);
	free_string(&Config.coredump_dir);
	free_onoff(&Config.onoff.redirector_bypass);
	free_onoff(&Config.onoff.ignore_unknown_nameservers);
#if USE_CACHE_DIGESTS
	free_onoff(&Config.onoff.digest_generation);
#endif
#if USE_CACHE_DIGESTS
	free_int(&Config.digest.bits_per_entry);
#endif
#if USE_CACHE_DIGESTS
	free_time_t(&Config.digest.rebuild_period);
#endif
#if USE_CACHE_DIGESTS
	free_time_t(&Config.digest.rewrite_period);
#endif
#if USE_CACHE_DIGESTS
	free_b_size_t(&Config.digest.swapout_chunk_size);
#endif
#if USE_CACHE_DIGESTS
	free_int(&Config.digest.rebuild_chunk_percentage);
#endif
	free_string(&Config.chroot_dir);
	free_int(&Config.restart_times);
}

