/*
 * $Id: util.h,v 1.53.4.2 1999/08/30 22:41:43 wessels Exp $
 *
 * AUTHOR: Harvest Derived
 *
 * SQUID Internet Object Cache  http://squid.nlanr.net/Squid/
 * --------------------------------------------------------
 *
 *  Squid is the result of efforts by numerous individuals from the
 *  Internet community.  Development is led by Duane Wessels of the
 *  National Laboratory for Applied Network Research and funded by
 *  the National Science Foundation.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *  
 */

#ifndef _UTIL_H_
#define _UTIL_H_

#include "config.h"
#include <stdio.h>
#include <time.h>
#if HAVE_TIME_H
#include <time.h>
#endif
#if HAVE_SYS_TIME_H
#include <sys/time.h>
#endif
#include <sys/types.h>
#if !defined(SQUIDHOSTNAMELEN)
#include <sys/param.h>
#ifndef _SQUID_NETDB_H_		/* need protection on NEXTSTEP */
#define _SQUID_NETDB_H_
#include <netdb.h>
#endif
#if !defined(MAXHOSTNAMELEN) || (MAXHOSTNAMELEN < 128)
#define SQUIDHOSTNAMELEN 128
#else
#define SQUIDHOSTNAMELEN MAXHOSTNAMELEN
#endif
#endif

#if defined(_SQUID_FREEBSD_)
#define _etext etext
#endif

extern const char *getfullhostname _PARAMS((void));
extern const char *mkhttpdlogtime _PARAMS((const time_t *));
extern const char *mkrfc1123 _PARAMS((time_t));
extern char *uudecode _PARAMS((const char *));
extern char *xstrdup _PARAMS((const char *));
extern char *xstrndup _PARAMS((const char *, size_t));
extern const char *xstrerror _PARAMS((void));
extern const char *xbstrerror _PARAMS((int));
extern int tvSubMsec _PARAMS((struct timeval, struct timeval));
extern int tvSubUsec _PARAMS((struct timeval, struct timeval));
extern double tvSubDsec _PARAMS((struct timeval, struct timeval));
extern char *xstrncpy _PARAMS((char *, const char *, size_t));
extern size_t xcountws _PARAMS((const char *str));
extern time_t parse_rfc1123 _PARAMS((const char *str));
extern void *xcalloc _PARAMS((int, size_t));
extern void *xmalloc _PARAMS((size_t));
extern void *xrealloc _PARAMS((void *, size_t));
extern void Tolower _PARAMS((char *));
extern void xfree _PARAMS((void *));
extern void xxfree _PARAMS((void *));

/* rfc1738.c */
extern char *rfc1738_escape _PARAMS((const char *));
extern char *rfc1738_escape_unescaped _PARAMS((const char *));
extern char *rfc1738_escape_part _PARAMS((const char *));
extern void rfc1738_unescape _PARAMS((char *));

#if XMALLOC_STATISTICS
extern void malloc_statistics _PARAMS((void (*)(int, int, void *), void *));
#endif

#if XMALLOC_TRACE
#define xmalloc(size) (xmalloc_func="xmalloc",xmalloc_line=__LINE__,xmalloc_file=__FILE__,xmalloc(size))
#define xfree(ptr) (xmalloc_func="xfree",xmalloc_line=__LINE__,xmalloc_file=__FILE__,xfree(ptr))
#define xxfree(ptr) (xmalloc_func="xxfree",xmalloc_line=__LINE__,xmalloc_file=__FILE__,xxfree(ptr))
#define xrealloc(ptr,size) (xmalloc_func="xrealloc",xmalloc_line=__LINE__,xmalloc_file=__FILE__,xrealloc(ptr,size))
#define xcalloc(n,size) (xmalloc_func="xcalloc",xmalloc_line=__LINE__,xmalloc_file=__FILE__,xcalloc(n,size))
#define xstrdup(ptr) (xmalloc_func="xstrdup",xmalloc_line=__LINE__,xmalloc_file=__FILE__,xstrdup(ptr))
extern int xmalloc_line;
extern char *xmalloc_file;
extern char *xmalloc_func;
extern int xmalloc_trace;
extern size_t xmalloc_total;
extern void xmalloc_find_leaks _PARAMS((void));
#endif

typedef struct in_addr SIA;
extern int safe_inet_addr _PARAMS((const char *, SIA *));
extern time_t parse_iso3307_time _PARAMS((const char *buf));
extern char *base64_decode _PARAMS((const char *coded));
extern const char *base64_encode _PARAMS((const char *decoded));

extern double xpercent _PARAMS((double part, double whole));
extern int xpercentInt _PARAMS((double part, double whole));
extern double xdiv _PARAMS((double nom, double denom));

extern const char *xitoa _PARAMS((int num));

#if !HAVE_DRAND48
double drand48(void);
#endif

#endif /* ndef _UTIL_H_ */
