/* tree.h - declare structures used by tree library
 *
 * vix 22jan93 [revisited; uses RCS, ANSI, POSIX; has bug fixes]
 * vix 27jun86 [broken out of tree.c]
 *
 * $Id: tree.h,v 1.4 1997/11/03 20:05:40 wessels Exp $
 */


#ifndef	_TREE_H_INCLUDED
#define	_TREE_H_INCLUDED

typedef struct tree_s {
    void *data;
    struct tree_s *left, *right;
    int bal;
} tree;

typedef int BTREE_CMP(void *, void *);
typedef int BTREE_UAR(void *);

void tree_init _PARAMS((tree **));
void *tree_srch _PARAMS((tree **, BTREE_CMP *, void *));
void *tree_add _PARAMS((tree **, int (*)(), void *, BTREE_UAR *));
int tree_delete _PARAMS((tree **, BTREE_CMP *, void *, BTREE_UAR *));
int tree_trav _PARAMS((tree **, BTREE_UAR *));
void tree_mung _PARAMS((tree **, BTREE_UAR *));

#endif /* _TREE_H_INCLUDED */
