/*
 * $Id: md5.h,v 1.6 1998/09/23 17:19:59 wessels Exp $
 */

#ifndef MD5_H
#define MD5_H
/* MD5.H - header file for MD5C.C
 */

/* Copyright (C) 1991-2, RSA Data Security, Inc. Created 1991. All
 * rights reserved.
 * 
 * License to copy and use this software is granted provided that it
 * is identified as the "RSA Data Security, Inc. MD5 Message-Digest
 * Algorithm" in all material mentioning or referencing this software
 * or this function.
 * 
 * License is also granted to make and use derivative works provided
 * that such works are identified as "derived from the RSA Data
 * Security, Inc. MD5 Message-Digest Algorithm" in all material
 * mentioning or referencing the derived work.
 * 
 * RSA Data Security, Inc. makes no representations concerning either
 * the merchantability of this software or the suitability of this
 * software for any particular purpose. It is provided "as is"
 * without express or implied warranty of any kind.
 * 
 * These notices must be retained in any copies of any part of this
 * documentation and/or software.
 */

/* MD5 context. */
typedef struct {
    u_num32 state[4];		/* state (ABCD) */
    u_num32 count[2];		/* number of bits, modulo 2^64 (lsb first) */
    unsigned char buffer[64];	/* input buffer */
} MD5_CTX;

void MD5Init _PARAMS((MD5_CTX *));
void MD5Update _PARAMS((MD5_CTX *, unsigned char *, unsigned int));
void MD5Final _PARAMS((unsigned char[16], MD5_CTX *));

#define MD5_DIGEST_CHARS         16

#endif /* MD5_H */
