/*
 * $Id: config.h.in,v 1.24.4.3 1997/06/16 19:45:49 wessels Exp $
 *
 * AUTHOR: Duane Wessels
 *
 * SQUID Internet Object Cache  http://squid.nlanr.net/Squid/
 * --------------------------------------------------------
 *
 *  Squid is the result of efforts by numerous individuals from the
 *  Internet community.  Development is led by Duane Wessels of the
 *  National Laboratory for Applied Network Research and funded by
 *  the National Science Foundation.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  
 */

#ifndef _CONFIG_H_
#define _CONFIG_H_

#include "autoconf.h"	/* For GNU autoconf variables */
//#include <assert.h>
#include "version.h"
#include "ansiproto.h"
/*
 *  XFER_TIMEOUT is the number of seconds that liburl will wait on a read()
 *  before giving up.
 */
#ifndef XFER_TIMEOUT
#define XFER_TIMEOUT    120     /* 2 minutes */
#endif

#ifndef USE_ASYNC_IO
#define USE_ASYNC_IO 0
#endif

/****************************************************************************
 *--------------------------------------------------------------------------*
 * DO *NOT* MAKE ANY CHANGES below here unless you know what you're doing...*
 *--------------------------------------------------------------------------*
 ****************************************************************************/

#ifdef USE_POSIX_REGEX
#ifndef USE_RE_SYNTAX
#define USE_RE_SYNTAX	REG_EXTENDED	/* default Syntax */
#endif
#endif

#if defined(SYSTYPE_SYSV) || defined(__svr4__) || defined(SYSTYPE_SVR4) || defined(__SYSTYPE_SVR4__)
#define _SQUID_SYSV_
#else
#define _SQUID_BSD_
#endif

/* define the _SQUID_TYPE_ based on a guess of the OS */
#if defined(__sun__)				/* SUN */
#define _SQUID_SUN_
#if defined(_SQUID_SYSV_)			/* SOLARIS */
#define _SQUID_SOLARIS_
#else						/* SUNOS */
#define _SQUID_SUNOS_
#endif

#elif defined(__EMX__)
#define _SQUID_EMX_				/* EMX OS/2 */

#elif defined(__hpux)                           /* HP-UX - SysV-like? */
#define _SQUID_HPUX_
#define _SQUID_SYSV_

#elif defined(__osf__)                          /* OSF/1 */
#define _SQUID_OSF_

#elif defined(__ultrix)				/* Ultrix */
#define _SQUID_ULTRIX_

#elif defined(_AIX)                          	/* AIX */
#define _SQUID_AIX_

#elif defined(__linux__)                        /* Linux */
#define _SQUID_LINUX_

#elif defined(__FreeBSD__)			/* FreeBSD */
#define _SQUID_FREEBSD_

#elif defined(__sgi__)	|| defined(sgi) || defined(__sgi) /* SGI */
#define _SQUID_SGI_
#if !defined(_SVR4_SOURCE)
#define _SVR4_SOURCE		/* for tempnam(3) */
#endif
#if USE_ASYNC_IO
#define _ABI_SOURCE
#endif /* USE_ASYNC_IO */

#elif defined(__NeXT__)
#define _SQUID_NEXT_

#elif defined(__bsdi__)
#define _SQUID_BSDI_                          /* BSD/OS */

#elif defined(__NetBSD__)
#define _SQUID_NETBSD_
#endif

#if !defined(CACHE_HTTP_PORT)
#define CACHE_HTTP_PORT 3128
#endif

#if !defined(CACHE_ICP_PORT)
#define CACHE_ICP_PORT 3130
#endif

#if !defined(CACHEMGR_HOSTNAME)
#define CACHEMGR_HOSTNAME ""
#endif

#if SQUID_UDP_SO_SNDBUF > 16384
#undef SQUID_UDP_SO_SNDBUF
#define SQUID_UDP_SO_SNDBUF 16384
#endif

#if SQUID_UDP_SO_RCVBUF > 16384
#undef SQUID_UDP_SO_RCVBUF
#define SQUID_UDP_SO_RCVBUF 16384
#endif

#ifdef HAVE_MEMCPY
#define xmemcpy(d,s,n) memcpy((d),(s),(n))
#elif HAVE_BCOPY
#define xmemcpy(d,s,n) bcopy((s),(d),(n))
#else
#define xmemcpy(d,s,n) memmove((d),(s),(n))
#endif

#if HAVE_RANDOM
#define squid_random random
#define squid_srandom srandom
#elif HAVE_LRAND48
#define squid_random lrand48
#define squid_srandom srand48
#else
#define squid_random rand
#define squid_srandom srand
#endif

#if SIZEOF_INT == 4
typedef int num32;
typedef unsigned int u_num32;
#elif SIZEOF_LONG == 4
typedef long num32;
typedef unsigned long u_num32;
#else
typedef long num32;             /* assume that long's are 32bit */
typedef unsigned long u_num32;
#endif
#define NUM32LEN sizeof(num32)  /* this should always be 4 */
#define xmemmove(d,s,n) memmove((d),(s),(n))

#endif /* _CONFIG_H_ */

// This is a sort of polygon on which I am tweaking parametres

#define xisspace(x) isspace((unsigned char)x)
#define xtoupper(x) toupper((unsigned char)x)
#define xtolower(x) tolower((unsigned char)x)
#define xisdigit(x) isdigit((unsigned char)x)
#define xisascii(x) isascii((unsigned char)x)
#define xislower(x) islower((unsigned char)x)
#define xisalpha(x) isalpha((unsigned char)x)

#define strcasecmp stricmp
#define strncasecmp strnicmp

#define USE_HTCP 0
#define USE_CACHE_DIGESTS 0
#define HTTP_VIOLATIONS 1
#define USE_ICMP 1
#define HAVE_RES_NSADDR_LIST 1
#define SQUID_SNMP 0
#define USE_IDENT 1
#define DELAY_POOLS 0
#define STDC_HEADERS 1
#define USE_WCCP 1
#define USE_ARP_ACL 0 // (? needed ?)
#define USE_CARP 0
#define IPF_TRANSPARENT 0 // (! Not portable !)
#define USE_DNSSERVERS 0
#define HEAP_REPLACEMENT 1
#define USE_USERAGENT_LOG 1