/* clib.c: Functions which we normally expect to find in the C library. */

/* This file is part of GNU Info, a program for reading online documentation
   stored in Info format.

   Copyright (C) 1995 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Written by Brian Fox (bfox@ai.mit.edu). */

#include <stdio.h>

static void *xmalloc (size_t n)
{
  void *p;

  p = malloc (n);
  if (p == NULL)
    {
      fprintf (stderr, "Out of memory\n");
      exit (2);
    }
  return p;
}

#if !defined (HAVE_STRDUP)
char *
strdup (string)
     char *string;
{
  char *result;

  result = (char *)xmalloc (1 + strlen (string));
  strcpy (result, string);
  return (result);
}
#endif /* !HAVE_STRDUP */

#if !defined (HAVE_STRERROR)
extern char *sys_errlist[];
extern int sys_nerr;

char *
strerror (num)
     int num;
{
  if (num >= sys_nerr)
    return ("");
  else
    return (sys_errlist[num]);
}
#endif /* !HAVE_STRERROR */

#if !defined (HAVE_STRCASECMP)
/* This Unix doesn't have the strcasecmp () function. */

#define info_toupper(x) (islower (x) ? toupper (x) : x)
#define info_tolower(x) (isupper (x) ? tolower (x) : x)

int
strcasecmp (string1, string2)
     char *string1, *string2;
{
  char ch1, ch2;

  for (;;)
    {
      ch1 = *string1++;
      ch2 = *string2++;

      if (!(ch1 | ch2))
	return (0);

      ch1 = info_toupper (ch1);
      ch2 = info_toupper (ch2);

      if (ch1 != ch2)
	return (ch1 - ch2);
    }
}

/* Compare at most COUNT characters from string1 to string2.  Case
   doesn't matter. */
int
strncasecmp (string1, string2, count)
     char *string1, *string2;
     int count;
{
  register char ch1, ch2;

  while (count)
    {
      ch1 = *string1++;
      ch2 = *string2++;

      ch1 = info_toupper (ch1);
      ch2 = info_toupper (ch2);

      if (ch1 == ch2)
	count--;
      else
	break;
    }
  return (count);
}
#endif /* !STRCASECMP */

