/* Copyright (c) 1995-1999 NEC USA, Inc.  All rights reserved.               */
/*                                                                           */
/* The redistribution, use and modification in source or binary forms of     */
/* this software is subject to the conditions set forth in the copyright     */
/* document ("Copyright") included with this distribution.                   */

/*
 * $Id: hide.h,v 1.4.4.8 1999/08/02 14:58:08 wlu Exp $
 */

#ifdef FOR_SHARED_LIBRARY
#ifdef HIDEORIG

#ifndef HIDE_H
#define HIDE_H

/* Try to hide these functions so we don't get compiler pukage.              */
#define HIDE(x)       _hidden_ ## x
#ifdef HAVE_GETHOSTBYNAME2
#define gethostbyname2 HIDE(gethostbyname2)
#endif
#define gethostbyname HIDE(gethostbyname)
#define getpeername   HIDE(getpeername)
#define getsockname   HIDE(getsockname)
#define accept        HIDE(accept)
#define connect       HIDE(connect)
#define select        HIDE(select)
#define bind          HIDE(bind)
#define recvfrom      HIDE(recvfrom)
#define sendto        HIDE(sendto)
#ifdef HAVE_SENDMSG
#define recvmsg       HIDE(recvmsg)
#define sendmsg        HIDE(sendmsg)
#endif
#define recv          HIDE(recv)
#define send          HIDE(send)
#define read          HIDE(read)
#define write         HIDE(write)
#ifdef HAVE_RRESVPORT
#define rresvport     HIDE(rresvport)
#endif
#define shutdown      HIDE(shutdown)
#define listen        HIDE(listen)
#define longjmp       HIDE(longjmp)
#define close         HIDE(close)

#else

#undef HIDE_H

/* Unhide these functions so we can deal with them now that includes are     */
/* done...Hopefully...                                                       */
#ifdef HAVE_GETHOSTBYNAME2
#undef gethostbyname2 
#endif
#undef gethostbyname 
#undef getpeername   
#undef getsockname   
#undef accept        
#undef connect       
#undef select       
#undef bind          
#undef recvfrom      
#undef sendto        
#ifdef HAVE_SENDMSG
#undef recvmsg      
#undef sendmsg        
#endif
#undef recv          
#undef send          
#undef read          
#undef write         
#ifdef HAVE_RRESVPORT
#undef rresvport     
#endif
#undef shutdown      
#undef listen        
#undef longjmp        
#undef close         

#endif
#endif
#endif
