#if !defined (HAVE_STRCASECMP)
/* This Unix doesn't have the strcasecmp () function. */
int
strcasecmp (string1, string2)
     char *string1, *string2;
{
  char ch1, ch2;

  for (;;)
    {
      ch1 = *string1++;
      ch2 = *string2++;

      if (!(ch1 | ch2))
	return (0);

      ch1 = info_toupper (ch1);
      ch2 = info_toupper (ch2);

      if (ch1 != ch2)
	return (ch1 - ch2);
    }
}

/* Compare at most COUNT characters from string1 to string2.  Case
   doesn't matter. */
int
strncasecmp (string1, string2, count)
     char *string1, *string2;
     int count;
{
  register char ch1, ch2;

  while (count)
    {
      ch1 = *string1++;
      ch2 = *string2++;

      ch1 = info_toupper (ch1);
      ch2 = info_toupper (ch2);

      if (ch1 == ch2)
	count--;
      else
	break;
    }
  return (count);
}
#endif /* !STRCASECMP */

