#ifndef _SLRN_FEATURES_H
#define _SLRN_FEATURES_H
/* Note!!!
 * Lines beginning with '#' characters do NOT indicate that the line is
 * commented out.  C does NOT use '#' as a comment character.  In this file, 
 * '1' indicates that the feature will be turned on, and '0' indicates that
 * the feature will be turned off.
 */

/* If you enable local SPOOL support, you must also enable NNTP support
 * or INEWS support.  Also, see below for filenames regarding the location
 * of the local spool and inews.  Currently only unix supports this.
 * 
 * NOTE: if you intend to use slrnpull, make sure you enable SPOOL_SUPPORT
 *       in addition to PULL_SUPPORT.
 */
#define SLRN_HAS_PULL_SUPPORT	1
#define SLRN_HAS_NNTP_SUPPORT	1
#define SLRN_HAS_SPOOL_SUPPORT	1
#define SLRN_HAS_INEWS_SUPPORT	1
/* Set this to 1 to force the user to use INEWS for posting.  This also means
 * that slrn will use the hardcoded inews program pathname.
 */
#define SLRN_FORCE_INEWS	0    

#define SLRN_HAS_SPOILERS	1
#define SLRN_HAS_MIME		1
#define SLRN_HAS_SORT_BY_SCORE	1

/* If non-zero, a User-Agent header will be generated instead of X-Newsreader. */
#define SLRN_HAS_USER_AGENT	1

/* If non-zero '~' characters will be used at the end of an article.  This 
 * is what the vi editor does. */
#define SLRN_HAS_TILDE_FEATURE	1

/* If non-zero, a special message will be displayed when article is the last
 * one in a thread.
 */
#define SLRN_HAS_END_OF_THREAD	1

/* See README.GroupLens.  This only works if SLRN_USE_SLTCP is non-zero. 
 * Also make sure NNTP support is enabled.
 */
#define SLRN_HAS_GROUPLENS	0

/* If set to 1, slrn will cache message-ids during a session and use those
 * to eliminate cross-posts.  This should not be necessary if the server 
 * supports Xref in its overview database.
 */
#define SLRN_HAS_MSGID_CACHE	0

/* Set this to 0 if you do not want the slang interpreter made available. */
#define SLRN_HAS_SLANG		1

/* Set this to 0 if you do not want slrn to generate message-id header. */
#define SLRN_HAS_GEN_MSGID	1

/* If you want mapping ISO Latin <--> native character set, set this to 1.
 * Supported character sets: isolatin, ibm850, and next
 */
#define SLRN_HAS_CHARACTER_MAP	1

/* If you want to use uudeview's uulib instead of slrn's builtin one
 * change this to 1.  You will also need to edit the Makefile to point to
 * the uudeview include file and and library.  Only enable this if you
 * have uudeview installed on your system.
 */
#define SLRN_HAS_UUDEVIEW	0

/* If an article does not contain a references but it contains an In-reply-to
 * header, then the In-reply-to header might serve as a references
 * header. Set this to 1 to allow for that possibility.  Since this
 * only works if XOVER is not used, most NNTP users will not be
 * affected by it.  However, it could be a big win for slrnpull users
 * who read groups that are gatewayed from a mailing list, e.g.,
 * comp.os.msdos.djgpp.
 */
#define SLRN_HAS_FAKE_REFS	1

/* The sltcp interface is necessary for simultaneous tcp/ip connections. */
#define SLRN_USE_SLTCP		1

#ifndef VMS
# define SLRN_HAS_DECODE	1
# define SLRN_HAS_PIPING	1
#else
# define SLRN_HAS_PIPING	0
# define SLRN_HAS_DECODE	0
#endif

/* If non-zero, an rn style lock file will be created if .newsrc is the newsrc
 * file.
 */
#if defined(VMS) || defined(__os2__) || defined(__NT__)
# define SLRN_HAS_RNLOCK	0
#else
# define SLRN_HAS_RNLOCK	1
#endif

/* If non-zero, slrn will add From header to mail messages. */
#if defined(IBMPC_SYSTEM)
# define SLRN_GEN_FROM_EMAIL_HEADER 1
#else
# define SLRN_GEN_FROM_EMAIL_HEADER 0
#endif

#define SLRN_MAX_HEADER_FORMATS 10

/* ----------------  LOCAL SPOOL and INEWS filenames and configuration ----------------------- */

#if SLRN_HAS_INEWS_SUPPORT
  /* Note the -S flag.  slrn appends the signature to the file to be posted and
   * the -S flag tells inews not to also do this.  The -h flag must be used.
   */
# define SLRN_INEWS_PROGRAM      "/usr/local/bin/inews -S -h"
#endif

#if SLRN_HAS_SPOOL_SUPPORT || defined(SLRNPULL_CODE)

/* Note: Do not be confused by INN.  You do not need INN.  slrn can work with
 *       CNEWS just as well.
 */

  /* Root directory names */
# define SLRN_SPOOL_ROOT	"/var/spool/news"
  /* SLRN_NOV_ROOT gives the root directory for overview files
   * if you don't have overview files, leave as SLRN_SPOOL_ROOT for now */
# define SLRN_SPOOL_NOV_ROOT	SLRN_SPOOL_ROOT
  /* SLRN_NOV_FILE gives filename for overview file in each directory */
# define SLRN_SPOOL_NOV_FILE	".overview"

# define SLRN_SPOOL_INNROOT	"/var/lib/news"
  /* If the following filenames are relative ones, they are considered to be
   * relative to SLRN_SPOOL_INNROOT.
   */
# define SLRN_SPOOL_ACTIVE	"data/active"
# define SLRN_SPOOL_ACTIVETIMES	"data/active.times"
# define SLRN_SPOOL_NEWSGROUPS	"data/newsgroups"

  /* set to 1 to allow scanning the active file for article ranges if there's
   * no .overview file -- if 0 or no active file, then look at filenames in
   * the spool directory instead.  0 seems best... */
# define SPOOL_ACTIVE_FOR_ART_RANGE 0
#endif

/* Default Startup mode.  Should slrn use spool or nntp?  What about default
 * posting agent?
 */
#if SLRN_HAS_NNTP_SUPPORT
# define SLRN_DEFAULT_SERVER_OBJ	SLRN_SERVER_ID_NNTP
# define SLRN_DEFAULT_POST_OBJ		SLRN_POST_ID_NNTP
#else
# define SLRN_DEFAULT_SERVER_OBJ	SLRN_SERVER_ID_SPOOL
# define SLRN_DEFAULT_POST_OBJ		SLRN_POST_ID_INEWS
#endif

#if SLRN_HAS_INEWS_SUPPORT && SLRN_FORCE_INEWS
# undef SLRN_DEFAULT_POST_OBJ
# define SLRN_DEFAULT_POST_OBJ SLRN_POST_ID_INEWS
#endif



/* ---------------- end of INEWS and LOCAL SPOOL configuration ----------- */

#ifdef VMS
/* 
 *                                                            VMS filenames
 */
# define SLRN_FAILED_POST_FILE		"slrn-failed-post.txt"
# define SLRN_USER_SLRNRC_FILENAME	"slrn.rc"
# define SLRN_LETTER_FILENAME		"slrn-letter.txt"
# define SLRN_ARTICLE_FILENAME		"slrn-article.txt"
# define SLRN_FOLLOWUP_FILENAME		"slrn-followup.txt"
# define SLRN_SIGNATURE_FILE		".signature"
# ifndef SLRN_LIB_DIR
#  define SLRN_LIB_DIR			"sys$manager:"
# endif
#else
# if defined(IBMPC_SYSTEM)
/*
 *                                                             OS/2 filenames
 */
#  define SLRN_FAILED_POST_FILE		"failpost.txt"
#  define SLRN_USER_SLRNRC_FILENAME	"slrn.rc"
#  define SLRN_LETTER_FILENAME		"letter.txt"
#  define SLRN_ARTICLE_FILENAME		"article.txt"
#  define SLRN_FOLLOWUP_FILENAME	"followup.txt"
#  define SLRN_SIGNATURE_FILE		"signatur.txt"
#  define SLRN_SENDMAIL_COMMAND		"sendmail -t -af"
#  ifndef SLRN_LIB_DIR
#    define SLRN_LIB_DIR		"C:/slrn"
#  endif
# else
#  ifdef __unix__
/* 
 *                                                             Unix filenames
 */
#   define SLRN_FAILED_POST_FILE	"slrn-failed-post.txt"
#   define SLRN_USER_SLRNRC_FILENAME	".slrnrc"
#   define SLRN_LETTER_FILENAME	".letter"
#   define SLRN_ARTICLE_FILENAME	".article"
#   define SLRN_FOLLOWUP_FILENAME	".followup"
#   define SLRN_SIGNATURE_FILE		".signature"
#   define SLRN_SENDMAIL_COMMAND	"/usr/lib/sendmail -oi -t -oem -odb"
#   ifndef SLRN_LIB_DIR
#    define SLRN_LIB_DIR		"/usr/local/lib/slrn"
#   endif
#  endif			       /* unix */
# endif				       /* os2 */
#endif				       /* vms */

/* #define OUR_ORGANIZATION "organization-name" */
/* #define OUR_HOSTNAME "host.name.here" */
/* #define NNTPSERVER_NAME  "my.server.name" */
/* #define NNTPSERVER_FILE		"/usr/local/lib/news/nntp_server" */

#if SLRN_HAS_GROUPLENS
# undef SLRN_USE_SLTCP
# define SLRN_USE_SLTCP 1
#endif

/* The rest of the files apply to slrnpull. */

/* This must be set to an absolute pathname. */
#define SLRNPULL_ROOT_DIR	"/var/spool/news/slrnpull"

/* The remaing variables are specified as relative names with respect to the
 * SLRNPULL_ROOT_DIR.
 */

/* slrnpull configuration filename. */
#define SLRNPULL_CONF		"slrnpull.conf"

/* slrnpull outgoing post directory. */
#define SLRNPULL_OUTGOING_DIR	"out.going"

/* If set to 1, slrn will write files to the outgoing directory with group
 * write permission.  This assumes that the outgoing directory has been 
 * created with the setgid bit enabled, which slrnpull will do if this is
 * set to 1.  See slrn/slrnpull/setgid.txt for more information.
 */
#define SLRNPULL_USE_SETGID_POSTS	0

/* The file that will be used for killing articles as they are fetched. */
#define SLRNPULL_SCORE_FILE	"score"

/* All news article retrived from the server will be placed in newsgroup
 * subdirectories in this directory.
 */
#define SLRNPULL_NEWS_DIR	"news"

/* File where messages and errors will be placed. */
#define SLRNPULL_LOGFILE	"log"

#if SLRN_HAS_PULL_SUPPORT && !SLRN_HAS_SPOOL_SUPPORT
# undef SLRN_HAS_PULL_SUPPORT
# define SLRN_HAS_PULL_SUPPORT 0
#endif

#if !SLRN_HAS_NNTP_SUPPORT
# undef SLRN_HAS_GROUPLENS
# define SLRN_HAS_GROUPLENS 0
#endif

/* Sanity checks.  Do not modify. */

#if !defined (SLRN_DEFAULT_SERVER_OBJ)
# if SLRN_HAS_NNTP_SUPPORT
#  define SLRN_DEFAULT_SERVER_OBJ SLRN_SERVER_ID_NNTP
# else
#  define SLRN_DEFAULT_SERVER_OBJ SLRN_SERVER_ID_SPOOL
# endif
#endif

#if !defined (SLRN_DEFAULT_POST_OBJ)
# if SLRN_HAS_NNTP_SUPPORT
#  define SLRN_DEFAULT_POST_OBJ SLRN_POST_ID_NNTP
# else
#  define SLRN_DEFAULT_POST_OBJ SLRN_POST_ID_INEWS
# endif
#endif

#endif				       /* _SLRN_FEATURES_H */
