/*--------------------------------------------------------------------------*/
/*									    */
/*		  OS/2 2.0 SLIP Driver for IBM TCP/IP v1.2.1		    */
/*									    */
/*		      Version 1.0 (Beta) - April 9, 1992		    */
/*			  David Bolen - db3l@ans.net			    */
/*									    */
/*				  SLIPUP.CMD				    */
/*									    */
/*	      ..................................................	    */
/*									    */
/*			Sample SLIP Attachment Script			    */
/*									    */
/*	      ..................................................	    */
/*									    */
/*									    */
/*			      Copyright (c) 1993			    */
/*	      David Bolen and Advanced Network & Services, Inc.		    */
/*			     All Rights Reserved		            */
/*									    */
/*									    */
/* Sample attachment script for dialing into a Xylogics Annex terminal      */
/* server in order to establish a SLIP connection.  This script should be   */
/* specified using the "attachcmd" and "attachparm" elements in the SLIP    */
/* configuration file SLIP.CFG.  For example:				    */
/*									    */
/*		interface sl0 {						    */
/*		   attachcmd  = slipup					    */
/*		   attachparm = "dialcmd username password"		    */	
/*		}						            */
/*									    */
/* The script parameters specify the command to send to the modem to dial   */
/* the remote site and the username/password combination to use to log into */
/* the terminal server.  If any of the parameters are omitted, or are       */
/* specified as an asterix (*), the script will prompt for them.  This is   */
/* most useful with the password parameter to avoid storing the password    */
/* in a text file on the disk.						    */
/*									    */
/* For example, the following might be an entry in a slip.cfg file:	    */
/*									    */
/*		interface sl0 {						    */
/*		   attachcmd  = slipup					    */
/*		   attachparm = "atdt###-#### db3l *"			    */	
/*		}						            */
/*									    */
/* which would cause slipup to initially prompt for the password.  It       */
/* would then feed the "atdt###-####" command to the modem, and when the    */
/* Annex answered, it would use "db3l" as a username and what had been      */
/* entered from the keyboard as the password.				    */
/*									    */
/*	      - - - - - - - - - - - - - - - - - - - - - - - - -		    */
/*									    */
/* When the script runs, it is automatically passed the interface name for  */
/* the interface it is running on as the first argument, and the user	    */
/* arguments (from SLIP.CFG) as the second argument.			    */
/*									    */
/* The script sends the dial string to the modem and then logs into the     */
/* terminal server using the username/password.  It then issues the SLIP    */
/* command to start SLIP, and parses the resulting output to determine the  */
/* appropriate addresses to use.  Lastly, it issues ifconfig and route	    */
/* commands to configure the OS/2 system appropriately.  Note that the      */
/* configuration assumes a class C netmask for the SLIP interface.	    */
/*									    */
/* A script must return 0 in order to signify to the SLIP driver that the   */
/* script executed correctly.  A non-zero exit code will be interpreted     */
/* as an error by the driver and will cause the driver to exit.		    */
/*									    */
/*--------------------------------------------------------------------------*/

parse arg interface , dialcmd username password

/*--------------------------------------------------------------------------*/
/*		     Initialization and Main Script Code		    */
/*--------------------------------------------------------------------------*/

/* Set some definitions for easier COM strings */
cr='0d'x
crlf='0d0a'x

say ''
say 'SLIPUP - SLIP Script for ANS Annex Terminal Server ',
    '(interface' interface')'

/* Prompt for missing information */
if dialcmd = '' then do
   call charout , 'Dial Command: '
   parse pull dialcmd
end
if username = '' | username = '*' then do
   call charout , 'User Name: '
   parse pull username
end
else do
   say 'User:' username
end
if password = '' | password = '*' then do
   call charout , 'Password: '
   password = readpass()
end

/* Flush any stuff left over from previous COM activity */
call flush_receive

/* Dial the remote server */
call charout , 'Now Dialing...'

/* Wait for connection */
call send dialcmd || cr
call waitfor 'CONNECT' ; call waitfor crlf

/* Handle login.  We wait for standard strings, and then flush anything */
/* else to take care of trailing spaces, etc..				*/
call send cr
call waitfor 'Username:' ; call flush_receive 'echo'
call send username || cr
call waitfor 'Password:' ; call flush_receive 'echo'
call send password || cr

/* Wait for the main prompt and then send the "slip" command */
call waitfor 'Annex:' ; call flush_receive 'echo'
call send 'slip' || cr

/* Parse the results of the SLIP command to determine our address. */
/* We use the "waitfor_buffer" variable from the waitfor routine   */
/* to parse the stuff we get from the Annex after waiting for an   */
/* appropriate point in the data stream.		           */
call waitfor 'Your address is'
parse var waitfor_buffer . 'Annex address is' a '.' b '.' c '.' d '.' .
annex_address = a||'.'||b||'.'||c||'.'||d

/* Now parse the remainder for our address */

call waitfor crlf
parse var waitfor_buffer a '.' b '.' c '.' d '.' .
os2_address = a||'.'||b||'.'||c||'.'||d

/* Flush anything else */
call flush_receive 'echo'

/* Now configure this host for the appropriate address, */
/* and for a default route through the Annex.		*/

say 'SLIP Connection Established'
say 'Configuring local address =' os2_address ', Annex =' annex_address

'ifconfig sl0' os2_address annex_address 'netmask 255.255.255.0'
'route -f add default' annex_address '1'

/* All done */
exit 0


/*--------------------------------------------------------------------------*/
/*			      send ( sendstring)			    */
/*..........................................................................*/
/*									    */
/* Routine to send a character string off to the modem.			    */
/*									    */
/*--------------------------------------------------------------------------*/

send:

   parse arg sendstring
   call slip_com_output interface , sendstring

   return

/*--------------------------------------------------------------------------*/
/*			    waitfor ( waitstring )			    */
/*..........................................................................*/
/*									    */
/* Waits for the supplied string to show up in the COM input.  All input    */
/* from the time this function is called until the string shows up in the   */
/* input is accumulated in the "waitfor_buffer" variable.		    */
/*									    */
/*--------------------------------------------------------------------------*/

waitfor:

   parse arg waitstring , timeout

   waitfor_buffer = '' ; done = 0 ; curpos = 1

   if (remain_buffer = 'REMAIN_BUFFER') then do
      remain_buffer = ''
   end

   do while done = 0
      if (remain_buffer \= '') then do
         line = remain_buffer
	 remain_buffer = ''
      end
      else do
         line = slip_com_input(interface)
      end
      waitfor_buffer = waitfor_buffer || line
      index = pos(waitstring,waitfor_buffer)
      if (index > 0) then do
         remain_buffer = substr(waitfor_buffer,index+length(waitstring))
	 waitfor_buffer = delstr(waitfor_buffer,index+length(waitstring))
         done = 1
      end
      call charout , substr(waitfor_buffer,curpos)
      curpos = length(waitfor_buffer)+1
    end

  return


/*--------------------------------------------------------------------------*/
/*				 readpass ()				    */
/*..........................................................................*/
/*									    */
/* Routine used to read a password from the user without echoing the        */
/* password to the screen.						    */
/*									    */
/*--------------------------------------------------------------------------*/

readpass:

  answer = ''
  do until key = cr
    key = slip_getch()
    if key \= cr then do
      answer = answer || key
    end
  end
  say ''
  return answer


/*--------------------------------------------------------------------------*/
/*			       flush_receive ()				    */
/*..........................................................................*/
/*									    */
/* Routine to flush any pending characters to be read from the COM port.    */
/* Reads everything it can until nothing new shows up for 100ms, at which   */
/* point it returns.							    */
/*									    */
/* The optional echo argument, if 1, says to echo flushed information.	    */
/*									    */
/*--------------------------------------------------------------------------*/

flush_receive:

   parse arg echo

   /* If echoing the flush - take care of waitfor remaining buffer */
   if (echo \= '') & (length(remain_buffer) > 0) then do
      call charout , remain_buffer
      remain_buffer = ''
   end

   /* Eat anything left in the modem or COM buffers */
   /* Stop when nothing new appears for 100ms.      */

   do until line = ''
     line = slip_com_input(interface,,100)
     if echo \= '' then
	call charout , line
   end

   return
