/******************************************************************/
/* SENDMAIL.CMD                                                   */
/*                                                                */
/*     This program acts as a front end for IBM TCP/IP SENDMAIL   */
/*     in a SLIP-only environment.  The program acts as follows:  */
/*                                                                */
/*     * If this is a server invokation (-bd), execute the "real" */
/*       SENDMAIL.EXE, which has been stored in the \MODIFIED     */
/*       subdirectory of the TCP/IP \BIN directory.               */
/*                                                                */
/*     * If the SLIP driver is active (determining this requires  */
/*       TASKS.CMD and TASK_ACTIVE.CMD), any parameters are       */
/*       passed to LAMPOP.EXE.                                    */
/*                                                                */
/*     * Otherwise, the SENDMAIL command is written to the        */
/*       pending mail queue, called PENDING_MAIL, in the          */
/*       \TMP directory.  If there is a file in the pipe, write   */
/*       that to a unique fileid in the \TMP directory and modify */
/*       the SENDMAIL command accordingly.                        */
/*                                                                */
/* Assumptions:                                                   */
/*                                                                */
/*     * LAMAIL will be used for sending mail                     */
/*     * TCPBIN variable has been set in CONFIG.SYS               */
/*     * "Real" SENDMAIL.EXE has been moved to \BIN\MODIFIED      */
/*     * Only the following two forms of SENDMAIL calls are used: */
/*                                                                */
/*       sendmail -bd -q[n]m                                      */
/*       sendmail -f [sender] [recipient] < [mail_file]           */
/*                                                                */
/******************************************************************/

trace OFF

   address CMD

   parse arg parameters
   parse upper arg _PARAMETERS

   error = 0

   run = Value('TCPBIN',, 'OS2ENVIRONMENT')
   server = Value('SLIP.POP_SERVER',, 'OS2ENVIRONMENT')
   user = Value('SLIP.USERNAME',, 'OS2ENVIRONMENT')
   password = Value('SLIP.PASSWORD',, 'OS2ENVIRONMENT')

   send_mail = ('@' || run || '\modified\sendmail.exe')
   send_pop = ('@' || 'lampop -s' server user password)

   select
     when (pos("-BD", _PARAMETERS) <> 0) then do
       address CMD send_mail parameters
       error = RC
     end /* when */

     when task_active(SLIP, tasks()) then do
       address CMD send_pop parameters
       error = RC
     end /* when */
 
     otherwise do
       work = Value('TMP',, 'OS2ENVIRONMENT')
       list = (work || '\' || 'pending_mail')
       file = (work || '\' || sdate())

       do write = 1 by 1 while lines() & (error == 0)
         error = lineout(file, linein())
       end write

       if (error == 0) then do
         command = (send_mail "-af" file parameters)
         error = lineout(list, command) 
       end /* if */

       call stream file, 'COMMAND', 'CLOSE'
       call stream list, 'COMMAND', 'CLOSE'
     end /* otherwise */
   end /* select */

exit (error)
