/******************************************************************/
/* Send pending (offline-composed) mail                           */
/******************************************************************/

trace OFF

   address CMD

   parse upper arg option .

   signal on HALT name CLEANUP
   signal on SYNTAX name CLEANUP
   signal on FAILURE name CLEANUP

/******************************************************************/
/*                                                                */
/******************************************************************/

   call initialize option

   do until (G._fatal == 1) | (G._interval <= 0)
     if (lines(G._old_list) <> 0) then do
       do while lines(G._old_list) & (G._fatal <> 1)
         command = linein(G._old_list)

         file = mail_file(command)
         to = recipient(command)
         subject = get_subject(file)

         emit(time() 'Sending message file: ' file)
	 emit('        ' 'First recipient:      ' to)
         emit('        ' 'Subject:              ' subject)

         error = send_message(command, file)

         if (error <> 0) then
           call problem command, error
       end /* while */

       call swap_lists
     end /* if */

     if (G._interval > 0) then	
       call syssleep G._interval
   end /* while */

/******************************************************************/
/*                                                                */
/******************************************************************/
   
cleanup: 

  if (RC <> 0) & (RC <> 'RC') then
    emit(Time() '*** Error' RC 'at line' SIGL)

exit (RC)

/******************************************************************/
/*                                                                */
/******************************************************************/

get_subject: procedure expose G.

   parse arg file
 
   subject = ""
   
   do while lines(file) & (subject == "") & (line <> "")
     line = linein(file)
     parse var line tag ":" value

     if (translate(tag) == "SUBJECT") then
       subject = value
   end /* while */

   result = stream(file, 'COMMAND', 'CLOSE')

return strip(subject)

/******************************************************************/
/*                                                                */
/******************************************************************/

mail_file: procedure expose G.

  parse arg . "-af" mail_file .

return strip(mail_file)

/******************************************************************/
/*                                                                */
/******************************************************************/

recipient: procedure expose G.

  parse arg . "-f" sender recipient .

return strip(recipient)

/******************************************************************/
/*                                                                */
/******************************************************************/

initialize: procedure expose G.

  parse arg option

  call rxfuncadd sysfiledelete, rexxutil, sysfiledelete
  call rxfuncadd syssleep, rexxutil, syssleep

  G. = ""

  G._fatal = 0

  if datatype(option, numeric) then
    G._interval = option
  else
    G._interval = 0

  G._server = value('SLIP.POP_SERVER',, 'OS2ENVIRONMENT')
  G._user = value('SLIP.USERNAME',, 'OS2ENVIRONMENT')
  G._password = value('SLIP.PASSWORD',, 'OS2ENVIRONMENT')
  G._work = value('TMP',, 'OS2ENVIRONMENT')

  G._old_list = (G._work || '\' || 'pending_mail')
  G._new_list = (G._work || '\' || 'pending_mail.temporary')

  call sysfiledelete G._new_list

return

/******************************************************************/
/*                                                                */
/******************************************************************/

emit: procedure expose G.

  parse arg text

  result = lineout(, text)

return "@"

/******************************************************************/
/*                                                                */
/******************************************************************/

swap_lists: procedure expose G.

  result = stream(G._old_list, 'COMMAND', 'CLOSE')
  result = stream(G._new_list, 'COMMAND', 'CLOSE')

  if (G._fatal == 1) then do
    call sysfiledelete G._new_list

    emit(Time() '*** Fatal error--Message list and files retained ***')
  end /* if */

  else do
    call sysfiledelete G._old_list

   '@rename' G._new_list filespec(name, G._old_list)

    if (RC <> 0) & lines(G._new_list) then do
      emit(Time() '*** Fatal error--Can not rename new message list ***')

      G._fatal = 1              
    end /* if */
 
    else do
      do while (G._sent <> "") 
        parse var G._sent file "15"x G._sent
       
        file = strip(file)
        result = stream(file, 'COMMAND', 'CLOSE')
 
        call sysfiledelete file

        emit(time() 'deleted message file' '"'file'", RC='result)
      end /* while */
    end /* else */
  end /* else */      

return

/******************************************************************/
/*                                                                */
/******************************************************************/

problem: procedure expose G.

  parse arg command, error

  emit('        ' '*** MTA error:        ' error '***')

  if (lineout(G._new_list, command) <> 0) then
    G._fatal = 1

return

/******************************************************************/
/*                                                                */
/******************************************************************/

send_message: procedure expose G.

  parse arg command, file

  address CMD ('@lampop' '-s' G._server G._user G._password "<" file)
  error = RC

  if (error == 0) then
    G._sent = (file "15"x G._sent)

return (error)
    