/******************************************************************/
/* CMWRAPPER                                                      */
/*                                                                */
/*    This is a skeleton for a CMANAGER demand-dial wrapper.      */
/*    TCP/IP functions must be enclosed in a wrapper to use the   */
/*    demand-dial capabilities provided by CMANAGER.              */
/*                                                                */
/*    This routine can be altered at will as long as the          */
/*    following conventions are observed:                         */
/*                                                                */
/*    1. CMSTART() must be called before the TCP/IP application   */
/*       is invoked.  It is advisable to use the blocking form of */
/*       CMSTART(id, 1) unless you want to perform your own       */
/*       SLIPWAIT.                                                */
/*                                                                */
/*    2. CMSTOP() must be called whenever the wrapper is          */
/*       terminated, either normally, by CTRL-C, or by kill       */
/*       signal.  Therefore, the SIGNAL ON exits should be        */
/*       preserved and all execution paths should lead to a       */
/*       CMSTOP() call.                                           */
/*                                                                */
/*    3. Select a different unique id (i.e., CMSTART(id, 1)) for  */
/*       each wrapper, but use the same id within a wrapper.      */
/*       While these ids do not affect CMANAGER, they are helpful */
/*       for debugging and logging purposes.                      */
/******************************************************************/

trace OFF

  /*** These signal traps should be preserved ***/

  signal on HALT name CLEANUP
  signal on FAILURE name CLEANUP
  signal on SYNTAX name CLEANUP

  /*** Replace [ID] with the unique id for this wrapper ***/

  unique = [ID]

  parse arg parameters

  if \CMStart(unique, 1) then 
    say date(USA) time() "001S connection could not be started"
  else do
    /*** include any code necessary to invoke the application ***/   
    /*** here.  The 'parameters' variable will contain any    ***/
    /*** command-line parameters passed to the wrapper        ***/
  end /* else */

CLEANUP: 

  call CMStop unqiue

return (RC)