/*************************************************************/
/* CMSTART ( identification , synchronize_flag )             */
/*                                                           */
/*   CMSTART is used to start a SLIP session for the program */
/*   identified by "identification."  CMSTART will optionally*/
/*   wait until the SLIP driver is started before returning  */
/*   to the calling program (synchronize_flag == 1).         */
/*                                                           */
/*   One CMSTOP() should be issued for each CMSTART() request*/
/*   when the session is completed (see CMWRAPPER() for more */
/*   details).                                               */
/*                                                           */
/*   "Identification" is a free-from string which will appear*/
/*   in the CMANAGER console output for the START operation. */
/*   The same identification string should be specified for  */
/*   the corresponding CMSTOP() operation.                   */
/*************************************************************/

trace OFF

  signal on HALT name CLEANUP
  signal on FAILURE name CLEANUP
  signal on SYNTAX name CLEANUP

  parse arg caller, synchronize

  completed = CMPerform('START', caller)

  if completed & (synchronize == 1) then do
   '@SLIPWAIT 240 > nul'
    completed = (RC == 0)
  end /* if */

CLEANUP: exit (completed == 1)

