/*************************************************************/
/* CMPERFORM ( operation , identifier )                      */
/*                                                           */
/*   CMPERFORM sends a request to CMANAGER and then waits    */
/*   for CMANAGER to accept the request.  CMPERFORM will     */
/*   block until CMANAGER sends an acknowledgement on the    */
/*   response queue.                                         */
/*                                                           */
/*   This acknowledgement does not imply successful          */
/*   completion of the request--only that CMANAGER has       */
/*   accepted it.                                            */
/*                                                           */
/*   "operation" is any valid CMANAGER operation (see        */
/*   CMANAGER() for details).                                */
/*                                                           */
/*   "identifier" is the identification that will be         */
/*   displayed in the CMANAGER() log for this request.       */
/*************************************************************/

trace OFF

  signal on HALT name CLEANUP
  signal on FAILURE name CLEANUP
  signal on SYNTAX name CLEANUP

  command = CMCommandQueue
  response = rxqueue(create)

  parse arg operation, caller

  previous = rxqueue(set, command)

  queue (operation '15'x caller '15'x response)

  call rxqueue set, response

  answer = linein('QUEUE:')

CLEANUP:

  call rxqueue set, previous
  call rxqueue delete, response

exit (answer == 1)

