/*
** Module   :INSTALL.CMD
** Abstract :
**
** Copyright (C) 1999 Link Guard Solutions Ltd.
**
** Log: Tue  21/12/1999 Created
**
*/

'@echo off'

rc=RxFuncAdd('BootDrive', 'bootdrv', 'BootDrive')
rc=RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs')
call SysLoadFuncs

signal on halt name bad_inst;

if RxFuncQuery('SysTempFileName') then
do
    say 'Unable to load REXXUTIL.DLL. Aborting installation'
    exit
end

if RxFuncQuery('BootDrive') then
do
    say 'Unable to load BOOTDRV.DLL. Aborting installation'
    exit
end

lgspath=BootDrive()':\SafeFire'
replace_config='N'
continue='N'
wps='Y'

say ''
say 'SafeFire PPP Install, Copyright (C) 1999 Link Guard Solutions Ltd.'
say ''
say 'This program will install SafeFire PPP to your PC.'

do while continue<>'Y'
    call ask_inst_dir
    call ask_mk_dir
    call ask_config
    call ask_wps

    say ''
    say ' Installation directory >'lgspath
    say ' Update CONFIG.SYS      >'replace_config
    say ' Create program objects >'wps
    say ''

    say 'Are these parameters correct?'
    say 'Enter '"'Y'" 'followed by Enter key to begin installation.'
    say 'Press Ctrl+Break to abort installation.'

    parse upper pull answer

    if answer='Y' then continue='Y'
end

/* Extract files */

if fileexist(lgspath, 'D') <> 1 then
do
    say 'Installation directory does no exists. Aborting'
    exit
end

if fileexist('PACKAGE.EXE', 'F') <> 1 then
do
    say 'Missing software package. Aborting'
    exit
end

parse value lgspath with drive':'path

'@dir /f PACKAGE.EXE | rxqueue'

parse pull package

'@'drive':'
'cd "'path'"'

'cd'

'@'package '-d -o'

if wps = 'Y' & fileexist('objects.lst', 'F') = 1 then
do
    call mkobjects 'objects.lst'
end

/* prepare CONFIG.SYS */

/* save a copy of CONFIG.SYS */

config=BootDrive()':\CONFIG.SYS'

if fileexist(config, 'F') = 1 then
do
    'copy 'config '.\CONFIG.ORG'

    if fileexist('CONFIG.ORG', 'F') <> 1 then
    do
        say 'Unable to save a copy of CONFIG.SYS.'
        say 'CONFIG.SYS will not be updated.'
    end
    else do
        fin='CONFIG.ORG'
        fout='CONFIG.SYS'
        path_ready=0

        call SysFileDelete fout

        do while lines(fin) > 0

            str=linein(fin)

            if left(translate(str),7) = 'LIBPATH' then
            do
                str=str';'lgspath'\bin'
            end

            if left(translate(str),10) = 'SET LGSDIR' then
            do
                path_ready=1
                'SET LGSDIR='lgspath
            end

            call lineout fout, str
        end

        if path_ready=0 then
        do
            call lineout fout, 'SET LGSDIR='lgspath
        end

        call stream fin , 'c', 'close'
        call stream fout, 'c', 'close'

        if replace_config = 'Y' then
        do
            'copy 'fout config

            say ''
            say 'Original CONFIG.SYS is saved as 'lgspath'\CONFIG.ORG'
            say ''
        end
    end
end


exit

/*----------------------------------------------------------------------*/
/* Utility routines                                                     */
/*----------------------------------------------------------------------*/

ask_inst_dir:

    say ''
    say 'Please, enter directory where SafeFire PPP should be installed'
    say 'or press Enter for installation to 'lgspath

    parse pull answer

    if answer<>'' then lgspath=answer

return

ask_config:

    say ''
    say 'Installer will to make changes in CONFIG.SYS.'
    say 'These changes are adding of LGSDIR environment variable'
    say 'and adding of path where SafeFire PPP will be installed'
    say 'to LIBPATH statement.'
    say ''
    say 'Press '"'Y'"' to allow Installer to make changes'
    say 'Press '"'N'"' and changed CONFIG.SYS will be placed in 'lgspath

    pull answer

    if answer='Y' then replace_config='Y';

return

ask_wps:

    say ''
    say 'Create program objects on the desktop ? [Y/N]'
    say ''
    pull answer

    if answer<>'Y' then wps='N' else wps ='Y';

return


ask_mk_dir:

    if fileexist(lgspath, 'D') <> 1 then
    do
        say ''
        say 'Directory 'lgspath' does no exists.'
        say 'Create this directory ? [Y/N]'

        pull answer

        if answer='Y' then
        do
            rc=SysMkDir(lgspath)
        end
    end

return

fileexist: procedure
    call SysFileTree ARG(1), stem, ARG(2)
return stem.0;

bad_inst:
    say 'Installation aborter. Exiting'
    exit
return

mkobjects:
    fin=arg(1)

    do while lines(fin) > 0
        str=linein(fin)

        if left(str,1)<>';' & strip(str)<>'' then
        do
            do while pos('%1',str) > 0
                parse value str with beg'%1'rest
                str=beg||lgspath||rest
            end

            parse value str with class '|' title '|' location '|' setup '|' option

            say 'Creating' str
            call SysCreateObject class, title, location, setup, option
        end
    end

    call stream fin, 'c', 'close'
return
