/* Recreate objects script.
 *
 * Generated via Object Desktop Package File 'Object Package'.
 */

/* Register with REXX API extensions. */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/* creation disposition. */
CreateCollision = 'Update'

Call CreateObjects
Exit

CreateObject: procedure
    Parse Arg Class, Title, Location, Setup, Collision
    Say 'Creating ['Title']'
    rc = SysCreateObject( Class, Title, Location, Setup, Collision )
    If rc <> 1 Then
        Say ' > failed to create ['Title' | 'Class'] at location ['Location']'
    return rc

CreateObjects:

current_dir = directory()
previous_dir = left(current_dir, ( length(current_dir) - 4 ))
ETC_path = value('ETC',,'OS2ENVIRONMENT')
folderID = '<Sendmail_8_8_8_for_OS_2>'

rc = CreateObject( 'WPFolder',,
    'Sendmail 8.8.8^for OS/2',,
    '<WP_DESKTOP>',,
    'ALWAYSSORT=YES;'||,
        'OBJECTID='||folderID,,
    CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Display Aliases^(From Database)',,
      folderID,,
      'EXENAME=CMD.EXE;'||,
          'STARTUPDIR='||ETC_path||';'||,
          'PARAMETERS= /c '||previous_dir||'\PRALIASES.EXE |more;'||,
          'NOAUTOCLOSE=YES;'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Mail Stats',,
      folderID,,
      'EXENAME=CMD.EXE;'||,
          'STARTUPDIR='||ETC_path||';'||,
          'PARAMETERS= /c '||previous_dir||'\MAILSTATS.EXE |more;'||,
          'NOAUTOCLOSE=YES;'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Process Mail Queue',,
      folderID,,
      'EXENAME=CMD.EXE;'||,
          'STARTUPDIR='||ETC_path||';'||,
          'PARAMETERS= /c '||previous_dir||'\SENDMAIL.EXE -q -v |more;'||,
          'NOAUTOCLOSE=YES;'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Purge Stats',,
      folderID,,
      'EXENAME=CMD.EXE;'||,
          'STARTUPDIR='||ETC_path||';'||,
          'PARAMETERS= /c '||previous_dir||'\SENDMAIL.EXE -bH |more;'||,
          'NOAUTOCLOSE=YES;'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Display Stats',,
      folderID,,
      'EXENAME=CMD.EXE;'||,
          'STARTUPDIR='||ETC_path||';'||,
          'PARAMETERS= /c '||previous_dir||'\SENDMAIL.EXE -bh |more;'||,
          'NOAUTOCLOSE=YES;'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Display Mail Queue',,
      folderID,,
      'EXENAME=CMD.EXE;'||,
          'STARTUPDIR='||ETC_path||';'||,
          'PARAMETERS= /c '||previous_dir||'\SENDMAIL.EXE -bp |more;'||,
          'NOAUTOCLOSE=YES;'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'New Aliases^(Compile Database)',,
      folderID,,
      'EXENAME='||previous_dir||'\SENDMAIL.EXE;'||,
          'STARTUPDIR='||ETC_path||';'||,
          'PARAMETERS=-bi;'||,
          'NOAUTOCLOSE=YES;'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Start Sendmail Deamon',,
      folderID,,
      'EXENAME='||previous_dir||'\SENDMAIL.EXE;'||,
          'STARTUPDIR='||ETC_path||';'||,
          'PARAMETERS=-bd;'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Stop Sendmail Deamon',,
      folderID,,
      'EXENAME='||previous_dir||'\OS2\SIGHUP.CMD;'||,
          'STARTUPDIR='||previous_dir||'\OS2;'||,
          'PARAMETERS='||ETC_path||'\sendmail.pid;'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'readme.os2',,
      folderID,,
      'SHADOWID='||previous_dir||'\readme.os2',,
      CreateCollision )

/* ======================================================================= */
/* Configuration Folder */

  conf_FolderID = left(folderID,length(folderID)-1)||'_conf>'

  rc = CreateObject( 'WPFolder',,
    'Configuration',,
    folderID,,
    'ALWAYSSORT=YES;'||,
        'OBJECTID='||conf_FolderID,,
    CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Edit sendmail.cf8',,
      conf_FolderID,,
      'EXENAME=E.EXE;'||,
          'PARAMETERS='||ETC_path||'\sendmail.cf8;'||,
          'PROGTYPE=PM',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Edit sendmail.cw8',,
      conf_FolderID,,
      'EXENAME=E.EXE;'||,
          'PARAMETERS='||ETC_path||'\sendmail.cw8;'||,
          'PROGTYPE=PM',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Edit aliases',,
      conf_FolderID,,
      'EXENAME=E.EXE;'||,
          'PARAMETERS='||ETC_path||'\aliases;'||,
          'PROGTYPE=PM',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Generate default SENDMAIL.CF8^(Overwrites any existing SENDMAIL.CF8)',,
      conf_FolderID,,
      'EXENAME='||previous_dir||'\os2\makecf.cmd;'||,
          'STARTUPDIR='||previous_dir||'\os2;'||,
          'PARAMETERS=[Are you sure? Press Open to Continue.];'||,
          'NOAUTOCLOSE=YES;'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Test Configuration^(Interactive)',,
      conf_FolderID,,
      'EXENAME='||previous_dir||'\SENDMAIL.EXE;'||,
          'STARTUPDIR='||ETC_path||';'||,
          'PARAMETERS=-bt;'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

/* ======================================================================= */
/* Syslog Folder */

  syslog_FolderID = left(folderID,length(folderID)-1)||'_syslog>'

  rc = CreateObject( 'WPFolder',,
    'Syslog',,
    folderID,,
    'ALWAYSSORT=YES;'||,
        'OBJECTID='||syslog_FolderID,,
    CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Start Syslog Deamon',,
      syslog_folderID,,
      'EXENAME='||previous_dir||'\os2\syslog\SYSLOGD.EXE;'||,
          'PARAMETERS=-f '||previous_dir||'\os2\syslog\syslog.conf;'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Edit SYSLOG.CONF',,
      syslog_FolderID,,
      'EXENAME=E.EXE;'||,
          'PARAMETERS='||previous_dir||'\os2\syslog\syslog.conf;'||,
          'PROGTYPE=PM',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'syslogd.man',,
      syslog_FolderID,,
      'SHADOWID='||previous_dir||'\os2\syslog\syslogd.man',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'logger.man',,
      syslog_FolderID,,
      'SHADOWID='||previous_dir||'\os2\syslog\logger.man',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'syslogcf.man',,
      syslog_FolderID,,
      'SHADOWID='||previous_dir||'\os2\syslog\syslogcf.man',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'read.me',,
      syslog_FolderID,,
      'SHADOWID='||previous_dir||'\os2\syslog\read.me',,
      CreateCollision )

/* ======================================================================= */
/* Docs Folder */

  docs_FolderID = left(folderID,length(folderID)-1)||'_docs>'

  rc = CreateObject( 'WPFolder',,
    'Docs',,
    folderID,,
    'ALWAYSSORT=YES;'||,
        'OBJECTID='||docs_FolderID,,
    CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Sendmail Home Page',,
      docs_FolderID,,
      'EXENAME=NETSCAPE.EXE;'||,
          'PARAMETERS=-3 http://www.sendmail.org;'||,
          'PROGTYPE=PM',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'changes.ps',,
      docs_FolderID,,
      'SHADOWID='||previous_dir||'\doc\changes\changes.ps',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'README',,
      docs_FolderID,,
      'SHADOWID='||previous_dir||'\cf\README',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'KNOWNBUGS',,
      docs_FolderID,,
      'SHADOWID='||previous_dir||'\KNOWNBUGS',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'usenix.ps',,
      docs_FolderID,,
      'SHADOWID='||previous_dir||'\doc\usenix\usenix.ps',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'RELEASE_NOTES',,
      docs_FolderID,,
      'SHADOWID='||previous_dir||'\RELEASE_NOTES',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'FAQ',,
      docs_FolderID,,
      'SHADOWID='||previous_dir||'\FAQ',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'op.ps',,
      docs_FolderID,,
      'SHADOWID='||previous_dir||'\doc\op\op.ps',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'READ_ME',,
      docs_FolderID,,
      'SHADOWID='||previous_dir||'\READ_ME',,
      CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'intro.ps',,
      docs_FolderID,,
      'SHADOWID='||previous_dir||'\doc\intro\intro.ps',,
      CreateCollision )


return

