/*
 * sarg - Squid user management log
 * Mar/98 - Pedro L Orso - orso@onda.com.br
 */

#include "include/conf.h"

int topuser(const char *dirname, int debug, const char *outdir, int userip, char *BgColor, char *TxColor, char *TxBgColor, char *TiColor, char *LogoImage, char *LogoText, char *LogoTextColor, char *Width, char *Height, char *Title, char *BgImage, char *FontFace, char *HeaderColor, char *HeaderBgColor, char *FontSize, char *TempDir, char *Ip2Name, char *TopuserSortField, char *TopuserSortOrder, char *UserAgentLog, char *DateFormat, int smartfilter)

{

   FILE *fp_in, *fp_ou, *fp_top1, *fp_top2, *fp_top3;
   long long int ttnbytes=0, ttnacc=0, tnacc=0;
   long long int tnbytes=0, ttnelap=0, tnelap=0;
   long long int tnincache=0, tnoucache=0, ttnincache=0, ttnoucache=0;
   float perc=0.00;
   float perc2=0.00;
   float inperc=0.00, ouperc=0.00;
   int posicao=0;
   char olduser[MAXLEN], csort[MAXLEN], periodo[MAXLEN], arqper[MAXLEN];
   char wger[MAXLEN], top1[MAXLEN], top2[MAXLEN], top3[MAXLEN];
   char user[MAXLEN], nacc[20], nbytes[20], url[1024], preg[8000], tusr[MAXLEN];
   char ip[MAXLEN], hora[16], data[16], elap[16], incac[16], oucac[16], html[MAXLEN];
   char ipantes[MAXLEN], nameantes[MAXLEN];
   char sfield[10]="2,2";
   char order[3]="-r";
   char wheader[512];
   char ftime[128];
   int  totuser=0;
   int  topcount=0;
   char *s;
   char mask2[255]="<th bgcolor=%s><font size=%s color=%s>%s</font></th>";

   ipantes[0]='\0';
   nameantes[0]='\0';

   strcpy(wger,dirname);
   strcpy(top1,dirname);
   strcpy(top2,dirname);
   strcpy(top3,dirname);
   strcpy(tusr,dirname);
   strcat(wger,"/geral");
   strcat(top1,"/top");
   strcat(top2,"/top.tmp");
   strcat(tusr,"/usuarios");
   strcat(top3,"/index.html");

   if((fp_in=fopen(wger,"r"))==NULL) {
    fprintf(stderr, "SARG: (topuser) %s: %s\n",text[45],wger);
    exit(1);
   }

   if((fp_top1=fopen(top1,"w"))==NULL) {
    fprintf(stderr, "SARG: (topuser) %s: %s\n",text[45],top1);
    exit(1);
   }

   if((fp_top2=fopen(top2,"w"))==NULL) {
    fprintf(stderr, "SARG: (topuser) %s: %s\n",text[45],top2);
    exit(1);
   }

   fscanf(fp_in,"%s",user);
   fscanf(fp_in,"%s",nacc);
   fscanf(fp_in,"%s",nbytes);
   fscanf(fp_in,"%s",url);
   fscanf(fp_in,"%s",ip);
   fscanf(fp_in,"%s",hora);
   fscanf(fp_in,"%s",data);
   fscanf(fp_in,"%s",elap);
   fscanf(fp_in,"%s",incac);
   fscanf(fp_in,"%s",oucac);

   strcpy(olduser,user);
   totuser=1;

   while(!feof(fp_in)) {
      if(strcmp(olduser,user) != 0) {
         if(strcmp(user,"TOTAL") != 0)
            totuser++;

         my_lltoa(tnbytes,val1,15);
         my_lltoa(tnacc,val2,15);
         my_lltoa(tnelap,val3,15);
         my_lltoa(tnincache,val4,15);
         my_lltoa(tnoucache,val5,15);
         sprintf(preg,"%s %s %s %s %s %s\n",olduser,val1,val2,val3,val4,val5);
         fputs(preg,fp_top2);

	 strcpy(olduser,user);
         ttnbytes+=tnbytes;
	 ttnacc+=tnacc;
	 ttnelap+=tnelap;
         ttnincache+=tnincache;
         ttnoucache+=tnoucache;
         tnbytes=0;
         tnacc=0;
         tnelap=0; 
         tnincache=0;
         tnoucache=0;
      }

      tnbytes+=my_atoll(nbytes);
      tnacc+=my_atoll(nacc);
      tnelap+=my_atoll(elap);
      tnincache+=my_atoll(incac);
      tnoucache+=my_atoll(oucac);

      fscanf(fp_in,"%s",user);
      fscanf(fp_in,"%s",nacc);
      fscanf(fp_in,"%s",nbytes);
      fscanf(fp_in,"%s",url);
      fscanf(fp_in,"%s",ip);
      fscanf(fp_in,"%s",hora);
      fscanf(fp_in,"%s",data);
      fscanf(fp_in,"%s",elap);
      fscanf(fp_in,"%s",incac);
      fscanf(fp_in,"%s",oucac);

      if(strcmp(user,"TOTAL") == 0)
         continue;
   }

   my_lltoa(tnbytes,val1,15);
   my_lltoa(tnacc,val2,15);
   my_lltoa(tnelap,val3,15);
   my_lltoa(tnincache,val4,15);
   my_lltoa(tnoucache,val5,15);
   sprintf(preg,"%s %s %s %s %s %s\n",olduser,val1,val2,val3,val4,val5);
   fputs(preg,fp_top2);

   ttnbytes+=tnbytes;
   ttnacc+=tnacc;
   ttnelap+=tnelap;
   ttnincache+=tnincache;
   ttnoucache+=tnoucache;

   my_lltoa(ttnbytes,val1,15);
   my_lltoa(ttnacc,val2,15);
   my_lltoa(ttnelap,val3,15);
   my_lltoa(ttnincache,val4,15);
   my_lltoa(ttnoucache,val5,15);
   sprintf(preg,"TOTAL %s %s %s %s %s\n",val1,val2,val3,val4,val5);
   fclose(fp_in);
   fclose(fp_top2);
   fclose(fp_top1);

   strup(TopuserSortField);
   strlow(TopuserSortOrder);

   if(strcmp(TopuserSortField,"USER") == 0)
      strcpy(sfield,"1,1");

   if(strcmp(TopuserSortField,"CONNECT") == 0)
      strcpy(sfield,"3,3");

   if(strcmp(TopuserSortField,"TIME") == 0)
      strcpy(sfield,"4,4");

   if(strcmp(TopuserSortOrder,"normal") == 0)
      order[0]='\0';

   sprintf(csort, SORT" -n -T %s %s -k %s -o %s %s", TempDir, order, sfield, top1, top2);
   system(csort);

   unlink(top2);

   if((fp_top1=fopen(top1,"a"))==NULL) {
    fprintf(stderr, "SARG: (topuser) %s: %s\n",text[45],top1);
    exit(1);
   }
   fputs(preg,fp_top1);
   fclose(fp_top1);

   if((fp_top1=fopen(top1,"r"))==NULL) {
      fprintf(stderr, "SARG: (topuser) %s: %s\n",text[45],top1);
      exit(1);
   }

   if((fp_top3=fopen(top3,"w"))==NULL) {
      fprintf(stderr, "SARG: (topuser) %s: %s\n",text[45],top3);
      exit(1);
   }

 /*
 * Obtem o periodo
 */

   strcpy(arqper,dirname);
   strcat(arqper,"/periodo");

   if ((fp_in = fopen(arqper, "r")) == 0) {
      fprintf(stderr, "SARG: (topuser) %s: %s\n",text[45],arqper);
      exit(1);
   }

   fgets(periodo,sizeof(periodo),fp_in);
   fclose(fp_in);

   fputs("<html>\n",fp_top3);
   fputs("<head>\n",fp_top3);
   sprintf(html,"  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
   fputs(html,fp_top3);
   fputs("</head>\n",fp_top3);

   // DAS: Using style=font-family more corresponds to standards. 
   sprintf(preg,"<body bgcolor=%s text=%s background='%s' style='font-family:%s;'>\n",BgColor,TxColor,BgImage,FontFace);
   fputs(preg,fp_top3);
   fputs("<center><table cellpadding=0 cellspacing=0>\n",fp_top3);

   if(strlen(LogoImage) > 0) {
      sprintf(preg,"<tr><th align=left><img src='%s' border=0 align=absmiddle width=%s height=%s><font color=%s>%s</font>\n",LogoImage,Width,Height,LogoTextColor,LogoText);
      fputs(preg,fp_top3);
   }

   sprintf(preg,"<tr><th align=center><b><font color=%s size=+1>%s</font></b></th></tr>\n",TiColor,Title);
   fputs(preg,fp_top3);

   sprintf(preg,"<tr><td align=center bgcolor=%s><font size=%s>%s: %s</font></td></tr>\n",HeaderBgColor,FontSize,text[89],periodo);
   fputs(preg,fp_top3);
   strcat(wheader,(char *)text[104]);
   strcat(wheader,": ");
   strcat(wheader,TopuserSortField);
   strcat(wheader,", ");
   strcat(wheader,TopuserSortOrder);
   sprintf(preg,"<tr><td align=center bgcolor=%s><font size=%s>%s</font></td></tr>\n",HeaderBgColor,FontSize,wheader);
   fputs(preg,fp_top3);
   sprintf(preg,"<tr><td align=center bgcolor=%s><font size=%s>Topuser %s</font></td></tr>\n",HeaderBgColor,FontSize,text[55]);
   fputs(preg,fp_top3);

   fputs("</table></center>\n",fp_top3);
   fputs("<center><table cellpadding=0 cellspacing=1>\n",fp_top3);
   fputs("<tr><td></td><td></td></tr>",fp_top3);

   if(strstr(ReportType,"topsites") != 0) {
      sprintf(preg,"<tr><td colspan=11><font size=-1><a href=\"topsites.html\">%s</a> %s</font></td></tr>\n",text[119],text[55]);
      fputs(preg,fp_top3);
   }

   if(strstr(ReportType,"sites_users") != 0) {
      sprintf(preg,"<tr><td colspan=11><font size=-1><a href=\"siteuser.html\">%s</a> %s</font></td></tr>\n",text[85],text[55]);
      fputs(preg,fp_top3);
   }

   if(denied_count) {
      sprintf(preg,"<tr><td colspan=11><font size=-1><a href=\"denied.html\">%s</a> %s</font></td></tr>\n",text[118],text[55]);
      fputs(preg,fp_top3);
   }

   if(authfail_count) {
      sprintf(preg,"<tr><td colspan=11><font size=-1><a href=\"authfail.html\">%s</a> %s</font></td></tr>\n",text[117],text[55]);
      fputs(preg,fp_top3);
   }

   if(smartfilter) {
     sprintf(preg,"<tr><td colspan=11><font size=-1><a href=\"smartfilter.html\">%s</a> %s</font></td></tr>\n",text[116],text[55]);
     fputs(preg,fp_top3);
   }
   strcpy(preg,"<tr><td></td></tr>\n");
   fputs(preg,fp_top3);

   strcpy(val1,text[100]);
   strcpy(val2,text[98]);
   strcpy(val3,text[92]);
   strcpy(val4,text[93]);
   sprintf(val11,"%%%s",text[93]);
   sprintf(val5,"%s-%s-%s",text[113],text[114],text[112]);
   strcpy(val6,text[94]);
   strcpy(val7,text[95]);
   sprintf(val8,"%%%s",text[99]);

   if(strstr(TopUserFields,"NUM") == 0)		 bzero(val1, 255);
   if(strstr(TopUserFields,"USERID") == 0)	 bzero(val2, 255);
   if(strstr(TopUserFields,"CONNECT") == 0)	 bzero(val3, 255);
   if(strstr(TopUserFields,"BYTES") == 0)	 bzero(val4, 255);
   if(strstr(TopUserFields,"SETYB") == 0)	 bzero(val11, 255);
   if(strstr(TopUserFields,"IN-CACHE-OUT") == 0) bzero(val5, 255);
   if(strstr(TopUserFields,"USED_TIME") == 0) 	 bzero(val6, 255);
   if(strstr(TopUserFields,"MILISEC") == 0) 	 bzero(val7, 255);
   if(strstr(TopUserFields,"TIME") == 0) 	 bzero(val8, 255);

   sprintf(preg,"<tr><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s></font></th><th align=left bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s colspan=2><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th></tr>\n",HeaderBgColor,FontSize,HeaderColor,val1,HeaderBgColor,FontSize,HeaderColor,HeaderBgColor,FontSize,HeaderColor,val2,HeaderBgColor,FontSize,HeaderColor,val3,HeaderBgColor,FontSize,HeaderColor,val4,HeaderBgColor,FontSize,HeaderColor,val11,HeaderBgColor,FontSize,HeaderColor,val5,HeaderBgColor,FontSize,HeaderColor,val6,HeaderBgColor,FontSize,HeaderColor,val7,HeaderBgColor,FontSize,HeaderColor,val8);

   fputs(preg,fp_top3);

   strcpy(preg,"<tr><td></td></tr>\n");
   fputs(preg,fp_top3);

   fscanf(fp_top1,"%s",user);
   fscanf(fp_top1,"%s",nbytes);
   fscanf(fp_top1,"%s",nacc);
   fscanf(fp_top1,"%s",elap);
   fscanf(fp_top1,"%s",incac);
   fscanf(fp_top1,"%s",oucac);

   while(!feof(fp_top1)) {
      if(atoi(TopUsersNum) > 0 && topcount >= atoi(TopUsersNum)) goto final;
      strcpy(user2,user);
      tnbytes=my_atoll(nbytes);

      if(tnbytes) {
         perc=tnbytes * 100;
         perc=perc / ttnbytes;
      } else perc = 0;

      if(atol(elap)) {
         perc2=atol(elap);
         perc2=((perc2 * 100) / ttnelap);
      } else perc2 = 0;

      if(atol(incac)) {
         inperc=atol(incac);
         inperc=((inperc * 100) / tnbytes);
      } else inperc = 0;

      if(atol(oucac)) {
         ouperc=atol(oucac);
         ouperc=((ouperc * 100) / tnbytes);
      } else ouperc = 0;

      strcpy(href," ");
      strcpy(href2," ");

      if(strcmp(user,"TOTAL") != 0){
         strcpy(href,"<a href='");
         strcpy(href2,"<a href='d");
         strcat(href,user);
         strcat(href2,user);
         strcat(href,".html'>");
         strcat(href2,".html'>");
      }

      posicao++;

      tnelap=my_atoll(elap);

      if(userip) {
         fixip(user2);
         if(strcmp(Ip2Name,"yes") == 0) {
            if(strcmp(user2,ipantes) != 0) {
               strcpy(ipantes,user2);
               ip2name(user2);
               strcpy(nameantes,user2);
            } else strcpy(user2,nameantes);
         }
      }
    
      if(strstr(ReportType,"date_time") != 0) {
         sprintf(ltext110,"%s",text[110]);
         if(*ltext110){
            for(s=ltext110; *s; ++s)
               *s=tolower(*s);
         }
      } else {
         bzero(href2, MAXLEN);
         bzero(ltext110, 50);
         sprintf(val1,"%s/d%s.html",dirname,user);
	 unlink(val1);
      }

      if(UserTabFile[0] != '\0') {
         sprintf(warea,":%s:",user2);
	 
         if((str=(char *) strstr(userfile,warea)) != (char *) NULL ) {
            z1=0;
            str2=(char *) strstr(str+1,":");
            str2++;
            bzero(name, MAXLEN);
            while(str2[z1] != ':') {
               name[z1]=str2[z1];
               z1++;
            }
         } else strcpy(name,user2);
      } else strcpy(name,user2);

      if(strcmp(Ip2Name,"yes") == 0) {
         if((str=(char *) strstr(name, ".")) != (char *) NULL) {
            if((str=(char *) strstr(str+1, ".")) != (char *) NULL)
               ip2name(name);
         }
      }

      twork=my_atoll(nacc);
      my_lltoa(twork,nacc,0);
      sprintf(wwork1,"%s",fixnum(twork));
      sprintf(wwork2,"%s",fixnum(tnbytes));
      sprintf(wwork3,"%s",fixnum(tnelap));

      sprintf(val1,"%d",posicao);
      sprintf(val2,"%s%s</a>",href2,ltext110);
      sprintf(val3,"%3.2f%%",perc);
      sprintf(val4,"%3.2f%%",inperc);
      sprintf(val5,"%3.2f%%",ouperc);
      sprintf(val6,"%s",buildtime(tnelap));
      sprintf(val7,"%3.2f%%",perc2);

      if(strstr(TopUserFields,"NUM") == 0)          	bzero(val1, 255);
      if(strstr(TopUserFields,"USERID") == 0)		bzero(val2, 255);
      if(strstr(TopUserFields,"CONNECT") == 0)	 	bzero(wwork1, 255);
      if(strstr(TopUserFields,"BYTES") == 0)	 	bzero(wwork2, 255);
      if(strstr(TopUserFields,"SETYB") == 0)	 	bzero(val3, 255);
      if(strstr(TopUserFields,"IN-CACHE-OUT") == 0) 	bzero(val4, 255);
      if(strstr(TopUserFields,"IN-CACHE-OUT") == 0) 	bzero(val5, 255);
      if(strstr(TopUserFields,"USED_TIME") == 0) 	bzero(val6, 255);
      if(strstr(TopUserFields,"MILISEC") == 0) 	 	bzero(wwork3, 255);
      if(strstr(TopUserFields,"TIME") == 0) 	 	bzero(val7, 255);
      if(strstr(ReportType,"users_sites") == 0)         href[0]='\0';

      sprintf(preg,"<tr><td align=right border=0 bgcolor=%s><font size=%s>%s</font></td><td bgcolor=%s><font size=%s>%s</font></td><td bgcolor=%s><font size=%s>%s%s</font></td><td align=right bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%s</font></td><td align=center bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%s</font><td align=right bgcolor=%s><font size=%s>%s</font></td></tr>\n",TxBgColor,FontSize,val1,TxBgColor,FontSize,val2,TxBgColor,FontSize,href,name,TxBgColor,FontSize,wwork1,TxBgColor,FontSize,wwork2,TxBgColor,FontSize,val3,TxBgColor,FontSize,val4,TxBgColor,FontSize,val5,TxBgColor,FontSize,val6,TxBgColor,FontSize,wwork3,TxBgColor,FontSize,val7);

      if(strstr(user,"TOTAL") != 0){

	 strcpy(preg,"<tr><td></td></tr><tr><td></td></tr>");
         fputs(preg,fp_top3);

         if(atol(incac)) {
            inperc=ttnbytes / 100;
            inperc=atol(incac) / inperc;
         } else inperc = 0;

         if(atol(oucac)) {
            ouperc=ttnbytes / 100;
            ouperc=atol(oucac) / ouperc;
         } else ouperc = 0;

	 sprintf(wwork1,"%s",fixnum(ttnacc));
	 sprintf(wwork2,"%s",fixnum(ttnbytes));
	 sprintf(wwork3,"%s",fixnum(ttnelap));

         if(strstr(ReportType,"date_time") != 0) {
	    if(strstr(TopUserFields,"TOTAL") != 0)
               sprintf(preg,"<tr><td></td><th align=left bgcolor=%s><font size=%s color=%s>%s</th><td></td><th align=right bgcolor=%s><font size=%s color=%s>%s</th><th align=right bgcolor=%s><font size=%s color=%s>%15s</th><td></td><th align=right bgcolor=%s><font size=%s color=%s>%3.2f%%</th><th align=left bgcolor=%s><font size=%s color=%s>%3.2f%%</th><th align=center bgcolor=%s><font size=%s color=%s>%s</th><th align=right bgcolor=%s><font size=%s color=%s>%s</th></tr>\n",HeaderBgColor,FontSize,HeaderColor,text[107],HeaderBgColor,FontSize,HeaderColor,wwork1,HeaderBgColor,FontSize,HeaderColor,wwork2,HeaderBgColor,FontSize,HeaderColor,inperc,HeaderBgColor,FontSize,HeaderColor,ouperc,HeaderBgColor,FontSize,HeaderColor,buildtime(ttnelap),HeaderBgColor,FontSize,HeaderColor,wwork3);
	 } else if(strstr(TopUserFields,"TOTAL") != 0)
            sprintf(preg,"<tr><td></td><td></td><th align=left bgcolor=%s><font size=%s color=%s>%s</th><th align=right bgcolor=%s><font size=%s color=%s>%s</th><th align=right bgcolor=%s><font size=%s color=%s>%15s</th><td></td><th align=right bgcolor=%s><font size=%s color=%s>%3.2f%%</th><th align=left bgcolor=%s><font size=%s color=%s>%3.2f%%</th><th align=center bgcolor=%s><font size=%s color=%s>%s</th><th align=right bgcolor=%s><font size=%s color=%s>%s</th></tr>\n",HeaderBgColor,FontSize,HeaderColor,text[107],HeaderBgColor,FontSize,HeaderColor,wwork1,HeaderBgColor,FontSize,HeaderColor,wwork2,HeaderBgColor,FontSize,HeaderColor,inperc,HeaderBgColor,FontSize,HeaderColor,ouperc,HeaderBgColor,FontSize,HeaderColor,buildtime(ttnelap),HeaderBgColor,FontSize,HeaderColor,wwork3);

      }

      fputs(preg,fp_top3);

      topcount++;

      fscanf(fp_top1,"%s",user);
      fscanf(fp_top1,"%s",nbytes);
      fscanf(fp_top1,"%s",nacc);
      fscanf(fp_top1,"%s",elap);
      fscanf(fp_top1,"%s",incac);
      fscanf(fp_top1,"%s",oucac);
   }

   if(ttnbytes) {
      tnbytes=ttnbytes / totuser;
   } else tnbytes=0;

   twork=ttnacc/totuser;
   twork2=ttnelap/totuser;
   sprintf(wwork1,"%s",fixnum(twork));
   sprintf(wwork2,"%s",fixnum(tnbytes));
   sprintf(wwork3,"%s",fixnum(twork2));

   if((strstr(ReportType,"date_time") && strstr(TopUserFields,"AVERAGE") != 0))
      sprintf(preg,"<tr><th></th><th align=left bgcolor=%s><font size=%s color=%s>%s</font></th><th></th><th align=right bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%15s</font></th><td></td><td></td><td></td><th align=center bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%s</font></th></tr>\n",HeaderBgColor,FontSize,HeaderColor,text[96],HeaderBgColor,FontSize,HeaderColor,wwork1,HeaderBgColor,FontSize,HeaderColor,wwork2,HeaderBgColor,FontSize,HeaderColor,buildtime(ttnelap/totuser),HeaderBgColor,FontSize,HeaderColor,wwork3);
   else
      if(strstr(TopUserFields,"AVERAGE") != 0) {
         sprintf(preg,"<tr><th><td></td></th><th align=left bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%15s</font></th><td></td><td></td><td></td><th align=center bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%s</font></th></tr>\n",HeaderBgColor,FontSize,HeaderColor,text[96],HeaderBgColor,FontSize,HeaderColor,wwork1,HeaderBgColor,FontSize,HeaderColor,wwork2,HeaderBgColor,FontSize,HeaderColor,buildtime(ttnelap/totuser),HeaderBgColor,FontSize,HeaderColor,wwork3);
         fputs(preg,fp_top3);
      }

   if(strlen(UserAgentLog) > 0) {
      fputs("<tr><td></td></tr>\n",fp_top3);
      fputs("<tr><td></td></tr>\n",fp_top3);
      fputs("<td align=left colspan=8><font size=-1><a href='useragent.html'>Useragent</a> Report</td>\n",fp_top3);
   }

   strcpy(preg,"</table></center>");
   fputs(preg,fp_top3);

   zdate(ftime, DateFormat);
   sprintf(html,"<br><br><center><font size=-2>%s <a href='%s'>%s-%s</a> %s %s</font></center>\n",text[108],URL,PGM,VERSION,text[109],ftime);
   fputs(html,fp_top3);

final:
   fclose(fp_top1);
   if(strcmp(RemoveTempFiles,"yes") == 0)
      unlink(top1);

   fclose(fp_top3);

   if((fp_ou=fopen(tusr,"w"))==NULL) {
      fprintf(stderr, "SARG: (topuser) %s: %s\n",text[45],tusr);
      exit(1);
   }

   sprintf(preg,"%d\n",totuser);
   fputs(preg,fp_ou);

   fclose(fp_ou);

   return (0);
}
