/*
 * sarg - Squid user management log
 * Mar/98 - Pedro L Orso - orso@onda.com.br
 */

#include "include/conf.h"

void smartfilter_report(const char *dirname, int debug, const char *outdir, int userip, char *BgColor, char *TxColor, char *TxBgColor, char *TiColor, char *LogoImage, char *LogoText, char *LogoTextColor, char *Width, char *Height, char *Title, char *BgImage, char *FontFace, char *HeaderColor, char *HeaderBgColor, char *FontSize, char *TempDir, char *Ip2Name, char *TopuserSortField, char *TopuserSortOrder, char *UserAgentLog, char *DateFormat)
{

   FILE *fp_in = NULL, *fp_ou = NULL, *fp_user = NULL;
      
   char url[MAXLEN];
   char html[MAXLEN];
   char html2[MAXLEN];
   char csort[255];
   char smart_in[MAXLEN];
   char smart_ou[MAXLEN];
   char per[MAXLEN];
   char sites[MAXLEN];
   char report[MAXLEN];
   char periodo[100];
   char ip[MAXLEN];
   char user[MAXLEN];
   char ouser[MAXLEN];
   char data[15];
   char hora[15];
   char smartcat[256];
   char smartheader[15];
   char ftime[128];
   char smartuser[MAXLEN];
   char *str;
   int  fuser=0;

   ouser[0]='\0';

   sprintf(smartheader,"%s",text[116]);
   strup(smartheader);

   sprintf(smart_in,"%s/smartfilter.unsort",dirname);
   sprintf(sites,"%s/sites",dirname);
   sprintf(smart_ou,"%s/smartfilter.log",dirname);
   sprintf(per,"%s/periodo",dirname);
   sprintf(report,"%s/smartfilter.html",dirname);

   if ((fp_in = fopen(per, "r")) == 0) {
      fprintf(stderr, "SARG: (smartfilter) %s: %s\n",text[45],per);
      exit(1);
   }

   fgets(periodo,sizeof(periodo),fp_in);
   fclose(fp_in);

   sprintf(csort, SORT" -n -k 1,1 -k 2,2 -k 3,3 -o %s %s",smart_ou,smart_in);
   system(csort);
   unlink(smart_in);

   if((fp_in=fopen(smart_ou,"r"))==NULL) {
     fprintf(stderr, "SARG: (smartfilter) %s: %s\n",text[8],smart_ou);
     exit(1);
   }

   if((fp_ou=fopen(report,"w"))==NULL) {
     fprintf(stderr, "SARG: (smartfilter) %s: %s\n",text[8],report);
     exit(1);
   }

   fputs("<html>\n",fp_ou);
   fputs("<head>\n",fp_ou);
   sprintf(html,"  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
   fputs(html,fp_ou);
   fputs("</head>\n",fp_ou);

   // DAS: Using style=font-family more corresponds to standards. 
   sprintf(url,"<body bgcolor=%s text=%s background='%s' style='font-family:%s;'>\n",BgColor,TxColor,BgImage,FontFace);
   fputs(url,fp_ou);
   fputs("<center><table cellpadding=0 cellspacing=0>\n",fp_ou);

   if(strlen(LogoImage) > 0) {
      sprintf(url,"<tr><th><img src='%s' border=0 align=absmiddle width=%s height=%s><font color=%s>%s</font>\n",LogoImage,Width,Height,LogoTextColor,LogoText);
      fputs(url,fp_ou);
   }

   sprintf(url,"<tr><th align=center><b><font color=%s size=+1>%s</font></b></th></tr>\n",TiColor,Title);
   fputs(url,fp_ou);

   sprintf(url,"<tr><td align=center bgcolor=%s><font size=%s>%s: %s</font></td></tr>\n",HeaderBgColor,FontSize,text[89],periodo);
   fputs(url,fp_ou);
   sprintf(url,"<tr><th bgcolor=%s align=center><font size=%s>%s %s</font></th></tr>\n",HeaderBgColor,FontSize,text[116],text[55]);
   fputs(url,fp_ou);
   fputs("</table></center>\n",fp_ou);

   fputs("<center><table cellpadding=0 cellspacing=2>\n",fp_ou);
   fputs("<tr><td></td></tr>\n",fp_ou);
   fputs("<tr><td></td></tr>\n",fp_ou);
   fputs("<tr><td></td></tr>\n",fp_ou);
   sprintf(url,"<tr><th bgcolor=%s><font size=%s>%s</font></th><th bgcolor=%s><font size=%s>%s</font></th><th bgcolor=%s><font size=%s>%s</font></th><th bgcolor=%s><font size=%s>%s</font></th><th bgcolor=%s><font size=%s>%s</font></th></tr>\n",HeaderBgColor,FontSize,text[98],HeaderBgColor,FontSize,text[111],HeaderBgColor,FontSize,text[110],HeaderBgColor,FontSize,text[91],HeaderBgColor,FontSize,smartheader);
   fputs(url,fp_ou);

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      getword(user,buf,' ');
      getword(data,buf,' ');
      getword(hora,buf,' ');
      getword(ip,buf,' ');
      getword(url,buf,' ');
      getword(smartcat,buf,'\n');

      if((str=(char *) strstr(user, "_")) != (char *) NULL ) {
         if((str=(char *) strstr(str+1, "_")) != (char *) NULL )
            fixip(user);
      }

      if(strcmp(ouser,user) != 0) {
         strcpy(ouser,user);
         sprintf(smartuser,"%s/denied_%s.html",dirname,user);
         if(fuser) {
            fuser=0;
            fputs("</table>\n",fp_user);
            zdate(ftime, DateFormat);
            sprintf(html2,"<br><br><center><font size=-2>%s <a href='%s'>%s-%s</a> %s %s</font></center>\n",text[108],URL,PGM,VERSION,text[109],ftime);
            fputs(html2,fp_user);
            fputs("</html>\n",fp_user);
            fclose(fp_user);
         }
         if ((fp_user = fopen(smartuser, "a")) == 0) {
            fprintf(stderr, "SARG: (smartfilter) %s: %s\n",text[45],smartuser);
            exit(1);
         }
         fuser=1;

         fputs("<html>\n",fp_user);
         fputs("<head>\n",fp_user);
         sprintf(html,"  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
         fputs(html,fp_user);
         fputs("</head>\n",fp_user);

         if(strlen(FontFace) > 0) {
            sprintf(html2,"<font face=%s>\n",FontFace);
            fputs(url,fp_user);
         }
         sprintf(html2,"<body bgcolor=%s text=%s background='%s'>\n",BgColor,TxColor,BgImage);
         fputs(html2,fp_user);
         fputs("<center><table cellpadding=0 cellspacing=0>\n",fp_user);
         if(strlen(LogoImage) > 0) {
            sprintf(html2,"<tr><th align=left><img src='%s' border=0 align=absmiddle width=%s height=%s><font color=%s>%s</font>\n",LogoImage,Width,Height,LogoTextColor,LogoText);
            fputs(html2,fp_user);
         }
         sprintf(html2,"<tr><th align=center><b><font color=%s size=+1>%s</font></b></th></tr>\n",TiColor,Title);
         fputs(html2,fp_user);
         sprintf(html2,"<tr><td align=center bgcolor=%s><font size=%s>%s: %s</font></td></tr>\n",HeaderBgColor,FontSize,text[89],periodo);
         fputs(html2,fp_user);
         sprintf(html2,"<tr><td align=center bgcolor=%s><font size=%s>%s:</font><font size=%s> %s</font></td></tr>\n",HeaderBgColor,FontSize,text[90],FontSize,user);
         fputs(html2,fp_user);
         fputs("</table></center>\n",fp_user);
         fputs("<center><table cellpadding=0 cellspacing=2>\n",fp_user);
         fputs("<tr><td></td></tr>\n",fp_user);
         fputs("<tr><td></td></tr>\n",fp_user);
         fputs("<tr><td></td></tr>\n",fp_user);
         sprintf(html2,"<tr><th bgcolor=%s><font size=%s>%s</font></th><th bgcolor=%s><font size=%s>%s</font></th><th bgcolor=%s><font size=%s>%s</font></th><th bgcolor=%s><font size=%s>%s</font></th><th bgcolor=%s><font size=%s>%s</font></th></tr>\n",HeaderBgColor,FontSize,text[98],HeaderBgColor,FontSize,text[111],HeaderBgColor,FontSize,text[110],HeaderBgColor,FontSize,text[91],HeaderBgColor,FontSize,smartheader);
         fputs(html2,fp_user);
      }
      sprintf(html2,"<tr><td bgcolor=%s align=center><font size=%s>%s</font></td><td bgcolor=%s align=center><font size=%s>%s</font></td><td bgcolor=%s align=center><font size=%s>%s-%s</font></td><td bgcolor=%s><font size=%s>%s</font></td><td bgcolor=%s><font size=%s>%s</font></td></th>\n",TxBgColor,FontSize,user,TxBgColor,FontSize,ip,TxBgColor,FontSize,data,hora,TxBgColor,FontSize,url,TxBgColor,FontSize,smartcat);
      fputs(html2,fp_user);

      sprintf(html,"<tr><td bgcolor=%s align=center><font size=%s>%s</font></td><td bgcolor=%s align=center><font size=%s>%s</font></td><td bgcolor=%s align=center><font size=%s>%s-%s</font></td><td bgcolor=%s><font size=%s>%s</font></td><td bgcolor=%s><font size=%s>%s</font></td></th>\n",TxBgColor,FontSize,user,TxBgColor,FontSize,ip,TxBgColor,FontSize,data,hora,TxBgColor,FontSize,url,TxBgColor,FontSize,smartcat);
      fputs(html,fp_ou);
   }

   fputs("</table>\n",fp_ou);

   zdate(ftime, DateFormat);
   sprintf(html,"<br><br><center><font size=-2>%s <a href='%s'>%s-%s</a> %s %s</font></center>\n",text[108],URL,PGM
,VERSION,text[109],ftime);
   fputs(html,fp_ou);

   fputs("</html>\n",fp_ou);

   fclose(fp_ou);
   if(fp_user) {
      fputs("</table>\n",fp_user);
      zdate(ftime, DateFormat);
      sprintf(html2,"<br><br><center><font size=-2>%s <a href='%s'>%s-%s</a> %s %s</font></center>\n",text[108],URL,PGM,VERSION,text[109],ftime);
      fputs(html2,fp_user);
      fputs("</html>\n",fp_user);
      fclose(fp_user);
   }

   return;
}
