/*
 * sarg - Squid user management log
 * Mar/98 - Pedro L Orso - orso@onda.com.br
 */

#include "include/conf.h"

void siteuser(const char *dirname, int debug, const char *outdir, int userip, char *BgColor, char *TxColor, char *TxBgColor, char *TiColor, char *LogoImage, char *LogoText, char *LogoTextColor, char *Width, char *Height, char *Title, char *BgImage, char *FontFace, char *HeaderColor, char *HeaderBgColor, char *FontSize, char *TempDir, char *Ip2Name, char *TopuserSortField, char *TopuserSortOrder, char *UserAgentLog, char *DateFormat)
{

   FILE *fp_in, *fp_ou;
      
   char user[MAXLEN];
   char url[MAXLEN];
   char wuser[MAXLEN];
   char ourl[MAXLEN];
   char nacc[20];
   char nbytes[20];
   char csort[255];
   char geral[MAXLEN];
   char geral2[MAXLEN];
   char per[MAXLEN];
   char html[MAXLEN];
   char sites[MAXLEN];
   char report[MAXLEN];
   char periodo[100];
   char ftime[128];
   int regs=0;
   int ucount=0;
   char *users;

//   bzero(users, MAXLEN);
   sprintf(geral,"%s/geral",dirname);
   sprintf(sites,"%s/sites",dirname);
   sprintf(geral2,"%s/geral2",dirname);
   sprintf(per,"%s/periodo",dirname);
   sprintf(report,"%s/siteuser.html",dirname);

   if ((fp_in = fopen(per, "r")) == 0) {
      fprintf(stderr, "SARG: (topuser) %s: %s\n",text[45],per);
      exit(1);
   }

   fgets(periodo,sizeof(periodo),fp_in);
   fclose(fp_in);

   sprintf(csort, SORT" -k 4,4 -k 1,1 -o %s %s",geral2,geral);
   system(csort);

   if((fp_in=fopen(geral2,"r"))==NULL) {
     fprintf(stderr, "SARG: (topsite) %s: %s\n",text[8],geral2);
     exit(1);
   }

   if((fp_ou=fopen(report,"w"))==NULL) {
     fprintf(stderr, "SARG: (topsite) %s: %s\n",text[8],report);
     exit(1);
   }

   fputs("<html>\n",fp_ou);
   fputs("<head>\n",fp_ou);
   sprintf(html,"  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
   fputs(html,fp_ou);
   fputs("</head>\n",fp_ou);

   // DAS: Using style=font-family more corresponds to standards. 
   sprintf(url,"<body bgcolor=%s text=%s background='%s' style='font-family:%s;'>\n",BgColor,TxColor,BgImage,FontFace);
   fputs(url,fp_ou);

   fputs("<center><table cellpadding=0 cellspacing=0>\n",fp_ou);

   if(strlen(LogoImage) > 0) {
      sprintf(url,"<tr><th align=left><img src='%s' border=0 align=absmiddle width=%s height=%s><font color=%s>%s</font>\n",LogoImage,Width,Height,LogoTextColor,LogoText);
      fputs(url,fp_ou);
   }

   sprintf(url,"<tr><th align=center><b><font color=%s size=+1>%s</font></b></th></tr>\n",TiColor,Title);
   fputs(url,fp_ou);

   sprintf(url,"<tr><td align=center bgcolor=%s><font size=%s>%s: %s</font></td></tr>\n",HeaderBgColor,FontSize,text[89],periodo);
   fputs(url,fp_ou);
   sprintf(url,"<tr><td align=center bgcolor=%s><font size=%s>%s</font></td></tr>\n",HeaderBgColor,FontSize,text[85]);
   fputs(url,fp_ou);
   fputs("</table></center>\n",fp_ou);

   fputs("<center><table cellpadding=0 cellspacing=1>\n",fp_ou);
   fputs("<tr><td></td></tr>\n",fp_ou);
   fputs("<tr><td></td></tr>\n",fp_ou);
   fputs("<tr><td></td></tr>\n",fp_ou);
   sprintf(url,"<tr><th>&nbsp;</th><th>&nbsp;</th><th bgcolor=%s><font size=%s>%s</font></th><th>&nbsp;</th><th bgcolor=%s><font size=%s>%s</font></th></tr>\n",HeaderBgColor,FontSize,text[91],HeaderBgColor,FontSize,text[103]);
   fputs(url,fp_ou);
  
   user[0]='\0';
   ourl[0]='\0';

   if((users=(char *) malloc(204800))==NULL){
      fprintf(stderr, "SARG: ERROR: %s",text[87]);
      exit(1);
   }
   strcat(users," ");

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      getword(user,buf,' ');
      if(strcmp(user,"TOTAL") == 0)
         continue;
      if(userip)
         fixip(user);
      if(strcmp(Ip2Name,"yes") == 0)
         ip2name(user);

      getword(nacc,buf,' ');
      getword(nbytes,buf,' ');
      getword(url,buf,' ');

      if(!regs) {
         strcpy(ourl,url);
         regs++;
      }
      
      sprintf(wuser," %s ",user);
      if(strstr(users,wuser) == 0 && strcmp(url,ourl) == 0) {
         strcat(users,user);
         strcat(users," ");
         ucount++;
         if(ucount>4) {
            strcat(users,"<br>");
            ucount=0;
         }
      }

      if(strcmp(url,ourl) != 0) {
         sprintf(html,"<tr><td bgcolor=%s align=right><font size=%s>%d</font></td><td>&nbsp;</td><td align=left border=0 bgcolor=%s><font size=%s><a href=\"http://%s\">%s</a></font></td><td>&nbsp;</td><td bgcolor=%s align=left><font size=%s>%s</font></td></tr>\n",TxBgColor,FontSize,regs,TxBgColor,FontSize,ourl,ourl,TxBgColor,FontSize,users);
         fputs(html,fp_ou);
         regs++;
         ucount=0;
	 strcpy(users,user);
         strcat(users," ");
         strcpy(ourl,url);
      }
   }

   sprintf(html,"<tr><td bgcolor=%s align=right><font size=%s>%d</font></td><td>&nbsp;</td><td align=left border=0 bgcolor=%s><font size=%s><a href=\"http://%s\">%s</font></td><td>&nbsp;</td><td bgcolor=%s align=left><font size=%s>%s</font></td></tr>\n",TxBgColor,FontSize,regs,TxBgColor,FontSize,ourl,ourl,TxBgColor,FontSize,users);
   fputs(html,fp_ou);

   unlink(geral2);

   fputs("</table></center>\n",fp_ou);

   zdate(ftime, DateFormat);
   sprintf(ourl,"<br><br><center><font size=-2>%s <a href='%s'>%s-%s</a> %s %s</font></center>\n",text[108],URL,PGM,VERSION,text[109],ftime);
   fputs(ourl,fp_ou);

   fputs("</html>\n",fp_ou);
   
   fclose(fp_in);
   fclose(fp_ou);

   return;

}
