/*
 * sarg - Squid user management log
 * Mar/98 - Pedro L Orso - orso@onda.com.br
 */

#include "include/conf.h"

void criatmp(char *user, char *dirname, int debug, int indexonly);
void criatmp_hora(char *user, char *dirname, int indexonly);
void gravatmp(char *oldaccuser, char *dirname, char *oldurl, long long int nacc, long long int nbytes, char *oldmsg, long long int nelap, int indexonly, long long int incache, long long int oucache);
void gravatmp_hora(char *dirname, char *user, char *data, char *hora, char *elap, char *accbytes, int indexonly);
void gravatmpf(char *oldaccuser, char *dirname, char *oldurl, long long int nacc, long long int nbytes, char *oldmsg, long long int nelap, int indexonly, long long int incache, long long int oucache);
void gravaporuser(char *user, char *dirname, char *url, char *ip, char *data, char *hora, char *tam, char *elap, int indexonly);
void gravager(char *dirname, char *user, long long int nacc, char *url, long long int nbytes, char *ip, char *hora, char *dia, long long int nelap, long long int incache, long long int oucache);
void grava_SmartFilter(char *dirname, char *user, char *ip, char *data, char *hora, char *url, char *smart);

void gerarel(char *tmp, int debug, const char *periodo, int debugz, int iprel, char* outdir, char *addr, char *site, char *us, int userip, char *email, char *temp2, char *BgColor, char *TxColor, char *TxBgColor, char *TiColor, char *LogoImage, char *LogoText, char *LogoTextColor, char *Width, char *Height, char *Title, char *BgImage, char *FontFace, char *HeaderColor, char *HeaderBgColor, char *FontSize, char *TempDir, char *Ip2Name, char *TopuserSortField, char *UserSortField, char *TopuserSortOrder, char *UserSortOrder, char *UserAgentLog, char *DateFormat, int indexonly, char *PerUserLimitFile, char *PerUserLimit)
{

   FILE *fp_in;

   char accdia[11], acchora[9], accuser[MAXLEN], accip[MAXLEN], accurl[MAXLEN], accbytes[12], accelap[10];
   char oldaccdia[11], oldacchora[9], oldaccip[MAXLEN], wdir[MAXLEN], per1[MAXLEN];
   char dirname[MAXLEN], wdirname[MAXLEN], oldurl[MAXLEN], oldaccuser[MAXLEN];
   char olduser[MAXLEN], oldmsg[50], acccode[50], oldaccelap[10], oldacccode[50];
   char ipantes[MAXLEN], nameantes[MAXLEN]; 
   char accsmart[MAXLEN];
   int  smartfilter=0;
   char wcrc[50];
   char crc2[50];
   long long int nbytes=0; 
   long long int nelap=0; 
   long long int nacc=0;
   long long int rtotal=0;
   long long int incache=0;
   long long int oucache=0;
   char *s;

   ipantes[0]='\0';
   nameantes[0]='\0';

   sprintf(dirname, "%s%s", outdir, periodo);
   sprintf(wdir, "%s%s", outdir, periodo);
   strcpy(per1,periodo);
   vrfydir(wdir, dirname, per1, addr, site, us, debug, email);

   if(debugz){
      debugaz("dirname",dirname);
      debugaz("wdir",wdir);
   }
 
   strcpy(wdirname,dirname);
   gperiodo(wdirname, periodo, debug);

   if(strlen(UserAgentLog) > 0 && email[0] == '\0') {
      strcpy(wdirname,dirname);
      useragent(wdirname,debug,outdir,TempDir,UserAgentLog,periodo,BgColor,TxColor,TxBgColor,TiColor,LogoImage,LogoText,LogoTextColor,Width,Height,Title,BgImage,FontFace,HeaderColor,HeaderBgColor,FontSize,Ip2Name, DateFormat);
   }

   olduser[0]='\0';

   if((fp_in=fopen(tmp,"r"))==NULL){
      fprintf(stderr, "SARG: (report) %s: %s\n",text[45],tmp);
      exit(1);
   }

   ttopen=0;
   bzero(html_old, MAXLEN);

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      getword(accdia,buf,' ');
      getword(acchora,buf,' ');
      getword(accuser,buf,' ');
      getword(accip,buf,' ');
      getword(accurl,buf,' ');
      getword(accbytes,buf,' ');
      getword(acccode,buf,' ');
      getword(accelap,buf,' ');
      getword(accsmart,buf,' ');
      getword(accsmart,buf,'"');

      if(strlen(accsmart) > 0) {
         smartfilter++;
         strcpy(wdirname,dirname);
         grava_SmartFilter(wdirname,accuser,accip,accdia,acchora,accurl,accsmart);
      }

      if(strcmp(Ip2Name,"yes") == 0) {
         if(strcmp(accip,ipantes) != 0) {
            strcpy(ipantes,accip);
            ip2name(accip);
            strcpy(nameantes,accip);
         } else strcpy(accip,nameantes);
      }
     
      if(strcmp(olduser,accuser) != 0){
         strcpy(wdirname,dirname);
	 criatmp(accuser,wdirname,debug,indexonly);
	 criatmp_hora(accuser,wdirname,indexonly);
         strcpy(olduser,accuser);
      }

      strcpy(wdirname,dirname);
      gravatmp_hora(wdirname,accuser,accdia,acchora,accelap,accbytes,indexonly);

      if(iprel){
         strcpy(wdirname,dirname);
         gravaporuser(accuser,wdirname,accurl,accip,accdia,acchora,accbytes,accelap,indexonly);
      }

      if(!rtotal){
         strcpy(oldurl,accurl);
         strcpy(oldacccode,acccode);
         strcpy(oldaccelap,accelap);
         strcpy(oldaccuser,accuser);
         strcpy(oldaccip,accip);
         strcpy(oldaccdia,accdia);
         strcpy(oldacchora,acchora);
         rtotal++;
      }

      if(site[0] != '\0') {
         if(strcmp(oldaccuser,accuser) != 0){
            strcpy(oldmsg,"OK");
            if(strstr(oldacccode,"DENIED") != 0)
               sprintf(oldmsg,"%s",text[46]);
            strcpy(wdirname,dirname);
            gravatmp(oldaccuser,wdirname,oldurl,nacc,nbytes,oldmsg,nelap,indexonly,incache,oucache);
            strcpy(wdirname,dirname);
            gravager(wdirname,oldaccuser,nacc,oldurl,nbytes,oldaccip,oldacchora,oldaccdia,nelap,incache,oucache);
            nacc=0;
            nbytes=0;
            nelap=0;
            incache=0;
            oucache=0;
         }
      } else {     
         if(strcmp(oldurl,accurl) != 0 || strcmp(oldaccuser,accuser) != 0){
            strcpy(oldmsg,"OK");
            if(strstr(oldacccode,"DENIED") != 0)
               sprintf(oldmsg,"%s",text[46]);
            strcpy(wdirname,dirname);
            gravatmp(oldaccuser,wdirname,oldurl,nacc,nbytes,oldmsg,nelap,indexonly,incache,oucache);
            strcpy(wdirname,dirname);
            gravager(wdirname,oldaccuser,nacc,oldurl,nbytes,oldaccip,oldacchora,oldaccdia,nelap,incache,oucache);
            nacc=0;
            nbytes=0;
            nelap=0;
            incache=0;
            oucache=0;
	    if(strcmp(oldaccuser,accuser) != 0)
	       ind2=0;
         }
      }
      nacc++;
      nbytes+=my_atoll(accbytes);
      nelap+=my_atoll(accelap);

      if(strstr(ReportType,"site_user_time_date") != 0) {
         if(!ttopen) {
            ind2++;
            encode_filename( siteind, accurl );
	    sprintf(arqtt,"%s/tt%s-%s.html",dirname,accuser,siteind);
            if ((fp_tt = fopen(arqtt, "w")) == 0) {
               fprintf(stderr, "SARG: (report) %s: %s\n",text[45],arqtt);
               exit(1);
            }
	    ttopen=1;

   	    if(strcmp(Privacy,"yes") == 0)
               sprintf(httplink,"<font size=%s color=%s><href=http://%s>%s",	\
	    	          FontSize,PrivacyStringColor,PrivacyString,PrivacyString);
	     else
               sprintf(httplink,"<font size=%s><a href=http://%s>%s</a>",FontSize,accurl,accurl);

            sprintf(ltext110,"%s",text[110]);
            if(*ltext110){
               for(s=ltext110; *s; ++s)
                  *s=tolower(*s);
            }

            fputs("<html>\n",fp_tt);
            fputs("<head>\n",fp_tt);
            sprintf(html,"  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
            fputs(html,fp_tt);
            fputs("</head>\n",fp_tt);

            // DAS: Using style=font-family more corresponds to standards. 
            sprintf(html,"<body bgcolor=%s text=%s background='%s' style='font-family:%s;'>\n",BgColor,TxColor,BgImage,FontFace);
            fputs(html,fp_tt);
            fputs("<center><table cellpadding=0 cellspacing=0>\n",fp_tt);

            if(strlen(LogoImage) > 0) {
               sprintf(html,"<tr><th align=left><img src='%s' border=0 align=absmiddle width=%s height=%s><font color=%s>%s</font>\n",LogoImage,Width,Height,LogoTextColor,LogoText);
               fputs(html,fp_tt);
            }

            sprintf(html,"<tr><th align=center colspan=2><b><font color=%s size=+1>%s</font></b></th></tr>\n",TiColor,Title);
            fputs(html,fp_tt);
            fputs("<tr><td></td></tr><tr><td></td></tr>",fp_tt);
            fputs("</table></center>\n",fp_tt);
            fputs("<center><table cellpadding=0 cellspacing=0>\n",fp_tt);

            sprintf(html,"<tr><td align=right bgcolor=%s><font size=%s>%s:</font></td><td align=left bgcolor=%s><font size=%s>&nbsp;%s</font></td></td></tr>\n",HeaderBgColor,FontSize,text[89],TxBgColor,FontSize,periodo);
            fputs(html,fp_tt);
            sprintf(html,"<tr><td align=right bgcolor=%s><font size=%s>%s:</font></td><td align=left bgcolor=%s><font size=%s>&nbsp;%s</font></td></td></tr>\n",HeaderBgColor,FontSize,text[90],TxBgColor,FontSize,name);
            fputs(html,fp_tt);
            sprintf(html,"<tr><td align=right bgcolor=%s><font size=%s>%s:</font></td><td align=left bgcolor=%s><font size=%s>&nbsp;%s, %s</font></td></td></tr>\n",HeaderBgColor,FontSize,text[104],TxBgColor,FontSize,UserSortField,UserSortOrder);
            fputs(html,fp_tt);
            sprintf(html,"<tr><td align=center bgcolor=%s colspan=2><font size=%s>%s %s</font></td></tr>\n",HeaderBgColor,FontSize,text[32],text[55]);
            fputs(html,fp_tt);

            fputs("</table></center>\n",fp_tt);
            fputs("<center><table cellpadding=1 cellspacing=1>\n",fp_tt);
            fputs("<tr><td></td><td></td></tr>",fp_tt);
            bzero(tmp4, MAXLEN);
            bzero(tmp5, MAXLEN);
            strncpy(tmp4,text[110],4);   // FIXME: This is not multilanguage!
            strncpy(tmp5,text[110]+5,4); // FIXME: This is not multilanguage!
            sprintf(html,"<tr><th align=left bgcolor=%s><font size=%s color=%s>%s</font></th><td></td><td></td><th bgcolor=%s><font size=%s color=%s>%s</font></th><td></td><td></td><th bgcolor=%s><font size=%s color=%s>%s</font></th></tr>\n",HeaderBgColor,FontSize,HeaderColor,text[91],HeaderBgColor,FontSize,HeaderColor,tmp4,HeaderBgColor,FontSize,HeaderColor,tmp5);
            fputs(html,fp_tt);
	 }

         sprintf(html,"<tr><td align=left bgcolor=%s><font size=%s>%s</font></td><td></td><td></td><td align=left bgcolor=%s><font size=%s>%s</font></td><td></td><td></td><td align=left bgcolor=%s><font size=%s>%s</font></td></tr>\n",TxBgColor,FontSize,accurl,TxBgColor,FontSize,accdia,TxBgColor,FontSize,acchora);

	 if(strcmp(html,html_old) != 0)
            fputs(html,fp_tt);
	 strcpy(html_old, html);
      } else {
         bzero(ltext110, 50);
      } 

      strcpy(wcrc,acccode);
      getword(crc2,wcrc,'/');

      if(strstr(crc2,"MISS") != 0)
         oucache+=my_atoll(accbytes);
       else incache+=my_atoll(accbytes);

      strcpy(oldurl,accurl);

      if(strcmp(accuser,oldaccuser) != 0) {
         strcpy(wdirname,dirname);
         totaliza_day(wdirname,oldaccuser,indexonly);
      }

      strcpy(oldaccuser,accuser);
      strcpy(oldacccode,acccode);
      strcpy(oldaccelap,accelap);
      strcpy(oldaccip,accip);
      strcpy(oldaccdia,accdia);
      strcpy(oldacchora,acchora);

   }

   strcpy(oldmsg,"OK");
   if(strstr(oldacccode,"DENIED") != 0)
      sprintf(oldmsg,"%s",text[46]);
   strcpy(wdirname,dirname);
   gravatmpf(oldaccuser,wdirname,oldurl,nacc,nbytes,oldmsg,nelap,indexonly,incache,oucache);
   strcpy(wdirname,dirname);
   gravager(wdirname,oldaccuser,nacc,oldurl,nbytes,oldaccip,oldacchora,oldaccdia,nelap,incache,oucache);
   strcpy(wdirname,dirname);
   totaliza_day(wdirname,oldaccuser,indexonly);
 
   fclose(fp_in);

   strcpy(wdirname,dirname);
   tmpsort(wdirname, debug, TempDir, TopuserSortField, UserSortField, TopuserSortOrder, UserSortOrder, indexonly);

   strcpy(wdirname,dirname);
   totalger(wdirname, debug, outdir);

   if(strlen(email) == 0) {
      strcpy(wdirname,dirname);
      topuser(wdirname, debug, outdir, userip, BgColor, TxColor, TxBgColor, TiColor, LogoImage, LogoText, LogoTextColor, Width, Height, Title, BgImage, FontFace, HeaderColor, HeaderBgColor, FontSize, TempDir, Ip2Name, TopuserSortField, TopuserSortOrder, UserAgentLog, DateFormat, smartfilter);

      if(strstr(ReportType,"topsites") != 0) {
         strcpy(wdirname,dirname);
         topsites(wdirname, debug, outdir, userip, BgColor, TxColor, TxBgColor, TiColor, LogoImage, LogoText, LogoTextColor, Width, Height, Title, BgImage, FontFace, HeaderColor, HeaderBgColor, FontSize, TempDir, Ip2Name, TopuserSortField, TopuserSortOrder, UserAgentLog, DateFormat);
      }

      if(strstr(ReportType,"sites_users") != 0) {
         strcpy(wdirname,dirname);
         siteuser(wdirname, debug, outdir, userip, BgColor, TxColor, TxBgColor, TiColor, LogoImage, LogoText, LogoTextColor, Width, Height, Title, BgImage, FontFace, HeaderColor, HeaderBgColor, FontSize, TempDir, Ip2Name, TopuserSortField, TopuserSortOrder, UserAgentLog, DateFormat);
      }

      strcpy(wdirname,dirname);
      gen_denied_report(wdirname, debug, outdir, BgColor, TxColor, TxBgColor, TiColor, LogoImage, LogoText, LogoTextColor, Width, Height, Title, BgImage, FontFace, HeaderColor, HeaderBgColor, FontSize, TempDir, DateFormat);

      strcpy(wdirname,dirname);
      authfail_report(wdirname, debug, outdir, BgColor, TxColor, TxBgColor, TiColor, LogoImage, LogoText, LogoTextColor, Width, Height, Title, BgImage, FontFace, HeaderColor, HeaderBgColor, FontSize, TempDir, DateFormat);

      if(smartfilter) {
         strcpy(wdirname,dirname);
         smartfilter_report(wdirname, debug, outdir, userip, BgColor, TxColor, TxBgColor, TiColor, LogoImage, LogoText, LogoTextColor, Width, Height, Title, BgImage, FontFace, HeaderColor, HeaderBgColor, FontSize, TempDir, Ip2Name, TopuserSortField, TopuserSortOrder, UserAgentLog, DateFormat);
      }

      if(strstr(ReportType,"users_sites") != 0) {
         strcpy(wdirname,dirname);
         htmlrel(wdirname, debug, iprel, userip, BgColor, TxColor, TxBgColor, TiColor, LogoImage, LogoText, LogoTextColor, Width, Height, Title, BgImage, FontFace, HeaderColor, HeaderBgColor, FontSize, TempDir, UserSortField, UserSortOrder, DateFormat, indexonly, PerUserLimitFile, PerUserLimit, Ip2Name);
      }

      strcpy(wdirname,outdir);
      geraindex(wdirname, debug, BgColor, TxColor, TxBgColor, TiColor, LogoImage, LogoText, LogoTextColor, Width, Height, Title, BgImage, FontFace, HeaderColor, HeaderBgColor, FontSize, TempDir, DateFormat, periodo);

      if(strncmp(SuccessfulMsg,"yes",3) == 0)
         fprintf(stderr, "SARG: %s %s\n",text[47],dirname);
    } else {
      strcpy(wdirname,dirname);
      geramail(wdirname, debug, outdir, userip, email, TempDir);

      if(strcmp(email,"stdout") != 0) {
         if(strncmp(SuccessfulMsg,"yes",3) == 0)
            fprintf(stderr, "SARG: %s %s\n",text[48],email);
      }
   }

   if(indexonly) {
      strcpy(wdirname,dirname);
      index_only(wdirname, debug);
   }

   removetmp(dirname,debug);

   return;
}


void criatmp(char *user, char *dirname, int debug, int indexonly)
{

   FILE *fp_ou;

   char wdirname[MAXLEN];

   if(indexonly) return;
   if(strstr(ReportType,"users_sites") == 0) return;

   strcpy(wdirname,dirname);
   strcat(wdirname,"/");
   strcat(wdirname,user);

   if(debug){
      sprintf(msg,"%s: %s",text[49],wdirname);
      debuga(msg);
   }

   strcat(wdirname,".tmp");
   if((fp_ou=fopen(wdirname,"w"))==NULL){
      fprintf(stderr, "SARG: (report) %s: %s\n",text[45],wdirname);
      exit(1);
   }

   fclose(fp_ou);
   return;
}


void criatmp_hora(char *user, char *dirname, int indexonly)
{

   FILE *fp_ou;

   char wdirname[MAXLEN];

   if(indexonly) return;
   if(strstr(ReportType,"users_sites") == 0) return;

   strcpy(wdirname,dirname);
   strcat(wdirname,"/");
   strcat(wdirname,user);

   strcat(wdirname,".htmp");
   if((fp_ou=fopen(wdirname,"w"))==NULL){
      fprintf(stderr, "SARG: (report) %s: %s\n",text[45],wdirname);
      exit(1);
   }

   fclose(fp_ou);
   return;
}


void gravatmp(char *oldaccuser, char *dirname, char *oldurl, long long int nacc, long long int nbytes, char *oldmsg, long long int nelap, int indexonly, long long int incache, long long int oucache)
{

   FILE *fp_ou;

   char reg[MAXLEN];
   char wdirname[MAXLEN];

   if(indexonly) return;
   if(strstr(ReportType,"users_sites") == 0) return;

   strcpy(wdirname,dirname);
   strcat(wdirname,"/");
   strcat(wdirname,oldaccuser);
   strcat(wdirname,".tmp");

   if((fp_ou=fopen(wdirname,"a"))==NULL){
      fprintf(stderr, "SARG: (report) %s: %s\n",text[45],wdirname);
      exit(1);
   } 

   my_lltoa(nacc,val1,15);
   my_lltoa(nbytes,val2,15);
   my_lltoa(nelap,val3,15);
   my_lltoa(incache,val4,15);
   my_lltoa(oucache,val5,15);
   sprintf(reg,"%s %s %s %s %s %s %s\n",val1,val2,oldurl,oldmsg,val3,val4,val5);
   fputs(reg,fp_ou);

   fclose(fp_ou);
   ttopen=0;

   if(fp_tt) {
      fputs("</table>\n",fp_tt);
      fputs("</html>\n",fp_tt);
      fclose(fp_tt);
   }

   return;

}


void gravatmp_hora(char *dirname, char *user, char *data, char *hora, char *elap, char *bytes, int indexonly)
{

   FILE *fp_ou;

   char reg[MAXLEN];
   char wdirname[MAXLEN];

   if(indexonly) return;
   if(strstr(ReportType,"users_sites") == 0) return;

   strcpy(wdirname,dirname);
   strcat(wdirname,"/");
   strcat(wdirname,user);
   strcat(wdirname,".htmp");

   if((fp_ou=fopen(wdirname,"a"))==NULL){
      fprintf(stderr, "SARG: (report) %s: %s\n",text[45],wdirname);
      exit(1);
   }

   if(strcmp(datetimeby,"bytes") == 0)
      sprintf(reg,"%s %s %s\n",data,hora,bytes);
   else sprintf(reg,"%s %s %s\n",data,hora,elap);
   fputs(reg,fp_ou);

   fclose(fp_ou);

   return;
}


void gravaporuser(char *user, char *dirname, char *url, char *ip, char *data, char *hora, char *tam, char *elap, int indexonly)
{

   FILE *fp_ou;

   char reg[MAXLEN];
   char wdirname[MAXLEN];

   if(indexonly) return;
   if(strstr(ReportType,"users_sites") == 0) return;

   strcpy(wdirname,dirname);
   strcat(wdirname,"/");
   strcat(wdirname,user);
   strcat(wdirname,".ip");

   if((fp_ou=fopen(wdirname,"a"))==NULL){
      fprintf(stderr, "SARG: (report) %s: %s\n",text[45],wdirname);
      exit(1);
   } 

   sprintf(reg,"%s %s %s %s %s %s\n",ip,url,data,hora,tam,elap);
   fputs(reg,fp_ou);

   fclose(fp_ou);

   return;

}


void gravatmpf(char *oldaccuser, char *dirname, char *oldurl, long long int nacc, long long int nbytes, char *oldmsg, long long int nelap, int indexonly, long long int incache, long long int oucache)
{

   FILE *fp_ou;

   char reg[MAXLEN];
   char wdirname[MAXLEN];

   if(indexonly) return;
   if(strstr(ReportType,"users_sites") == 0) return;

   strcpy(wdirname,dirname);
   strcat(wdirname,"/");
   strcat(wdirname,oldaccuser);
   strcat(wdirname,".tmp");

   if((fp_ou=fopen(wdirname,"a"))==NULL){
      fprintf(stderr, "SARG: (report) %s: %s\n",text[45],wdirname);
      exit(1);
   }

   my_lltoa(nacc,val1,15);
   my_lltoa(nbytes,val2,15);
   my_lltoa(nelap,val3,15);
   my_lltoa(incache,val4,15);
   my_lltoa(oucache,val5,15);
   sprintf(reg,"%s %s %s %s %s %s %s\n",val1,val2,oldurl,oldmsg,val3,val4,val5);
   fputs(reg,fp_ou);

   fclose(fp_ou);
   ttopen=0;
   ind2=0;

   if(fp_tt) {
      fputs("</table>\n",fp_tt);
      fputs("</html>\n",fp_tt);
      fclose(fp_tt);
   }

   return;
     
}


void gravager(char *dirname, char *user, long long int nacc, char *url, long long int nbytes, char *ip, char *hora, char *dia, long long int nelap, long long int incache, long long int oucache)
{

   FILE *fp_ou;
   char reg[MAXLEN];

   strcat(dirname,"/");
   strcat(dirname,"geral");
   
   if((fp_ou=fopen(dirname,"a"))==NULL){
      fprintf(stderr, "SARG: (report) %s: %s\n",text[45],dirname);
      exit(1);
   }

   my_lltoa(nacc,val1,15);
   my_lltoa(nbytes,val2,15);
   my_lltoa(nelap,val3,15);
   my_lltoa(incache,val4,15);
   my_lltoa(oucache,val5,15);
   sprintf(reg,"%s %s %s %s %s %s %s %s %s %s\n",user,val1,val2,url,ip,hora,dia,val3,val4,val5);
   fputs(reg,fp_ou);

   fclose(fp_ou);
   return;

}

void grava_SmartFilter(char *dirname, char *user, char *ip, char *data, char *hora, char *url, char *smart)
{

   FILE *fp_ou;

   char reg[MAXLEN];
   char wdirname[MAXLEN];

   sprintf(wdirname,"%s/smartfilter.unsort",dirname);

   if((fp_ou=fopen(wdirname,"a"))==NULL){
      fprintf(stderr, "SARG: (report) %s: %s\n",text[45],wdirname);
      exit(1);
   }

   sprintf(reg,"%s %s %s %s %s %s\n",user,data,hora,ip,url,smart);
   fputs(reg,fp_ou);

   fclose(fp_ou);

   return;

}
