/*
 * sarg - Squid user management log
 * Mar/98 - Pedro L Orso - orso@onda.com.br
 */

#include "include/conf.h"

extern numlist hours;

void report_day(const char *dirname, char *user, int *iprel, int *ipuser, char *BgColor, char *TxColor, char *TxBgColor, char *TiColor, char *LogoImage, char *LogoText, char *LogoTextColor, char *Width, char *Height, char *Title, char *BgImage, char *FontFace, char *HeaderColor, char *HeaderBgColor, char *FontSize, char *TempDir, char *UserSortField, char *UserSortOrder, char *DateFormat, char *periodo)

{

   FILE *fp_in, *fp_ou;

   char data[20];
   char dia[3];
   char mes[3];
   char ano[3];
   char odata[20];
   char hora[20];
   char elap[20];
   char oelap[20];
   char whora[3];
   char html[8000];
   char arqout[MAXLEN];
   char wdirname[MAXLEN];
   char wuser[255];
   char c[ 24 ][20];
   int  count=0;
   int  ihora=0;
   long long int telap=0;
   long long int v[ 24 ] = { 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 
			     0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L };
   long long int t[ 24 ] = { 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 
			     0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L };
   long long int tt=0, ttt=0;
   char ftime[128];
   int i;

   sprintf(wdirname,"%s/%s.day",dirname,user);
   sprintf(arqout,"%s/d%s.html",dirname,user);

   if((fp_in=fopen(wdirname,"r"))==NULL) {
     fprintf(stderr, "SARG: (totday) %s: %s\n",text[8],wdirname);
     exit(1);
   }

   if((fp_ou=fopen(arqout,"w"))==NULL) {
     fprintf(stderr, "SARG: (totday) %s: %s\n",text[8],arqout);
     exit(1);
   }

   fputs("<html>\n",fp_ou);
   fputs("<head>\n",fp_ou);
   sprintf(html,"  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
   fputs(html,fp_ou);
   fputs("</head>\n",fp_ou);

   // DAS: Using style=font-family more corresponds to standards. 
   sprintf(html,"<body bgcolor=%s text=%s background='%s' style='font-family:%s;'>\n",BgColor,TxColor,BgImage,FontFace);
   fputs(html,fp_ou);

   fputs("<center><table cellpadding=0 cellspacing=0>\n",fp_ou);

   if(strlen(LogoImage) > 0) {
      sprintf(html,"<tr><th align=left><img src='%s' border=0 align=absmiddle width=%s height=%s><font color=%s>%s</font>\n",LogoImage,Width,Height,LogoTextColor,LogoText); 
      fputs(html,fp_ou);
   }

   sprintf(html,"<tr><th align=center colspan=2><b><font color=%s size=+1>%s</font></b></th></tr>\n",TiColor,Title);
   fputs(html,fp_ou);
   
   fputs("</table></center>\n",fp_ou);
   fputs("<center><table cellpadding=0 cellspacing=0>\n",fp_ou);

   sprintf(html,"<tr><td align=right bgcolor=%s><font size=%s>%s:</font></td><td align=left bgcolor=%s><font size=%s>&nbsp;%s</font></td></td></tr>\n",HeaderBgColor,FontSize,text[89],TxBgColor,FontSize,periodo);
   fputs(html,fp_ou);

   strcpy(wuser,user);
   if(strstr(wuser,"_") != 0)
      fixip(wuser);

   if(strcmp(Ip2Name,"yes") == 0)
      if((str=(char *) strstr(name, ".")) != (char *) NULL) {
         if((str=(char *) strstr(str+1, ".")) != (char *) NULL)
            ip2name(wuser);
   }

   if(UserTabFile[0] != '\0') {
      sprintf(warea,":%s:",wuser);
      if((str=(char *) strstr(userfile,warea)) != (char *) NULL ) {
         z1=0;
         str2=(char *) strstr(str+1,":");
         str2++;
         bzero(name, MAXLEN);
         while(str2[z1] != ':') {
            name[z1]=str2[z1];
            z1++;
         }
      } else strcpy(name,wuser);
   } else strcpy(name,user);
     
   sprintf(html,"<tr><td align=right bgcolor=%s><font size=%s>%s:</font></td><td align=left bgcolor=%s><font size=%s>&nbsp;%s</font></td></td></tr>\n",HeaderBgColor,FontSize,text[90],TxBgColor,FontSize,name);
   fputs(html,fp_ou);

   fputs("<tr><td></td></tr><tr><td></td></tr>\n",fp_ou);
   fputs("<tr><td></td></tr><tr><td></td></tr></table>\n",fp_ou);

   fputs("<table cellpadding=1 cellspacing=1>\n", fp_ou);

   fputs( "<tr><td border=0></td>\n", fp_ou );

   if(strcmp(datetimeby,"bytes") == 0)
     strcpy( html, "BYTES" );
   else
     strcpy( html, "H:M:S" );

   for( i = 0; i < hours.len; i++ )
     fprintf( fp_ou,
	"<td align=center bgcolor=%s><font size=-2>%02d<br>%s</td>\n",
	      HeaderBgColor, hours.list[ i ], html );
   fprintf( fp_ou,
     "<td align=center bgcolor=%s><font size=-2>%s<br>%s</td></tr>\n",
	  HeaderBgColor, text[107], html );

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      getword(data,buf,' ');
      if(!count) {
         strcpy(odata,data);
         count++;
      }

      getword(hora,buf,' ');
      getword(elap,buf,' ');
      elap[strlen(elap)-1]='\0';

      if(strcmp(data,odata) != 0) {
         strcpy(oelap,elap);

	 for( i = 0; i < hours.len; i++ )
	   sprintf(c[ hours.list[ i ] ],"%s",fixtime(v[ hours.list[ i ] ]));

	 for( i = 8; i <= 17; i++ )
	   if(strcmp(c[ hours.list[ i ] ],"00:00:00") == 0)
		bzero(c[ hours.list[ i ] ],12);

         fprintf( fp_ou,
       "<tr><td align=center bgcolor=%s><font color=darkblue size=-2>%s</td>\n",
		HeaderBgColor,odata );
	 for( i = 0; i < hours.len; i++ )
	   fprintf( fp_ou,
	     "<td align=center bgcolor=%s><font color=blue size=-2>%s</td>\n",
		 TxBgColor, c[ hours.list[ i ] ] );
	 fprintf( fp_ou,
	   "<td align=right bgcolor=%s><font color=darkblue size=-2>%s</td>\n",
	      HeaderBgColor,fixtime(tt) );
        
         tt=0;
	 for( i = 0; i < hours.len; i++ ) v[ hours.list[ i ] ]=0;
         strcpy(odata,data);
         strcpy(elap,oelap);
      }

      ihora=atoi(hora);

      v[ ihora ]+=my_atoll(elap);
      tt+=my_atoll(elap);
      t[ ihora ]+=my_atoll(elap);
      ttt+=my_atoll(elap);

   }

   for( i = 0; i < hours.len; i++ )
     sprintf(c[ hours.list[ i ] ],"%s",fixtime(v[ hours.list[ i ] ]));

   for( i = 0; i < hours.len; i++ )
     if(strcmp(c[ hours.list[ i ] ],"00:00:00") == 0) bzero(c[ hours.list[ i ] ],12);
 
   fprintf( fp_ou,
     "<tr><td align=center bgcolor=%s><font color=darkblue size=-2>%s</td>\n",
	HeaderBgColor, data );
   for( i = 0; i < hours.len; i++ )
     fprintf( fp_ou,
       "<td align=center bgcolor=%s><font color=blue size=-2>%s</td>\n",
	   TxBgColor, c[ hours.list[ i ] ] );
   fprintf( fp_ou,
     "<td align=right bgcolor=%s><font color=darkblue size=-2>%s</td></tr>\n",
	HeaderBgColor, fixtime(tt) );

   for( i = 0; i < hours.len; i++ )
     sprintf(c[ hours.list[ i ] ],"%s",fixtime(t[ hours.list[ i ] ]));

   fprintf( fp_ou,
     "<tr><td align=center bgcolor=%s><font color=darkblue size=-2>%s</td>\n",
	HeaderBgColor, text[107] );
   for( i = 0; i < hours.len; i++ )
     fprintf( fp_ou,
       "<td align=center bgcolor=%s><font color=blue size=-2>%s</td>\n",
	   TxBgColor, c[ hours.list[ i ] ] );
   fprintf( fp_ou,
     "<td align=right bgcolor=%s><font color=darkblue size=-2>%s</td></tr>\n",
	 HeaderBgColor, fixtime(ttt) );

   fputs("</table>\n", fp_ou);

   zdate(ftime, DateFormat);
   sprintf(html,"<br><br><center><font size=-2>%s <a href='%s'>%s-%s</a> %s %s</font></center>\n",text[108],URL,PGM,VERSION,text[109],ftime);
   fputs(html, fp_ou);

   fclose(fp_in);
   fclose(fp_ou);

   unlink(wdirname);

   return;
}
