/*
 * Copyright (c) 2002 by Dmitry A.Steklenev
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <direct.h>
#include <errno.h>
#include <string.h>

static void usage( void )
{
  printf( "Usage: [OPTION] DIRECTORY...\n" );
  printf( "Create the DIRECTORY(ies), if they do not already exist.\n\n"
          "  -p  no error if existing, make parent directories as needed\n"
          "  -m  ignored for compatibility\n" );

  exit( EXIT_SUCCESS );
}

int make_directory( char *path, int recurse )
{
  int ret;
  #if 0
  printf( "SAMD: %s\n", path );
  #endif

  if( recurse )
  {
    char *pp = strrchr(path, '\\' );
    if( pp && pp != path && pp[-1] != ':' )
    {
      *pp = '\0';
      ret = make_directory( path, recurse );
      *pp = '\\';

      if( ret == -1 )
        return ret;
    }
  }

  ret = mkdir( path );
  if( ret == -1 )
  {
    if( recurse && errno == EACCESS )
      ret = 0;
    else
      fprintf( stderr, "SAMD: Cannot create directory (%d) '%s'\n", errno, path );

  }

  return ret;
}

int main( int argc, char **argv )
{
  int recurse = 0;
  int i, opt;

  while((opt = getopt( argc, argv, "m:p")) != -1 )
  {
    switch(opt)
    {
      case 'm':
        break;

      case 'p':
        recurse = 1;
        break;

      default:
        usage();
    }
  }

  if( optind == argc )
    usage();

  for( i = optind; i < argc; i++ )
  {
    char *path = strdup( argv[i] ), *p;

    for( p = path; *p; p++ )
      if( *p == '/' ) *p = '\\';

    make_directory( path, recurse );
    free( path );
  }

  return( EXIT_SUCCESS );
}
