/* 
 * Copyright (c) 1990-1995 by Eberhard Mattes 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _GETOPT_H
#define _GETOPT_H

#if defined (__cplusplus)
extern "C" {
#endif

extern char *optarg;       /* argument of current option                    */
extern int   optind;       /* index of next argument; default=0: initialize */
extern int   opterr;       /* 0=disable error messages; default=1: enable   */
extern int   optopt;       /* option character which caused the error       */
extern char *optswchar;    /* characters introducing options; default="-"   */

extern enum _optmode
{
  GETOPT_UNIX,             /* options at start of argument list (default)   */
  GETOPT_ANY,              /* move non-options to the end                   */
  GETOPT_KEEP              /* return options in order                       */
} optmode;

/* Note: The 2nd argument is not const as GETOPT_ANY reorders the
   array pointed to. */

int getopt (int, char **, const char *);

#if defined (__cplusplus)
}
#endif

#endif /* not _GETOPT_H */
