/*
 * sarg - Squid user management log
 * Mar/98 - Pedro L Orso - orso@onda.com.br
 */

#include "include/conf.h"

char *userfile;
char *excludefile;
char *excludeuser;

numlist weekdays = { { 0, 1, 2, 3, 4, 5, 6 }, 7 };
numlist hours = { { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12,
	     13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23 }, 24 };

void getusers(char *pwdfile, int debug);
void gethexclude(char *hexfile, int debug);
void getuexclude(char *uexfile, int debug);
void ttx(char *user);
int compar( const void *, const void * );

int main(argc,argv)
   int argc;
   char *argv[];
{

   FILE *fp_in = NULL, *fp_ou = NULL, *fp_denied, *fp_usr, *fp_authfail;

   extern int optind;
   extern int optopt;
   extern char *optarg;

   char w[MAXLEN];
   char data[255]; 
   char elap[255];
   char none[255];
   char ip[MAXLEN];
   char msg[MAXLEN];
   char tam[255];
   char fun[255];
   char url[8192];
   char urly[8192];
   char user[MAXLEN];
   char wuser[MAXLEN]; 
   char code[MAXLEN];
   char code2[MAXLEN];
   char periodo[MAXLEN];
   char dia[128]; 
   char wdata[128];
   char mes[30];
   char ano[30];
   char hora[30];
   char tmp[MAXLEN];
   char tmp2[MAXLEN];
   char tmp3[MAXLEN];
   char wtemp[MAXLEN];
   char wtemp2[255];
   char us[50];
   char date[255];
   char arq[255];
   char warq[255][255];
   char addr[MAXLEN];
   char hm[6];
   char smartfilter[MAXLEN];
   char site[MAXLEN];
   char uagent[MAXLEN];
   char hexclude[MAXLEN];
   char csort[MAXLEN]; 
   char tbuf[128];
   char email[MAXLEN];
   char zip[20];
   char *str;
   char outdir[MAXLEN];
   char cdfrom[30];
   char cduntil[30];
   char bufz[8192];
   char bufy[8192];
   int  common; 
   int  common_log=0;
   int  squid_log=0;
   int  userip=0;
   int  indexonly=0;
   int  ch;
   int  d;
   int  x, l, i;
   int  errflg=0;
   int  debug=0;
   int  debugz=0;
   int  debugm=0;
   int  iprel=0;
   int  puser=0;
   int  fhost=0;
   int  dns=0;
   int  fuser=0;
   int  dfrom=0; 
   int  duntil=0;
   int  idata=0;
   int  narq=0;
   int  iarq=0;
   long totregsl=0; 
   long totregsg=0;
   long totregsx=0;
   long totper=0;
   long int  max_elapsed=0;
   time_t tt;
   struct tm *t;
   unsigned long nreg=0;
   off_t recs1=0;
   unsigned long recs2=0;

   BgImage[0]='\0';
   LogoImage[0]='\0';
   LogoText[0]='\0';
   FontFace[0]='\0';
   PasswdFile[0]='\0';
   OutputEmail[0]='\0';
   Ip2Name[0]='\0';
   UserAgentLog[0]='\0';
   ExcludeHosts[0]='\0';
   ExcludeUsers[0]='\0';
   ConfigFile[0]='\0';
   code[0]='\0';
   LastLog[0]='\0';
   UserIp[0]='\0';
   MaxElapsed[0]='\0';
   ReportType[0]='\0';
   UserTabFile[0]='\0';

   strcpy(AccessLog,"/usr/local/squid/logs/access.log");
   sprintf(ExcludeCodes,"%s/exclude_codes",SYSCONFDIR);
   strcpy(BgColor,"white");
   strcpy(TxColor,"black");
   strcpy(TxBgColor,"beige");
   strcpy(TiColor,"green");
   strcpy(Width,"80");
   strcpy(Height,"45");
   strcpy(LogoTextColor,"black");
   strcpy(HeaderColor,"darkblue");
   strcpy(HeaderBgColor,"blanchedalmond");
   strcpy(FontSize,"-1");
   strcpy(TempDir,"/tmp");
   strcpy(OutputDir,"/usr/local/etc/httpd/htdocs/squid-reports");
   strcpy(Ip2Name,"no");
   strcpy(DateFormat,"u");
   strcpy(OverwriteReport,"no");
   strcpy(RemoveTempFiles,"yes");
   strcpy(ReplaceIndex,"index.html");
   strcpy(Index,"yes");
   strcpy(RecordsWithoutUser,"ip");
   strcpy(UseComma,"no");
   strcpy(MailUtility,"mailx");
   strcpy(TopSitesNum,"100");
   strcpy(UserIp,"no");
   strcpy(TopuserSortField,"BYTES");
   strcpy(UserSortField,"BYTES");
   strcpy(TopuserSortOrder,"reverse");
   strcpy(UserSortOrder,"reverse");
   strcpy(TopsitesSortField,"CONNECT");
   strcpy(TopsitesSortType,"D");
   strcpy(LongUrl,"no");
   strcpy(language,"English");
   strcpy(datetimeby,"bytes");
   strcpy(CharSet,"ISO-8859-1");
   strcpy(Privacy,"no");
   strcpy(PrivacyString,"***.***.***.***");
   strcpy(PrivacyStringColor,"blue");
   strcpy(SuccessfulMsg,"yes");
   strcpy(TopUserFields,"NUM DATE_TIME USERID CONNECT BYTES %BYTES IN-CACHE-OUT USED_TIME MILISEC %TIME TOTAL AVERAGE");
   strcpy(DataFileDelimiter,";");
   strcpy(DataFileFields,"user;date;time;url;connect;bytes;in_cache;out_cache;elapsed");

   dia[0]='\0';
   mes[0]='\0';
   ano[0]='\0';
   hora[0]='\0';
   tmp[0]='\0';
   tmp2[0]='\0';
   tmp3[0]='\0';
   wtemp[0]='\0';
   wtemp2[0]='\0';
   us[0]='\0';
   date[0]='\0';
   df[0]='\0';
   uagent[0]='\0';
   hexclude[0]='\0';
   addr[0]='\0';
   hm[0]='\0';
   site[0]='\0';
   outdir[0]='\0';
   elap[0]='\0';
   email[0]='\0';
   zip[0]='\0';
   UserInvalidChar[0]='\0';
   DataFile[0]='\0';
   excode=0;
   denied_count=0;
   authfail_count=0;

   bzero(IncludeUsers, MAXLEN);
   bzero(ExcludeString, MAXLEN);

   for(x=0; x<=254; x++) 
      warq[x][0]='\0';

   language_load(language);
   strcpy(Title,text[88]);

   while((ch = getopt(argc, argv, "a:b:c:d:e:f:g:u:l:o:r:s:t:w:hijmnpxz")) != -1){
      switch(ch)
      {
         case 'a':
            strcpy(addr,optarg);
            break;
         case 'b':
            strcpy(uagent,optarg);
            break;
         case 'c':
            strcpy(hexclude,optarg);
            break;
         case 'd':
            strcpy(date,optarg);
            strcpy(cduntil,optarg);
            getword(cdfrom,cduntil,'-');
            date_from(date, cdfrom, cduntil);
            dfrom=atoi(cdfrom);
            duntil=atoi(cduntil);
            break;
         case 'e':
            strcpy(email,optarg);
            break;
         case 'f':
            strcpy(ConfigFile,optarg);
            break;
         case 'g':
            strcpy(df,optarg);
            break;
   	 case 'h':
  	    usage(argv[0]);
            exit(0);
 	    break;
         case 'i':
            iprel++;
            break;
         case 'l':
            strcpy(warq[narq],optarg);
            narq++;
            break;
         case 'm':
            debugm++;
            break;
         case 'n':
            dns++;
            break;
         case 'o':
            strcpy(outdir,optarg);
            break;
         case 'p':
            userip++;
            break;
         case 's':
            strcpy(site,optarg);
            break;
         case 't':
            strcpy(hm,optarg);
            break;
         case 'u':
            strcpy(us,optarg);
            break;
         case 'w':
            strcpy(tmp,optarg);
            break;
         case 'x':
            debug++;
            break;
         case 'z':
            debugz++;
            break;
         case ':':
	    fprintf(stderr, "Option -%c require an argument\n",optopt);
	    errflg++;
	    break;
         case '?':
            usage(argv[0]);
            exit(1);
            break;
      }

   }

   if (errflg) {
      usage(argv[0]);
      exit(2);
   }

   if(debug)
      debuga("Init");

   if(ConfigFile[0] == '\0')
      sprintf(ConfigFile,"%s/sarg.conf",SYSCONFDIR);
    else {
      if(access(ConfigFile, R_OK) != 0) {
         sprintf(msg,"Cannot open config file: %s",ConfigFile);
         debuga(msg);
         exit(1);
      }
   }
    
   if(access(ConfigFile, R_OK) == 0)
      getconf(debugm, ConfigFile, AccessLog, debug, BgColor, TxColor, TxBgColor, TiColor, LogoImage, LogoText, LogoTextColor, Width, Height, Title, BgImage, FontFace, HeaderColor, HeaderBgColor, FontSize, PasswdFile, TempDir, OutputDir, OutputEmail, Ip2Name, TopuserSortField, UserSortField, TopuserSortOrder, UserSortOrder, UserAgentLog, ExcludeHosts, DateFormat, ExcludeUsers, PerUserLimitFile, PerUserLimit, UserIp, MaxElapsed);

   if(debugz) {
      fprintf(stderr, "SARG: ConfigFile.........= %s\n",ConfigFile);
      fprintf(stderr, "SARG: AccessLog..........= %s\n",AccessLog);
      fprintf(stderr, "SARG: BgColor............= %s\n",BgColor);
      fprintf(stderr, "SARG: TxColor............= %s\n",TxColor);
      fprintf(stderr, "SARG: TxBgColor..........= %s\n",TxBgColor);
      fprintf(stderr, "SARG: TiColor............= %s\n",TiColor);
      fprintf(stderr, "SARG: LogoImage..........= %s\n",LogoImage);
      fprintf(stderr, "SARG: LogoText...........= %s\n",LogoText);
      fprintf(stderr, "SARG: LogoTextColor......= %s\n",LogoTextColor);
      fprintf(stderr, "SARG: Width..............= %s\n",Width);
      fprintf(stderr, "SARG: Height.............= %s\n",Height);
      fprintf(stderr, "SARG: Title..............= %s\n",Title);
      fprintf(stderr, "SARG: BgImage............= %s\n",BgImage);
      fprintf(stderr, "SARG: FontFace...........= %s\n",FontFace);
      fprintf(stderr, "SARG: HeaderColor........= %s\n",HeaderColor);
      fprintf(stderr, "SARG: HeaderBgColor......= %s\n",HeaderBgColor);
      fprintf(stderr, "SARG: FontSize...........= %s\n",FontSize);
      fprintf(stderr, "SARG: PasswdFile.........= %s\n",PasswdFile);
      fprintf(stderr, "SARG: TempDir............= %s\n",TempDir);
      fprintf(stderr, "SARG: OutputDir..........= %s\n",OutputDir);
      fprintf(stderr, "SARG: Ip2Name............= %s\n",Ip2Name);
      fprintf(stderr, "SARG: TopuserSortField.........= %s\n",TopuserSortField);
      fprintf(stderr, "SARG: UserSortField.........= %s\n",UserSortField);
      fprintf(stderr, "SARG: TopuserSortOrder.........= %s\n",TopuserSortOrder);
      fprintf(stderr, "SARG: UserSortOrder.........= %s\n",UserSortOrder);
      fprintf(stderr, "SARG: UserAgentLog.......= %s\n",UserAgentLog);
      fprintf(stderr, "SARG: ExcludeHosts.......= %s\n",ExcludeHosts);
      fprintf(stderr, "SARG: DateFormat.........= %s\n",DateFormat);
      fprintf(stderr, "SARG: ExcludeUsers.......= %s\n",ExcludeUsers);
      fprintf(stderr, "SARG: PerUserLimitFile...= %s\n",PerUserLimitFile);
      fprintf(stderr, "SARG: PerUserLimit.......= %s\n",PerUserLimit);
      fprintf(stderr, "SARG: UserIp.............= %s\n",UserIp);
      fprintf(stderr, "SARG: MaxElapsed.........= %s\n",MaxElapsed);
      fprintf(stderr, "SARG: LastLog............= %s\n",LastLog);
      fprintf(stderr, "SARG:\n");
   }


   dataonly=0;
   if(DataFile[0] != '\0');
      dataonly++;
   
   str2=(char *)subs(TopUserFields,"%BYTES","SETYB");
   strcpy(TopUserFields,str2);

   if(!narq) {
      strcpy(warq[0],AccessLog);
      narq++;
   }

   if(strcmp(hexclude,"onvert") == 0 && strcmp(site,"plit") != 0) {
      convlog(warq[0], df, dfrom, duntil);
      exit(0);
   }
   
   if(strcmp(site,"plit") == 0) {
      splitlog(warq[0], df, dfrom, duntil, hexclude);
      exit(0);
   }

   if(ExcludeCodes[0] != '\0') {
      if((excludecode=(char *) malloc(1024))==NULL) {
         fprintf(stderr, "SARG: %s (1024):\n",text[59]);
         exit(1);
      }
      bzero(excludecode,1024);
      load_excludecodes();
   }

   if(access(PasswdFile, R_OK) == 0) {
      getusers(PasswdFile,debug);
      puser++;
   }

   if(hexclude[0] == '\0')
      strcpy(hexclude,ExcludeHosts);
   if(access(hexclude, R_OK) == 0) {
      gethexclude(hexclude,debug);
      fhost++;
   }

   if(ReportType[0] == '\0')
      strcpy(ReportType,"topsites users_sites sites_users date_time denied auth_failures site_user_time_date");

   if(access(ExcludeUsers, R_OK) == 0) {
      getuexclude(ExcludeUsers,debug);
      fuser++;
   }

   indexonly=0;
   if(fuser) {
      if(strstr(excludeuser,"indexonly") != 0)
         indexonly++;
   }
   if(strcmp(ExcludeUsers,"indexonly") == 0)
      indexonly++;
   if(strcmp(Index,"only") == 0)
      indexonly++;

   if(dns)
      strcpy(Ip2Name,"yes");

   if(strcmp(UserIp,"yes") == 0)
      userip++;

   if(strcmp(UserIp,"yes") == 0)
      userip++;

   if(strlen(MaxElapsed)>1)
      max_elapsed=atol(MaxElapsed);

   if(strlen(outdir)<1)
      strcpy(outdir,OutputDir);
   strcat(outdir,"/");


   if(arq[0] == '\0')
      strcpy(arq,AccessLog);

   if(uagent[0] == '\0')
      strcpy(uagent,UserAgentLog);

   if(tmp[0] == '\0')
     strcpy(tmp,TempDir);
    else
     strcpy(TempDir,tmp);

   if(df[0] == '\0')
      strcpy(df,DateFormat);
    else
      strcpy(DateFormat,df);

   if(df[0] == '\0') {
      strcpy(df,"u");
      strcpy(DateFormat,"u");
   }

   if(strlen(email)<1){
      if(strlen(OutputEmail)>0)
         strcpy(email,OutputEmail);
   }

   strcpy(tmp2,tmp);
   strcpy(tmp4,tmp);
   strcpy(tmp5,tmp);
   strcpy(tmp6,tmp);

   if(strlen(email) > 0) {
      sprintf(wtemp2, MKDIR" -p %s/sarg_tmp",tmp2);
      system(wtemp2);
      strcat(tmp2,"/sarg_tmp");
      strcpy(outdir,tmp2);
      strcat(outdir,"/");
    }

   strcat(tmp2,"/sarg.log");

   strcpy(tmp3,tmp2);
   strcat(tmp3,".unsort");
   strcat(tmp4,"/denied.log.unsort");
   strcat(tmp5,"/denied.log");
   strcat(tmp6,"/authfail.log.unsort");

   if(debug) {
      fprintf(stderr, "SARG: %s:\nSARG:\n",text[22]);
      fprintf(stderr, "SARG: %35s (-a) = %s\n",text[23],addr);
      fprintf(stderr, "SARG: %35s (-b) = %s\n",text[71],uagent);
      fprintf(stderr, "SARG: %35s (-c) = %s\n",text[69],hexclude);
      fprintf(stderr, "SARG: %35s (-d) = %s\n",text[24],date);
      fprintf(stderr, "SARG: %35s (-e) = %s\n",text[41],email);
      fprintf(stderr, "SARG: %35s (-f) = %s\n",text[70],ConfigFile);
      if(strcmp(df,"e") == 0)
         fprintf(stderr, "SARG: %35s (-g) = %s (dd/mm/yyyy)\n",text[25],text[26]);
      if(strcmp(df,"u") == 0)
         fprintf(stderr, "SARG: %35s (-g) = %s (mm/dd/yyyy)\n",text[25],text[27]);
      if(strcmp(df,"w") == 0)
         fprintf(stderr, "SARG: %35s (-g) = %s (yyyy/ww)\n",text[25],text[85]);
      if(iprel)
         fprintf(stderr, "SARG: %35s (-i) = %s\n",text[28],text[1]);
       else
         fprintf(stderr, "SARG: %35s (-i) = %s\n",text[28],text[2]);
      fprintf(stderr, "SARG: %35s (-l) = %s\n",text[37],arq);
      if(strcmp(Ip2Name,"yes") == 0)
         fprintf(stderr, "SARG: %35s (-n) = %s\n",text[65],text[1]);
       else
         fprintf(stderr, "SARG: %35s (-n) = %s\n",text[65],text[2]);
      fprintf(stderr, "SARG: %35s (-o) = %s\n",text[38],outdir);
      if(strcmp(UserIp,"yes") == 0)
         fprintf(stderr, "SARG: %35s (-p) = %s\n",text[29],text[1]);
       else
         fprintf(stderr, "SARG: %35s (-p) = %s\n",text[29],text[2]);
      fprintf(stderr, "SARG: %35s (-s) = %s\n",text[30],site);
      fprintf(stderr, "SARG: %35s (-t) = %s\n",text[31],hm);
      fprintf(stderr, "SARG: %35s (-u) = %s\n",text[32],us);
      fprintf(stderr, "SARG: %35s (-w) = %s\n",text[34],tmp);
      if(debug)
         fprintf(stderr, "SARG: %35s (-x) = %s\n",text[35],text[1]);
       else
         fprintf(stderr, "SARG: %35s (-x) = %s\n",text[35],text[2]);
      if(debugz)
         fprintf(stderr, "SARG: %35s (-z) = %s\n",text[36],text[1]);
       else
         fprintf(stderr, "SARG: %35s (-z) = %s\n",text[36],text[2]);
      fprintf(stderr, "SARG:\n");
   }

   if(debugm) {
      printf("%s:\nSARG:\n",text[22]);
      printf("%35s (-a) = %s\n",text[23],addr);
      printf("%35s (-b) = %s\n",text[71],uagent);
      printf("%35s (-c) = %s\n",text[69],hexclude);
      printf("%35s (-d) = %s\n",text[24],date);
      printf("%35s (-e) = %s\n",text[41],email);
      printf("%35s (-f) = %s\n",text[70],ConfigFile);
      if(strcmp(df,"e") == 0)
         printf("%35s (-g) = %s (dd/mm/yyyy)\n",text[25],text[26]);
      if(strcmp(df,"u") == 0)
         printf("%35s (-g) = %s (mm/dd/yyyy)\n",text[25],text[27]);
      if(strcmp(df,"w") == 0)
         printf("%35s (-g) = %s (yyyy/ww)\n",text[25],text[85]);
      if(iprel)
         printf("%35s (-i) = %s\n",text[28],text[1]);
       else
         printf("%35s (-i) = %s\n",text[28],text[2]);
      printf("%35s (-l) = %s\n",text[37],arq);
      if(strcmp(Ip2Name,"yes") == 0)
         printf("%35s (-n) = %s\n",text[65],text[1]);
       else
         printf("%35s (-n) = %s\n",text[65],text[2]);
      printf("%35s (-o) = %s\n",text[38],outdir);
      if(strcmp(UserIp,"yes") == 0)
         printf("%35s (-p) = %s\n",text[29],text[1]);
       else
         printf("%35s (-p) = %s\n",text[29],text[2]);
      printf("%35s (-s) = %s\n",text[30],site);
      printf("%35s (-t) = %s\n",text[31],hm);
      printf("%35s (-u) = %s\n",text[32],us);
      printf("%35s (-w) = %s\n",text[34],tmp);
      if(debug)
         printf("%35s (-x) = %s\n",text[35],text[1]);
       else
         printf("%35s (-x) = %s\n",text[35],text[2]);
      if(debugz)
         printf("%35s (-z) = %s\n",text[36],text[1]);
       else
         printf("%35s (-z) = %s\n",text[36],text[2]);
      printf("sarg %s: %s\n",text[73],VERSION);
      printf("Language=%s\n\n",text[3]);
   }

   if(debug){
      sprintf(msg,"sarg %s: %s",text[73],VERSION);
      debuga(msg);
   }

   if(UserTabFile[0] != '\0') {
      if(debug){
         sprintf(msg,"%s: %s",text[86],UserTabFile);
         debuga(msg);
      }
      if((fp_usr=fopen(UserTabFile,"r"))==NULL) {
        fprintf(stderr, "%s: (log) %s: %s\n",argv[0],text[45],UserTabFile);
        exit(1);
      }
      nreg = lseek(fileno(fp_usr), 0, SEEK_END);
      lseek(fileno(fp_usr), 0, 0);
      if((userfile=(char *) malloc(nreg+100))==NULL){
         fprintf(stderr, "%s ERROR: %s",argv[0],text[87]);
         exit(1);
      }
      bzero(userfile,nreg+100);
      strncat(userfile,":",1);
      z1=0;
      z2=1;
      while(fgets(buf,MAXLEN,fp_usr)!=NULL){
        buf[strlen(buf)-1]='\0';
        if(strstr(buf,"\r") != 0)
           buf[strlen(buf)-1]='\0';
        getword(bufy,buf,' ');
        for(z1=0; z1<=strlen(bufy); z1++) {
           userfile[z2]=bufy[z1];
           z2++;
        }
        strncat(userfile,":",1);
        for(z1=0; z1<=strlen(buf); z1++) {
           userfile[z2]=buf[z1];
           z2++;
        }
        strncat(userfile,":",1);
      }
      fclose(fp_usr);
   }

   if((fp_ou=fopen(tmp3,"w"))==NULL) {
     fprintf(stderr, "%s: (log) %s: %s\n",argv[0],text[9],tmp3);
     exit(1);
   }

   while(narq--) {
      strcpy(arq,warq[iarq]);
      iarq++;  

   decomp(arq,zip);
   if(debug) {
      sprintf(msg, "%s: %s",text[7],arq);
      debuga(msg);
   }

   if((fp_in=fopen(arq,"r"))==NULL) {
     fprintf(stderr, "%s: (log) %s: %s\n",argv[0],text[8],arq);
     exit(1);
   }

   if(strstr(ReportType,"denied") != 0) {
      if((fp_denied=fopen(tmp4,"w"))==NULL) {
         fprintf(stderr, "%s: (log) %s: %s\n",argv[0],text[45],tmp4);
         exit(1);
      }
   }

   if(DataFile[0]=='\0') {
      if(strstr(ReportType,"denied") != 0 || strstr(ReportType,"auth_failures") != 0) {
         if((fp_authfail=fopen(tmp6,"w"))==NULL) {
            fprintf(stderr, "%s: (log) %s: %s\n",argv[0],text[45],tmp6);
            exit(1);
         }
      }
   }

   if(debug) {
      recs1=0;
      while(fgets(bufz,sizeof(bufz),fp_in)!=NULL)
         recs1++;
      lseek(fileno(fp_in), 0, 0);
   }
   
   while(fgets(bufz,sizeof(bufz),fp_in)!=NULL) {
	recs2++;
	if(debug) 
	   printf("SARG: Records in file=%d Reading=%d Rest=%d \r",recs1,recs2,recs1-recs2);
        if(!bufz[0]) continue;
        if(strstr(bufz,"HTTP/0.0") != 0) continue;
        if(strstr(bufz,"logfile turned over") != 0) continue;
        if(bufz[0] == ' ') continue;
        if(strlen(bufz) < 58) continue;

	// Record only hours usage which is required
	tt = (time_t) strtoul( bufz, NULL, 10 );
	t = localtime( &tt );

	if( bsearch( &( t -> tm_wday ), weekdays.list, weekdays.len,
					sizeof( int ), compar ) == NULL )
	  continue;

	if( bsearch( &( t -> tm_hour ), hours.list, hours.len,
					sizeof( int ), compar ) == NULL )
	  continue;

	// exclude_string
	if(strlen(ExcludeString) > 0) {
	   strcpy(warea,bufz);
	   strcpy(html,ExcludeString);
	   while(strstr(html,":") != 0) {
              getword(val1,html,':');
              if((str=(char *) strstr(warea,val1)) != (char *) NULL )
	         continue;;
	   }
           if((str=(char *) strstr(warea,html)) != (char *) NULL )
	         continue;;
	}
        
        strcpy(bufy,bufz);
        if ((str = strchr(bufz, '\n')) != NULL)
           *str = '\0';          /* strip \n */       

        totregsl++;
        common=0;
        if(debugm)
       	   printf("BUF=%s\n",bufz);

	getword(data,bufz,' ');
        if((str=(char *) strstr(data, ".")) != (char *) NULL ) {
           if((str=(char *) strstr(str+1, ".")) != (char *) NULL ) {
	      strcpy(ip,data);
	      strcpy(elap,"0");
	      getword(user,bufz,' ');
	      getword(none,bufz,' ');
	      getword(data,bufz,']');
	      getword(fun,bufz,'"');
	      getword(fun,bufz,' ');
	      getword(url,bufz,'"');
              getword(code2,bufz,' ');
              getword(code2,bufz,' ');
              getword(tam,bufz,' ');
              strcpy(code,bufz);

              if ((str = strchr(code, ':')) != NULL)
                 *str = '/'; 

	      if(strcmp(tam,"\0") == 0)
	         strcpy(tam,"0");

	      common++;
	      common_log=1;
	   }
	}

	if(!common) {
	      getword(elap,bufz,' ');
	      while(strcmp(elap,"") == 0)
	         getword(elap,bufz,' ');
	      getword(ip,bufz,' ');
	      getword(code,bufz,' ');
	      getword(tam,bufz,' ');
	      getword(fun,bufz,' ');
	      getword(url,bufz,' ');
	      getword(user,bufz,' ');
	      squid_log=1;
	}

	// include_users
	if(strlen(IncludeUsers) > 0) {
           sprintf(val1,":%s:",user);
           if((str=(char *) strstr(IncludeUsers,val1)) == (char *) NULL )
              continue;
	}

        if(excode) {
           if(vercode(code)) {
              totregsx++;
              continue;
           }
        }

        if(testvaliduserchar(user))
	   continue;

        if(strstr(user,"%5c") != 0) {
           getword(w,user,'%');
           strcpy(wuser,user+2);
           sprintf(user,"%s.%s",w,wuser);
        }

	z1=0;
	z2=0;
	str=user;
	for(z1=0; z1<=strlen(str); z1++) {
	   if(isalnum(str[z1]) || ispunct(str[z1])) {
	      if(str[z1]=='/')
	         str[z1]='_';
	      if(str[z1]=='\\')
	         str[z1]='_';
	      if(str[z1]==';')
	         str[z1]='_';
	      user[z2]=str[z1];
	      z2++;
	   }
	}

        strlow(user);

        if(strstr(ReportType,"denied") != 0)
           strcpy(urly,url);

        if (strchr(url,'/')) {
           getword(w,url,'/');
           getword(w,url,'/');
        }

        if(strcmp(LongUrl,"no") == 0) {
           getword(w,url,'/');
           strcpy(url,w);
        }

        if(!common) {
           tt=atoi(data);
           t=localtime(&tt);

           if(strncmp(df,"u",1) == 0)
	      strftime(tbuf, 127, "%Y%b%d", t);
           if(strncmp(df,"e",1) == 0)
	      strftime(tbuf, 127, "%d%b%Y", t);
           if(strncmp(df,"w",1) == 0)
	      strftime(tbuf, 127, "%Y.%U", t);

           strftime(dia, 127, "%d/%m/%Y", t);
           strftime(wdata, 127, "%Y%m%d", t);
          
           idata=atoi(wdata);

           if(strncmp(df,"u",1)==0)
              strftime(dia, 127, "%m/%d/%Y", t);
           sprintf(hora,"%02d:%02d:%02d",t->tm_hour,t->tm_min,t->tm_sec);
	 } else {
	   strcpy(wtemp,data+1);
	   getword(data,wtemp,':');
	   getword(hora,wtemp,' ');
	   getword(dia,data,'/');
	   getword(mes,data,'/');
	   getword(ano,data,'/');

           if(strcmp(df,"u") == 0)
	      sprintf(tbuf,"%s%s%s",ano,mes,dia);
           if(strcmp(df,"e") == 0)
	      sprintf(tbuf,"%s%s%s",dia,mes,ano);
	   builddia(dia,mes,ano,df,wdata);
           idata=atoi(wdata);
	}

        if(debugm)
           printf("DATE=%s IDATA=%d DFROM=%d DUNTIL=%d\n",date,idata,dfrom,duntil);

        l=1;
        if(strlen(us)>0){
  	   if(strcmp(user,us)==0)
	      l=1;else l=0;
 	}
           
        if(l){
           if(strlen(addr)>0){
  	      if(strcmp(addr,ip)==0)
	         l=1;else l=0;
 	   }
           if(fhost) {
              l=vhexclude(excludefile,ip);
              l=vhexclude(excludefile,url);
              if(!l)
	         totregsx++;
           }
        }

        if(l){
           if(strlen(date) > 0){
              if(idata >= dfrom && idata <= duntil)
	         l=1;else l=0;
 	   }
        }
        if(l){
           if(strlen(hm)>0){
  	      if(strncmp(hm,hora,strlen(hm))==0)
	         l=1;else l=0;
 	   }
        }
        if(l){
           if(strlen(site)>0){
  	      if(strstr(url,site)!=0)
	         l=1;else l=0;
 	   }
        }

        if(userip)
           strcpy(user,ip);

        if(strcmp(user,"-") == 0 || strcmp(user," ") == 0 || strcmp(user,"") == 0) {
           if(strcmp(RecordsWithoutUser,"ip") == 0)
	      strcpy(user,ip);
           if(strcmp(RecordsWithoutUser,"ignore") == 0)
	      continue;
           if(strcmp(RecordsWithoutUser,"everybody") == 0)
	      strcpy(user,"everybody");
        }

        if(puser) {
           sprintf(wuser,":%s:",user);
           if(strstr(userfile, wuser) == 0)
              continue;
        }
        
        if(l) {
           if(fuser) {
              l=vuexclude(excludeuser,user);
              if(!l)
	         totregsx++;
           }
        }

        if(l) {
           if(userip)
              fixip(user);
        }

        if(l&&max_elapsed) {
           if(atol(elap)>max_elapsed) {
              elap[0]='0';
              elap[1]='\0';
	    }
        }

        if(l) {
	   if(strcmp(user,"-") !=0 && strlen(url) > 0 && strcmp(user," ") !=0 && strcmp(user,"") !=0 && strcmp(user,":") !=0){
              if((str=(char *) strstr(bufz, "[SmartFilter:")) != (char *) NULL ) {
                 str[strlen(str)-1]='\0';
                 sprintf(smartfilter,"\"%s\"",str+1);
              } else sprintf(smartfilter,"\"\"");

              sprintf(bufz, "%s %s %s %s %s %s %s %s %s\n",dia,hora,user,ip,url,tam,code,elap,smartfilter);
              fputs(bufz,fp_ou);
	      totregsg++;

              if(strstr(ReportType,"denied") != 0 || strstr(ReportType,"auth_failures") != 0) {
                 if(strstr(code,"DENIED/403") != 0) {
                    sprintf(bufz, "%s %s %s %s %s\n",dia,hora,user,ip,urly);
                    fputs(bufz,fp_denied);
                    denied_count++;
                 }
                 if(strstr(code,"DENIED/401") != 0 || strstr(code,"DENIED/407") != 0) {
                    sprintf(bufz, "%s %s %s %s %s\n",dia,hora,user,ip,urly);
                    if(fp_authfail)
                       fputs(bufz,fp_authfail);
                    authfail_count++;
                 }
              }
       
              if(!totper){
	         totper++;
                 sprintf(periodo,"%s-",tbuf);
                 if(strlen(date)>0)
                    fixper(tbuf, periodo, cduntil);
                 if(debugz){
                    debugaz("tbuf",tbuf);
                    debugaz("periodo",periodo);
                 }
	      }
           }

           if(debugm){
              printf("IP=\t%s\n",ip);
              printf("USER=\t%s\n",user);
              printf("ELAP=\t%s\n",elap);
              printf("DATE=\t%s\n",dia);
              printf("TIME=\t%s\n",hora);
              printf("FUNC=\t%s\n",fun);
              printf("URL=\t%s\n",url);
              printf("CODE=\t%s\n",code);
              printf("LEN=\t%s\n",tam);
	   }
        }
      }
   }

   if(debug) {
      printf("\n");
      sprintf(msg, "   %s: %ld, %s: %ld, %s: %ld",text[10],totregsl,text[11],totregsg,text[68],totregsx);
      debuga(msg);
  
      if((common_log) && (squid_log))
         debuga(text[12]);
  
      if((common_log) && (!squid_log)) 
         debuga(text[13]);
 
      if((!common_log) && (squid_log))
         debuga(text[14]);
 
      if((!common_log) && (!squid_log)) {
         if(!totregsg){
            fprintf(stderr, "SARG: %s\n",text[16]);
            fprintf(stderr, "SARG: %s\n",text[21]);
	 } else fprintf(stderr, "---->SARG: %s\n",text[15]);
         bzero(msg,sizeof(msg));
         fclose(fp_in);
         fclose(fp_ou);
         if(fp_denied)
            fclose(fp_denied);
         if(fp_authfail)
            fclose(fp_authfail);
         if(*tmp4)
            unlink(tmp4);
         if(*tmp6)
            unlink(tmp6);
         unlink(tmp3);
         exit(0);
      }
   }
 
   if(!totregsg){
      fprintf(stderr, "SARG: %s\n",text[16]);
      fprintf(stderr, "SARG: %s\n",text[21]);
      fclose(fp_in);
      fclose(fp_ou);
      if(fp_denied)
         fclose(fp_denied);
      if(fp_authfail)
         fclose(fp_authfail);
      exit(0);
   }

   if(date[0] == '\0')
      strcat(periodo,tbuf);

   if(debugz){
      debugaz("data",dia);
      debugaz("tbuf",tbuf);
      debugaz("periodo",periodo);
   }

   if(debug){
     sprintf(msg, "%s: %s",text[17],periodo);
     debuga(msg);
   }

   fclose(fp_in);
   fclose(fp_ou);
   if(fp_denied)
      fclose(fp_denied);
   if(fp_authfail)
      fclose(fp_authfail);

   if(debug){
     sprintf(msg,"Sort: %s %s %s",text[18],tmp,text[19]);
     debuga(msg);
     sprintf(msg, "%s: %s",text[20],tmp2);
     debuga(msg);
   }

   sprintf(csort, SORT" -T %s -k 3,3 -k 5,5 -o %s %s", tmp, tmp2, tmp3);
   system(csort);
   unlink(tmp3);

   if(strstr(ReportType,"denied") != 0) {
      sprintf(csort, SORT" -T %s -k 3,3 -k 5,5 -o %s %s", tmp, tmp5, tmp4);
      system(csort);
      unlink(tmp4);
   }

   if(strlen(DataFile) > 0)
      data_file(tmp2,debug,periodo,debugz,iprel,outdir,addr,site,us,userip,email,wtemp2,BgColor,TxColor, TxBgColor,TiColor,LogoImage,LogoText,LogoTextColor,Width,Height,Title,BgImage,FontFace,HeaderColor,HeaderBgColor,FontSize,TempDir,Ip2Name,TopuserSortField,UserSortField,TopuserSortOrder,UserSortOrder,uagent,DateFormat,indexonly,PerUserLimitFile,PerUserLimit);
   else
      gerarel(tmp2,debug,periodo,debugz,iprel,outdir,addr,site,us,userip,email,wtemp2,BgColor,TxColor, TxBgColor,TiColor,LogoImage,LogoText,LogoTextColor,Width,Height,Title,BgImage,FontFace,HeaderColor,HeaderBgColor,FontSize,TempDir,Ip2Name,TopuserSortField,UserSortField,TopuserSortOrder,UserSortOrder,uagent,DateFormat,indexonly,PerUserLimitFile,PerUserLimit);

   unlink(tmp2);
   if(strstr(ReportType,"denied") != 0)
      unlink(tmp5);
 
   if(strlen(zip) > 0)
      recomp(arq, zip);

   if(debug)
      debuga(text[21]);

   exit(0);

}


void getusers(char *pwdfile, int debug)
{

   FILE *fp_usr;
   char buf[255];
   char Msg[255];
   char user[255];
   unsigned long int nreg=0;

   if(debug) {
      sprintf(Msg,"%s: %s",text[60],pwdfile);
      debuga(Msg);
   }

   if ((fp_usr = fopen(pwdfile, "r")) == NULL) {
      fprintf(stderr, "SARG: (getusers) %s: %s\n",text[45],pwdfile);
      exit(1);
   }

   nreg = lseek(fileno(fp_usr), (off_t)0, SEEK_END);
   nreg = nreg+5000; 
   lseek(fileno(fp_usr), (off_t)0, 0);

   if((userfile=(char *) malloc(nreg))==NULL){
      fprintf(stderr, "SARG: %s (%ld):\n",text[59],nreg);
      exit(1);
   }

   bzero(userfile,nreg);
   sprintf(userfile,":");

   while(fgets(buf,300,fp_usr)!=NULL){
     getword(user,buf,':');
     strncat(userfile,user,strlen(user));
     strncat(userfile,":",1);
   }

   fclose(fp_usr);

   return;
}


void gethexclude(char *hexfile, int debug)
{

   FILE *fp_ex;
   char buf[255];
   char Msg[255];
   unsigned long int nreg=0;

   if(debug) {
      sprintf(Msg,"%s: %s",text[67],hexfile);
      debuga(Msg);
   }

   if ((fp_ex = fopen(hexfile, "r")) == NULL) {
      fprintf(stderr, "SARG: (gethexclude) %s: %s\n",text[45],hexfile);
      exit(1);
   }

   nreg = lseek(fileno(fp_ex), (off_t)0, SEEK_END);
   lseek(fileno(fp_ex), (off_t)0, 0);

   if((excludefile=(char *) malloc(nreg+11))==NULL){
      fprintf(stderr, "SARG: %s (%ld):\n",text[59],nreg);
      exit(1);
   }

   bzero(excludefile,nreg+11);

   while(fgets(buf,300,fp_ex)!=NULL){
     if(strstr(buf,"#") != 0)
        continue;
     buf[strlen(buf)-1]='\0';
     strcat(excludefile,buf);
     strcat(excludefile," ");
   }

   strcat(excludefile,"*FIM* ");

   fclose(fp_ex);

   return;
}


void getuexclude(char *uexfile, int debug)
{

   FILE *fp_ex;
   char buf[255];
   char Msg[255];
   unsigned long int nreg=0;

   if(debug) {
      sprintf(Msg,"%s: %s",text[67],uexfile);
      debuga(Msg);
   }

   if ((fp_ex = fopen(uexfile, "r")) == NULL) {
      fprintf(stderr, "SARG: (gethexclude) %s: %s\n",text[45],uexfile);
      exit(1);
   }

   nreg = lseek(fileno(fp_ex), (off_t)0, SEEK_END);
   lseek(fileno(fp_ex), (off_t)0, 0);

   if((excludeuser=(char *) malloc(nreg+11))==NULL){
      fprintf(stderr, "SARG: %s (%ld):\n",text[59],nreg);
      exit(1);
   }

   bzero(excludeuser,nreg+11);

   while(fgets(buf,300,fp_ex)!=NULL){
     if(strstr(buf,"#") != 0)
        continue;
     buf[strlen(buf)-1]='\0';
     strcat(excludeuser,buf);
     strcat(excludeuser," ");
   }

   strcat(excludeuser,"*FIM* ");

   fclose(fp_ex);

   return;
}
