/*
 * sarg - Squid user management log
 * Mar/98 - Pedro L Orso - orso@onda.com.br
 */

#include "include/conf.h"

void mklastlog(char *outdir, int debug)
{

   FILE *fp_in, *fp_ou;
   DIR *dirp;
   struct dirent *direntp;
   char temp[MAXLEN];
   char warea[MAXLEN];
   char ftime[128];
   int  ftot=0;
   time_t t;
   struct tm *local;
   struct stat statb;

   if(strcmp(LastLog,"0") == 0)
      return;

   sprintf(temp,"%slastlog1",outdir);
   if((fp_ou=fopen(temp,"w"))==NULL) {
     fprintf(stderr, "SARG: (lastlog) %s: %s\n",text[9],temp);        
     exit(1);
   }

   dirp = opendir(outdir);
   while ((direntp = readdir( dirp )) != NULL ){
      if(strstr(direntp->d_name,"-") == 0)
         continue;

      sprintf(warea,"%s%s",outdir,direntp->d_name);
      stat(warea,&statb);
      t=statb.st_ctime;
      local = localtime(&t);
      strftime(ftime, 127, "%Y%m%d%H%M%S", local);
      sprintf(buf,"%s %s\n",ftime,direntp->d_name);
      fputs(buf,fp_ou);
      ftot++;
   }

   (void)closedir( dirp );
   fclose(fp_ou);
   
   sprintf(buf, SORT" -n -k 1,1 -o %slastlog %s",outdir,temp);
   system(buf);

   unlink(temp);

   if(ftot<=atoi(LastLog)) {
      sprintf(temp,"%slastlog",outdir);
      if(access(temp, R_OK) == 0)
         unlink(temp);
      return;
   }

   ftot-=atoi(LastLog);

   sprintf(temp,"%slastlog",outdir);
   if((fp_in=fopen(temp,"r"))==NULL) {
     fprintf(stderr, "SARG: (lastlog) %s: %s\n",text[9],temp);        
     exit(1);
   }

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      getword(warea,buf,' ');
      buf[strlen(buf)-1]='\0';
     
      if(ftot) {
         if(debug) {
            sprintf(msg,"%s: %s",text[81],buf);
            debuga(msg);
         }
         sprintf(temp, RM" -r %s%s",outdir,buf);
         system(temp);
         ftot--;
      }
   }

   fclose(fp_in);
   sprintf(temp,"%slastlog",outdir);
   unlink(temp);
 
   return;
}
