/* REXX: watch etc/ppp0.pid and if this file is changed determine */
/*       actual dynamic IP.  If IP is new update DynDNS host with */
/*       RXDYNDNS IFCONFIG, HOSTNAME, USERNAME, PASSWORD.  Please */
/*       edit these variables below to reflect your DynDNS host.  */

/* Usage: WATCHPPP seconds|*                                      */
/* where seconds (e.g. 10) is a poll interval used to check file  */
/* mptn/etc/ppp0.pid for changes.  Use WATCHPPP * to (re)create a */
/* WPS object for WATCHPPP 10.  Maybe add an icon to this object, */
/* and/or put a shadow in the start folder <WP_START>.            */

   signal on syntax name TRAP ;  signal on novalue  name TRAP
   signal on halt   name TRAP ;  signal on failure  name TRAP

   IFCONFIG = 'ppp0'             /* interface ppp0 using ppp0.pid */
   HOSTNAME =  'test.dnsalias.org'
   USERNAME =  'test'            /* DynDNS login for RXDYNDNS.CMD */
   PASSWORD =  'test'            /* DynDNS password               */

   call UTIL 'SysSleep'          /*********************************/
   NSU = IFCONFIG || '.daemon'   /* private RxQueue PPP0.daemon   */
   ETC = value( 'ETC',, 'OS2ENVIRONMENT' )
   ETC = ETC || '\' || IFCONFIG || '.pid'
   OLD = stream( ETC, 'C', 'QUERY DATETIME' )

   EOL = x2c( 0D0A )          ;  if PROC() = 3 then EOL = x2c( 0D )
   NSU = translate( NSU )     ;  if QINI() then exit TRAP( NSU )
   signal on syntax name QERR ;  signal on novalue  name QERR
   signal on halt   name QERR ;  signal on failure  name QERR
   OIP = HOST()

   if datatype( arg( 1 ), 'W' ) = 0 then do
      parse source . . NIP
      NEW =               'usage:' NIP 'seconds|*'
      NEW = NEW || EOL || 'checks' ETC 'and hostid'
      NEW = NEW || EOL || OIP 'cyclically with specified'
      NEW = NEW || EOL || 'delay. If changed and' IFCONFIG 'shows'
      NEW = NEW || EOL || 'a new inet number (IP), then DynDNS'
      NEW = NEW || EOL || 'host' HOSTNAME 'is updated'
      NEW = NEW || EOL || 'for user' USERNAME 'with RXDYNDNS.CMD.'

      if arg( 1 ) <> '*' then exit QINI( NEW )
      NEW = NEW || EOL || 'Press ENTER to (re)create WPS object:'
      if QINI( NEW ) = 0 then exit 0

      exit WAIT( 'WPS object' MAKE( NSU, 10 ) 'updated, have fun' )
   end

   do while POLL( arg( 1 ))
      NEW = stream( ETC, 'C', 'QUERY DATETIME' )
      if OLD = NEW   then  iterate     /* known OLD ppp session   */

      NIP = INET( IFCONFIG )           /* new session: get new IP */
      if OIP =  NIP  then  iterate     /* still the same known IP */
      if  '' =  NIP  then  iterate     /* new IP not yet known    */
      OLD = NEW

      OIP = LOOK( HOSTNAME )           /* caveat: RXDYNDNS checks */
      if OIP =  NIP  then  iterate     /* HOSTNAME more seriously */
      if OIP =  ''   then  exit QERR( NSU 'cannot lookup' HOSTNAME )

      call RXDYNDNS IFCONFIG, HOSTNAME, USERNAME, PASSWORD
      if WAIT( 'DynDNS update result' result ) = 0 then leave
   end
   exit QINI( NSU 'terminated' )

POLL: procedure expose NSU       /* delay using loaded SysSleep() */
   if queued() > 0 then return 0 ;  signal on syntax name POLL.TRAP
   call SysSleep arg( 1 )        ;  return queued() = 0
POLL.TRAP:                       /* if SysSleep() lost load again */
   signal on syntax name QERR    ;  call UTIL 'SysSleep'
   if WAIT( NSU 'POLL error:' rc errortext( rc )) = 0 then return 0
   call SysSleep arg( 1 )        ;  return queued() = 0

INET: procedure expose NSU       /* try to get new current ppp IP */
   signal on error name QERR
   address CMD '@ifconfig' arg( 1 ) '2>&1 | RxQueue' NSU
   if queued() = 0 then exit QERR( NSU 'error: ifconfig' arg( 1 ))
   if queued() = 2 then pull     /* remove 1st line for interface */
   if queued() > 1 then exit QINI( NSU 'terminated' )
   parse pull 'inet' IP .     ;  return strip( IP )

LOOK: procedure expose NSU       /* simple DNS lookup using host: */
   signal on error name QERR
   address CMD '@host' arg( 1 ) '| RxQueue' NSU
   if queued() = 0 then exit QERR( NSU 'cannot use host' arg( 1 ))
   if queued() > 1 then exit QINI( NSU 'terminated' )
   parse pull . '=' IP        ;  return strip( IP )

HOST: procedure expose NSU       /* try to get the current hostid */
   signal on error name QERR
   address CMD '@hostid | RxQueue' NSU
   if queued() = 0 then exit QERR( NSU 'cannot get hostid' )
   if queued() > 1 then exit QINI( NSU 'terminated' )
   parse pull . '=' IP        ;  return strip( IP )

QINI: procedure expose NSU       /* manage private daemon queue   */
   QUE = RxQueue( 'Get' )
   if QUE = NSU then do
      call RxQueue 'Delete', QUE
      if result <> 0
         then exit TRAP( 'delete' QUE 'result' result )
         else return WAIT( arg( 1 ))
   end
   else do forever
      QUE = RxQueue( 'Create', NSU )   ;  call RxQueue 'Set'   , NSU
      if QUE = NSU then return 0       ;  call RxQueue 'Delete', QUE
      if result <> 0 then exit TRAP( 'delete' QUE 'result' result )
      QUE = 'sent to' NSU              ;  queue QUE
      if WAIT( 'termination request' queued() QUE ) = 0 then exit 0
   end

/* -------------- procedures updated by REXXTRAP.KEX ------------ */

WAIT: procedure                  /* get OKay resp. CANCEL answer: */
   KEY = PROC()                  ;  OUT = 'STDERR'

   select
      when KEY = 1 then do       /* 1 (real) obsolete: here DOS   */
         parse version KEY . .   /* REXX/Personal has no STDERR:  */
         if KEY <> 'REXXSAA' then OUT = '\dev\con'
      end
      when KEY = 3 then do       /* 3 (PM) RxMessageBox() output  */
         parse source KEY  ;  KEY = centre( KEY, 100 )   /* HACK  */
         KEY = RxMessageBox( arg( 1 ), KEY, 'OKCANCEL', 'ASTERISK' )
         return KEY = 1 | KEY = 6 | KEY = 8
      end                        /* 0 (fullscreen) and 2 (window) */
      when KEY < 4 then call UTIL 'SysGetKey'
      otherwise nop              /* 4 (detached) tested in AKEY() */
   end
   call charout OUT, arg( 1 ) || x2c( 7 )

   do until c2d( KEY ) <> 0 & c2d( KEY ) <> 224
      KEY = AKEY()
   end
   call lineout OUT, ''          /* hardwiring F3 '=', Alt-F4 'k' */
   return KEY <> x2c( 1B ) & KEY <> '=' & KEY <> 'k'

AKEY: procedure                  /* keyboard char. input function */
   KEY = PROC()
   if KEY == 4          then return x2c( 1B )      /* 4: detached */
   if KEY <> 1          then return SysGetKey( 'NoEcho' )
   parse version KEY . .                           /* 1: DOS REXX */
   if KEY == 'REXXSAA'  then return  RxGetKey( 'NoEcho' )
                        else return right( INKEY(), 1 )

PROC: procedure                  /* avoid "unknown function" TRAP */
   parse source OS .             /* for REXXSAA portability abuse */
   if OS <> 'OS/2' then return 1 /* the now obsolete 1: real mode */

   OS = 'ProcessType'            /* assume Sys... = RxProcessType */
   if RxFuncQuery( 'Sys' || OS ) = 0 then return SysProcessType()
   if RxFuncAdd(   'Sys' || OS, 'RxUtils', 'Rx' || OS ) = 0 then do
      signal on syntax name PROC.TRAP  ;  return SysProcessType()
   end                           /* tries RxUtils only once, else */
PROC.TRAP:                       /* force RexxUtil SysProcessType */
   call  RxFuncDrop 'SysProcessType'   ;  signal on syntax name TRAP
   call        UTIL 'SysProcessType'   ;  return SysProcessType()

MAKE: procedure                  /* recreate or update WPS object */
   /* 1st arg: optional object title, default name of source      */
   /* 2nd arg: optional start arg.s,  use '[txt]' if interactive  */
   /* 3rd arg: optional start directory, default TMP environment  */
   TMP = value( 'TMP',, 'OS2ENVIRONMENT' )
   if TMP = '' then TMP = directory()
   call UTIL 'SysCreateObject'      ;  call UTIL 'SysGetEA'
   parse upper source . . SRC       ;  POS = lastpos( '\', SRC )
   TXT = substr( SRC, POS + 1 )     ;  DIR = left( SRC, POS )
   OBJ = '<' || TXT || '>'          ;  POS = lastpos( '.', TXT )
   TXT = left( TXT, POS - 1 )       ;  NEW = 0

   ICO = stream( DIR || TXT || '.ICO', 'c', 'query exists' )
   if ICO = '' & SysGetEA( SRC, '.ICON', 'POS' ) = 0 then do
      call UTIL 'SysTempFileName'   ;  call UTIL 'SysFileDelete'
      signal on notready name TRAP  ;  SET = substr( POS, 5 )
      NEW = ( length( SET ) = c2d( reverse( substr( POS, 3, 2 ))))
      NEW = NEW & abbrev( POS, x2c( 'F9FF' ))
      if NEW then do             /* SysTempFileName error ignored */
         ICO = SysTempFileName( TMP || '\TMP?????.ICO' )
         call charout ICO, SET      ;  call charout ICO
      end
   end

   if arg( 3, 'O' ) then DIR = TMP  ;  else DIR = arg( 3 )
   if arg( 1, 'E' ) then TXT = arg( 1 )

   SET = 'EXENAME=*;PARAMETERS=/C' strip( SRC arg( 2 ))
   SET = SET || ';MINIMIZED=YES;PROGTYPE=PM'
   if ICO <> '' then SET = SET || ';ICONFILE=' || ICO
   SET = SET || ';STARTUPDIR=' || DIR || ';OBJECTID=' || OBJ || ';'

   POS = '<WP_DESKTOP>'
   POS = SysCreateObject( 'WPProgram', TXT, POS, SET, 'Update' )
   if NEW then call SysFileDelete ICO
   if POS then return OBJ        /* ready to create shadow etc.   */
          else exit TRAP( 'fatal - cannot update' OBJ )

UTIL: procedure                  /* load necessary RexxUtil entry */
   if RxFuncQuery(  arg( 1 )) then
      if RxFuncAdd( arg( 1 ), 'RexxUtil', arg( 1 )) then
         exit TRAP( "can't add RexxUtil"  arg( 1 ))
   return 0

QERR:                            /* delete queue and handle TRAP: */
   signal on novalue name TRAP   ;  signal on syntax name TRAP
   signal on failure name TRAP   ;  signal on halt   name TRAP
   QERR = RxQueue( 'Delete', RxQueue( 'Get' ))

TRAP:                            /* select REXX exception handler */
   call trace 'O' ;  trace N           /* don't trace interactive */
   parse source TRAP                   /* source on separate line */
   TRAP = x2c( 0D ) || right( '+++', 10 ) TRAP || x2c( 0D0A )
   TRAP = TRAP || right( '+++', 10 )   /* = standard trace prefix */
   TRAP = TRAP strip( condition( 'c' ) 'trap:' condition( 'd' ))
   select
      when wordpos( condition( 'c' ), 'ERROR FAILURE' ) > 0 then do
         if condition( 'd' ) > ''      /* need an additional line */
            then TRAP = TRAP || x2c( 0D0A ) || right( '+++', 10 )
         TRAP = TRAP '(RC' rc || ')'   /* any system error codes  */
         if condition( 'c' ) = 'FAILURE' then rc = -3
      end
      when wordpos( condition( 'c' ), 'HALT SYNTAX'   ) > 0 then do
         if condition( 'c' ) = 'HALT' then rc = 4
         if condition( 'd' ) > '' & condition( 'd' ) <> rc then do
            if condition( 'd' ) <> errortext( rc ) then do
               TRAP = TRAP || x2c( 0D0A ) || right( '+++', 10 )
               TRAP = TRAP errortext( rc )
            end                        /* future condition( 'd' ) */
         end                           /* may use errortext( rc ) */
         else  TRAP = TRAP errortext( rc )
         rc = -rc                      /* rc < 0: REXX error code */
      end
      when condition( 'c' ) = 'NOVALUE'  then rc = -2 /* dubious  */
      when condition( 'c' ) = 'NOTREADY' then rc = -1 /* dubious  */
      otherwise                        /* force non-zero whole rc */
         if datatype( value( 'RC' ), 'W' ) = 0 then rc = 1
         if rc = 0                             then rc = 1
         if condition() = '' then TRAP = TRAP arg( 1 )
   end                                 /* direct: TRAP( message ) */

   TRAP = TRAP || x2c( 0D0A ) || format( sigl, 6 )
   signal on syntax name TRAP.SIGL     /* throw syntax error 3... */
   if 0 < sigl & sigl <= sourceline()  /* if no handle for source */
      then TRAP = TRAP '*-*' strip( sourceline( sigl ))
      else TRAP = TRAP '+++ (source line unavailable)'
TRAP.SIGL:                             /* ...catch syntax error 3 */
   if abbrev( right( TRAP, 2 + 6 ), x2c( 0D0A )) then do
      TRAP = TRAP '+++ (source line unreadable)'   ;  rc = -rc
   end
   select
      when 0 then do                   /* in pipes STDERR: output */
         parse version TRAP.REXX . .   /* REXX/Personal: \dev\con */
         signal on syntax name TRAP.FAIL
         if TRAP.REXX = 'REXXSAA'      /* fails if no more handle */
            then call lineout 'STDERR'  , TRAP
            else call lineout '\dev\con', TRAP
      end
      when 1 then do                   /* OS/2 PM: RxMessageBox() */
         signal on syntax name TRAP.FAIL
         call RxMessageBox ,           /* fails if not in PMREXX  */
            translate( TRAP, ' ', x2c( 0D )), , 'CANCEL', 'WARNING'
      end                              /* replace any CR by blank */
      otherwise   say TRAP ; trace ?L  /* interactive Label trace */
   end

   if condition() = 'SIGNAL' then signal TRAP.EXIT
TRAP.CALL:  return rc                  /* continue after CALL ON  */
TRAP.FAIL:  say TRAP ;  rc = 0 - rc    /* force TRAP error output */
TRAP.EXIT:  exit   rc                  /* exit for any SIGNAL ON  */
