/* REXX: simplified http://members.dyndns.org/nic.update? script, */
/* needs RxSock.DLL (REXX sockets library from IBM), a dynamic IP */
/* (i.e. a new dialup internet connection), and a DynDNS HOSTNAME */
/* not already associated with this IP.                           */

/* Usage: RXDYNDNS.CMD  interface  hostname  username  password   */
/* resp.: call RXDYNDNS interface, hostname, username, password   */
/*  e.g.: call RXDYNDNS 'ppp0','test.dnsalias.org','test','test'  */

/* The result is either an error message (incl. DynDNS messages)  */
/* or the message 'good a.b.c.d' after updating dyn. IP a.b.c.d . */
/* Please change the COPYLEFT below if you modify this script...  */

   signal on novalue  name TRAP  ;  signal on syntax name TRAP
   signal on failure  name TRAP  ;  signal on halt   name TRAP

   COPYLEFT = 'rxdyndns/0.6 frank.ellermann@t-online.de'
   PEERNAME = 'members.dyndns.org'     /* HTTP server for members */
   PEERPORT = 8245                     /* 80 works without proxy  */

   if arg() = 1                        /* i.e. if used as command */
      then parse arg IFCONFIG  HOSTNAME  USERNAME  PASSWORD  N
      else parse arg IFCONFIG, HOSTNAME, USERNAME, PASSWORD, N

   if strip( HOSTNAME USERNAME PASSWORD ) = ''  then do
      HOSTNAME = 'test.dnsalias.org'   /* DynDns domain for tests */
      USERNAME = 'test' ;  PASSWORD = 'test'
   end
   if right( strip( HOSTNAME ), 11 ) = '.orgdns.org' then do
      PEERPORT = 80                    /* hardwired ORGDNS stuff: */
      PEERNAME = 'members.orgdns.org'  /* HTTP server for members */
   end
   if sign( pos( left( IFCONFIG, 1 ), '?-/' ))  then return HELP()
   if IFCONFIG = '' | HOSTNAME = '' | N <> ''   then return HELP()
   if USERNAME = '' | PASSWORD = ''             then return HELP()

   SOCK = -1   ;  N = 'SockLoadFuncs'
   if RxFuncQuery( N ) then            /* here FAIL throws a TRAP */
      if RxFuncAdd( N, 'RXSOCK', N ) then
         return FAIL( N 'in RXSOCK.DLL not found' )
   call SockLoadFuncs 'N'

   if SockGetHostByName( PEERNAME, 'PEER.1' ) = 0
      then return FAIL( 'unknown host' PEERNAME )
   if SockGetHostByName( HOSTNAME, 'HOST.1' ) = 0
      then return FAIL( 'unknown host' HOSTNAME )

   PASSWORD       = MIME( USERNAME || ':' || PASSWORD )
   PEER.1FAMILY   = 'AF_INET' ;  CRLF = x2c( 0D0A )
   PEER.1PORT     = PEERPORT  ;  MYIP = MYIP( IFCONFIG )

   do N = 1 to HOST.1ADDR.0
      if MYIP = HOST.1ADDR.N then return FAIL( MYIP 'already set' )
   end N

   TEXT = 'GET /nic/update?system=dyndns&hostname=' || HOSTNAME
   TEXT = TEXT || '&myip=' || MYIP
   TEXT = TEXT || '&wildcard=NOCHG&offline=NO HTTP/1.0'
   TEXT = TEXT || CRLF     || 'Host:' || PEERNAME
   TEXT = TEXT || CRLF     || 'Authorization: Basic' PASSWORD
   TEXT = TEXT || CRLF     || 'Pragma: no-cache'
   TEXT = TEXT || CRLF     || 'Connection: close'
   TEXT = TEXT || CRLF     || 'User-Agent:' COPYLEFT
   TEXT = TEXT || CRLF     || CRLF

   SOCK = SockSocket( 'AF_INET', 'SOCK_STREAM', 'IPPROTO_TCP' )
   if SOCK = -1 then return FAIL( 'SockSocket() =' SOCK )

   signal on novalue  name SOCK  ;  signal on syntax name SOCK
   signal on failure  name SOCK  ;  signal on halt   name SOCK

   if SockConnect( SOCK, 'PEER.1' ) <> 0 then
      return FAIL( 'SockConnect' )
   if SockSend( SOCK, TEXT ) = -1 then
      return FAIL( 'SockSend' )
   if SockShutDown( SOCK, 1 ) <> 0 then
      return FAIL( 'SockShutDown' )

   TEXT = ''
   do until N = 0
      N = SockRecv( SOCK, 'MORE', 1024 )
      if N = -1 then return FAIL( 'SockRecv' )
      TEXT = TEXT || left( MORE, N )
   end

   if SockClose( SOCK ) <> 0 then return FAIL( 'SockClose' )
   signal on novalue  name TRAP  ;  signal on syntax name TRAP
   signal on failure  name TRAP  ;  signal on halt   name TRAP

   do while TEXT <> ''                 /* get last line of result */
      parse var TEXT MORE (CRLF) TEXT
   end
   if arg() <> 1  then  return MORE    /* else used as command... */
   say HOSTNAME MORE ;  return 1 - abbrev( MORE, 'good' )

MYIP: procedure expose SOCK      /* get dynamic IP of interface:  */
   Q = RxQueue( 'Get' )          /* use whatever actual RX queue, */
   if queued() = 0 then do       /* empty queue set up by caller: */
      address CMD '@ifconfig' arg( 1 ) '2>&1 | RxQueue' Q
      if queued() = 2 then do
         pull  ;  parse pull 'inet' Q .   ;  Q = strip( Q )
         if verify( Q, '0.123456789' ) = 0 then return Q
      end                        /* IP contains dots and digits,  */
   end                           /* anything else is erroneous... */
   exit FAIL( 'ifconfig' arg( 1 ) || ':' Q queued())

MIME: procedure                  /* encode authorization string:  */
   SRC = x2b( c2x( arg( 1 )))
   ADD = ''
   DST =        'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdef'
   DST = DST || 'ghijklmnopqrstuvwxyz0123456789+/'
   do N = 0 until DST = '' ;  parse var DST C.N 2 DST ;  end N
   do N = 1 to (( length( SRC ) // 24 ) / 4 ) // 3
      ADD = ADD || '='  ;  SRC = SRC || '00'
   end N
   do while SRC <> ''
      parse var SRC N 7 SRC
      N = x2d( b2x( N ))
      DST = DST || C.N
   end
   return DST || ADD

HELP: procedure                  /* show usage message and return */
   parse source . . N
   N = substr( N, 1 + lastpos( '\', N ))
   N = substr( N, 1 + lastpos( '/', N ))
   NN = ' e.g.:' N 'ppp0 test.dnsalias.org test test'
   NN = 'usage:' N 'interface host login password' x2c( 0D0A ) || NN
   say NN   ;  return NN         /* caller can show NN in PM win. */

FAIL: procedure expose SOCK      /* show a socket error on stderr */
   NN = arg( 1 ) '(error' max( 0, SockSock_errno() - 10000 ) || ')'
   call SockPSock_errno NN       /* REXX handles missing function */
   call SockClose SOCK           /* as syntax TRAP exiting anyway */
   return NN                     /* caller can show NN in PM win. */

/* -- TRAP handler managed by REXXTRAP.KEX ---------------------- */

SOCK:                            /* close socket and handle TRAP: */
   call SockClose SOCK
   if result <> 0 then call SockPSock_errno 'SockClose() =' result

TRAP:                            /* select REXX exception handler */
   call trace 'O' ;  trace N           /* don't trace interactive */
   parse source TRAP                   /* source on separate line */
   TRAP = x2c( 0D ) || right( '+++', 10 ) TRAP || x2c( 0D0A )
   TRAP = TRAP || right( '+++', 10 )   /* = standard trace prefix */
   TRAP = TRAP strip( condition( 'c' ) 'trap:' condition( 'd' ))
   select
      when wordpos( condition( 'c' ), 'ERROR FAILURE' ) > 0 then do
         if condition( 'd' ) > ''      /* need an additional line */
            then TRAP = TRAP || x2c( 0D0A ) || right( '+++', 10 )
         TRAP = TRAP '(RC' rc || ')'   /* any system error codes  */
         if condition( 'c' ) = 'FAILURE' then rc = -3
      end
      when wordpos( condition( 'c' ), 'HALT SYNTAX'   ) > 0 then do
         if condition( 'c' ) = 'HALT' then rc = 4
         if condition( 'd' ) > '' & condition( 'd' ) <> rc then do
            if condition( 'd' ) <> errortext( rc ) then do
               TRAP = TRAP || x2c( 0D0A ) || right( '+++', 10 )
               TRAP = TRAP errortext( rc )
            end                        /* future condition( 'd' ) */
         end                           /* may use errortext( rc ) */
         else  TRAP = TRAP errortext( rc )
         rc = -rc                      /* rc < 0: REXX error code */
      end
      when condition( 'c' ) = 'NOVALUE'  then rc = -2 /* dubious  */
      when condition( 'c' ) = 'NOTREADY' then rc = -1 /* dubious  */
      otherwise                        /* force non-zero whole rc */
         if datatype( value( 'RC' ), 'W' ) = 0 then rc = 1
         if rc = 0                             then rc = 1
         if condition() = '' then TRAP = TRAP arg( 1 )
   end                                 /* direct: TRAP( message ) */

   TRAP = TRAP || x2c( 0D0A ) || format( sigl, 6 )
   signal on syntax name TRAP.SIGL     /* throw syntax error 3... */
   if 0 < sigl & sigl <= sourceline()  /* if no handle for source */
      then TRAP = TRAP '*-*' strip( sourceline( sigl ))
      else TRAP = TRAP '+++ (source line unavailable)'
TRAP.SIGL:                             /* ...catch syntax error 3 */
   if abbrev( right( TRAP, 2 + 6 ), x2c( 0D0A )) then do
      TRAP = TRAP '+++ (source line unreadable)'   ;  rc = -rc
   end
   select
      when 0 then do                   /* in pipes STDERR: output */
         parse version TRAP.REXX . .   /* REXX/Personal: \dev\con */
         signal on syntax name TRAP.FAIL
         if TRAP.REXX = 'REXXSAA'      /* fails if no more handle */
            then call lineout 'STDERR'  , TRAP
            else call lineout '\dev\con', TRAP
      end
      when 1 then do                   /* OS/2 PM: RxMessageBox() */
         signal on syntax name TRAP.FAIL
         call RxMessageBox ,           /* fails if not in PMREXX  */
            translate( TRAP, ' ', x2c( 0D )), , 'CANCEL', 'WARNING'
      end                              /* replace any CR by blank */
      otherwise   say TRAP ; trace ?L  /* interactive Label trace */
   end

   if condition() = 'SIGNAL' then signal TRAP.EXIT
TRAP.CALL:  return rc                  /* continue after CALL ON  */
TRAP.FAIL:  say TRAP ;  rc = 0 - rc    /* force TRAP error output */
TRAP.EXIT:  exit   rc                  /* exit for any SIGNAL ON  */
