


rsync(1)                                                 rsync(1)


NNAAMMEE
       rsync - faster, flexible replacement for rcp

SSYYNNOOPPSSIISS
       rsync [options] [user@]host:path path

       rsync [options] path [user@]host:path

       rsync [options] path path

       rsync [options] [user@]host::module[/path] path

       rsync [options] path [user@]host::module[/path]

       rsync   [options]   rsync://[user@]host[:port]/module/path
       path


DDEESSCCRRIIPPTTIIOONN
       rsync is a program that behaves in much the same way  that
       rcp  does,  but  has  many more options and uses the rsync
       remote-update protocol to greatly speedup  file  transfers
       when the destination file already exists.

       The  rsync remote-update protocol allows rsync to transfer
       just the differences between two sets of files across  the
       network link, using an efficient checksum-search algorithm
       described in the technical report  that  accompanies  this
       package.

       Some of the additional features of rsync are:


       o      support  for copying links, devices, owners, groups
              and permissions

       o      exclude and exclude-from options similar to GNU tar

       o      a CVS exclude mode for ignoring the same files that
              CVS would ignore

       o      can use any transparent remote shell, including rsh
              or ssh

       o      does not require root privileges

       o      pipelining  of  file  transfers to minimize latency
              costs

       o      support  for  anonymous  or   authenticated   rsync
              servers (ideal for mirroring)






                           24 Nov 1998                          1





rsync(1)                                                 rsync(1)


GGEENNEERRAALL
       There are six different ways of using rsync. They are:


       o      for  copying local files. This is invoked when nei-
              ther source nor destination path contains a : sepa-
              rator


       o      for  copying  from  the  local  machine to a remote
              machine using a remote shell program as the  trans-
              port (such as rsh or ssh). This is invoked when the
              destination path contains a single : separator.


       o      for copying from a  remote  machine  to  the  local
              machine  using  a  remote  shell  program.  This is
              invoked when the local path contains a : separator.


       o      for copying from a remote rsync server to the local
              machine. This is invoked when the source path  con-
              tains a :: separator or a rsync:// URL.


       o      for  copying  from  the  local  machine to a remote
              rsync server. This is invoked when the  destination
              path contains a :: separator.


       o      for listing files on a remote machine. This is done
              the same way as rsync  transfers  except  that  you
              leave off the local destination.

       Note that in all cases at least one of the source and des-
       tination paths must be local.


SSEETTUUPP
       See the file README for installation instructions.

       Once installed you can use rsync to any machine  that  you
       can  use  rsh  to.  rsync uses rsh for its communications,
       unless both the source and destination are local.

       You can also specify a alternative to rsh, by either using
       the  -e  command  line option, or by setting the RSYNC_RSH
       environment variable.

       One common substitute is to use ssh, which offers  a  high
       degree of security.

       Note  that  rsync must be installed on both the source and
       destination machines.



                           24 Nov 1998                          2





rsync(1)                                                 rsync(1)


UUSSAAGGEE
       You use rsync in the same way you use rcp. You must  spec-
       ify  a  source  and  a  destination,  one  of which may be
       remote.

       Perhaps the best way to explain the syntax is  some  exam-
       ples:

              rsync *.c foo:src/

       this  would  transfer  all  files matching the pattern *.c
       from the current directory to the  directory  src  on  the
       machine  foo.  If  any  of  the files already exist on the
       remote system then the  rsync  remote-update  protocol  is
       used  to  update the file by sending only the differences.
       See the tech report for details.

              rsync -avz foo:src/bar /data/tmp

       recursively transfer all files from the directory  src/bar
       on the machine foo into the /data/tmp/bar directory on the
       local machine. The  files  are  transferred  in  "archive"
       mode,   which   ensures   that  symbolic  links,  devices,
       attributes, permissions, ownerships etc are  preserved  in
       the  transfer.   Additionally  compression will be used to
       reduce the size of data portions of the transfer.

              rsync -avz foo:src/bar/ /data/tmp

       a trailing slash on the source changes  this  behavior  to
       transfer  all  files  from  the  directory  src/bar on the
       machine foo into the /data/tmp/.  A trailing / on a source
       name means "copy the contents of this directory".  Without
       a trailing slash it means "copy the directory". This  dif-
       ference  becomes  particularly  important  when  using the
       --delete option.

       You can also use rsync in local-only mode, where both  the
       source  and  destination  don't have a ':' in the name. In
       this case it behaves like an improved copy command.


CCOONNNNEECCTTIINNGG TTOO AANN RRSSYYNNCC SSEERRVVEERR
       It is also possible to use rsync without using rsh or  ssh
       as  the  transport.  In  this  case  you will connect to a
       remote rsync server running on TCP port 873.

       Using rsync in this was is the same as using it  with  rsh
       or ssh except that:


       o      you use a double colon :: instead of a single colon
              to separate the hostname from the path.




                           24 Nov 1998                          3





rsync(1)                                                 rsync(1)


       o      the remote server may print a message  of  the  day
              when you connect


       o      if  you  specify  no path name on the remote server
              then the list of accessible  paths  on  the  server
              will be shown.


       o      if  you specify no local destination then a listing
              of the specified files on the remote server is pro-
              vided

       Some  paths  on  the remote server may require authentica-
       tion. If so then you will receive a password  prompt  when
       you  connect. You can avoid the password prompt by setting
       the environment variable RSYNC_PASSWORD  to  the  password
       you  want to use. This may be useful when scripting rsync.


RRUUNNNNIINNGG AANN RRSSYYNNCC SSEERRVVEERR
       An rsync server is configured using a config file which by
       default   is   called  /etc/rsyncd.conf.  Please  see  the
       rsyncd.conf(5) man page for more information.


EEXXAAMMPPLLEESS
       Here are some examples of how I use rsync.

       To backup my wife's  home  directory,  which  consists  of
       large MS word files and mail folders I use a cron job that
       runs

              rsync -Cavz . arvidsjaur:backup

       each night over a PPP link to a duplicate directory on  my
       machine "arvidsjaur".

       To  synchronize  my samba source trees I use the following
       Makefile targets:

              get:
              rsync -avuzb --exclude '*~' samba:samba/ .

              put:
              rsync -Cavuzb . samba:samba/

              sync: get put

       this allows me to sync with a CVS directory at  the  other
       end  of  the  link. I then do cvs operations on the remote
       machine, which saves a lot of time as the remote cvs  pro-
       tocol isn't very efficient.




                           24 Nov 1998                          4





rsync(1)                                                 rsync(1)


       I  mirror a directory between my "old" and "new" ftp sites
       with the command

              rsync -az  -e  ssh  --delete  ~ftp/pub/samba/  nim-
              bus:"~ftp/pub/tridge/samba"

       this is launched from cron every few hours.


OOPPTTIIOONNSS SSUUMMMMAARRYY
       Here  is a short summary of the options avalable in rsync.
       Please refer to the detailed description below for a  com-
       plete description.




       Usage: rsync [OPTION]... SRC [USER@]HOST:DEST
         or   rsync [OPTION]... [USER@]HOST:SRC DEST
         or   rsync [OPTION]... SRC DEST
         or   rsync [OPTION]... [USER@]HOST::SRC DEST
         or   rsync [OPTION]... SRC [USER@]HOST::DEST
         or    rsync  [OPTION]...  rsync://[USER@]HOST[:PORT]/SRC
       DEST

       Options
        -v, --verbose               increase verbosity
        -c, --checksum              always checksum
        -a, --archive               archive mode
        -r, --recursive             recurse into directories
        -R, --relative              use relative path names
        -b,  --backup                 make  backups  (default   ~
       extension)
        -u,  --update                update only (don't overwrite
       newer files)
        -l, --links                 preserve soft links
        -L, --copy-links            treat soft links like regular
       files
            --safe-links            ignore links outside the des-
       tination tree
        -H, --hard-links            preserve hard links
        -p, --perms                 preserve permissions
        -o, --owner                 preserve owner (root only)
        -g, --group                 preserve group
        -D, --devices               preserve devices (root only)
        -t, --times                 preserve times
        -S, --sparse                 handle  sparse  files  effi-
       ciently
        -n,  --dry-run                show  what  would have been
       transferred
        -W, --whole-file            copy whole files,  no  incre-
       mental checks
        -x, --one-file-system       don't cross filesystem bound-
       aries



                           24 Nov 1998                          5





rsync(1)                                                 rsync(1)


        -B, --block-size=SIZE       checksum blocking size
        -e, --rsh=COMMAND           specify rsh replacement
            --rsync-path=PATH       specify path to rsync on  the
       remote machine
        -C, --cvs-exclude           auto ignore files in the same
       way CVS does
            --delete                delete files that don't exist
       on the sending side
            --partial                keep  partially  transferred
       files
            --force                 force deletion of directories
       even if not empty
            --numeric-ids            don't  map uid/gid values by
       user/group name
            --timeout=TIME          set IO timeout in seconds
        -I,  --ignore-times           don't  exclude  files  that
       match length and time
        -T   --temp-dir=DIR           create  temporary  files in
       directory DIR
            --compare-dest=DIR       also   compare   destination
       files relative to DIR
        -z, --compress              compress file data
            --exclude=PATTERN        exclude  files matching PAT-
       TERN
            --exclude-from=FILE     exclude files listed in FILE
            --include=PATTERN       don't exclude files  matching
       PATTERN
            --include-from=FILE     don't exclude files listed in
       FILE
            --suffix=SUFFIX         override backup suffix
            --version               print version number
            --daemon                run as a rsync daemon
            --config=FILE           specify alternate rsyncd.conf
       file
            --port=PORT             specify alternate rsyncd port
       number
            --stats                 give some file transfer stats
            --progress              show progress during transfer
            --log-format=FORMAT      log  file  transfers   using
       specified format
        -h, --help                  show this help screen





OOPPTTIIOONNSS
       rsync  uses the GNU long options package. Many of the com-
       mand line options have two variants,  one  short  and  one
       long.   These  are  shown  below separated by commas. Some
       options only have a long variant.






                           24 Nov 1998                          6





rsync(1)                                                 rsync(1)


       --hh,, ----hheellpp
              Print a short  help  page  describing  the  options
              available in rsync


       ----vveerrssiioonn
              print the rsync version number and exit


       --vv,, ----vveerrbboossee
              This option increases the amount of information you
              are given during the transfer.   By  default  rsync
              works  silently. A single -v will give you informa-
              tion about what files are being transferred  and  a
              brief  summary  at  the end. Two -v flags will give
              you information on what files are being skipped and
              slightly more information at the end. More than two
              -v flags should only be used if you  are  debugging
              rsync


       --II,, ----iiggnnoorree--ttiimmeess
              Normally rsync will skip any files that are already
              the same length and have the same time-stamp.  This
              option turns off this behavior.


       --cc,, ----cchheecckkssuumm
              This  forces the sender to checksum all files using
              a 128-bit MD4 checksum before transfer. The  check-
              sum  is then explicitly checked on the receiver and
              any files of the same name which already exist  and
              have the same checksum and size on the receiver are
              skipped.  This option can be quite slow.


       --aa,, ----aarrcchhiivvee
              This is equivalent to -rlptDg. It is a quick way of
              saying  you  want  recursion  and  want to preserve
              everything.

              Note: if the user launching rsync is root then  the
              -o option (preserve uid) is also implied.


       --rr,, ----rreeccuurrssiivvee
              This tells rsync to copy directories recursively


       --RR,, ----rreellaattiivvee
              Use  relative  paths. This means that the full path
              names specified on the command line are sent to the
              server rather than just the last parts of the file-
              names. This is particularly useful when you want to



                           24 Nov 1998                          7





rsync(1)                                                 rsync(1)


              sent  several  different  directories  at  the same
              time. For example, if you used the command



              rsync foo/bar/foo.c remote:/tmp/



              then this would create a file called foo.c in /tmp/
              on the remote machine. If instead you used



              rsync -R foo/bar/foo.c remote:/tmp/



              then a file called /tmp/foo/bar/foo.c would be cre-
              ated on the remote machine. The full path  name  is
              preserved.


       --bb,, ----bbaacckkuupp
              With  this option preexisting destination files are
              renamed with a ~ extension as each file  is  trans-
              ferred.   You  can  control the backup suffix using
              the --suffix option.


       --uu,, ----uuppddaattee
              This forces rsync to skip any files for  which  the
              destination  file  already  exists  and  has a date
              later than the source file.


       --ll,, ----lliinnkkss
              This tells rsync to recreate symbolic links on  the
              remote system  to  be the same as the local system.
              Without this option all symbolic links are skipped.


       --LL,, ----ccooppyy--lliinnkkss
              This  tells rsync to treat symbolic links just like
              ordinary files.


       ----ssaaffee--lliinnkkss
              This tells rsync to ignore any symbolic links which
              point  outside  the  destination tree. All absolute
              symlinks are also ignored.  Using  this  option  in
              conjunction  with  --relative  may  give unexpecetd
              results.




                           24 Nov 1998                          8





rsync(1)                                                 rsync(1)


       --HH,, ----hhaarrdd--lliinnkkss
              This tells rsync to recreate hard   links   on  the
              remote system  to  be the same as the local system.
              Without this option hard  links  are  treated  like
              regular files.

              Note  that rsync can only detect hard links if both
              parts of the link are in the list  of  files  being
              sent.

              This  option  can  be quite slow, so only use it if
              you need it.


       --WW,, ----wwhhoollee--ffiillee
              With this option the incremental rsync algorithm is
              not  used   and   the  whole  file  is  sent  as-is
              instead. This may be useful when using rsync with a
              local machine.


       ----ppaarrttiiaall
              By  default  rsync will delete any partially trans-
              ferred file if the transfer is interrupted. In some
              circumstances  it  is  more  desirable to keep par-
              tially  transferred  files.  Using  the   --partial
              option  tells  rsync to keep the partial file which
              should make a subsequent transfer of  the  rest  of
              the file much faster.


       --pp,, ----ppeerrmmss
              This  option causes rsync to update the remote per-
              missions to be the same as the local permissions.


       --oo,, ----oowwnneerr
              This option causes  rsync  to  update  the   remote
              owner  of  the   file  to  be the same as the local
              owner. This is only available  to  the  super-user.
              Note  that  if  the source system is a daemon using
              chroot, the --numeric-ids option is implied because
              the  source  system  cannot  get access to the user
              names.


       --gg,, ----ggrroouupp
              This option causes  rsync  to  update  the   remote
              group  of  the  file  to  be  the same as the local
              group.  Note that if the source system is a  daemon
              using  chroot,  the --numeric-ids option is implied
              because the source system cannot get access to  the
              group names.




                           24 Nov 1998                          9





rsync(1)                                                 rsync(1)


       --DD,, ----ddeevviicceess
              This  option causes rsync to transfer character and
              block device information to the  remote  system  to
              recreate  these devices. This option is only avail-
              able to the super-user.


       --tt,, ----ttiimmeess
              This tells rsync  to  transfer  modification  times
              along  with the files and update them on the remote
              system.  Note that if this option is not used,  the
              optimization that excludes files that have not been
              modified cannot be effective;  in  other  words,  a
              missing  -t  or  -a will cause the next transfer to
              behave as if it used -I, and all  files  will  have
              their  checksums  compared  and show up in log mes-
              sages even if they haven't changed.


       --nn,, ----ddrryy--rruunn
              This tells rsync to  not  do  any  file  transfers,
              instead  it  will  just report the actions it would
              have taken.


       --SS,, ----ssppaarrssee
              Try to handle sparse files efficiently so they take
              up less space on the destination.

              NOTE: Don't use this option when the destination is
              a Solaris "tmpfs" filesystem. It  doesn't  seem  to
              handle  seeks  over null regions correctly and ends
              up corrupting the files.


       --xx,, ----oonnee--ffiillee--ssyysstteemm
              This tells rsync not to cross filesystem boundaries
              when  recursing.   This  is useful for transferring
              the contents of only one filesystem.


       ----ddeelleettee
              This tells rsync to delete any files on the receiv-
              ing  side  that  aren't  on  the sending side. This
              option can be dangerous if used incorrectly!

              It is a very good idea to run first using  the  dry
              run  option (-n) to see what files would be deleted
              to make sure important files aren't listed.

              rsync 1.6.4 changed the  behavior  of  --delete  to
              make  it  less  dangerous.   rsync  now  only scans
              directories on the receiving side that are  explic-
              itly transferred from the sending side.  Only files



                           24 Nov 1998                         10





rsync(1)                                                 rsync(1)


              in these directories are deleted.

              Still, it is probably easy to get burnt  with  this
              option.   The  moral  of the story is to use the -n
              option until  you  get  used  to  the  behavior  of
              --delete.

              If  the sending side detects any IO errors then the
              deletion of any files at the  destination  will  be
              automatically  disabled.  This is to prevent tempo-
              rary filesystem failures (such as  NFS  errors)  on
              the  sending  side  causing  a  massive deletion of
              files on the destination.


       ----ffoorrccee
              This options tells rsync to delete directories even
              if  they  are  not empty.  This applies to both the
              --delete option and to cases where rsync  tries  to
              copy  a  normal file but the destination contains a
              directory of the same  name.  Normally  rsync  will
              refuse to do a recursive directory deletion in such
              cases, by using --force the recursive deletion will
              be done.

              Use this option with caution!


       --BB ,, ----bblloocckk__ssiizzee BBLLOOCCKKSSIIZZEE
              This  controls  the  block  size  used in the rsync
              algorithm. See the technical report for details.


       --ee,, ----rrsshh CCOOMMMMAANNDD
              This option allows you  to  choose  an  alternative
              remote  shell  program  to  use  for  communication
              between the local and remote copies  of  rsync.  By
              default  rsync  will  use  rsh, but you may like to
              instead use ssh because of its high security.

              You can also choose the remote shell program  using
              the RSYNC_RSH environment variable.


       ----rrssyynncc--ppaatthh PPAATTHH
              Use  this  to specify the path to the copy of rsync
              on the remote machine. Useful when its not in  your
              path.


       ----eexxcclluuddee ppaatttteerrnn
              This  option allows you to selectively exclude cer-
              tain files from the list  of  files  to  be  trans-
              ferred.  This  is most useful in combination with a



                           24 Nov 1998                         11





rsync(1)                                                 rsync(1)


              recursive transfer.

              You may use as many --exclude options on  the  com-
              mand line as you like to build up the list of files
              to exclude.

              See the section of exclude patterns for information
              on the syntax of this option.


       ----eexxcclluuddee--ffrroomm FFIILLEE
              This option is similar to the --exclude option, but
              instead it adds all filenames listed  in  the  file
              FILE to the exclude list.


       ----iinncclluuddee ppaatttteerrnn
              This  option  tells rsync to not exclude the speci-
              fied pattern of filenames. This  is  useful  as  it
              allows    you    to    build   up   quite   complex
              exclude/include rules.

              See the section of exclude patterns for information
              on the syntax of this option.


       ----iinncclluuddee--ffrroomm FFIILLEE
              This  specifies  a  list of include patterns from a
              file.


       --CC,, ----ccvvss--eexxcclluuddee
              This is a useful shorthand for  excluding  a  broad
              range  of files that you often don't want to trans-
              fer between systems. It  uses  the  same  algorithm
              that  CVS  uses  to  determine  if a file should be
              ignored.

              The exclude list is initialized to:

              RCS SCCS CVS  CVS.adm  RCSLOG  cvslog.*  tags  TAGS
              .make.state  .nse_depinfo  *~ #* .#* ,* *.old *.bak
              *.BAK *.orig *.rej .del-* *.a *.o  *.obj  *.so  *.Z
              *.elc *.ln core

              then  files  listed in a $HOME/.cvsignore are added
              to the list and any files listed in  the  CVSIGNORE
              environment variable (space delimited).

              Finally  in  each directory any files listed in the
              .cvsignore file in that directory are added to  the
              list.





                           24 Nov 1998                         12





rsync(1)                                                 rsync(1)


       ----ssuuffffiixx SSUUFFFFIIXX
              This  option  allows  you  to  override the default
              backup suffix used with the -b option. The  default
              is a ~.


       ----ccssuumm--lleennggtthh LLEENNGGTTHH
              By  default the primary checksum used in rsync is a
              very strong 16 byte MD4 checksum. In most cases you
              will find that a truncated version of this checksum
              is quite efficient, and this will decrease the size
              of  the  checksum  data  sent over the link, making
              things faster.

              You can choose the number of bytes in the truncated
              checksum  using the --csum-length option. Any value
              less than or equal to 16 is valid.

              Note that if you use this option then you  run  the
              risk  of  ending  up with an incorrect target file.
              The risk with a value of 16 is microscopic and  can
              be  safely  ignored (the universe will probably end
              before it fails) but with smaller values  the  risk
              is higher.

              Current  versions of rsync actually use an adaptive
              algorithm for the checksum length by default, using
              a  16 byte file checksum to determine if a 2nd pass
              is required with a longer block checksum. Only  use
              this  option  if  you have read the source code and
              know what you are doing.


       --TT,, ----tteemmpp--ddiirr DDIIRR
              This option instructs rsync to use DIR as a scratch
              directory  when  creating  temporary  copies of the
              files  transferred  on  the  receiving  side.   The
              default  behavior  is to create the temporary files
              in the receiving directory.


       ----ccoommppaarree--ddeesstt DDIIRR
              This option instructs rsync to use DIR as an  addi-
              tional   directory  to  compare  destination  files
              against when doing transfers.  This is  useful  for
              doing  transfers to a new destination while leaving
              existing files intact,  and  then  doing  a  flash-
              cutover  when  all  files  have  been  successfully
              transfered  (for  example  by  moving   directories
              around  and  removing  the  old directory, although
              this requires also doing the transfer  with  -I  to
              avoid  skipping  files that haven't changed).  This
              option  increases  the  usefulness   of   --partial
              because  partially transferred files will remain in



                           24 Nov 1998                         13





rsync(1)                                                 rsync(1)


              the new temporary destination  until  they  have  a
              chance to be completed.  If DIR is a relative path,
              it is relative to the destination directory.


       --zz,, ----ccoommpprreessss
              With this option, rsync compresses  any  data  from
              the  source  file(s) which it sends to the destina-
              tion machine.  This option is useful on slow links.
              The compression method used is the same method that
              gzip uses.

              Note this this  option  typically  achieves  better
              compression  ratios that can be achieved by using a
              compressing remote shell, or a  compressing  trans-
              port,  as it takes advantage of the implicit infor-
              mation sent for matching data blocks.


       ----nnuummeerriicc--iiddss
              With this option rsync will transfer numeric  group
              and user ids rather than using user and group names
              and mapping them at both ends.

              By default rsync will use the user name  and  group
              name to determine what ownership to give files. The
              special uid 0 and the special  group  0  and  never
              mapped  via user/group names even if the --numeric-
              ids option is not specified.

              If the source system is a daemon using  chroot,  or
              if  a user or group name does not exist on the des-
              tination system,  then  the  numeric  id  from  the
              source system is used instead.


       ----ttiimmeeoouutt==TTIIMMEEOOUUTT
              This  option allows you to set a maximum IO timeout
              in seconds. If no data is transferred for the spec-
              ified  time then rsync will exit. The default is 0,
              which means no timeout.


       ----ddaaeemmoonn
              This tells rsync that it is to run as a rsync  dae-
              mon.  If standard input is a socket then rsync will
              assume that it is being run via inetd, otherwise it
              will  detach from the current terminal and become a
              background daemon. The daemon will read the  config
              file  (/etc/rsyncd.conf)  on each connect made by a
              client and respond to requests accordingly. See the
              rsyncd.conf(5) man page for more details.





                           24 Nov 1998                         14





rsync(1)                                                 rsync(1)


       ----ccoonnffiigg FFIILLEE
              This  specifies  an  alternate config file than the
              default /etc/rsyncd.conf.  This  is  only  relevant
              when --daemon is specified.


       ----ppoorrtt PPOORRTT
              This  specifies an alternate TCP port number to use
              rather than the default port 873.


       ----lloogg--ffoorrmmaatt==FFOORRMMAATT
              This allows you to specify exactly what  the  rsync
              client  logs to stdout on a per file basis. The log
              format is specified using the same  format  conven-
              tions as the log format option in rsyncd.conf.


       ----ssttaattss
              This  tells rsync to print a verbose set of statis-
              tics on the file transfer, allowing you to tell how
              effective  the  rsync  algorithm  is for your data.
              This option only works in conjunction with  the  -v
              (verbose) option.


       ----pprrooggrreessss
              This  option tells rsync to print information show-
              ing the progress of  the  transfer.  This  gives  a
              bored user something to watch.



EEXXCCLLUUDDEE PPAATTTTEERRNNSS
       The  exclude and include patterns specified to rsync allow
       for flexible selection of what files to transfer and  what
       files to skip.

       rsync  build  a ordered list of include/exclude options as
       specified on the command line. When a filename is  encoun-
       tered   rsync   then   checks   the   name   against  each
       exclude/include pattern in turn. The first  matching  pat-
       tern  is  acted  on. If it is an exclude pattern than that
       file is skipped. If it is an  include  pattern  then  that
       filename  is  not  skipped. If no matching include/exclude
       pattern is found then the filename is not skipped.

       The patterns themselves can take several forms. The  rules
       are:


       o      if  the  pattern starts with a / then it is matched
              against the start of the filename, otherwise it  is
              matched  against the end of the filename. Thus /foo



                           24 Nov 1998                         15





rsync(1)                                                 rsync(1)


              would match a file called foo at the  base  of  the
              tree  whereas  foo  would match any file called foo
              anywhere in the tree.


       o      if the pattern ends with a  /  then  it  will  only
              match a directory, not a file, link or device.


       o      if  the  pattern contains a wildcard character from
              the set *?[ then  regular  expression  matching  is
              applied  using  the  normal shell filename matching
              rules. Otherwise a simple string match is used.


       o      if the pattern contains a / (not counting a  trail-
              ing  /)  then  it is matched against the full file-
              name, including any leading directory. If the  pat-
              tern  doesn't  contain  a / then it is matched only
              against the final component of the filename.


       o      if the pattern starts with "+ " (a plus followed by
              a  space)  then  it  is always considered a include
              pattern, even if specified as part  of  an  exclude
              option. The "+ " part is discarded before matching.


       o      if the pattern starts with "- " (a  minus  followed
              by  a space) then it is always considered a exclude
              pattern, even if specified as part  of  an  include
              option. The "- " part is discarded before matching.


       o      if the pattern is a single exclamation mark !  then
              the  current  exclude  list  is reset, removing all
              previous exclude patterns.

       The +/- rules are most useful in exclude  lists,  allowing
       you  to  have  a  single  exclude  list that contains both
       include and exclude options.

       Here are some examples:


       o      --exclude "*.o" would exclude all filenames  match-
              ing *.o

       o      --exclude  "/foo"  would exclude a file in the base
              directory called foo

       o      --exclude "foo/" would exclude any directory called
              foo




                           24 Nov 1998                         16





rsync(1)                                                 rsync(1)


       o      --include  "*/" --include "*.c" --exclude "*" would
              include all directories and C source files.

       o      --include "foo/"  --include  "foo/bar.c"  --exclude
              "*"  would  include only foo/bar.c (the foo/ direc-
              tory must be explicitly included  or  it  would  be
              excluded by the "*")


DDIIAAGGNNOOSSTTIICCSS
       rsync  occasinally produces error messages that may seem a
       little cryptic. The one that seems to cause the most  con-
       fusion  is  "protocol  version  mismatch  -  is your shell
       clean?".

       This message is usually caused by your startup scripts  or
       remote  shell  facility  producing unwanted garbage on the
       stream that rsync is using for its transport. The  way  ot
       diagnose  this  problem  is  to run your remote shell like
       this:




          rsh remotehost /bin/true > out.dat




       then look at out.dat. If everything is  working  correctly
       then  out.dat  should  be  a zero length file. You you are
       getting the above error from rsync then you will  probably
       find  that out.dat contains some text or data. Look at the
       contents and try to work out what  is  producing  it.  The
       most  common  cause is incorrectly configued shell startup
       scripts (such as .cshrc or .profile) that  contain  output
       statements for non-interactive logins.


EENNVVIIRROONNMMEENNTT VVAARRIIAABBLLEESS
       CCVVSSIIGGNNOORREE
              The  CVSIGNORE environment variable supplements any
              ignore patterns in .cvsignore files. See the --cvs-
              exclude option for more details.


       RRSSYYNNCC__RRSSHH
              The  RSYNC_RSH  environment  variable allows you to
              override the default shell used  as  the  transport
              for  rsync.  This  can  be  used  instead of the -e
              option.






                           24 Nov 1998                         17





rsync(1)                                                 rsync(1)


       RRSSYYNNCC__PPAASSSSWWOORRDD
              Setting RSYNC_PASSWORD  to  the  required  password
              allows  you  to run authenticated rsync connections
              to a rsync daemon without user  intervention.  Note
              that  this  does  not  supply a password to a shell
              transport such as ssh.


       UUSSEERR or LLOOGGNNAAMMEE
              The USER or LOGNAME environment variables are  used
              to  determine  the default username sent to a rsync
              server.


       HHOOMMEE   The HOME environment variable is used to  find  the
              users default .cvsignore file.



FFIILLEESS
       /etc/rsyncd.conf


SSEEEE AALLSSOO
       rsyncd.conf(5)


DDIIAAGGNNOOSSTTIICCSS
BBUUGGSS
       times are transferred as unix time_t values

       file  permissions,  devices  etc are transferred as native
       numerical values

       see also the comments on the --delete option

       Please report bugs!  The  rsync  bug  tracking  system  is
       online at http://samba.anu.edu.au/rsync/


VVEERRSSIIOONN
       This man page is current for version 2.0 of rsync


CCRREEDDIITTSS
       rsync  is  distributed  under the GNU public license.  See
       the file COPYING for details.

       The     primary     ftp     site     for     rsync      is
       ftp://samba.anu.edu.au/pub/rsync.

       A WEB site is available at http://samba.anu.edu.au/rsync/

       We  would  be  delighted to hear from you if you like this



                           24 Nov 1998                         18





rsync(1)                                                 rsync(1)


       program.

       This program uses the zlib compression library written  by
       Jean-loup Gailly and Mark Adler.


TTHHAANNKKSS
       Thanks  to  Richard  Brent,  Brendan  Mackay,  Bill Waite,
       Stephen Rothwell and David Bell  for  helpful  suggestions
       and testing of rsync. I've probably missed some people, my
       apologies if I have.


AAUUTTHHOORR
       rsync was written by Andrew Tridgell and  Paul  Mackerras.
       They may be contacted via email at tridge@samba.anu.edu.au
       and Paul.Mackerras@cs.anu.edu.au








































                           24 Nov 1998                         19


