/*
*/
#include "rproxy.h"

uIP  *userList;         // user table
int  userListSize;      // current size of the user's table
int  maxUserListSize = _DEF_MAX_USERS;  // max size of the user's table
ACL  *ACList;           // access control list
int  ACListSize;        // access control list size
int  maxACLListSize = _DEF_MAX_ACL_RULES;


unsigned char RPROXY_Control_Entry [] = "RPROXY_CONTROL_ENTRY";
unsigned char RPROXY_User_Entry []    = "RPROXY_USER_ENTRY";
unsigned char CGI_PathTranslated []   = "URL";
unsigned char CGI_RemoreAddr []       = "REMOTE_ADDR";
unsigned char CGI_QueryString []      = "QUERY_STRING";
unsigned char TrustedHosts [_MAX_TRUSTED_HOSTS] [_MAX_IP_IN_STRING];
int      totalTrustedHosts = 0;
TID      tidThread = 0;
#ifndef DEBUG
long     garbageCollectionTimeout = _DEF_GARBAGECOLLECTION_TIMEOUT;
#else
long     garbageCollectionTimeout = 1000L*30L;
#endif

CommandMessage CommandsDictionary [] = {
    "ADDUSER",           rp_AddUser,
    "ADDUSERQUIET",      rp_AddUserQuiet,
    "DELETEUSER",        rp_DeleteUser,
    "VIEWUSERS",         rp_ViewUsers,
    "DELETETRUSTEDHOST", rp_DeleteTrustedHost,
    "VIEWTRUSTEDHOSTS",  rp_ViewTrustedHosts,
    "VIEWACL",           rp_ViewACL,
    "ADDTRUSTEDHOST",    rp_AddTrustedHost,
    "VERSION",           rp_Version,
    "ADDACLRULE",        rp_AddACLrule,
    "CLEARACL",          rp_ClearACL,
    "CLEARTRUSTEDHOSTS", rp_ClearTrustedHosts,
    };
int CdictSize = 12;

CommandMessage UsersDictionary [] = {
    "ADDUSERQUIET",      rp_AddUserQuiet,
    };
int UdictSize = 1;


unsigned char *Msgs [] = {
    "ACL rule succesfully added.\n",
    "ACL overflow.\n",
    "Trusted host succesfully added.\n",
    "Too many trusted hosts, table overflow.\n",
    "User succesfully added.\n",
    "Unable to add user to list.\n",
    "ACL table succesfully cleared.\n",
    "Trusted host table succesfully cleared.\n",
    "User succesfully deleted.\n",
    "Unable to find user in list.\n",
    "Rproxy version 0.1",
    "Trusted host succesfully deleted.\n",
    "Trusted host not found.\n",
    };

unsigned char *Errs [] = {
    "Too many users. Increase the size of the user's table.",
    "Can't find user request",
    "Can't find user address",
    "Unable to allocate enough memory",
    };