/*
      rp_atox - routine convert hexfdecimal text string into integer value.
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>


int rp_atox ( unsigned char *v, int maxlen )
{
    register int digits;
    register unsigned char *p;
    int  value, weight;

if ( v == NULL )              // check up input parameter
    return ( 0 );

for ( ; *v == '0' || toupper(*v) == 'X' && *v; v++ );
for ( p = v, digits = 0; *p && isxdigit(*p) && digits < maxlen; p++, digits++ );
for ( weight = 1, value = 0; digits; digits-- )
    {
    value += weight*(int)(isalpha(v[digits-1])?
                     (toupper(v[digits-1])-'A'+10):(v[digits-1]-'0'));
    weight = weight == 1 ? 16 : weight * 16;
    }
return ( value );
}
