/*
      rp_AddTrustedHost - set up trusted hosts ip address mask.
      rp_DeleteTrustedHost - delete trusted host mask.
*/
#include "rproxy.h"

static int rp_SearchHost ( unsigned char hostmask[] )
{
        register int i;

for ( i = 0; i < totalTrustedHosts; i++ )
    {
    if ( !strcmp(TrustedHosts[i],hostmask) )
        return ( i );
    }
return ( EOF );
}


void rp_AddTrustedHost ( unsigned char *handle, CommandMessage *M,
                   unsigned char Value[], long *rcode )
{
        register unsigned char *p, *pip;

for ( p = Value; *p && *p != ','; p++ );
*p = (unsigned char)'\0';
pip = Value;

rp_PutHeader ( handle, rcode );
if ( totalTrustedHosts < _MAX_TRUSTED_HOSTS )
    {
    if ( rp_SearchHost(pip) == EOF )
        {
        strncpy ( TrustedHosts [totalTrustedHosts], pip, _MAX_IP_IN_STRING-1 );
        TrustedHosts [totalTrustedHosts] [_MAX_IP_IN_STRING-1] = (unsigned char)'\0';
        ++totalTrustedHosts;
        }
    rp_write ( handle, Msgs[2], rcode );
    }
else
    {
    rp_write ( handle, Msgs[3], rcode );
    }
*rcode = HTTP_OK;
}



void rp_DeleteTrustedHost ( unsigned char *handle, CommandMessage *M,
                   unsigned char Value[], long *rcode )
{
        register unsigned char *p, *pip;
        register int n;

for ( p = Value; *p && *p != ','; p++ );
*p = (unsigned char)'\0';
pip = Value;

rp_PutHeader ( handle, rcode );
if ( (n=rp_SearchHost(pip)) != EOF )
    {
    memcpy ( &TrustedHosts[n],&TrustedHosts[n+1],
                    sizeof(TrustedHosts[0])*(totalTrustedHosts-n) );
    --totalTrustedHosts;
    rp_write ( handle, Msgs [11], rcode );
    }
else
    {
    rp_write ( handle, Msgs [12], rcode );
    }
*rcode = HTTP_OK;
}
