/*
      rp_AddACLrule - add new acl rule.
*/
#include "rproxy.h"


void rp_AddACLrule ( unsigned char *handle, CommandMessage *M,
                   unsigned char Value[], long *rcode )
{
        register unsigned char *p, *pname;

for ( p = Value; *p && *p != ','; p++ );
if ( *p )
    {
    pname = Value;              // after name we have a mask, p pints to a
    *p = (unsigned char)'\0';   // http mask
    ++p;
    rp_PutHeader ( handle, rcode );
    if ( ACListSize < maxACLListSize )
        {
        strncpy ( ACList [ACListSize].name, pname, _MAX_USERNAME_LENGTH-1 );
        ACList [ACListSize].name [_MAX_USERNAME_LENGTH-1] = (unsigned char)'\0';
        pname = p;
        for ( ; *p && *p != ','; p++ );
        if ( *p )
            {
            *p = (unsigned char)'\0';
            ++p;
            ACList [ACListSize].state = (short)atoi(p);    
            }
        else
            ACList [ACListSize].state = _ACL_RULE_PERMIT;    
        strncpy ( ACList [ACListSize].url, pname, _MAX_URL_LENGTH-1 );
        ACList [ACListSize].url [_MAX_URL_LENGTH-1] = (unsigned char)'\0';
        ++ACListSize;
        rp_write ( handle, Msgs[0], rcode );
        }
    else
        {
        rp_write ( handle, Msgs[1], rcode );
        }
    }
*rcode = HTTP_OK;
}
