/* rexx */
/*
Date: 12/17/94 - version 1
Author: Jamie Hoglund
Contact: jhoglund@cscns.com
         70244,3234@compuserve.com
Script: 1/3

 use this script to sort and pre-process summary files created
 by the uqwk offline reader program.
 
 This script and MakeSel.CMD are Non-interactive, therefore, they may 
 safely be "Detached". This is why there are 3 seperate scripts, and not
 1 main script.


-------------------------------------------------------------------------
         Note: Configuration can be done by editing this file.
               Use your editors "Search" function to search for
               lines that have the string: "@CFG" in them.
-------------------------------------------------------------------------
 
 Adjust SortPgm as needed for your system,
 
 This isn't effecient code, it'll take a while to run...
  Note: The OS/2 default sort program can only handle
       files 63k in size, you may need a differen't sort
       program than the default if you intend to work with
       larger files.

Dll's required: None!

Bugs:
  Very large summaries, summaries containing more than 10 newsgroups
  tend to confuse the display program.

                        --File Formats--
GroupFil: Seek position ^ Tagged ^ Newsgroup name CRLF

Seek Position is the file position the subject lines begin at.

Tagged is a string of "0", The length of this string = the number of
  Articles. Any position in the string that is "1" = Tagged article:
  Length("00010010") = 8 articles, fourth & seventh article is tagged.
  Length("001000000") = 9 articles, Article #3 is tagged.

  The purpose of this is to store the tag pointers, for re-starting the
  Program, you don't have to re-tag the subjects, (Other utilities
  that auto-tag/untag  articles can use this)

Newsgroup name = The actual name for the newsgroup.

SortFil: NewsgroupNumber \0x0FE Article Subject(Re\0xFD:) \0x0FE Article number

\0x0FE  = 254 separates group number from group name
  The purpose of translating delimiters is two-fold, The newsgroup Number
  is used to tell the sort program to sort in newsgroup order, and as a
  relation to the newsgroup name.

\0x0FD  = 253 Used to denote that this is a "Re: subject
  The Purpose of mangling the "Re: " is for the sort program. (otherwise all
  the RE:'s are sorted under 'R') Please Note that Re appears at the end of 
  the Subject line.

Newsgroup Number is a five digit number, preceeded by zero's.
This is for the sort program.
      
*/

/* Configuration information */
TempFil = "tempFil.tmp"     /* Temporary file                    @CFG*/
SortFil = "SortFil.Tmp"     /* this is the sorted output file    @CFG*/
SortPgm = "sort"            /* _program_ used to sort text files @CFG*/
GroupFil  = "Groups.Tmp"    /* file containing current groups    @CFG*/

Buf = Arg(1)
Parse Var Buf Infil OutFil Garbage

/* display help screen */
If Length(Infil) = 0 then
  Signal helpme

Say "Organizing file, this can take a while, please wait..."

/* Delete old files */
IF LENGTH(STREAM(TempFil,"C","QUERY EXISTS")) > 0 then
 '@DEL 'TempFil                  /* OS Dependent          @CFG */
IF LENGTH(STREAM(GroupFil,"C","QUERY EXISTS")) > 0 then
 '@DEL 'GroupFil                 /* OS Dependent          @CFG */
IF LENGTH(STREAM(SortFil,"C","QUERY EXISTS")) > 0 then
 '@DEL 'SortFil                  /* OS Dependent          @CFG */


/* Mangle the file, for the sort program */
Grp = 0
Do until Lines(Infil) = 0
   Buf = Linein(Infil)
   If Length(Buf) = 0 then
     Iterate
   if Left(Buf,1) = "*" then do  /* put group name in groups. array */
       Grp = Grp + 1
       Groups.Grp = buf
       Articles.1.grp = 0
       Articles.2.grp = "0"Stream(TempFil,"C","seek") /* get seek position */
       Iterate
   end  
   Buf = Translate(Buf," :",": ")
   Parse var buf Num Data 
   If Translate(Word(Data,1)) = "RE" then do  /* handle Re: subjects */
     Parse var Data R Data
     Data = Data":Re"D2C(253)" "
   end
/* replace spaces with an unlikely 8-bit byte, for later parse */
 Call LineOut TempFil,Right(Grp,5,"0")||D2C(254)||Translate(Data,": "," :")||D2C(254)||Num
 Articles.1.Grp = Articles.1.Grp + 1
end 

/* sort the file, format is GroupNumber,Subject,MessageNumber */
'@'SortPgm' <'TempFil' >'SortFil  /* OS dependent command @CFG */
 Call Stream TempFil,"C","Close"
'@del 'TempFil                    /* OS Dependent command @CFG */

/* output a list of groups 
SeekPosition ^ Number of lines ^ newsgroup name
*/
DO I = 1 to Grp
   /* tagged is a string of 0's representing the tagged articles. */
   tagged = COPIES("0",articles.1.i)
   Buf = Articles.2.I" "Tagged" "STRIP(TRANSLATE(Groups.I," ","*"))
   Call Lineout GroupFil,Buf
end 
Call Stream GroupFil,"C","Close"
Exit

exit
HelpMe:
Say ""
Say "Use this script to sort [process] summary files created by uqwk"
SAy ""
SAy "Usage:"
SAy "Sortsum Summary "
Say ""
Say "Summary - File generated by Uqwk"
SAy ""
exit

