/* rexx */

/* 
Date: 12/17/94 - version 1
Author: Jamie Hoglund
Contact: jhoglund@cscns.com
         70244,3234@compuserve.com
Script: 3/3 

  Create a _selection_ file from GroupFil and SortFil
 
  part of 3 Rexx files designed to aid in selecting from Summary
  Files created by the uqwk Offline reader program.

-------------------------------------------------------------------------
         Note: Configuration can be done by editing this file.
               Use your editors "Search" function to search for
               lines that have the string: "@CFG" in them.
-------------------------------------------------------------------------

Use this program to create a file to upload to Uqwk for selecting articles.

GroupFil - Sortfil Seek Position, Tagged articles, Newsgroup name

SortFil - Newsgroup number, Article text, Message number

Outfil - this is created in the format that uqwk accepts.
         *** newsgroup.name
         0000:
         0001:
 
         *** newsgroup.name
         ...

Known Bugs:
    In this script, I don't know of any. ReadSum.CMD contains a few though.
    If you find any, or fix any, please let me know.
*/

/* Configuration information */
SortFil = "SortFil.Tmp"      /*Article data, Output by Sortsum.CMD        @CFG*/
GroupFil  = "Groups.Tmp"     /*Groups and Tag info, Output by Readsum.CMD @CFG*/
OutFil    = "Selected.sel"   /* File for uploading to uqwk -Output        @CFG*/

/* make sure files exist */
If Length(Stream(Sortfil,"C","Query exists")) = 0 then do
  Say SortFil"  - Does not exist, must run sortsum.cmd, Readsum.cmd or re-configure"
  exit
end
If Length(Stream(Groupfil,"C","Query exists")) = 0 then do
  Say GroupFil"  - Does not exist, must run sortsum.cmd, Readsum.cmd or re-configure"
  exit
end

/* Main processing loop */
Say "Creating a selection file for uqwk, Please wait..."
Current_Group = 0
Do Until Lines(Groupfil) = 0
  Gbuf = Linein(Groupfil)
  Current_Group = Current_Group + 1
  
  Parse Var Gbuf Sp TagDat GrpName      /* Seek Pos. Tag info, Group name */
  Group.Current_Group = GrpName         /* Save group name */

  Call Read_Id       /* Read Message Id's into MessageId.Current_Group.[n] */
END

DO I = 1 to Current_Group
   Call LineOut Outfil,"*** "Group.I          /* Newsgroup name */

   DO T = 1 to MessageID.I.0                 /* Output selected articles */
     Call Lineout Outfil,MessageID.I.t":"
   end 

   Call Lineout OutFil,""       /* Blank line at end of list */
end

/* close files & exit */
Call Stream GroupFil,"C","Close"
Call Stream outFil,"C","Close"
Call Stream SortFil,"C","Close"
exit

/* 
   read all tagged article numbers from SortFil, and produce a list of
   Selected articles.

   SP
   TagDat
   -----
   MessageID.Current_Group.[n] = List of Message ID's
   MessageID.Current_Group.0   = Number of articles selected.
*/
Read_Id:
A = 0                           /* article pointer */
MessageId.Current_Group.0 = 0   /* Number of selected articles from Newsgroup */
DO I = 1 to LENGTH(TagDat)
  Abuf = TRANSLATE(Linein(SortFil),D2C(254)" "," "D2C(254))  /* swap spaces */
  If Substr(TagDat,I,1) = "1" then do
    A = A + 1
    Parse Var Abuf Group Dat ID
    MessageId.Current_Group.A = ID    
  end
END
MessageId.Current_Group.0 = A /* Store the number of selected articles */
Return

