/*
 * ICQHost.CMD	Update the hosts file when the user goes online/offline
 *
 * pwICQ macro: ICQHost %n %d %i
 *
 */

parse arg nick mode addr

 ok      = RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs')
 ok      = SysLoadFuncs()

 etcpath = Value( 'ETC',,'OS2ENVIRONMENT' )
 tmppath = Value( 'TMP',,'OS2ENVIRONMENT' )
 hfile   = etcpath || '\HOSTS.'
 semaf   = tmppath || '\ICQHOST.SMF' 

 do while lineout(semaf,"ICQHost.CMD semaphore") <> 0
 end

 if mode = 1 
    then ok = addhost(nick,addr)
    else ok = addhost(nick,"")

 ok = stream(semaf,'c','close')
 '@del '||semaf||' > NUL: 2> NUL:'

return ok

addhost:

parse arg nick, addr

   say nick||' = '||addr

   tfile = SysTempFileName(tmppath || '\HST?????.TMP','?')

   do while Lines( hfile ) > 0

       lin  = LineIn( hfile )
       ip   = word(lin,1)
       host = word(lin,2)

       if host <> nick 
          then ok  = lineout(tfile,ip||" "||host)

   end

   if(addr <> "")
      then ok = lineout(tfile,strip(addr)||" "||strip(nick))


   ok = stream(hfile,'c','close')
   ok = stream(tfile,'c','close')

   '@copy '||tfile||' '||hfile||' > NUL:'
   '@del  '||tfile||' > nul:'

return rc

