/* ASC2ADR.CMD -- Convert ascii file to Post Road Mailer address book.    */
/* Parameters: ascii_file < address_book_file >                           */
/* (c) Copyright, 1995, InnoVal System Solutions, Inc., Tom Springall     */

 /* Constants */
 CRLF = X2C('0D0A')

 /* Possible code values: */
 SAVE_FILECARDS        = X2C('0700') ; SAVE_GROUPS           = X2C('0800')
 SAVE_GNAME            = X2C('2000') ; SAVE_ADDRESSES        = X2C('2200')
 SAVE_GADDRESS         = X2C('2400') ; SAVE_BOOK_NAME        = X2C('3000')
 SAVE_FIRST            = X2C('3500') ; SAVE_CNAME            = X2C('4000')
 SAVE_COMPANY          = X2C('4500') ; SAVE_EMAIL1           = X2C('5000')
 SAVE_EMAIL2           = X2C('7500') ; SAVE_EMAIL3           = X2C('7600')
 SAVE_EMAIL4           = X2C('7700') ; SAVE_EMAIL5           = X2C('7800')
 SAVE_PHONE1           = X2C('8000') ; SAVE_PHONE2           = X2C('8500')
 SAVE_FAX              = X2C('9000') ; SAVE_ADDRESS          = X2C('9500')
 SAVE_NICKNAME1        = X2C('0001') ; SAVE_NICKNAME2        = X2C('0101')
 SAVE_NICKNAME3        = X2C('0201') ; SAVE_NICKNAME4        = X2C('0301')
 SAVE_NICKNAME5        = X2C('0401')

 Arg filespec outfile
 If filespec = '' | Pos('?',filespec) <> 0 then Signal Help

 If Pos('.', filespec) = 0 then filespec = filespec || '.ASC'
 If Stream(filespec,'C','QUERY EXISTS') = '' then Signal Err1

 /* Input extension need not be .ASC, but cannot be .ADR */
 Parse var filespec file '.' ext
 If ext = 'ADR' then Signal Err2

 If outfile = '' then do
   /* Default output file: current directory, same filename, extension .ADR */
   filename = SubStr(file, LastPos('\',file) + 1)
   outfile = filename || '.ADR'
   end
 Else
   If Pos('.', outfile) = 0 then outfile = outfile || '.ADR'

 If '' <> Stream(outfile,'C','QUERY EXISTS') then do
   Say outfile 'already exists. Do you want to replace it? (Y/n)'
   Pull ans
   If Left(ans,1) <> 'N' then '@ERASE' outfile
   Else Exit 1
   end

 /* Check for address book name and write to output file. */
 lin = LineIn(filespec)
 /* must be in the first row */
 If Left(lin,11) <> '<BOOK_NAME>' then Signal Err3
 Call SaveIt SAVE_BOOK_NAME, Substr(lin,12)

 i = 1 ; activity = 0 ; cards = 0 ; groups = 0 ; data. = ''

 /* Read in entire input file to memory. */
 Do While Lines(filespec) > 0

   lin = LineIn(filespec)
   first = Left(lin,1)
   Select
     /* blank line means new address or group */
     When first = ' ' & activity > 0 then do
       /* check values since last blank, if any */
       Call CheckI
       activity = 0
       end /* of When */
     When first = '<' then do                /* it's a tag */
       Parse var lin '<' tag '>' valu
       Select
         When tag = 'COMMENTS' then do       /* gotta append these */
           If data.i.COMMENTS <> '' then
              data.i.COMMENTS = data.i.COMMENTS || CRLF
           data.i.COMMENTS = data.i.COMMENTS || valu
           end
         When tag = 'GADDRESS' then do       /* gotta count these */
           j = data.i.addresses
           If j = '' then j = 1
           Else j = j + 1
           data.i.GADDRESS.j = valu
           data.i.addresses = j
           end
         Otherwise                           /* otherwise, just save value */
           /* assign valu to data.i.field */
           x = Value('data.i.' || tag, valu)
         end /* of Select */
       activity = 1    /* indicate that something has been saved at level i */
       end
     Otherwise Nop                          /* skip comments, etc. */
     end /* of Select */
   end /* of Do While */
 Call LineOut filespec                      /* close input file */

 /* entire file read in. check if last i has anything in it */
 If i <> 0 & activity > 0 then Call CheckI

 /* save card and group counts */
 Call SaveIt SAVE_FILECARDS, MakeNum(cards)
 Call SaveIt SAVE_GROUPS, MakeNum(groups)

 /* write out each level (each level contains an address page or group) */
 Do j = 1 to i - 1
   Select
     When typ.j = 'CARD' then do
       /* address page must start with last name field */
       Call SaveIt SAVE_CNAME, data.j.LAST_NAME  /* must be 1st */
       Call SaveIt SAVE_FIRST, data.j.FIRST_NAME
       Call SaveIt SAVE_COMPANY, data.j.ORGANIZATION
       Call SaveIt SAVE_EMAIL1, data.j.EMAIL1
       Call SaveIt SAVE_EMAIL2, data.j.EMAIL2
       Call SaveIt SAVE_EMAIL3, data.j.EMAIL3
       Call SaveIt SAVE_EMAIL4, data.j.EMAIL4
       Call SaveIt SAVE_EMAIL5, data.j.EMAIL5
       Call SaveIt SAVE_PHONE1, data.j.PHONE1
       Call SaveIt SAVE_PHONE2, data.j.PHONE2
       Call SaveIt SAVE_FAX, data.j.FAX
       Call SaveIt SAVE_ADDRESS, data.j.COMMENTS
       Call SaveIt SAVE_NICKNAME1, data.j.NICKNAME1
       Call SaveIt SAVE_NICKNAME2, data.j.NICKNAME2
       Call SaveIt SAVE_NICKNAME3, data.j.NICKNAME3
       Call SaveIt SAVE_NICKNAME4, data.j.NICKNAME4
       Call SaveIt SAVE_NICKNAME5, data.j.NICKNAME5
       end /* of When */

     When typ.j = 'GROUP' then do         /* it's a group */
       /* group must begin with name of group */
       Call SaveIt SAVE_GNAME, data.j.GROUP_NAME
       /* number of addresses in group */
       Call SaveIt SAVE_ADDRESSES, MakeNum(data.j.addresses)
       /* then, each address */
       Do k = 1 to data.j.addresses
         Call SaveIt SAVE_GADDRESS, data.j.GADDRESS.k
         end
       end /* of When */
     Otherwise Nop
     end /* of Select */
   end /* of Do j... */

 Call CharOut outfile                /* close output file */

 Say ''
 Say 'The address book version of' filespec
 Say ' is now in' outfile
 Say ''
 Say 'It contains' cards 'name(s),' groups 'group(s).'
 Say ''

 Exit

/*----------------------------------------------------------------------*/
HELP:

 Say ''
 Say 'ASC2ADR.CMD converts a text file to a Post Road Mailer address book.'
 Say ''
 Say 'Syntax is:  ASC2ADR <path>filename.ASC < filename.ADR >'
 Say ''
 Say 'The default output file has the same filename as the text file and'
 Say 'an .ADR extension, i.e., filename.ADR'
 Say ''
 Say 'See ADR2ASC.DOC for info on the required input file format.'
 Say ''
 Exit

/*---------------------------------------------------------------------------*/
SAVEIT: Procedure Expose outfile

   /* write field to output file */
   code = Left(Arg(1),4,D2C(0))
   valu = Arg(2)
   len = MakeNum(Length(valu))

   If 0 <> CharOut(outfile, code || len || valu) then Signal Err4

   Return

/*---------------------------------------------------------------------------*/
MAKENUM: Procedure   /* Convert integer into 4-byte Intel format */

   Return Intel(D2C(Arg(1),4))

/*---------------------------------------------------------------------------*/
INTEL:  Procedure    /* Swaps bytes in an Intel 2 or 4 byte number. */
 Parse arg x

 If Length(x) = 2 then
   Return Right(x,1) || Left(x,1)

 Else
   Return Intel(Right(x,2)) || Intel(Left(x,2))

/*---------------------------------------------------------------------------*/
CHECKI: Procedure Expose i data. cards groups typ.

  /* Check to see if any real stuff collected at the current level (i) */
  /* is it a card? */
  If data.i.LAST_NAME <> '' | data.i.ORGANIZATION <> '' then do
    typ.i = 'CARD'
    cards = cards + 1
    i = i + 1
    end
  Else
    If data.i.GROUP_NAME <> '' then do /* is it a group? */
      typ.i = 'GROUP'
      groups = groups + 1
      i = i + 1
      end
    Else
      data.i. = ''               /* false alarm. reset */
  Return

/*---------------------------------------------------------------------------*/
ERR1:
 Say 'File' filespec 'not found.'
 Exit 1
/*---------------------------------------------------------------------------*/
ERR2:
 Say 'The input file' filespec 'should not have an address book (.ADR) extension.'
 Exit 1
/*---------------------------------------------------------------------------*/
ERR3:
 Say 'File' filespec 'does not appear to be in ascii address book format.'
 Call LineOut filespec
 Exit 1
/*---------------------------------------------------------------------------*/
ERR4:
 Say 'Error writing to file' outfile
 Call LineOut filespec
 Call CharOut outfile
 Exit 1
/*---------------------------------------------------------------------------*/
