/* ADR2ASC.CMD -- Convert Post Road Mailer address book to ascii file.    */
/* Parameters: address_book_file  < ascii_output_file >                   */
/* address_book_file must have ADR extensionfilename.                     */
/* Default output file has same filename as ADR and extension ASC.        */
/* (c) Copyright, 1995, InnoVal System Solutions, Inc., Tom Springall     */

 default = 'NOBLANKS'
 /* Default is to suppress blank fields in the output file. If you want
    the blank fields included, de-comment the next line. */
 /* default = 'BLANKS' */

 /* Constants */
 CRLF = X2C('0D0A')

 /* Possible code values: */
 SAVE_FILECARDS        = X2C('0700') ; SAVE_GROUPS           = X2C('0800')
 SAVE_GNAME            = X2C('2000') ; SAVE_ADDRESSES        = X2C('2200')
 SAVE_GADDRESS         = X2C('2400') ; SAVE_BOOK_NAME        = X2C('3000')
 SAVE_FIRST            = X2C('3500') ; SAVE_CNAME            = X2C('4000')
 SAVE_COMPANY          = X2C('4500') ; SAVE_EMAIL1           = X2C('5000')
 SAVE_EMAIL2           = X2C('7500') ; SAVE_EMAIL3           = X2C('7600')
 SAVE_EMAIL4           = X2C('7700') ; SAVE_EMAIL5           = X2C('7800')
 SAVE_PHONE1           = X2C('8000') ; SAVE_PHONE2           = X2C('8500')
 SAVE_FAX              = X2C('9000') ; SAVE_ADDRESS          = X2C('9500')
 SAVE_NICKNAME1        = X2C('0001') ; SAVE_NICKNAME2        = X2C('0101')
 SAVE_NICKNAME3        = X2C('0201') ; SAVE_NICKNAME4        = X2C('0301')
 SAVE_NICKNAME5        = X2C('0401')

 Arg filespec outfile
 If filespec = '' | Pos('?',filespec) <> 0 then Signal Help

 If Pos('.', filespec) = 0 then filespec = filespec || '.ADR'
 If Stream(filespec,'C','QUERY EXISTS') = '' then Signal Err1

 /* Input file must have ADR extension */
 Parse var filespec file '.' ext
 If ext <> 'ADR' then Signal Err2

 If outfile = '' then do
   /* Default output file will be filename.ASC in the current directory */
   filename = SubStr(file, LastPos('\',file) + 1)
   outfile = filename || '.ASC'
   end
 Else                /* make sure it has an extension */
   If Pos('.', outfile) = 0 then
     outfile = outfile || '.ASC'

 If '' <> Stream(outfile,'C','QUERY EXISTS') then do
   Say outfile 'already exists. Do you want to replace it? (Y/n)'
   Pull ans
   If Left(ans,1) <> 'N' then '@ERASE' outfile
   Else Exit 1
   end

 /* Get address book name and write to output file. Must be 1st field. */
 If SAVE_BOOK_NAME <> GetCodeLen() then Signal Err3
 valu = CharIn(filespec,,len)
 If 0 <> LineOut(outfile, '<BOOK_NAME>' || valu) then Signal Err4

 valu = '* Created from Post Road Mailer address book:'
 If 0 <> LineOut(outfile, valu filespec) then Signal Err4

 typ = '' ; cards = 0 ; groups = 0 ; data. = ''

 /* Read in .ADR file. Fields for an address page or a group follow the */
 /* last_name or group_name field, but may be in any order. Don't write */
 /* page or group to output until all fields are collected.             */

 Do While Chars(filespec) > 0

   /* read in code value and length of field */
   code = GetCodeLen()                  /* len is also returned */
   /* read in value of field */
   valu = CharIn(filespec,,len)

   Select                               /* handle various code values */
     When code = SAVE_FILECARDS then
       filecards = C2D(Intel(valu))     /* number of cards in file */
     When code = SAVE_GROUPS then
       filegroups = C2D(Intel(valu))    /* number of groups in file */

     When code = SAVE_GNAME then do     /* beginning of a new group */
       Call ProcessPrior typ            /* write prior group or page */
       typ = 'GROUP'
       groups = groups + 1
       data. = ''
       addresses = 0                    /* my count of addresses in group */
       data.GROUP_NAME = valu
       end

     When code = SAVE_ADDRESSES then
       data.FILEADDRS = C2D(Intel(valu)) /* number of addresses in group */

     When code = SAVE_GADDRESS then do   /* a group address */
       addresses = addresses + 1
       data.GADDRESS.addresses = valu
       end

     When code = SAVE_CNAME then do      /* beginning of a new address page */
       Call ProcessPrior typ             /* write prior page or group */
       typ = 'CARD'
       cards = cards + 1
       data. = ''
       data.LAST_NAME = valu             /* last name */
       end

     When code = SAVE_FIRST then data.FIRST_NAME = valu
     When code = SAVE_COMPANY then data.ORGANIZATION = valu
     When code = SAVE_EMAIL1 then data.EMAIL1 = valu
     When code = SAVE_EMAIL2 then data.EMAIL2 = valu
     When code = SAVE_EMAIL3 then data.EMAIL3 = valu
     When code = SAVE_EMAIL4 then data.EMAIL4 = valu
     When code = SAVE_EMAIL5 then data.EMAIL5 = valu
     When code = SAVE_PHONE1 then data.PHONE1 = valu
     When code = SAVE_PHONE2 then data.PHONE2 = valu
     When code = SAVE_FAX then data.FAX = valu
     When code = SAVE_ADDRESS then data.COMMENTS = valu
     When code = SAVE_NICKNAME1 then data.NICKNAME1 = valu
     When code = SAVE_NICKNAME2 then data.NICKNAME2 = valu
     When code = SAVE_NICKNAME3 then data.NICKNAME3 = valu
     When code = SAVE_NICKNAME4 then data.NICKNAME4 = valu
     When code = SAVE_NICKNAME5 then data.NICKNAME5 = valu

     Otherwise Nop

     End /* of Select */

   end /* of Do While */

 Call ProcessPrior typ            /* write last page or group */

 Call CharOut filespec            /* close files */
 Call LineOut outfile

 Say ''
 Say 'The ASCII version of' filespec
 Say ' is now in' outfile
 Say ''
 Say 'It contains' cards 'name(s),' groups 'group(s).'
 Say ''

 /* Check my counts against file counts */
 If cards <> filecards then
   Say 'Name count from file' filespec 'is' filecards || '.'
 If groups <> filegroups then
   Say 'Group count from file' filespec 'is' filegroups || '.'

 Exit                            /* all done. */

/*----------------------------------------------------------------------*/
HELP:
 Say ''
 Say 'ADR2ASC.CMD converts a Post Road Mailer address book to a text file.'
 Say ''
 Say 'Syntax is:  ADR2ASC <path>filename.ADR < ascii_file >'
 Say ''
 Say 'If output file is not specified, the text file will be created in'
 Say 'the current directory, have the same filename as the address book'
 Say 'and an .ASC extension, i.e., filename.ASC'
 Say ''
 Say 'A description of the output file format is in ADR2ASC.DOC.'
 Say ''
 Exit
/*---------------------------------------------------------------------------*/
GETCODELEN: Procedure Expose filespec len

   /* get 1st 2 words of each record: code, length */
   w1w2 = CharIn(filespec,,8)

   /* save length of what follows (in bytes) */
   len = C2D(Intel(Substr(w1w2,5,2)))

   /* return code for field type */
   Return Left(w1w2,2)

/*---------------------------------------------------------------------------*/
INTEL:  Procedure    /* Swaps bytes in an Intel 2 or 4 byte number. */
 Parse arg x

 If Length(x) = 2 then
   Return Right(x,1) || Left(x,1)

 Else
   Return Intel(Right(x,2)) || Intel(Left(x,2))

/*---------------------------------------------------------------------------*/
PROCESSPRIOR:
 /* Writes field for prior record to the output file. */
 Arg typ

 Select
   When typ = 'CARD' then do            /* address page */

     /* blank line between records */
     Call LineOut outfile, ''

     /* Include blank fields in output? */
     blankdef = default = 'BLANKS'

     /* write records in sequence shown in address book */
     Call LineOut outfile, '<LAST_NAME>' || data.LAST_NAME
     If blankdef | data.FIRST_NAME <> '' then
       Call LineOut outfile, '<FIRST_NAME>' || data.FIRST_NAME
     If blankdef | data.ORGANIZATION <> '' then
       Call LineOut outfile, '<ORGANIZATION>' || data.ORGANIZATION
     If blankdef | data.EMAIL1 <> '' then
       Call LineOut outfile, '<EMAIL1>' || data.EMAIL1
     If blankdef | data.NICKNAME1 <> '' then
       Call LineOut outfile, '<NICKNAME1>' || data.NICKNAME1
     If blankdef | data.EMAIL2 <> '' then
       Call LineOut outfile, '<EMAIL2>' || data.EMAIL2
     If blankdef | data.NICKNAME2 <> '' then
       Call LineOut outfile, '<NICKNAME2>' || data.NICKNAME2
     If blankdef | data.EMAIL3 <> '' then
       Call LineOut outfile, '<EMAIL3>' || data.EMAIL3
     If blankdef | data.NICKNAME3 <> '' then
       Call LineOut outfile, '<NICKNAME3>' || data.NICKNAME3
     If blankdef | data.EMAIL4 <> '' then
       Call LineOut outfile, '<EMAIL4>' || data.EMAIL4
     If blankdef | data.NICKNAME4 <> '' then
       Call LineOut outfile, '<NICKNAME4>' || data.NICKNAME4
     If blankdef | data.EMAIL5 <> '' then
       Call LineOut outfile, '<EMAIL5>' || data.EMAIL5
     If blankdef | data.NICKNAME5 <> '' then
       Call LineOut outfile, '<NICKNAME5>' || data.NICKNAME5
     If blankdef | data.PHONE1 <> '' then
       Call LineOut outfile, '<PHONE1>' || data.PHONE1
     If blankdef | data.PHONE2 <> '' then
       Call LineOut outfile, '<PHONE2>' || data.PHONE2
     If blankdef | data.FAX <> '' then
       Call LineOut outfile, '<FAX>' || data.FAX
     If blankdef | data.COMMENTS <> '' then
       /* one output row per line of comments */
       Do Until data.COMMENTS = ''
         Parse var data.COMMENTS left (CRLF) data.COMMENTS
         Call LineOut outfile, '<COMMENTS>' || left
         end /* of Do Until */

     end /* of When */

   When typ = 'GROUP' then do        /* group of addresses */

     /* blank line between records */
     Call LineOut outfile, ''

     Call LineOut outfile, '<GROUP_NAME>' || data.GROUP_NAME

     If addresses <> data.FILEADDRS then do  /* check my count vs file */
       Say 'For group' data.GROUP_NAME || ':'
       Say ' file count of addresses is' data.FILEADDRS
       Say ' but' addresses 'addresses found.'
       Say ''
       end

     Do i = 1 to addresses
       Call LineOut outfile, '<GADDRESS>' || data.GADDRESS.i
       end

     end /* of When */

   Otherwise Nop

   End /* of Select */

 Return

/*---------------------------------------------------------------------------*/
ERR1:
 Say 'File' filespec 'not found.'
 Exit 1
/*---------------------------------------------------------------------------*/
ERR2:
 Say 'File' filespec 'does not have an address book (.ADR) extension.'
 Exit 1
/*---------------------------------------------------------------------------*/
ERR3:
 Say 'File' filespec 'does not appear to be an address book.'
 Call CharOut filespec
 Exit 1
/*---------------------------------------------------------------------------*/
ERR4:
 Say 'Error writing to file' outfile
 Call CharOut filespec
 Call LineOut outfile
 Exit 1
/*---------------------------------------------------------------------------*/
