/* ----------- Auto forward utility for the Post Road Mailer --------------- */
/* The author or InnoVal System Solutions can not be held responsible        */
/* for damage that might occur when using this program. Use at your own risk.*/
/* (c)1995, InnoVal Systems Solutions, Inc. Bill Springall <postsvc@ibm.net> */

Trace 'O'

ARG fn
fn = Stream(fn,'C','QUERY EXISTS')
if fn = '' then Signal ERR1
prmpath = Left(fn,Lastpos('\',fn))

initfile = 'prmaf102.cfg'

parse source . . initpth
initpth = Left(initpth,Lastpos('\',initpth))
initfile = initpth || initfile
initfile = Stream(initfile,'C','QUERY EXISTS')
if initfile = '' then Signal ERR2

/* ---------------- Load init contents into variables ---------------------*/

Writ = 0;init. = ''
Do While Lines(initfile) <> 0
    lininit = Linein(initfile)
    L = translate(lininit)
    Select
       When Left(L,10) = '<SRCH_STR>' then
          init.srchstr = Substr(L,11)          /* init.srchstr */
       When Left(L,10) = '<SRCH_FLD>' then do
           Parse var L '<SRCH_FLD>' val .
           If val = 'TO' | val = 'FROM' | val = 'SUBJECT' | val = 'REPLY-TO' then
              init.srchfld = val
           Else Signal ERR4
       End /* end of When - do */
       When Left(L,8) = '<FWD_TO>' then
          init.fwdto = Substr(lininit,9)       /* init.fwdto */
       When Left(L,10) = '<FWD_FROM>' then
          init.fwdfrom = Substr(lininit,11)    /* init.fwdfrom */
       When Left(L,13) = '<FWD_REPLYTO>' then
          init.fwdrep = Substr(lininit,14)     /* init.fwdrep */
       When Left(L,13) = '<FWD_SUBJECT>' then
          init.fwdsub = Substr(lininit,14)     /* init.fwdsub */
       Otherwise NOP
    End    /* End of Select */
End /* End of While Loop */
Call Lineout initfile   /* Close init file */

/* --------- Time to see if the search string is in this file --------------*/

If init.srchstr = '' then   /* If search string is blank then found = 1 and */
   found = 1                /* all mail is forwarded */
Else found = 0

Do While Lines(fn) <> 0 & found <> 1
   Lin = Linein(fn)
   If Lin = '' then EXIT    /* Past header and search string is not found   */
   Select
     When Left(lin,6) = 'From: ' & init.srchfld = 'FROM' then do
          ln = translate(lin)
          If Pos(init.srchstr,ln) > 0 then
                found = 1
          Else EXIT           /* String not found in search field (FROM) */
     End
     When Left(lin,4) = 'To: ' & init.srchfld = 'TO' then do
          ln = translate(lin)
          If Pos(init.srchstr,ln) > 0 then
                found = 1
          Else EXIT           /* String not found in search field (TO) */
     End /* end of when */
     When Left(lin,9) = 'Subject: ' & init.srchfld = 'SUBJECT' then do
          ln = translate(lin)
          If Pos(init.srchstr,ln) > 0 then
                found = 1
          Else EXIT           /* String not found in search field (SUBJECT) */
     End /* End of when */
     When Left(lin,10) = 'Reply-To: ' & init.srchfld = 'REPLY-TO' then do
          ln = translate(lin)
          If Pos(init.srchstr,ln) > 0 then
                found = 1
          Else EXIT           /* String not found in search field (REPLY-TO) */
     End  /* End of when */
     Otherwise NOP
   End /* End of Select */
End /* End of While loop */
Call lineout fn
If found = 0 then Signal ERR5

/* ------------ Time to gather the header from the original ---------------- */

Lin = '';ln = '';data. = ''
Do While Lines(fn) <> 0
    Lin = Linein(fn)
    Select
       When Left(lin,9) = 'Subject: ' then
           If data.subj = '' then
              data.subj = Substr(lin,10)
       When Left(lin,6) = 'From: ' then
           If data.from = '' then
              data.from = Substr(lin,7)
       When Left(lin,4) = 'To: ' then data.to = Substr(lin,5)
       When Left(lin,10) = 'Reply-To: ' then
           If data.rep = '' then           /* For messages with more than one*/
              data.rep = Substr(lin,11)    /* reply-to field. ie. listserv digests */
       Otherwise NOP
    End /* End of Select */
End /* End of While */
Call lineout fn

fnlfrom = '';fnlsubj = '';fnlrep = ''
/* See if we use the original variables(in fn) or the user-spec'd ones(init) */
If Left(init.fwdfrom, 1) = '*' then
    fnlfrom = data.from
Else fnlfrom = init.fwdfrom
If Left(init.fwdrep, 1) = '*' then
    fnlrep = data.rep
Else fnlrep = init.fwdrep
If Left(init.fwdsub, 1) = '*' then
    fnlsubj = data.subj
Else fnlsubj = init.fwdsub

/* ------ Strip pers. name and email from 'from' field (nlx editing) ------ */

personal = '';email = ''
lessthan = Pos('<',fnlfrom)
paren = Pos('(',fnlfrom)
If lessthan <> 0 then
   parse var fnlfrom personal '<' email '>' .
If paren <> 0 then
   parse var fnlfrom personal '(' email ')' .

/* -----------------   Time to go to work on Sndnotes   -------------------- */

HRT = D2C('03');FFACE = D2C('02');Face = D2C('01');Excl = D2C('19');Quotes = D2C('34');Writ = 0
/* The above are binary chars that PRM uses in the SNDNOTES files */

sndnote = prmpath || 'sndnotes.nlg'
Call Lineout sndnote, '<<NEW NOTE>>'
Call Lineout sndnote, excl || face || init.fwdto
Call lineout sndnote, 'From: ' || fnlfrom
Call lineout sndnote, 'Reply-To: ' || fnlrep
Call lineout sndnote, 'Subject: ' || fnlsubj
Call lineout sndnote, ''
Call lineout sndnote, excl || quotes
Do While Lines(fn) <> 0 & writ <> 1
    lin = Linein(fn)
    If lin = '' then do
       writ = 1
       Do While Lines(fn) <> 0
           ick = Linein(fn)
           Call lineout sndnote, ick
       end /* end of inner while loop */
    end /* end of if then */
end /*end of while loop */
Call lineout sndnote, ''
Call lineout sndnote, excl || '#'      /* These are binary tags used by PRM */
Call lineout sndnote, ''
Call lineout sndnote, excl || '$'
Call lineout sndnote, ''
Call lineout sndnote, excl || '%'
Call lineout sndnote, ''
Call lineout sndnote

/* Append forwarded tag at end of original message to facilitate filtering */

Call lineout fn, '** Forwarded to' init.fwdto ' by PRM AF utility **'
Call lineout fn

/* --------------- Time to do some sndnotes.nlx editing -------------------*/
/* First see if it exists, if it doesn't then it will be created and the   */
/* "Notes waiting to be sent" tag will placed on top                       */

sndnlx = prmpath || 'sndnotes.nlx'
If Stream(sndnlx,'C','QUERY EXISTS') = '' then
  Call Lineout sndnlx,face || 'Notes waiting to be sent'

If personal = '' then
   personal = fnlfrom
If email = '' then
   email = fnlfrom

tmfor = time();tmfor = Left(tmfor,5)
dtfor = Date('O')
dtstring = '0' || dtfor || tmfor || 'EST'
ln1 = Left(init.fwdto, 49)
ln2 = Left(dtstring, 29)
lnend = '0   ' || personal || face || fnlsubj || face || face || email || fface || init.fwdto || hrt
Call Lineout sndnlx, ' ' || ln1 || ln2 || lnend
Call Lineout sndnlx
Exit

/* -------------------------- Error Messages ------------------------------- */

ERR1: say 'Cannot find passed file - '|| fn; Exit
ERR2: say 'Cannot find init file - ' || initfile;Exit
ERR4: say 'Search field must be TO, FROM, SUBJECT or REPLY-TO.';Exit
ERR5: say 'Search field is not in this file.';Exit
