/*--------------------------------------------------------------------*/
/*       Program:    pnews.cmd                                        */
/*       Author:     Snuffles P. Bear                                 */
/*                   Kendra Electronic Wonderworks                    */
/*                   P.O. Box 132                                     */
/*                   Arlington, MA 02174                              */
/*                                                                    */
/*       Function:   Quick and (very) dirty OS/2 posting program      */
/*                   for UUPC/extended                                */
/*--------------------------------------------------------------------*/

/*  This file modified and renamed to POSTNEWS.CMD for use with TIN   */
/*  for OS/2.   */

/*--------------------------------------------------------------------*/
/*       Note: This program doesn't support prefixed keywords in      */
/*             the UUPC/extended RC file, and further presumes you    */
/*             always want your posts saved for posterity and/or      */
/*             law suits.  In truth, this program was a quickly       */
/*             hacked prototype and no more or less.                  */
/*                                                                    */
/*             Did we mention it also ALWAYS tacks on your .sig       */
/*             file?  Or that it may not work on multiple disk        */
/*             systems?                                               */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/*       Changes Copyright (c) 1989-1994 by Kendra Electronic         */
/*       Wonderworks.                                                 */
/*                                                                    */
/*       All rights reserved except those explicitly granted by       */
/*       the UUPC/extended license agreement.                         */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/*                          RCS Information                           */
/*--------------------------------------------------------------------*/

/*
 *    $Id: pnews.cmd 1.2 1994/02/13 04:56:14 ahd Exp $
 *
 *    $Log: pnews.cmd $
 *       Revision 1.2  1994/02/13  04:56:14  ahd
 *       Add RCS log field
 *
 */

/* Changed to POSTNEWS.CMD by John D. Carmack to work with OS/2 TIN */
/* Notice it is mostly just taking stuff out of the original        */

signal on novalue
'@echo off'                             /* Disable OS/2 command echo  */

/*--------------------------------------------------------------------*/
/*                    Get environment information                     */
/*--------------------------------------------------------------------*/

uupcusrrc    = value( 'UUPCUSRRC',,'OS2ENVIRONMENT');

domain       = getuupc("fromDomain", getuupc("domain"));
editor       = getuupc("OS2.editor",,uupcusrrc);
home         = getuupc("home",,uupcusrrc);
mailbox      = getuupc("mailbox",,uupcusrrc);
name         = getuupc("name",,uupcusrrc);
organization = getuupc("organization","NOT!",uupcusrrc);
signature    = getuupc("signature","NOT!",uupcusrrc);
tempdir      = getuupc("TEMPDIR" )

/*--------------------------------------------------------------------*/
/*                      Create a posting header                       */
/*--------------------------------------------------------------------*/

dfile        = Arg(1);
say dfile

/*--------------------------------------------------------------------*/
/*              Save the file whether or not we post it               */
/*--------------------------------------------------------------------*/

savefile = home || '\' || 'USENETPR.SPB'

call lineout savefile,copies('01'x,19)
call lineout savefile,'Date:' left(date('w'),3) || ',' date() time() 'LOCAL';
do while(lines(dfile))
   call lineout savefile,linein(dfile)
end

call lineout savefile

say 'Copy saved in' savefile;

/*--------------------------------------------------------------------*/
/*       Determine if the user really wants to post the article       */
/*--------------------------------------------------------------------*/

if signature <> 'NOT!' then
do;
   if pos( '\' , signature ) == 0 then
      signature = home || '\' || signature;

   call lineout dfile,'--';         /* Terminate body of message     */
   do while( lines(signature) )
      call lineout dfile,linein(signature)
   end;

   call lineout dfile;              /* Close the file          */
end;

/*--------------------------------------------------------------------*/
/*                          Execute the post                          */
/*--------------------------------------------------------------------*/

'inews <' dfile;

/*--------------------------------------------------------------------*/
/*                   Delete our work file and exit                    */
/*--------------------------------------------------------------------*/

/* call sysfiledelete dfile; */
call SysCls;
exit rc;


