/* routing decisions
 * Copyright (C) 1999  Cendio Systems AB.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * RCSID $Id$
 */


struct routeinfo {
	struct in_addr	dest;
	struct in_addr	netmask;
	int		mask_nbits;
	struct in_addr	gateway;
	char		iface[32];

	struct routeinfo *next;
};


#ifndef ROUTING_TABLE_FILE
# define ROUTING_TABLE_FILE	"/dev/null"
#endif

extern const char *routing_table_file;

extern bool reread_routing_table(const char *proc_net_route);
extern struct routeinfo * find_route(struct in_addr dest);
