/* Initiate an Oakley Aggressive Mode exchange.
 * --> HDR, SA, KE, Ni, IDii
 */
static stf_status
aggr_outI1(
  int whack_sock,
  struct connection *c,
  bool pending_quick,
  lset_t policy,
  unsigned long klives)
{
    u_char space[8192]; /* NOTE: we assume 8192 is big enough to build the packet */
    pb_stream reply;  /* not actually a reply, but you know what I mean */
    pb_stream rbody;

    struct isakmp_hdr hdr;
    struct state *st;

    /* set up new state */
    cur_state = st = new_state();

    st->st_connection = c;
    st->st_pending_quick = pending_quick;
    st->st_policy = policy;
    st->st_whack_sock = whack_sock;
    st->st_klives = klives;
    st->st_state = STATE_AGGR_I1;

    init_st_oakley(st);

    glean_myidentity(st); /* gets fictional identity */

    get_cookie(ISAKMP_INITIATOR, st->st_icookie,
               COOKIE_SIZE, c->that.host);

    insert_state(st); /* needs cookies, connection, and msgid (0) */

    /* an event will be scheduled for st before we return */

    log("initiating Aggressive Mode, state #%lu, connection \"%s\""
        , st->st_serialno, st->st_connection->name);

    /* set up reply */
    init_pbs(&reply, space, sizeof(space), "reply packet");

    /* HDR out */

    memset(&hdr, '\0', sizeof(hdr));  /* default to 0 */

    hdr.isa_version = ((ISAKMP_MAJOR_VERSION << ISA_MAJ_SHIFT)
           | ISAKMP_MINOR_VERSION);
    hdr.isa_np = ISAKMP_NEXT_SA;
    hdr.isa_xchg = ISAKMP_XCHG_AGGR;
    memcpy(hdr.isa_icookie, st->st_icookie, COOKIE_SIZE);
    /* R-cookie, flags and MessageID are left zero */

    if (!out_struct(&hdr, &isakmp_hdr_desc, &reply, &rbody))
      return STF_INTERNAL_ERROR;

    /* SA out */
    {
       u_char *sa_start = rbody.cur;

      if (!out_sa(&rbody, &oakley_sadb, st, TRUE, ISAKMP_NEXT_KE))
        return STF_INTERNAL_ERROR;

      /* save initiator SA for later HASH */
      passert(st->st_p1isa.ptr == NULL);  /* no leak! */
      clonetochunk(st->st_p1isa, sa_start, rbody.cur - sa_start,
                   "sa in aggr_outI1");
    }

    if (!build_and_ship_KE(st, &st->st_gi, st->st_oakley.group,
         &rbody, ISAKMP_NEXT_NONCE))
      return STF_INTERNAL_ERROR;


    if (!build_and_ship_nonce(&st->st_ni, &rbody, ISAKMP_NEXT_ID, "Ni"))
      return STF_INTERNAL_ERROR;

    /* IDii
     * Magic happens here for the Road Warrior case.
     */
    {
       struct isakmp_ipsec_id id;
       pb_stream id_pbs;

      id.isaiid_np = ISAKMP_NEXT_NONE;
      id.isaiid_idtype = st->st_myidentity_type;
      id.isaiid_protoid = 0;  /* ??? is this right?  IPPROTO_UDP? */
      id.isaiid_port = 0; /* ??? is this right?  our_port? */
      if (!out_struct(&id, &isakmp_ipsec_identification_desc,
          &rbody, &id_pbs)
      || !out_chunk(st->st_myidentity, &id_pbs, "my identity"))
      {
        return STF_INTERNAL_ERROR;
      }
      close_output_pbs(&id_pbs);
    }

    if (st->st_myidentity_type == ID_KEY_ID) 
      log ("TOKEN CARD\n");

    /* finish message */

    close_message(&rbody);
    close_output_pbs(&reply);

    clonetochunk(st->st_tpacket, reply.start, pbs_offset(&reply),
     "reply packet from aggr_outI1");

    /* Transmit */

    DBG_cond_dump(DBG_RAW, "sending:\n",
      st->st_tpacket.ptr, st->st_tpacket.len);

    send_packet(st, "aggr_outI1");

    /* Set up a retransmission event, half a minute henceforth */
    event_schedule(EVENT_RETRANSMIT, EVENT_RETRANSMIT_DELAY, st);

    whack_log(st->st_whack_sock, RC_NEW_STATE + STATE_AGGR_I1,
        "%s: initiate", enum_name(&state_names, st->st_state));
    cur_state = NULL;
    return STF_NO_REPLY;
}


