TITLE DUMMY.ASM: Assembly GROUP directive used to create .COM file.

Comment |
******************************************************************

File:       DUMMY.ASM
Author:     Patrick Whittle
Date:       2/27/95
Assembler:  TASM 3.1 in MASM mode

Purpose:    Install at given interrupt vector to accept packet data

******************************************************************|

comGrp GROUP  dSeg1, dSeg2, cSeg

cSeg   SEGMENT WORD 'CODE'
cSeg   ENDS
dSeg1  SEGMENT WORD PUBLIC 'DATA'
dSeg1  ENDS
dSeg2  SEGMENT WORD PUBLIC 'DATA'
dSeg2  ENDS

CR               EQU     0Dh
LF               EQU     0Ah
envBlock         EQU     2Ch  ; A pointer can be found offset 2C into PSP

dSeg1  SEGMENT
tsrMessage       DB 'FTP Packet Driver Emulator v1.01 Copyright (c) Patrick Whittle, 1995', CR, LF
                 DB 09, 'Program using interrupt '
intUsing         DB 00, 00, ' hex, now resident at ', 0
errorMess1       DB 'Error: Interrupts 60h to 80h are unavailable.', CR, LF, 0
errorMess2       DB 'An FTP packet driver is already installed.', CR, LF, 0
intNo            DB 0FFh
dSeg1  ENDS

dSeg2  SEGMENT                             ; Uninitialized data here.
SaveBX           DW      ?

dSeg2  ENDS

cSeg   SEGMENT

    ASSUME  cs:comGrp, ds:comGrp, es:comGrp, ss:comGrp
    .186
    ORG   100h

pktRoutine PROC NEAR

    call hookIn      ; never returns

pktRoutine ENDP

;----------------------------------------------

residentCode:
    jmp   over
    nop              ; necessary to add to 3 bytes

signature DB 'PKT DRVR', 0           ; Any resident data can follow this, but
                                     ;   cannot come before.
residentData     EQU     THIS BYTE
installedAddress EQU     THIS BYTE
newseg           DW      2 DUP (?)
                 DB      ':'
newoff           DW      2 DUP (?)
Cr_Lf            DB      CR, LF, 0

over:
    cmp   ah, 4             ; ftp function to send packet
    jne   intDone

    push  ax
    push  bx
    push  ds

    mov   bx, cs
    mov   ds, bx            ; point to our data.
    lea   bx, Cr_Lf
    call  dispString        ; advance the cursor

    mov   ah, 0Fh           ; get current video mode
    int   10h               ; will return active video page in bh
    mov   ah, 3             ; get cursor position
    int   10h
    mov   ah, 2             ; set cursor position
    inc   dl                ; advance cursor one column
    int   10h

    pop   ds                ; point back to callers data
    mov   bx, si            ; pointer passed by caller in si register
    add   bx, 14            ; Point past the address portion of packet
    ;call  dispString        ; display the packet string
    pop   bx
    pop   ax

intDone:
    iret

dispString PROC NEAR
;
;  Print ASCIIZ strings.
;
    push  ax
    push  dx
    mov   ah, 02h

sendPrompt:
    cmp   BYTE PTR [bx], 00h
    je    promptDone
    mov   dl, BYTE PTR [bx]
    int   21h
    inc   bx
    jmp   sendPrompt

promptDone:
    pop   dx
    pop   ax
    ret

dispString ENDP

showAddr PROC NEAR
;
;  The caller must ensure ES:DX contains address to be converted.  Once this
;  procedure is called, "installedAddress" can be printed subsequently for
;  any purpose.  Calling a second time with new ES:DX value will replace
;  contents of "installedAddress".
;
    push  dx
    mov   ax, es
    call  ConHexLong                 ; 357D for example in AX is returned as
    mov   BYTE PTR newseg, al        ; DX:AX ---> 4437:3533
    mov   BYTE PTR newseg+1, ah      ;            D 7  5 3   in ASCII.
    mov   BYTE PTR newseg+2, dl      ; We then store appropriately in memory
    mov   BYTE PTR newseg+3, dh      ; (i.e. al, ah, dl, then dh).

    pop   ax                         ; Now convert offset portion of ES:DX
    call  ConHexLong
    mov   BYTE PTR newoff, al
    mov   BYTE PTR newoff+1, ah
    mov   BYTE PTR newoff+2, dl
    mov   BYTE PTR newoff+3, dh

    lea   bx, installedAddress
    call  dispString
    ret

showAddr ENDP

ConHex PROC
;
; The following routine converts the number in AL into an ASCII
; representation of the hex value, with a leading zero.  Value
; is returned in AX as well.

    mov   cl, 10h             ; What we will be dividing by
    mov   ah, 0
    div   cl                  ; Divide by 16
    add   al, 30h
    add   ah, 30h
    cmp   al, '9'             ; Is it greater than 9?
    jbe   CA4                 ; No, so continue
    add   al, 7               ; Make into hex digit

CA4:        
    cmp   ah, '9'             ; Is it greater than 9?
    jbe   CA5                 ; No, so continue
    add   ah, 7               ; Make into hex digit

CA5:        
    ret

ConHex ENDP

ConHexLong PROC
;
; The following uses ConHex to convert a long number (AX) into it's ASCII
; equivalent in DX:AX.

    push  ax
    call  ConHex
    mov   dx, ax
    pop   ax
    mov   al, ah
    call  ConHex
    ret

ConHexLong ENDP

;---------------- transient code begins here ----------------

hookIn PROC NEAR
;
    push  es                 ; This first block of code checks if DUMMY.COM
    push  bx                 ; is already installed.
    mov   al, 80h            ; About to search backwards between 80h and 60h

scanVector:
    mov   ah, 35h              ; getvect function of int 21h
    int   21h                  ; ES:BX receive vector
    mov   WORD PTR SaveBX, bx
    mov   dx, es
    add   dx, bx
    cmp   dx, 0                ; Check for null pointer
    je    continue             ; Okay to install

    call  chkSignature         ; Returns true or false in ZF flag.
    jz    errorType2           ; Jump if an ftp driver is already present.
    jmp   loopBottom

continue:                      ; Nothing is installed if we reach this point.
    mov   BYTE PTR intNo, al   ; set to 0FFh at begining

loopBottom:
    dec   al
    cmp   al, 60h
    jae   scanVector

    cmp   BYTE PTR intNo, 0FFh  ; Were absolutely no vectors available?
    je    errorType1

    mov   ah, 25h               ; setvect returns installed address in DS:DX
    mov   al, BYTE PTR intNo
    lea   dx, residentCode      ; point intNo to the code in "residentCode"
    int   21h

    lea   bx, tsrMessage
    call  dispString
    mov   ah, BYTE PTR intNo
    shr   ax, 8               ; 6000 in ax becomes 0060
    call  ConHex
    mov   WORD PTR intUsing, ax
    lea   bx, intUsing
    call  dispString
    push  ds
    pop   es                  ; we need what setvect returned in ES
    call  showAddr            ; Display address returned from setvect above.
                              ; Ensure ES:DX contains seg:offset before hand!
    mov   es, ds:[envBlock]
    mov   ah, 49h             ; Free memory not needed (i.e. transient code)
    int   21h
    
    lea   dx, hookIn      ; end of resident area
    shr   dx, 4           ; num in paragraphs to keep resident (divide by 16)
    inc   dx              ; add 1 for safety
    mov   ax, 3100h       ; Function to go TSR

exitPgm:
    pop   bx
    pop   es
    int   21h

errorType1:
    lea   bx, errorMess1
    jmp   errorCommon

errorType2:
    lea   bx, errorMess2     ; This program, or valid ftp packet driver
                             ;  is already resident.
errorCommon:
    call  dispString
    mov   ax, 4CFFh          ; Return DOS errorlevel
    jmp   exitPgm

hookIn ENDP

chkSignature PROC NEAR
;
; Input:   ES:BX contining interrupt vector returned from getvect
;          DS points to our data
;
; Returns: True or False condition in zero flag (i.e. ZF=1 for True).
;
    mov   di, bx
    add   di, 3
    lea   si, signature
    lea   cx, residentData
    sub   cx, si             ; subtract start from end to get length
    cld                      ; clear direction flag
    repe  cmpsb              ; zero flag set to 0 if not equal
    ret           

chkSignature ENDP

cSeg   ENDS

END pktRoutine
