/*--------------------------------------------------------------------------*/
/*                                                                          */
/*      Minimized OS/2 2.0 SLIP Driver for IBM TCP/IP version 2.0           */
/*                                                                          */
/*                             NUSLIPUP.CMD                                 */
/*                                                                          */
/*            ..................................................            */
/*                                                                          */
/*       August 1, 1994                                                     */
/*                                                                          */
/* NOTE: This file has evolved from the SLIPUP.CMD file supplied with       */
/*       IBM's TCP/IP package.  Some people who are new to TCPIP and/or     */
/*       Rexx have had difficulty getting their SLIP connection working     */
/*       and it is hoped that this file may be easier to understand.        */
/*                                                                          */
/*       These modifications by John Pedersen, CompuServe 76547,357         */
/*       Any suggestions or comments are welcome.                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/* This is an attachment script for dialing into a SLIP service provider.   */
/* Notes on usage:                                                          */
/*                                                                          */
/* 1. The default installation procedure for TCP/IP puts TCPSTART.CMD into  */
/*    your STARTUP folder.  This file invokes another .CMD file called      */
/*    SETUP.CMD.  To get yourself going, remove TCPSTART.CMD from your      */
/*    STARTUP folder so these programs never get called.                    */
/*                                                                          */
/* 2. This script file should be specified using the "attachcmd" in the     */
/*    SLIP.CFG file; however no "attachparm" elements are used so that we   */
/*    can move a lot of the tweaking into one place (ie. the front part of  */
/*    this file.  For example, SLIP.CFG might look like this:               */
/*                                                                          */
/*             interface sl0 { device=COM1,                                 */
/*                             mtu=1006,                                    */
/*                             compression=auto,                            */
/*                             attachcmd=nuslipup.cmd }                     */
/*                                                                          */
/* 3. This method REQUIRES that your password be inserted permanently into  */
/*    the file below.  If security is a problem, DON'T use this method, or  */
/*    take appropriate measures.  Also, if you wish to pass this file along */
/*    to help somebody else, REMOVE your password first.                    */
/*                                                                          */
/* 4. The basic idea here is:                                               */
/*                                                                          */
/*    a) First the script sends the dial string to the modem.  If           */
/*       connection is not made, it will redial (10 times).                 */
/*                                                                          */
/*    b) Next, we log into the service provider using the                   */
/*       username and password.                                             */
/*                                                                          */
/*    c) At this point, the service provider may offer a menu, and we  have */
/*       to respond appropriately.                                          */
/*                                                                          */
/*    d) If IP Addresses are to be assigned at login time, we have to grab  */
/*       that output and parse it to determine the appropriate addresses    */
/*       to use.                                                            */
/*                                                                          */
/*    e) Lastly, it issues ifconfig and route commands to configure our     */
/*       system appropriately.  Note that the configuration assumes a       */
/*       class C netmask for the SLIP interface.                            */
/*                                                                          */
/* NOTE(!), if you're studying the Rexx below, that there are calls to two  */
/* Rexx functions provided by TCPIP:                                        */
/*   slip_com_input ( interface(sl0) , [max_characters] , [timeout(ms.)] )  */
/*        As implied, this gets characters from the COM port.               */
/*   slip_com_output ( interface , string )                                 */
/*        And, also obvious, this sends a string to the COM port.  Note     */
/*        that the chararacters may not all have been sent when this        */
/*        routine returns.                                                  */



/*==========================================================================*/
/* THIS AREA IS FOR SETTING UP YOUR UNIQUE VARIABLES.  EDIT AS APPROPRIATE. */
/* For LoginPrompt and PwPrompt, enter the end of the text string which is  */
/* sent by your service provider to prompt you for your user name and your  */
/* password.  Match upper and lower case exactly!!!                         */

/* Except for my password, I've got my own login details inserted below,    */
/* to give you a better idea of how it ends up.                             */
/* When you're trying to get things going, look at the actual text that     */
/* your service provider is sending.  LoginPrompt, PwPrompt, ThirdPrompt    */
/* below should be changed so YOU are looking for the text that YOUR        */
/* service provider is sending.  AddrMarker1 and AddrMarker2 are also       */
/* prompt strings, for those cases where IP Addresses are assigned at login.*/

DialType    = 'T'               /* T for tone; P for pulse.                 */
DialNumber  = '1-905-847-8866'  /* Phone number of service provider.        */
LoginName   = 'pedersen'        /* Your login name.                         */
Password    = ''                /* Change this to your password.            */
ComNumber   = 1                 /* 1 for COM1, 2 for COM2.                  */
LoginStart  = 'CR'              /* 'CR' to start login with cr; else '*'.   */
LoginPrompt = 'login:'          /* Text prompting for login name.           */
PwPrompt    = 'Password:'       /* Text prompting for password.             */
ThirdPrompt = 'choice:'         /* Text prompting for connection type.      */
ThirdAnswer = '2'               /* My reply to the third prompt.            */
MyIPAddress = '199.0.20.53'     /* Set to '*' if IP Addr assigned at login. */
Gateway     = '165.154.1.1'     /* Srvce provider; '*' if assigned at login.*/
AddrMarker1 = 'Your address is' /* Line with this text has your IP Address. */
AddrMarker2 = 'Your gateway is' /* Line with this text has Gateway Address. */


/*==========================================================================*/
/* THIS SECTION MAKES SURE THAT YOUR COM PORT IS SET UP CORRECTLY.  The     */
/* settings below will be correct for most circumstances; most modems will  */
/* negotiate a lower rate if required.                                      */
/*--------------------------------------------------------------------------*/
'mode com'ComNumber': 19200,',      /* Baud rate                            */
                         'n,',      /* No parity                            */
                         '8,',      /* 8 data bits                          */
                         '1,',      /* 1 stop bit                           */
                   'xon=off,',      /* software (XON/XOFF) handshake off    */
                  'idsr=off,',      /* input "DataSet Ready" handshake off  */
                  'odsr=off,',      /* output "DataSet Ready" handshake off */
                   'octs=on,',      /* output "Clear To Send" handshake on  */
                    'rts=hs,',      /* "Request To Send" handshake on       */
                    'dtr=on,',      /* Data Terminal Ready                  */
                 'buffer=on'        /* use buffer if applicable             */


/*==========================================================================*/
/**************** MAIN SCRIPT CODE STARTS HERE ******************************/
/*--------------------------------------------------------------------------*/
cr='0d'x                           /* define the carriage return character  */
crlf='0d0a'x                       /* and carriage return-line feed pair.   */


/*==========================================================================*/
/* THIS SECTION DIALS THE PHONE; IT INCLUDES A LOOP FOR REDIALING IF BUSY.  */
/*--------------------------------------------------------------------------*/
Dialcmd = 'ATD'DialType||DialNumber  /* Put together the dial command.      */
DialCnt = 0                          /* Initialize a retry counter.         */
call DoDial                          /* Call the dial routine.              */
do while waitfor('CONNECT', '35')=1  /* Wait for CONNECT signal from modem. */
   call send 'ATH'                   /* if you time out, send "hangup" cmd  */
   call flush_receive                /* to modem,                           */
   say 'Hanging up....'              /* and inform user.                    */
   call DoDial                       /* Send the dial command again.        */
end                                  /* End of redial loop.                 */
call waitfor crlf                    /* Wait for characters from provider.  */


/*==========================================================================*/
/* THIS SECTION IS THE LOGIN SEQUENCE.                                      */
/* Wait for standard strings, and then flush anything else to take care of  */
/* trailing spaces, etc..                                                   */
/*--------------------------------------------------------------------------*/
if LoginStart = 'CR' then call send cr  /* Start with CR if required.       */
call waitfor LoginPrompt                /* Wait for the prompt for          */
call flush_receive 'echo'               /* username and reply               */
call send LoginName || cr               /* with your login name.            */
call waitfor PwPrompt                   /* Wait for the prompt for          */
call flush_receive 'echo'               /* password and reply               */
call send Password || cr                /* with your password.              */
call waitfor ThirdPrompt                /* Wait for the menu prompt and     */
call flush_receive 'echo'               /* respond with "SLIP" or "2" or    */
call send ThirdAnswer || cr             /* whatever is required.            */
call flush_receive 'echo'               /* Show it, and                     */


/*==========================================================================*/
/* WE NEED TO DO THIS SECTION IF OUR IP ADDRESS IS ASSIGNED AT LOGIN.       */
/* Parse the results of the SLIP command to determine our address.          */
/* We use the "waitfor_buff" variable from the waitfor routine to parse     */
/* the stuff we get from the service provider after waiting for an          */
/* appropriate point in the data stream.                                    */
/* There's a section for extracting the Gateway address, and there's a      */
/* section for extracting your address; switch them around according to     */
/* your needs.                                                              */
/*--------------------------------------------------------------------------*/

If Gateway = '*' then                    /* If we need to get IP's then     */
DO                                       /* do this block.  First wait      */
   call waitfor AddrMarker2              /* for text that tells you that    */
   Gateway = GetIPAddr(waitfor_buff)     /* the line is in buffer; then     */
   call flush_receive 'echo'             /* Do the flush.                   */
END                                      /* extract it.                     */


If MyIPAddress = '*' then                /* Next get your                   */
DO                                       /* own IP address; first           */
   call waitfor AddrMarker1              /* wait for next line.             */
   MyIPAddress = GetIPAddr(waitfor_buff) /* Call extraction routine.        */
   call flush_receive 'echo'             /* Flush anything else             */
END                                      /* End of IP address collection.   */


/*==========================================================================*/
/* CONFIGURE THIS HOST                                                      */
/* for appropriate address, and for default route through service provider. */
/*--------------------------------------------------------------------------*/
say 'SLIP Connection Established'
say 'Configuring local address =' MyIPAddress Gateway
'ifconfig sl0' MyIPAddress Gateway 'netmask 255.255.255.0'
'route -f add default' Gateway '1'

exit 0
/*--------------------------------------------------------------------------*/
/* All done; end of main routine. (callable routines follow...)             */
/*==========================================================================*/


/*==========================================================================*/
/* ONLY CALLABLE ROUTINES BELOW THIS POINT                                  */
/*==========================================================================*/


/*==========================================================================*/
/*                            send ( sendstring)                            */
/*..........................................................................*/
/*                                                                          */
/* Routine to send a character string off to the modem.                     */
/*                                                                          */
/*--------------------------------------------------------------------------*/

send:

   parse arg sendstring
   call slip_com_output 'sl0' , sendstring

   return


/*==========================================================================*/
/*                    waitfor ( waitstring , [timeout] )                    */
/*..........................................................................*/
/*                                                                          */
/* Waits for the supplied string to show up in the COM input.  All input    */
/* from the time this function is called until the string shows up in the   */
/* input is accumulated in the "waitfor_buff" variable.                     */
/*                                                                          */
/* If timeout is specified, it says how long to wait if data stops showing  */
/* up on the COM port (in seconds).                                         */
/*                                                                          */
/*--------------------------------------------------------------------------*/

waitfor:

   parse arg waitstring , timeout              /* get text string and       */
                                               /* timeout value in seconds. */
   if timeout = '' then timeout = 5000         /* LONG delay if unspecified */
   waitfor_buff = ''                           /* Clear waitfor_buff.       */
   done = -1                                   /* Initialize a "done" flag. */
   TimerVal = TIME('R')                        /* Reset the timer.          */
 
   do while (done = -1)                        /* Do below until a flag set.*/
      line = slip_com_input('sl0',,10)         /* Get any input from COM,   */
      if timeout>50 then                       /* don't need feedback       */
         call charout , line                   /* while dialing.            */
      waitfor_buff = waitfor_buff||line        /* append to waitfor_buff.   */
      if pos(waitstring,waitfor_buff)>0 then   /* search the buffer for our */
      DO                                       /* text string; if found,    */
         done = 0                              /* Set done flag to indicate */
         DO UNTIL line = ''                    /* 'til null (100ms. timeout)*/
           line = slip_com_input('sl0',,100)   /* left in COM or modem buffs*/
           waitfor_buff=waitfor_buff||line     /* Stick into buffer.        */
         END
      END
      TimerVal = TRUNC( TIME('E') )            /* Get elapsed seconds.      */
      If TimerVal<>LastTime & Timeout<50 then
          call charout , CR||"Elapsed time:" TimerVal "  "
      LastTime = TimerVal
 
      if TimerVal>timeout then do
        call lineout , ' WAITFOR: timed out '
        done = 1
       end
   end
   return done


/*--------------------------------------------------------------------------*/
/*                             flush_receive ()                             */
/*..........................................................................*/
/*                                                                          */
/* Routine to flush any pending characters to be read from the COM port.    */
/* Reads everything it can until nothing new shows up for 100ms, at which   */
/* point it returns.                                                        */
/*                                                                          */
/* The optional echo argument, if present, says to echo flushed information.*/
/*                                                                          */
/*--------------------------------------------------------------------------*/

flush_receive:
   parse arg echo                           /* this says if echo wanted.    */
   if (echo \= '') then                     /* If echo wanted, and there    */
      call charout , remain_buff            /* do the echo.                 */
   remain_buff = ''                         /* Clear the remain_buff.       */
   do until line = ''                       /* Until null (100ms. timeout)  */
     line = slip_com_input('sl0',,100)      /* left in COM or modem buffers */
     if echo \= '' then call charout , line /* just echo or throw away.     */
   end

   return


/*==========================================================================*/
/*                             GetIPAddr ()                                 */
/*--------------------------------------------------------------------------*/
/* This routine takes a string of text with an IP (Internet Protocol)       */
/* address buried somewhere in it, and returns the IP address only.         */
/*..........................................................................*/
GetIPAddr: Procedure                 /* Use procedure to isolate variables. */
parse arg  a '.' b '.' c '.' d       /* Initial parsing; a & d may contain  */
a = WORD(a, WORDS(a) )               /* excess: in a we only want last word */
d = WORD(d, 1)                       /* and in d we only want first word.   */
IPAddr = a||'.'||b||'.'||c||'.'||d   /* Put address components              */
Say "IP Address extracted:" IPAddr   /* together, and report to             */
return IPAddr                        /* user.                               */


/*==========================================================================*/
/*                            DoDial                                        */
/*--------------------------------------------------------------------------*/
/* This routine flushes the buffer; sends the dialcommand to the modem,     */
/* and keeps a count of the number of tries.                                */
/*..........................................................................*/
DoDial:
call flush_receive                   /* Flush stuff from prev. COM activity */
DialCnt = DialCnt + 1                /* Count the dial attempt.             */
If DialCnt>10 then                   /* Test to see if the maximum number   */
DO                                   /* of retries will be exceeded.        */
   say "...aborting after 10 tries." /* Bail out if                         */
   exit                              /* no more retries are permitted.      */
END
call slip_com_output 'sl0' , dialcmd||cr  /* Dial remote server.            */
OutString = 'Now Dialing (#'DialCnt')...' /* Give user some                 */
call charout , crlf||Outstring||crlf      /* feedback.                      */
return



