/*
 * nsjava.cmd - Select the JVM for Netscape Navigator 2.02
 * Arguments:
 *      <none> or java11        Activates java11
 *      java102                 Activates java102
 *
 * Works by modifying LIBPATH and CLASSPATH in CONFIG.SYS.
 * You must reboot after running.
 *
 * Warning: contains untranslated English usage and error messages.
 *
 * Implementation:
 *
 * To switch from java102 to java11:
 * 1. Backup config.sys
 * 2. Add x:\netscape\java11 to beginning of LIBPATH and CLASSPATH
 *
 * To switch from java11 to java102:
 * 1. Backup config.sys
 * 2. Remove x:\netscape\java11 from LIBPATH and CLASSPATH
 */

Call RxFuncAdd 'SysSearchPath', 'RexxUtil', 'SysSearchPath'
/* Set debug to 1 for debug print lines */
debug = 0
tmpcfg = '.\cf_tempx.f00'
jemzip = '\JEMPCL10.ZIP'
ziplen = Length(jemzip)

/* Get parameters */
Arg whichjava
If whichjava = '' Then whichjava = 'JAVA11'
If debug Then Say 'whichjava =' whichjava
If whichjava <> '' & whichjava <> 'JAVA11' & whichjava <> 'JAVA102' Then Do
	Say 'Usage: nsjava [java11 | java102]'
	Exit 0
End

/* Find CONFIG.SYS */
'@bootdrv | rxqueue'
Parse Pull bootDrive
dspec = bootDrive':'
cfgsys = dspec'\CONFIG.SYS'
cfgbase = dspec'\CONFIG'
If debug Then Say 'cfgsys =' cfgsys
If Stream(cfgsys, 'Command', 'Query Exists') = '' Then Do
        Say 'Could not find CONFIG.SYS'
        Exit 1
End

/* Find NETSCAPE install directory */
fspec = SysSearchPath('PATH', 'NETSCAPE.EXE')
If debug Then Say 'netscape.exe =' fspec
If fspec = '' Then Do
        Say 'Could not find NETSCAPE install directory'
        Exit 1
End
nsdir = FileSpec("drive", fspec) || FileSpec("path", fspec) || 'JAVA11'
nsdir = Translate(nsdir)
If debug Then Say 'nsdir =' nsdir
dirlen = Length(nsdir)

/* Delete temp file if it exists */
'@del' tmpcfg '> NUL: 2>&1'

/* Add or remove netscape java11 dir from LIBPATH and CLASSPATH */
updated = 0
Do While Lines(cfgsys)
        line = LineIn(cfgsys)
        capline = Translate(line)
        libpathpos = Pos("LIBPATH", capline)
        classpathpos = Pos("SET CLASSPATH", capline)

        /* Assumes commands appear at char 1 */
        /* Won't update REM'ed out commands */

        If libpathpos = 1 | classpathpos = 1 Then Do
                If debug Then Say 'Found path:' SubStr(capline, 1, 20)'...'
                dirpos = Pos(nsdir, capline)
                startpos = Pos("=", capline) + 1

                /* Add netscape dir to paths */
                If whichjava = 'JAVA11' & dirpos = 0 Then Do
                        tmpline = SubStr(line, 1, startpos-1) || nsdir
                        If classpathpos = 1 Then tmpline = tmpline || jemzip
                        line = tmpline';'SubStr(line, startpos)
                        updated = 1
                        If debug Then Say line
                End
                /* Or remove netscape dir from paths */
                Else If whichjava = 'JAVA102' & dirpos <> 0 Then Do
                        tmpline = SubStr(line, 1, dirpos-1)
                        extralen = 0
                        If classpathpos = 1 Then extralen = ziplen
                        /* Skip over the nsdir string by adding nsdir length,
                           plus zipfile len if this is classpath, plus
                           one for the semicolon */
                        rest = dirpos + dirlen + extralen + 1
                        line = tmpline || SubStr(line, rest)
                        updated = 1
                        If debug Then Say line
                End
        End

        Call LineOut tmpcfg, line
End

Call Stream cfgsys, 'Command', 'Close'
Call Stream tmpcfg, 'Command', 'Close'

If debug Then Say 'Updated =' updated

/*
 * Make a copy of this system's config.sys, in a similar manner to Software Installer
 * (i.e., config.xxx, where xxx is 000, 001, etc.)
 */
If updated Then Do
        i = 0
        Do Forever
                cfgbak = cfgbase'.'nto3ascii(i)
                If debug Then Say 'Query Exists:' cfgbak
                /* Exit loop when we find an unused extension */
                If Stream(cfgbak, 'Command', 'Query Exists') = '' | i = 999 Then
                        Leave
                i = i + 1;
        End

        /* Copy current config to a backup, temp config to current config, and delete temp config */
        If debug Then Do
                'copy' cfgsys cfgbak
                'copy' tmpcfg cfgsys
        End
        Else Do
                '@copy' cfgsys cfgbak '> NUL: 2>&1'
                '@copy' tmpcfg cfgsys '> NUL: 2>&1'
        End
End

If debug Then
        'del' tmpcfg
Else
        '@del' tmpcfg '> NUL: 2>&1'

Exit 0

/* Convert the decimal value i to a 3 character string with leading (ASCII) '0's */
nto3ascii: Procedure Expose i
  test1 = Trunc(i//10)
  test100 = Trunc(i/100)
  test10 = Trunc((i-(test100*100)-test1)/10)
  strnum100 = d2c(test100+48)
  strnum10 = d2c(test10+48)
  strnum1 = d2c(test1+48)
  strnum = strnum100||strnum10||strnum1
  strnum = SubStr(strnum, 1, 3);
Return strnum

