/*
 * Script to install News Harvest
 */

if RxFuncQuery('SysLoadFuncs') 
then do
   call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call SysLoadFuncs
end

/* Make sure they agree to licence */

SAY "Software Licence"
SAY "~~~~~~~~~~~~~~~~"
SAY "News Harvest Copyright (C) 1997,1998 KRT Pty. Ltd. "
SAY "All Rights Reserved News Harvest Copyright (C) 1997,1998 Kingsley R."
SAY "Turner All Rights Reserved"
SAY ""
SAY "Use of this software by any person or organisation for any purpose"
SAY "requires that a usage licence be obtained by that person or organisation."
SAY ""
SAY "Commercial redistribution of this software, by itself or as part of"
SAY "another application is allowed only under express written permission of"
SAY "KRT Pty. Ltd."
SAY ""
SAY "KINGSLEY R. TURNER AND KRT PTY. LTD. DISCLAIM ALL WARRANTIES WITH REGARD"
SAY "TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND"
SAY "FITNESS, IN NO EVENT SHALL KINGSLEY R. TURNER OR KRT PTY. LTD. BE"
SAY "LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES"
SAY "WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN"
SAY "ACTION OF CONTRACT, OR OTHER ACTION, ARISING OUT OF OR IN CONNECTION"
SAY "WITH THE USE OR PERFORMANCE OF THIS SOFTWARE."
SAY ""
SAY "Do you accept the terms of the Licence? [yes/no]"
PULL yess
SELECT
    WHEN yess = 'yes' 
        THEN NOP
    WHEN yess = 'YES' 
        THEN NOP
OTHERWISE
    SAY ""
    SAY "Using News Harvest requires acceptance of the licence agreement"
    EXIT
END    

say "Installing News Harvest v1.4o"

dir = directory() || '\'
background  = 'background.bmp'
foldericon  = 'folder1.ico'
foldopicon  = 'folder2.ico'
licenceicon = 'licence.ico'
programicon = 'program.ico'
regoicon    = 'program.ico'
htmlicon    = 'html.ico'
bmticon     = 'purchase.ico'

current_dir = directory()


say "Folder:"

/* Make the folder for the objects */
call SysCreateObject "WPFolder","News Harvest v1.4o","<WP_DESKTOP>","OBJECTID=<NHFOLD>;ALWAYSSORT=YES;ICONFONT=8.Helv;BACKGROUND=" || dir || background || ",T;ICONFILE=" || dir || foldericon || ";ICONNFILE=1," || dir || foldopicon  ,"replace"
say "   News Harvest v1.4o"

say "Objects:"

/* The NewsHarvest.exe Object */
call SysCreateObject "WPProgram"," News Harvest ","<NHFOLD>","EXENAME=" || dir || "NewsHarvest.exe;STARTUPDIR=" || dir || ";ICONFILE=" || dir || programicon,"REPLACE"
say "   Program"

/* The Software Licence file Object */
call SysCreateObject "WPProgram"," Software Licence","<NHFOLD>","EXENAME=E.EXE;PARAMETERS=" || dir || "UserLicence.txt;ICONFILE=" || dir || licenceicon,"replace"
say "   Licence"

/* Link to website */
call SysCreateObject "WPProgram"," www.krt.com.au","<NHFOLD>","EXENAME=NETSCAPE.EXE;PARAMETERS=http://www.krt.com.au;ICONFILE=" || dir || htmlicon,"replace"
say "   URL to KRT"

/* The Registerererer Object */
call SysCreateObject "WPProgram","Enter Registration"||d2c(10)||"(requires key)","<NHFOLD>","EXENAME=" || dir || "Register.exe;ICONFILE=" || dir || regoicon || ";STARTUPDIR=" || dir,"replace"
say "   Register News Harvest"


/* -------- REGO Stuff ---------- */


/* Make the SUB-folder for the Rego Programs */
call SysCreateObject "WPFolder","Online"||d2c(10)||"Registration Purchase","<NHFOLD>","OBJECTID=<NHSUBFOLD>;ALWAYSSORT=YES;ICONFONT=8.Helv;BACKGROUND=" || dir || background || ",T;ICONFILE=" || dir || foldericon || ";ICONNFILE=1," || dir || foldopicon  ,"replace"
say "Registration Folder:"

/* EMail Order Form */
call SysCreateObject "WPProgram","BMT Micro"||d2c(10)||"eMail Order Form","<NHSUBFOLD>","EXENAME=E.EXE;PARAMETERS=" || dir || "register.bmt;ICONFILE=" || dir || bmticon,"replace"
say "   BMT Micro eMail Order Form"

/* BMT Micro Purchase App */
call SysCreateObject "WPProgram","BMT Micro"||d2c(10)||"Direct Order Form","<NHSUBFOLD>","EXENAME=" || dir || "PURCHASE.EXE;ICONFILE=" || dir || bmticon,"replace"
say "   BMT Micro On-Line Order Form"


say "Done."

EXIT


