/************************************************************/
/*                                                          */
/* newurl.cmd                                               */
/*                                                          */
/* Script that scans a mail file, and starts an URL creator */
/* with the subject being the URL.                          */
/*                                                          */
/* Requires createurlobj.cmd for operation.                 */
/*                                                          */
/* Copyright (C) 1996 Bjorn Fahller                         */
/*                                                          */
/************************************************************/

parse arg filename

subject='';
headerfound=0;
status = stream(filename, 'c', 'open read')
do while (headerfound == 0 | subject == '')
   iline = linein(filename);
   parse var iline header': 'content
   if content \= "" & headerfound == 0 then
     do
       headerfound=1;
     end
   if header == "" & headerfound == 1 then
     do
       exit 2;
     end
   if header == "Subject" then
     do
       subject=content;
     end
end /* do */
status = stream(filename, 'c', 'close');

parse var subject type'://'address
Address cmd 'detach createurlobj 'type' 'address

exit 0;

