/* Global filter for MLP 0.9 by Jivko Koltchev                         */
/* =================================================================== */
/* This filter reads all header lines of the mail file and puts them   */
/* in correspondig vars. All characters of the header key words other  */
/* than [0-9,A-Z,a-z] will be translated into underline characters "_" */
/* (Example: content of header line "Message-Id:" will be placed into  */
/* var "Message_Id")                                                   */
/* =================================================================== */
/* Search for "your code" to find where to place your own code.        */
/* =================================================================== */
/* Written by Michael Warmuth (Michael.Warmuth@wu-wien.ac.at)          */

/* Load the REXX Utility Functions */
if rxfuncquery('SysLoadFuncs') then do
   call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call SysLoadFuncs
end  /* Do */

/* Get argument */
parse arg mail_file .



/* Put all header lines in corresponding vars */
/* Create translation tables */
chars_not =
xrange('00'x,'2f'x)xrange('3a'x,'40'x)xrange('5b'x,'60'x)xrange('7b'x,'ff'x)
chars_ok  = left('',length(chars_not),'_')

/* Quit if file doesn't exist */
if stream(mail_file,'c','query exists')='' then return

/* Open mail file */
do while stream(mail_file,'c','open read')\='READY:'
   call SysSleep 1
end /* do */

/* Read header */
do until next_line=''
   next_line = strip(linein(mail_file))
   if right(word(next_line,1),1)=':' then do
      parse var next_line keyword ':' content

      /* Replace all single quotes in content */
      content2 = ''
      do while pos("'",content)\=0
         parse var content tmp "'" content
         content2 = content2||tmp"''"
      end /* do */
      content = content2 || content

      /* Replace all special chars in var name */
      keyword = translate(space(keyword,1),chars_ok,chars_not)

      k = keyword "= '"strip(content)"'"
      interpret k
   end  /* Do */
end /* do */
call stream mail_file, 'c', 'close'



/* =================================================================== */
/* Put your code after this comment                                    */
/* =================================================================== */

/* Delete file if it is a command and there are illegal characters */
if left(subject,1)='[' & (pos('|',subject)\=0 | pos('&',subject)\=0 |,
      pos('>',subject)\=0 | pos('<',subject)\=0) then
   call SysFileDelete mail_file


/* Delete file if it is from a MAILER-DAEMON */
if pos('MAILER-DAEMON',from)\=0 then
   call SysFileDelete mail_file

/* =================================================================== */
/* Put your code before this comment                                   */
/* =================================================================== */



return

