/* MakeHTML.CMD -  Make HTML code for a set of download dirs */
/* By Paul M Blais - pblais@visi.com - September 13, 1996 */
CALL RxFuncAdd 'FileLoadFuncs' , 'FILEREXX' , 'FileLoadFuncs'
CALL FileLoadFuncs
CALL RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
CALL SysLoadFuncs

/* ======== This stuff should be examined before you run the script ====== */
RootDir = 'F:\DOWNLOAD'     /* root of the library (UPDATE THIS) */

/* Controls for the HTML Pages Update these are required */
MyHTML = 'INDEX.HTML'               /* default HTML file name */
ReadMe = 'README'                   /* default readme file to be included AFTER the */
                                    /* HTML header. No slashes, No path, May include an extension */
BodyParm = 'BACKGROUND="/down.gif"' /* if you want a background or other <BODY> HTML parms */
HomePage = '/welcome.html'          /* Your Web Site Home Page for the Home Icon in the footer */
HomeSite = 'Paul Blais Downloads'   /* the name of you Web site download library for the */
                                    /*   HTML Title it will have the dir subject ea appended */

/* HTML File for the main Root directory (Do NOT change) */
RootPage = MakeHTMLPath(FILESPEC('path' , RootDir)||FILESPEC('name' , RootDir)||'/'||MyHTML)

/* Home Button for the footer */
HomeButton = '<A HREF="'||HomePage||'"><IMG SRC="/ADMIN/SKYHOME.GIF" ALIGN="BOTTOM" ALT=" ">HOME PAGE</A>'
/* Icon to retrun to previous library */
BackButton = '<IMG SRC="/ICONS/BACK.GIF" ALIGN="BOTTOM" ALT=" ">'
/* Icon to return to root library */
MainButton = '<A HREF="'||RootPage||'"><IMG SRC="/ICONS/DIR.GIF" ALIGN="BOTTOM" ALT=" ">'
/* Icon for related libraries */
RelatedIcon = '<IMG SRC="/ADMIN/YELDOT.GIF" WIDTH=14 HEIGHT=14 ALIGN="ABSMIDDLE" ALT=" ">'
/* Icons for member files */
FileIcon = '<IMG SRC="/ICONS/DITDOT.GIF" WIDTH=14 HEIGHT=13 ALIGN="ABSMIDDLE" ALT=" ">'

/* ======== Program Starts Here ========== */
SAY 'Creating HTML Pages'
/* Init the forever loop for the first pass */
FCount = 0                  /* Number of files in the current page */
DCount = 0                  /* Dir count on the current page */
TDCount = 1                 /* sequence number in the ToDO stem */
CurrentDir = 0              /* sequence # of the current Dir in the ToDo stem */
ToDo. = ''                  /* Stem for dirs to process */
Handle = 0                  /* File handle for FileREXX */
ToDo.0 = 1                  /* one dir in the hooper already (the root dir) */

/* get the subject from the root directory */
TmpSubject = ""
PathName = RootDir
IF SysGetEA(RootDir , ".subject" , "TmpSubject") = 0 THEN DO
    /* Parse out the first 4 bytes FM/2 prepends */
    PARSE VAR TmpSubject 5 TmpSubject
    /* Remove leading and trailing spaces */
    TmpSubject = STRIP(TmpSubject)
    /* If no .subject make one */
    IF TmpSubject = "" THEN TmpSubject = '- No desc -'
END  /* End Get EA */
ELSE TmpSubject = '- No desc -'

/* Load the data for the root directory */
ToDo.TDCount.dpath = PathName
ToDo.TDCOunt.parent = '/'
ToDo.TDCount.sb = TmpSubject

DO FOREVER  /* keep processing dirs til we get them all */
  FCount = 0                  /* Number of files in the current page */
  Files. =''                  /* Stem for file names */
  Dirs.  = ''                 /* Stem for current dirs */
  Files.0 = 0                 /* reinit the Files. stem var each time */
  Dirs.0 = 0                  /* reinit the Dirs. stem var each time */
  DCount = 0                  /* Dir count on the current page */
  CurrentDir = CurrentDir + 1 /* pointer to the next dir to process */

  /* this is how we break the FOREVER LOOP */
  /* we keep looking for more dirs and when there are no more we quit */
  /* Note that we also keep adding to the ToDo. stem as we find subdirs */
  IF CurrentDir > ToDo.0 THEN LEAVE

  /* get the next dir on the list to process */
  PathName = ToDo.CurrentDir.dpath

  /* find all the files in the current dir */
  Handle = 0   /* reset the handle each time we start */
  DO Until Handle  = 0
    err = FileMatchFile('File','Handle',PathName||'\',DIR,'SIZE|DATE')
    IF err = 0 THEN DO

      /* Get Subject EA this will be the description or "- no desc" - is none found */
      TmpSubject = ""
      IF SysGetEA(PathName||'\'||File , ".subject" , "TmpSubject") = 0 THEN DO
          /* Parse out the first 4 bytes FM/2 prepends */
          PARSE VAR TmpSubject 5 TmpSubject
          /* Remove leading and trailing spaces */
          TmpSubject = STRIP(TmpSubject)
          /* If no .subject make one */
          IF TmpSubject = "" THEN TmpSubject = '- no desc -'
      END  /* Get EA */
      ELSE TmpSubject = '- no desc -'

      /* Filter out HTML files and any objects with a leading * in the subject EA */
      /* The store dirs in the Dirs. stem and Files in the Files. stem */
      IF \(File = MyHTML | File = ReadMe | SUBSTR(TmpSubject,1,1) = '*') THEN DO

        IF File.0 \= '' THEN DO  /* It's a file not a Dir */
           /* File FCount  hOw many files in this dir */
           FCount = FCount + 1
           Files.0 = FCount

           /* Subject EA this will be the file description */
           Files.FCount.sb = TmpSubject

           /* File Size calculation in either bytes, KB, or MB as required */
           IF File.0 > 1024  THEN DO
                IF File.0 > 1024*1024  THEN DO
                  Files.FCount.size = STRIP(FORMAT(File.0/(1024*1024) , 5 , 1)' MB')
                END
                ELSE Files.FCount.size = STRIP(FORMAT(File.0/1024 , 5 , 0)' KB')
           END /* File.0 > 1024 */
           ELSE Files.FCount.size = STRIP(File.0)

           /* File name fold to upper case always*/
           Files.FCount.nm = TRANSLATE(File)
           Files.FCount.html = MakeHTMLPath(PathName||'\'||File)

           /* File Date in MM-DD-YYYY format*/
           Files.FCount.dt = WORD(File.1,1)'-'WORD(File.1,2)'-'WORD(File.1,3)

        END /* File.0 \= 0 a single file is added to the stem */
        ELSE DO        /* It's a driectory not a file */
                       /* zero length files will test to be a dir, this is a problem */
          /* Increment the Dirs  DCount */
          DCount = DCount + 1
          Dirs.0 = DCount

          /* Subject EA */
          Dirs.DCount.nm = TRANSLATE(File)
          Dirs.DCount.html = MakeHTMLPath(PathName||'\'||File)

          TDCount = TDCount + 1
          ToDo.0 = TDCount
          ToDo.TDCount.dpath = PathName||'\'||File
          ToDo.TDCOunt.parent = MakeHTMLPath(PathName'\')

          /* Parse the Subject for a attr flag */
          /* If you need more flags start mucking with the code here */
          Flag = SUBSTR(TmpSubject , 1 , 1) /* get the 1st char from the subject) */
          SELECT
            WHEN Flag = '#' THEN DO
              ToDo.TDCount.attr = '#'
              ToDo.TDCount.sb = SUBSTR(TmpSubject,2, LENGTH(TmpSubject)-1)
              Dirs.DCount.sb = ToDo.TDCount.sb
            END
            OTHERWISE
              ToDo.TDCount.attr = ''
              ToDo.TDCount.sb = TmpSubject
              Dirs.DCount.sb = TmpSubject
          END  /* End Flag select */
        END /* It's a DIR a new dir has been added to it's stem */
      END /* Pass the filter test we skip those that don't pass */
    END /* err = 0 get next file from the dir */

    /* opps had a problem reading files from the dir CHKDSK is appropriate */
    ELSE IF err <> 18 THEN SAY 'Error Processing '||PathName||'\'||File||' Please run CHKDSK'
  END /* Handle = 0 this directory has all the stuff we need to make an HTML page */

  /* for some reason this needs to be cleared, I don't know why */
  err = FileMatchFile(0,Handle)

  /*==============================*/
  /* Output the new HTML Page     */
  /*==============================*/
  handle = 0   /* Init the File Handle */

  /* Overwrite any esisting HTML pages */
  /* Open a new HTML file without any file sharing allowed */
  handle = FileOpen(ToDo.CurrentDir.dpath||'\'||MyHTML , 'wrs--' , 'on' , 0)
  IF handle = 0 Then DO
     SAY '!! Unable to create '||ToDo.CurrentDir.dpath||'\'||MyHTML
     SAY 'handle = '||handle||' FileErr = '||FileErr
     EXIT  /* Bail out */
  END /* End Open File */

  /* ============== ouput standard Page header ===================== */
  SELECT  /* there may be a totally empty directory (not counting an existing .HTML index file */
    WHEN (Dirs.0 > 0) | (Files.0 > 0) THEN DO /* there are files or sub dirs to process */
      /* write the HTML header */
      err = Makeheader()

      /* Process the subdirectories */
      IF Dirs.0 > 0 THEN DO /* there are sub dirs in this dir */
        err = OutputDirs()
      END /* end dirs processing */

      /* Process the files */
      IF Files.0 > 0 THEN DO /* There are files in this dir to process */
      /* setup before the files table */
      err = OutputFiles()
      /* any stuff after the files table goes here */
      END /* End files processing */
      /* make a standard page footer */
      err = MakeFooter()
    END /* End of dirs or files to process */

    OTHERWISE /* it's an empty directory */
      /* Create a special Under Construction Page with header, the message below and a footer */
      /* write the HTML header */
      err = Makeheader()
      err = FilePuts(handle,'<P>!!!! - Library '||ToDo.CurrentDir.sb||' is under construction.</P>')
      /* make a standard page footer */
      err = MakeFooter()
  END
  /* Post processing after the page is done */
  SAY 'Created: '||ToDo.CurrentDir.dpath||'\'||MyHTML
  err = FileClose(handle)
END /* end forever */
/* do any clean up or final processing before we leave.  All HTML pages are done */
SAY 'All HTML Pages were made!'
EXIT

/*============================= Functions and procedures ==============================*/

MakeHTMLPath:
/* --------- Make an HTML path with forward slashes ----------*/
  ARG HTMLPath
  /* Strip off the drive letter */
  HTMLPath = FILESPEC('path' , HTMLPath)FILESPEC('name' , HTMLPath)

  /* Replace all the "\" chars with a "/" char i.e. global search & replace */
  Counter = 0
  DO LENGTH(HTMLPath)
    Counter = Counter + 1
    IF COMPARE('\' , SUBSTR(HTMLPath , Counter , 1)) = 0
    THEN HTMLPath = SUBSTR(HTMLPath , 1 , Counter-1)'/'SUBSTR(HTMLPath , Counter+1 , LENGTH(HTMLPath)-Counter)
  END
  RETURN HTMLPath

/*=============================== The following procedures define the HTML page =================== */
/* all pages have a Header, the Dirs (if any), the Files (if any) and a footer */

Makeheader:
/* ------------------ Make Page Header ---------------- */
  err = FilePuts(handle,'<HTML> <HEAD>')
  /* I test the err var on the first and last write only! */
  IF err <> LENGTH('<HTML> <HEAD>')+2 THEN DO
    Say 'Error writing to HTML File '||ToDo.CurrentDir.dpath||'\'||MyHTML
    EXIT
  END

  err = FilePuts(handle,'<TITLE>'||HomeSite||' : '||ToDo.CurrentDir.sb||'</TITLE></HEAD><BODY '||BodyParm||'>')
  err = FilePuts(handle,'<P><H1>Downloads : <B>'||ToDo.CurrentDir.sb||'</B></H1></P>')
  /* --- Insert any README text ----- */
  err = AddTheReadme()
  /* Thre is no previous dir on the root page */
  IF CurrentDir \= 1 THEN DO
    err = FilePuts(handle,'<P><A HREF="'||ToDo.CurrentDir.parent||MyHTML||'">'||BackButton||'<B>Parent Library</B></A></P>')
  END
RETURN 0

OutputDirs:
/*----------------- Output the Dirs Stem -------------------*/
  /* Init the table and legend */
  err = FilePuts(handle,'<P><H2>'||RelatedIcon||'Related Libraries</H2></P>')
  err = FilePuts(handle,'<TABLE BORDER=1 WIDTH=100%>')
  err = FilePuts(handle,' <TR>')
  err = FilePuts(handle,'   <TD><B>Related Library</B></TD>')
  err = FilePuts(handle,'   <TD><B>Description</B></TD></TR>')

  /* make all the rows in the table */
  DO x=1 TO Dirs.0
    err = FilePuts(handle,' <TR>')
    err = FilePuts(handle,'   <TD VALIGN=TOP>'||RelatedIcon||'<A HREF="'||Dirs.x.html||'/'||MyHTML'"><B>'||Dirs.x.nm||'</B></A></TD>')
    err = FilePuts(handle,'   <TD VALIGN=TOP>'||Dirs.x.sb||'</TD></TR>')
  END
  /* Close the table */
  err = FilePuts(handle,'</TABLE>')
RETURN 0

OutputFiles:
/*----------------- Output the Files Stem -------------------*/
  /* Init the table and legend */
  err = FilePuts(handle,'<P><H2>'||FileIcon||'Files in this Library</H2></P>')
  err = FilePuts(handle,'<P>'||Files.0||' Files</P>')
  err = FilePuts(handle,'<TABLE BORDER=1 WIDTH=100%>')
  err = FilePuts(handle,' <TR>')
  err = FilePuts(handle,'   <TD><B>File Name</B></TD>')
  err = FilePuts(handle,'   <TD><B>Description</B></TD>')
  err = FilePuts(handle,'   <TD ALIGN=RIGHT><B>Size</B></TD>')
  /* Special ToDo.x.Attr flag for this dir (reverse order) */
  IF ToDo.CurrentDir.attr \= '#' THEN err = FilePuts(handle,'   <TD ALIGN=RIGHT><B>Date</B></TD></TR>')
  IF ToDo.CurrentDir.attr = '#'  THEN err = FilePuts(handle,'   </TR>')

  /* make all the rows in the table */
  SELECT
    /* set the loop params for processing all the files in Files. stem var */
    When ToDo.CurrentDir.attr = '#' THEN DO
    /* Special ToDo.x.Attr flag for this dir (reverse order) */
    /* I also don't add a Date column either (see below)*/
      Beg = Files.0
      Endat = 1
      DecBy = -1
      END
    /* Alpha Order normal default */
    OTHERWISE
      Beg = 1
      Endat = Files.0
      DecBy = 1
  END

  DO x=Beg TO Endat BY DecBy
    err = FilePuts(handle,' <TR>')
    err = FilePuts(handle,'   <TD VALIGN=TOP>'||FileIcon||'<A HREF="'||Files.x.html||'"><B>'||Files.x.nm||'</B></A></TD>')
    err = FilePuts(handle,'   <TD VALIGN=TOP>'||Files.x.sb||'</TD>')

    /* Special ToDo.x.Attr flag for this dir (reverse order) */
    IF ToDo.CurrentDir.attr \= '#' THEN err = FilePuts(handle,'   <TD ALIGN=RIGHT VALIGN=TOP><I>'||Files.x.size||'</I></TD>')
    IF ToDo.CurrentDir.attr \= '#' THEN err = FilePuts(handle,'   <TD ALIGN=RIGHT VALIGN=TOP><I>'||Files.x.dt||'</I></TD></TR>')

    IF ToDo.CurrentDir.attr  = '#' THEN err = FilePuts(handle,'   <TD ALIGN=RIGHT VALIGN=TOP><I>'||Files.x.size||'</I></TD></TR>')
  END
  /* Close the table */
  err = FilePuts(handle,'</TABLE>')
RETURN 0

MakeFooter:
/* ------------------ Make Page footer ---------------- */
  /* Add any standard links at the bottom of the page. You may want this different */

  /* add a link to the Home page and to the main Library page */
  err = FilePuts(handle,'<P>'||HomeButton||' | '||MainButton||Todo.1.sb||' Library</A></P>')
  /* put the current date as the last updated date, also use smaller font */
  err = FilePuts(handle,'<P><FONT SIZE=-1>Last Updated : '||DATE('W')||' - '||DATE('N')||'</FONT></P>')

  /* You MUST have this in the footer duh! */
  err = FilePuts(handle,'</BODY></HTML>')
  /* I test the err var on the first and last write only! */
  IF err <> LENGTH('</BODY></HTML>')+2 THEN DO
    Say 'Error writing to HTML File '||ToDo.CurrentDir.dpath||'\'||MyHTML
    EXIT
  END
RETURN 0

AddTheReadme:
/* ----- Inserts any readme file into the HTML File after the header ------ */
/* Readme should be in HTML format */
  handle2 = 0 /* Init the handle */
  handle2 = FileOpen(ToDo.CurrentDir.dpath||'\'||ReadMe)
  IF handle2 = 0 Then RETURN 0 /* no handle means no file found */
  /* If you want plain text you could insert a <PRE> here and a </PRE> at the end */
  DO FOREVER
    Line = FileGets(handle2, 't')
    /* Detect End of File */
    IF FileErr = 0 THEN LEAVE  /* EOF encountered */
    /* write to the HTMl file */
    err = FilePuts(handle, Line)
  END
  /* Close the README */
  /* insert </PRE> here */
  err = FileClose(handle2)
RETURN 0


